/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.dashboard;

import at.letto.data.dto.dashboard.DashboardAllDto;
import at.letto.data.dto.dashboard.DashboardDto;
import at.letto.data.repository.TestsEntityRepository;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    @Autowired
    TestsEntityRepository dashboardRepo;
    @PersistenceContext
    EntityManager em;

    public List<DashboardDto> loadDashboardStarted(int idUser, int idSchuljahr) {
        return this.dashboardRepo.loadDashboardStarted(idUser, idSchuljahr).stream().map(v -> {
            try {
                v.setProz(v.getSoll() != 0.0 ? v.getIst() / v.getSoll() : 0.0);
            }
            catch (Exception e) {
                v.setProz(0.0);
            }
            return v;
        }).filter(v -> v.getIdParent() == 0 || v.getIdParent() > 0 && v.getParentVisible() != false).filter(v -> v.getStopActive() == false || v.getStop() == null || v.getStop().after(new Date())).collect(Collectors.toList());
    }

    public List<DashboardDto> loadDashboardNotStarted(int idUser, int idSchuljahr) {
        return this.dashboardRepo.loadDashboardNotStarted(idUser, idSchuljahr).stream().filter(v -> v.getIdParent() == 0 || v.getIdParent() > 0 && v.getParentVisible() != null && v.getParentVisible() != false).filter(v -> v.getStop() == null || v.getStop().after(new Date())).collect(Collectors.toList());
    }

    public DashboardAllDto loadDashboard(int idUser, int idSchuljahr) {
        List open = this.loadDashboardStarted(idUser, idSchuljahr);
        List notStarted = this.loadDashboardNotStarted(idUser, idSchuljahr);
        return new DashboardAllDto(open, notStarted);
    }
}

