/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.export;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.data.mapper.ExportQuestionMapper_V1;
import at.letto.data.service.question.QuestionListService;
import at.letto.data.service.question.QuestionService;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.export.dto.questions.ExportQuestionV1;
import java.util.List;
import java.util.Vector;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportMapService {
    @Autowired
    QuestionService questionService;
    @Autowired
    QuestionListService questionListService;
    ExportQuestionMapper_V1 qMapper_v1 = (ExportQuestionMapper_V1)Mappers.getMapper(ExportQuestionMapper_V1.class);

    public ExportCategoryV1 map_v1(CategoryDTO cat) {
        return this.map_cat_v1(cat, true);
    }

    public ExportQuestionV1 map_v1(QuestionDTO q) {
        return this.qMapper_v1.map(q, new CycleAvoidingMappingContext());
    }

    public ExportQuestionV1 map_question_v1(QuestionListDTO ql) {
        try {
            QuestionDTO q = this.questionService.loadQuestion(ql.getId());
            return this.qMapper_v1.map(q, new CycleAvoidingMappingContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ExportQuestionV1 map_questionDto_v1(QuestionDTO q) {
        try {
            return this.qMapper_v1.map(q, new CycleAvoidingMappingContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public QuestionDTO map_to_questionDto(ExportQuestionV1 q) {
        try {
            return this.qMapper_v1.mapDto(q, new CycleAvoidingMappingContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ExportCategoryV1 map_cat_v1(CategoryDTO c, boolean loadQuestions) {
        ExportCategoryV1 ret = new ExportCategoryV1();
        ret.setId(c.getId());
        ret.setName(c.getName());
        ret.setIdParent(c.getIdParent());
        ret.setEinheitenKorrText(c.getEinheitenKorrText());
        ret.setCategoryLink(c.getCategoryLink());
        ret.setGlobalCategory(c.isGlobalCategory());
        ret.setPrivateCategory(c.isPrivateCategory());
        ret.setIdKompetenz(c.getIdKompetenz());
        ret.setLevel(c.getLevel() != null ? c.getLevel().name() : null);
        ret.setQuestions(new Vector());
        ret.setCategories(new Vector());
        List qList = this.questionListService.loadQuestionsInCategory(c.getId(), -1);
        for (QuestionListDTO ql : qList) {
            try {
                QuestionDTO q = this.questionService.loadQuestion(ql.getId());
                ret.getQuestions().add(this.map_v1(q));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public QuestionService getQuestionService() {
        return this.questionService;
    }

    public QuestionListService getQuestionListService() {
        return this.questionListService;
    }

    public ExportQuestionMapper_V1 getQMapper_v1() {
        return this.qMapper_v1;
    }

    public void setQuestionService(QuestionService questionService) {
        this.questionService = questionService;
    }

    public void setQuestionListService(QuestionListService questionListService) {
        this.questionListService = questionListService;
    }

    public void setQMapper_v1(ExportQuestionMapper_V1 qMapper_v1) {
        this.qMapper_v1 = qMapper_v1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportMapService)) {
            return false;
        }
        ExportMapService other = (ExportMapService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        QuestionService this$questionService = this.getQuestionService();
        QuestionService other$questionService = other.getQuestionService();
        if (this$questionService == null ? other$questionService != null : !this$questionService.equals(other$questionService)) {
            return false;
        }
        QuestionListService this$questionListService = this.getQuestionListService();
        QuestionListService other$questionListService = other.getQuestionListService();
        if (this$questionListService == null ? other$questionListService != null : !this$questionListService.equals(other$questionListService)) {
            return false;
        }
        ExportQuestionMapper_V1 this$qMapper_v1 = this.getQMapper_v1();
        ExportQuestionMapper_V1 other$qMapper_v1 = other.getQMapper_v1();
        return !(this$qMapper_v1 == null ? other$qMapper_v1 != null : !this$qMapper_v1.equals(other$qMapper_v1));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportMapService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QuestionService $questionService = this.getQuestionService();
        result = result * 59 + ($questionService == null ? 43 : $questionService.hashCode());
        QuestionListService $questionListService = this.getQuestionListService();
        result = result * 59 + ($questionListService == null ? 43 : $questionListService.hashCode());
        ExportQuestionMapper_V1 $qMapper_v1 = this.getQMapper_v1();
        result = result * 59 + ($qMapper_v1 == null ? 43 : $qMapper_v1.hashCode());
        return result;
    }

    public String toString() {
        return "ExportMapService(questionService=" + this.getQuestionService() + ", questionListService=" + this.getQuestionListService() + ", qMapper_v1=" + this.getQMapper_v1() + ")";
    }
}

