/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.config;

import at.letto.basespringboot.config.BaseMicroServiceConfiguration;
import at.letto.basespringboot.security.WebSecurityConfig;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.edit.endpoints.LettoEditEndpoint;
import at.letto.globalinterfaces.ImageService;
import at.letto.lehrplan.restclient.RestLehrplanService;
import at.letto.lettoedit.service.CategoryService;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.question.restclient.QuestionRestService;
import at.letto.question.restclient.TestQuestionRestService;
import at.letto.restclient.endpoint.EndpointInterface;
import at.letto.security.LettoToken;
import at.letto.service.base.BaseImageService;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.setup.restclient.RestSetupService;
import at.letto.setup.restclient.SetupService;
import at.letto.tools.Cmd;
import at.letto.tools.rest.MsgException;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class MicroServiceConfiguration
extends BaseMicroServiceConfiguration {
    @Autowired
    private CategoryService catService;
    @Lazy
    @Autowired
    private ConfigService configService;
    @Autowired
    private WebSecurityConfig webSecurityConfig;
    @Value(value="${letto_default_dataservice:}")
    private String defaultDataService = "";
    private RestLehrplanService lehrplanService;
    private ImageService imageService;
    private SetupService setupService;
    private Map<String, RestLettoDataService> dataservices = new ConcurrentHashMap();
    private QuestionRestService questionService;
    private TestQuestionRestService testQuestionService;
    private RestLettoDataService defaultDataservice = null;

    @PostConstruct
    public void init() {
        this.webSecurityConfig.init((BaseMicroServiceConfiguration)this, (EndpointInterface)new LettoEditEndpoint());
    }

    public RestLehrplanService getLehrplanService() {
        if (this.lehrplanService == null) {
            this.lehrplanService = new RestLehrplanService(this.getLehrplanServiceUri());
        }
        return this.lehrplanService;
    }

    public ImageService getImageService() {
        if (this.imageService == null) {
            try {
                this.imageService = new BaseImageService(this.getImageLocalImagePath(), this.getImageUri(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.imageService;
    }

    public SetupService getSetupService() {
        if (this.setupService == null) {
            try {
                this.setupService = new RestSetupService(this.getSetupServiceUri(), "user", this.getUserUserPassword());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.setupService;
    }

    public RestLettoDataService getDataService(LettoToken token) {
        return this.getDataService(token.getSchool());
    }

    public QuestionRestService getQuestionService() {
        if (this.questionService == null) {
            this.questionService = new QuestionRestService(this.getQuestionServiceUri(), "user", this.getUserUserPassword());
        }
        return this.questionService;
    }

    public TestQuestionRestService getTestQuestionService() {
        if (this.testQuestionService == null) {
            this.testQuestionService = new TestQuestionRestService(this.getQuestionServiceUri(), "user", this.getUserUserPassword());
        }
        return this.testQuestionService;
    }

    public RestLettoDataService getDefaultDataservice(String school) {
        if (this.defaultDataservice == null) {
            try {
                this.defaultDataservice = new RestLettoDataService(this.defaultDataService, "user", this.getUserUserPassword(), 0, school);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultDataservice;
    }

    public RestLettoDataService getDataService(String school) {
        if (!Cmd.isEmpty((String)this.defaultDataService)) {
            return this.getDefaultDataservice(school);
        }
        if (this.dataservices.containsKey(school)) {
            return (RestLettoDataService)this.dataservices.get(school);
        }
        Optional<ServiceSchuleDto> schule = this.getSetupService().getSchulen().stream().filter(s -> s.getShortname().equals(school)).findFirst();
        if (schule.isPresent()) {
            String uri = schule.get().getDataUri();
            RestLettoDataService dataService = new RestLettoDataService(uri, "user", this.getUserUserPassword(), schule.get().getIdSchuleData(), school);
            this.dataservices.put(school, dataService);
            return dataService;
        }
        throw new MsgException("dataserviceNotFound");
    }

    public CategoryService getCatService() {
        return this.catService;
    }
}

