/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.data.dto.beurteilung.AlleBeurteilungenDTO;
import at.letto.data.dto.beurteilung.StudentDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.beurteilung.BeurteilungService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class BeurteilungsController {
    @Autowired
    BeurteilungService beurteilungService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "BeurteilungsController");

    @PostMapping(value={"/edit/api/teacher/beurt/beurt_load_allebeurteilungen"})
    public ResponseEntity<DtoAndMsg<AlleBeurteilungenDTO>> loadBeurteilungen(@RequestBody HashMap<String, String> dto) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(BeurteilungService::loadBeurteilungenAll, (Object)this.beurteilungService, dto, (Object)token);
    }

    @PostMapping(value={"/edit/api/student/beurt/beurt_load_allebeurteilungen"})
    public ResponseEntity<DtoAndMsg<StudentDto>> loadBeurteilungenStudent(@RequestBody HashMap<String, String> dto) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(BeurteilungService::loadBeurteilungenStudent, (Object)this.beurteilungService, dto, (Object)token);
    }

    private LettoToken loadToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (LettoToken)authentication.getDetails();
    }
}

