/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.data.dto.config.GlobalConfigDto;
import at.letto.data.dto.config.UserConfigDto;
import at.letto.data.dto.user.UserDto;
import at.letto.edit.dto.conf.UserLettoConfigDto;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.security.LettoToken;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ConfigController {
    @Autowired
    private ConfigService configService;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "ConfigController");

    @PostMapping(value={"/edit/api/teacher/config/load_conf_user"})
    public ResponseEntity<DtoAndMsg<UserConfigDto>> loadConf(@RequestBody String key) {
        return this.r.getResponse(ConfigService::get, (Object)this.configService, (Object)key, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/config/load_letto_conf_user"})
    public ResponseEntity<DtoAndMsg<UserLettoConfigDto>> loadUserConf() {
        return this.r.getResponse(ConfigService::loadUserConf, (Object)this.configService, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/config/save_letto_conf_user"})
    public ResponseEntity<DtoAndMsg<String>> saveUserConf(@RequestBody UserLettoConfigDto conf) {
        return this.r.getErrResponse(ConfigService::saveUserConf, (Object)this.configService, (Object)conf, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/config/del_conf_user"})
    public ResponseEntity<DtoAndMsg<String>> deleteUserConf(@RequestBody String key) {
        return this.r.getErrResponse(ConfigService::deleteUserConf, (Object)this.configService, (Object)key, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/config/change_user_pwd"})
    public ResponseEntity<DtoAndMsg<String>> changeUserPwd(@RequestBody HashMap<String, String> dto) {
        return this.r.getErrResponse(ConfigService::changeUserPwd, (Object)this.configService, dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/conf_change_user"})
    public ResponseEntity<DtoAndMsg<String>> changeUser(@RequestBody UserDto dto) {
        return this.r.getErrResponse(ConfigService::changeUser, (Object)this.configService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/config/save_conf_user"})
    public ResponseEntity<DtoAndMsg<String>> saveConf(@RequestBody UserConfigDto c) {
        return this.r.getErrResponse(ConfigService::set, (Object)this.configService, (Object)c, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/config/load_conf_users"})
    public ResponseEntity<DtoAndMsg<List<UserConfigDto>>> loadUserConfigs(@RequestBody String key) {
        return this.r.getResponse(ConfigService::loadUserConfigs, (Object)this.configService, (Object)key, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/config/save_conf_glob"})
    public ResponseEntity<DtoAndMsg<String>> saveGlobal(@RequestBody GlobalConfigDto c) {
        return this.r.getErrResponse(ConfigService::setGlobal, (Object)this.configService, (Object)c, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/config/load_conf_glob"})
    public ResponseEntity<DtoAndMsg<GlobalConfigDto>> loadGlobal(@RequestBody String key) {
        return this.r.getErrResponse(ConfigService::getGlobalConf, (Object)this.configService, (Object)key, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/open/schul_image"})
    public ResponseEntity<DtoAndMsg<String>> loadSchulImage(@RequestBody ServiceSchuleDto school) {
        return this.r.getResponse(ConfigService::loadSchulImage, (Object)this.configService, (Object)school);
    }

    @PostMapping(value={"/edit/api/teacher/config/del_conf_glob"})
    public ResponseEntity<DtoAndMsg<String>> deleteGlobalConfig(@RequestBody String key) {
        return this.r.getErrResponse(ConfigService::deleteGlobalConf, (Object)this.configService, (Object)key, (Object)this.loadToken());
    }

    private LettoToken loadToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (LettoToken)authentication.getDetails();
    }
}

