/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.data.dto.activity.ActivityChangeDto;
import at.letto.data.dto.activity.ActivityDto;
import at.letto.data.dto.activity.InsertHtmlActivities;
import at.letto.data.dto.activitytype.ActivitytypeBaseDto;
import at.letto.data.dto.inetlinks.InetlinksBaseDto;
import at.letto.data.dto.schuljahr.SchuljahrDto;
import at.letto.data.dto.user.UserDto;
import at.letto.edit.dto.conf.SchoolLoginDto;
import at.letto.lettoedit.service.LehrerKlasseService;
import at.letto.lettoedit.service.UserService;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.lettoedit.service.testservice.TestsService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class LehrerKlasseController {
    @Autowired
    LehrerKlasseService lehrerKlasseService;
    @Autowired
    ConfigService configService;
    @Autowired
    UserService userService;
    @Autowired
    TestsService testsService;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "LehrerKlasseController");

    @PostMapping(value={"/edit/api/teacher/test"}, consumes={"application/json"})
    public ResponseEntity<String> testDateDto(@RequestBody ActivityChangeDto x) {
        return ResponseEntity.ok((Object)x.getName());
    }

    @PostMapping(value={"/edit/api/teacher/lk_teacher/load_schuljahre"})
    public ResponseEntity<DtoAndMsg<List<SchuljahrDto>>> loadLehrerSchuljahre() {
        int idUser = this.loadToken().getIdUser();
        return ResponseTools.getResponse(LehrerKlasseService::loadLehrerSchuljahre, (Object)this.lehrerKlasseService, (Object)idUser, (Object)this.loadToken().getSchool());
    }

    @PostMapping(value={"/edit/api/student/lk_student/load_schuljahre"})
    public ResponseEntity<DtoAndMsg<List<SchuljahrDto>>> loadStudentSchuljahre() {
        int idUser = this.loadToken().getIdUser();
        return ResponseTools.getResponse(LehrerKlasseService::loadStudentSchuljahre, (Object)this.lehrerKlasseService, (Object)idUser, (Object)this.loadToken().getSchool());
    }

    @PostMapping(value={"/edit/api/student/user/user_by_name"})
    public ResponseEntity<DtoAndMsg<UserDto>> loadUserByName(@RequestBody String name) {
        return ResponseTools.getResponse(UserService::loadUserByName, (Object)this.userService, (Object)name, (Object)this.loadToken().getSchool());
    }

    @PostMapping(value={"/edit/api/teacher/lk_change_activity"}, consumes={"application/json"})
    public ResponseEntity<DtoAndMsg<ActivityChangeDto>> saveChangeActivity(@RequestBody ActivityChangeDto dto) {
        return ResponseTools.getResponse(LehrerKlasseService::saveChangeActivity, (Object)this.lehrerKlasseService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/lk_activity_types"})
    public ResponseEntity<DtoAndMsg<List<ActivitytypeBaseDto>>> loadActivityTypes() {
        return ResponseTools.getResponse(TestsService::loadActivityTypes, (Object)this.testsService, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/base_load_inetlink"})
    public ResponseEntity<DtoAndMsg<InetlinksBaseDto>> loadInetLink(@RequestBody Integer id) {
        return ResponseTools.getResponse(LehrerKlasseService::loadInetLink, (Object)this.lehrerKlasseService, (Object)id, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/base_html_question"})
    public ResponseEntity<DtoAndMsg<List<ActivityDto>>> insHtmlQuestion(@RequestBody InsertHtmlActivities dto) {
        return ResponseTools.getResponse(LehrerKlasseService::insHtmlQuestion, (Object)this.lehrerKlasseService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/open/setup_schulen"})
    public ResponseEntity<DtoAndMsg<List<SchoolLoginDto>>> loadSchulen() {
        return ResponseTools.getResponse(ConfigService::loadSchulen, (Object)this.configService);
    }

    @PostMapping(value={"/edit/api/teacher/clone_activity"})
    public ResponseEntity<DtoAndMsg<ActivityDto>> cutCopyActivity(@RequestBody Map<String, String> vals) {
        return ResponseTools.getResponse(LehrerKlasseService::cutCopyActivity, (Object)this.lehrerKlasseService, vals, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/load_students_in_klasse"})
    public ResponseEntity<DtoAndMsg<List<UserDto>>> loadStudentsInKlasse(@RequestBody int idKlasse) {
        return ResponseTools.getResponse(LehrerKlasseService::loadStudentsInKlasse, (Object)this.lehrerKlasseService, (Object)idKlasse, (Object)this.loadToken());
    }

    private LettoToken loadToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (LettoToken)authentication.getDetails();
    }
}

