/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.data.dto.dashboard.DashboardAllDto;
import at.letto.data.dto.enums.AnswerMode;
import at.letto.data.dto.tests.TestVersuchDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.edit.dto.test.TestVersucheAndTest;
import at.letto.edit.dto.testquestion.NextQuestionAndOldAnswerDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.LehrerKlasseService;
import at.letto.lettoedit.service.testservice.GroupingService;
import at.letto.lettoedit.service.testservice.TestQuestionService;
import at.letto.lettoedit.service.testservice.TestsService;
import at.letto.question.dto.QuestionWithAnswer;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class TestForStudentsController {
    @Autowired
    TestsService testsService;
    @Autowired
    TestQuestionService testQuestionService;
    @Autowired
    GroupingService groupingService;
    @Autowired
    LehrerKlasseService lkService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "TestForStudentsController");

    @PostMapping(value={"/edit/api/student/test/load_test_versuche"})
    public ResponseEntity<DtoAndMsg<TestVersucheAndTest>> loadTestVersucheByTestAndUser(@RequestBody Map<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idUser = Integer.parseInt(vals.get("idUser"));
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::findTestVersucheByUserId, (Object)this.testsService, (Object)idUser, (Object)idTest, (Object)token);
    }

    @PostMapping(value={"/edit/api/student/test/create_test_versuch"})
    public ResponseEntity<DtoAndMsg<TestVersuchDto>> createTestVersuch(@RequestBody Map<String, String> vals) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::createTestVersuchForStudent, (Object)this.testsService, vals, (Object)token);
    }

    @PostMapping(value={"/edit/api/student/test/open_test_versuch"})
    public ResponseEntity<DtoAndMsg<TestVersuchDto>> openTestVersuchByID(@RequestBody Map<String, String> vals) {
        int idVersuch = Integer.parseInt(vals.get("idVersuch"));
        int idTest = Integer.parseInt(vals.get("idTest"));
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::loadTestVersuch, (Object)this.testsService, (Object)idVersuch, (Object)idTest, (Object)true, (Object)token);
    }

    @GetMapping(value={"/edit/api/student/load_by_td"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<QuestionWithAnswer>> loadQuestionByTd(@RequestParam Integer idTd) {
        return this.r.getResponse(TestQuestionService::loadQuestionFromDetail, (Object)this.testQuestionService, (Object)idTd, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/score"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> score(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(TestQuestionService::score, (Object)this.testQuestionService, (Object)AnswerMode.beurteilen, (Object)dto, (Object)false, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/test_question_score_next"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<NextQuestionAndOldAnswerDto>> scoreNext(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(TestQuestionService::scoreNext, (Object)this.testQuestionService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/test_question_score_penalty"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> scorePenalty(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(TestQuestionService::scorePenalty, (Object)this.testQuestionService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/test_question_next"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<NextQuestionAndOldAnswerDto>> saveAndNext(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(TestQuestionService::saveNext, (Object)this.testQuestionService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/save_question_answer"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> saveAnswer(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(TestQuestionService::saveAnswer, (Object)this.testQuestionService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/test_versuch_score"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestVersuchDto>> rescoreTestVersuch(@RequestBody Map<String, String> vals) {
        return this.r.getResponse(TestsService::scoreTestVersuchStudent, (Object)this.testsService, vals, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/store_proz_test_versuch"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<String>> storeProzentTestVersuch(@RequestBody Map<String, String> vals) {
        return this.r.getResponse(TestsService::storeProzentTestVersuch, (Object)this.testsService, vals, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/test_versuch_save"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<String>> saveTestVersuch(@RequestBody TestVersuchDto v) {
        return this.r.getResponse(TestsService::saveTestVersuch, (Object)this.testsService, (Object)v, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/student/test_dashboard"})
    public ResponseEntity<DtoAndMsg<DashboardAllDto>> dashBoard(@RequestBody Map<String, String> vals) {
        int idUser = Integer.parseInt(vals.get("idUser"));
        int idSj = Integer.parseInt(vals.get("idSj"));
        return ResponseTools.getResponse(TestsService::loadDashboard, (Object)this.testsService, (Object)idUser, (Object)idSj, (Object)this.loadToken());
    }

    private LettoToken loadToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (LettoToken)authentication.getDetails();
    }
}

