/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.data.dto.gruppierung.InitTestInfoDto;
import at.letto.data.dto.testFrage.InsertTestFrageDto;
import at.letto.data.dto.tests.TestFrageDto;
import at.letto.data.dto.tests.TestInhaltDto;
import at.letto.edit.dto.testquestion.GroupingTestFragenDto;
import at.letto.edit.dto.testquestion.IsolateFrageDto;
import at.letto.edit.dto.testquestion.MoveTestFrageDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.LehrerKlasseService;
import at.letto.lettoedit.service.testservice.GroupingService;
import at.letto.lettoedit.service.testservice.TestsService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class TestsController {
    @Autowired
    TestsService testsService;
    @Autowired
    GroupingService groupingService;
    @Autowired
    LehrerKlasseService lkService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "TestsController");

    @PostMapping(value={"/edit/api/teacher/category_edit/load_full"})
    public ResponseEntity<DtoAndMsg<TestInhaltDto>> loadTestInhalt(@RequestBody int id) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::loadTestInhalt, (Object)this.testsService, (Object)id, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/activity_change_visible"})
    public ResponseEntity<DtoAndMsg<String>> changeActivityVisibility(@RequestBody Map<String, String> vals) {
        int idActivity = Integer.parseInt(vals.get("idActivity"));
        boolean visible = "true".equals(vals.get("visible"));
        LettoToken token = this.loadToken();
        return this.r.getResponse(LehrerKlasseService::changeActivityVisibility, (Object)this.lkService, (Object)idActivity, (Object)visible, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/move_testfrage"})
    public ResponseEntity<DtoAndMsg<List<TestFrageDto>>> moveTestfrage(@RequestBody MoveTestFrageDto dto) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::moveTestfrage, (Object)this.testsService, (Object)dto, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/del_testfrage"})
    public ResponseEntity<DtoAndMsg<String>> delTestFrage(@RequestBody Map<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idTestfrage = Integer.parseInt(vals.get("idTestfrage"));
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::delTestFrage, (Object)this.testsService, (Object)idTest, (Object)idTestfrage, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/isolate_testfrage"})
    public ResponseEntity<DtoAndMsg<String>> isolateTestFrage(@RequestBody IsolateFrageDto dto) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::isolateTestFrage, (Object)this.testsService, (Object)dto.getIdTest(), (Object)dto.getTestfragen(), (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/update_testfrage_points"})
    public ResponseEntity<DtoAndMsg<String>> updateTestFragePoints(@RequestBody Map<String, String> vals) {
        int idTestfrage = Integer.parseInt(vals.get("idTestfrage"));
        int idTest = Integer.parseInt(vals.get("idTest"));
        double points = Double.parseDouble(vals.get("points"));
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::updateTestFragePoints, (Object)this.testsService, (Object)idTestfrage, (Object)idTest, (Object)points, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/grouping_testfragen"})
    public ResponseEntity<DtoAndMsg<TestInhaltDto>> groupingTestFragen(@RequestBody GroupingTestFragenDto dto) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(GroupingService::groupingTestFragen, (Object)this.groupingService, (Object)dto.getIdTest(), (Object)dto.getIdsTestfragen(), (Object)dto.getAnzahl(), (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/grouping_anzahl"})
    public ResponseEntity<DtoAndMsg<String>> changeGroupingAnzahl(@RequestBody Map<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idGruppierung = Integer.parseInt(vals.get("idGruppierung"));
        int anzahl = Integer.parseInt(vals.get("anzahl"));
        LettoToken token = this.loadToken();
        return this.r.getResponse(GroupingService::changeGroupingAnzahl, (Object)this.groupingService, (Object)idTest, (Object)idGruppierung, (Object)anzahl, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/grouping_remove"})
    public ResponseEntity<DtoAndMsg<TestInhaltDto>> removeGruppierung(@RequestBody Map<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idGruppierung = Integer.parseInt(vals.get("idGruppierung"));
        LettoToken token = this.loadToken();
        return this.r.getResponse(GroupingService::removeGruppierung, (Object)this.groupingService, (Object)idTest, (Object)idGruppierung, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/load_init_test_info"})
    public ResponseEntity<DtoAndMsg<InitTestInfoDto>> loadInitTestInfo(@RequestBody Map<String, String> vals) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::loadInitTestInfo, (Object)this.testsService, vals, (Object)token);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/save_test_frage"})
    public ResponseEntity<DtoAndMsg<String>> insertTestQuestion(@RequestBody InsertTestFrageDto dto) {
        LettoToken token = this.loadToken();
        return this.r.getResponse(TestsService::insertTestQuestion, (Object)this.testsService, (Object)dto, (Object)token);
    }

    private LettoToken loadToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (LettoToken)authentication.getDetails();
    }
}

