/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service;

import at.letto.data.dto.activity.ActivityBaseDto;
import at.letto.data.dto.activity.ActivityChangeDto;
import at.letto.data.dto.activity.ActivityDto;
import at.letto.data.dto.activity.InsertHtmlActivities;
import at.letto.data.dto.activity.RetHtmlActivity;
import at.letto.data.dto.beurteilung.LehrerInfoDTO;
import at.letto.data.dto.gegenstand.GegenstandBaseDto;
import at.letto.data.dto.inetlinks.InetlinksBaseDto;
import at.letto.data.dto.klasse.KlasseBaseDto;
import at.letto.data.dto.klasse.KlasseDto;
import at.letto.data.dto.lehrerKlasse.LehrerKlasseBaseDto;
import at.letto.data.dto.lehrerKlasse.LehrerKlasseDto;
import at.letto.data.dto.schuelerKlasse.SchuelerKlasseBaseDto;
import at.letto.data.dto.schuljahr.SchuljahrBaseDto;
import at.letto.data.dto.schuljahr.SchuljahrDto;
import at.letto.data.dto.user.UserDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.data.restclient.data.RestLehrerKlasse;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.LehrerKlasseService;
import at.letto.lettoedit.service.testservice.TestsService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LehrerKlasseService {
    @Autowired
    TestsService testsService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    private ModelMapper modelMapper = new ModelMapper();
    private ConcurrentMap<String, ConcurrentMap<Integer, List<SchuelerKlasseBaseDto>>> studentMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ConcurrentMap<Integer, List<LehrerKlasseDto>>> lehrerMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ConcurrentMap<Integer, List<LehrerKlasseDto>>> klasseLehrerMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ConcurrentMap<Integer, LehrerKlasseDto>> lkMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ConcurrentMap<Integer, KlasseBaseDto>> klassenMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ConcurrentMap<Integer, SchuljahrBaseDto>> schuljahrMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ConcurrentMap<Integer, ActivityDto>> activityMap = new ConcurrentHashMap();

    private void addSchool(String school) {
        ConcurrentMap<Integer, UserDto> lehrerHash = ((List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadLehrer())).stream().collect(Collectors.toConcurrentMap(UserDto::getId, u -> u, (u1, u2) -> u1));
        ConcurrentMap<Integer, SchuljahrBaseDto> _schuljahre = ((List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadSchuljahre())).stream().collect(Collectors.toConcurrentMap(SchuljahrBaseDto::getId, s -> s, (s1, s2) -> s1));
        this.schuljahrMap.put(school, _schuljahre);
        ConcurrentMap<Integer, KlasseBaseDto> _klassen = ((List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadKlassen())).stream().collect(Collectors.toConcurrentMap(KlasseBaseDto::getId, k -> k, (k1, k2) -> k1));
        this.klassenMap.put(school, _klassen);
        Map<Integer, GegenstandBaseDto> gegenstandsMap = ((List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadGegenstaende())).stream().collect(Collectors.toMap(GegenstandBaseDto::getId, g -> g, (g1, g2) -> g1));
        List lks = (List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadLehrerKlassen());
        Map<Integer, List<LehrerInfoDTO>> fremdlehrerMap = ((List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadFremdlehrerAll())).stream().collect(Collectors.groupingBy(LehrerInfoDTO::getIdLk));
        HashMap mapLehrerKlassen = new HashMap();
        HashMap mapUser_LehrerKlassen = new HashMap();
        List lkList = lks.stream().map(lkx -> {
            LehrerKlasseDto lk = new LehrerKlasseDto();
            this.modelMapper.map(lkx, (Object)lk);
            GegenstandBaseDto g = (GegenstandBaseDto)gegenstandsMap.get(lk.getIdGegenstand());
            if (g != null) {
                lk.setAbkGegenstand(g.getKuerzel());
                lk.setGegenstand(g.getName());
            }
            if (fremdlehrerMap.containsKey(lk.getId())) {
                lk.setFremdlehrer((List)fremdlehrerMap.get(lk.getId()));
            }
            try {
                lk.setUser(((UserDto)lehrerHash.get(lk.getIdUser())).getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            mapLehrerKlassen.put(lk.getId(), lk);
            return lk;
        }).collect(Collectors.toList());
        this.klasseLehrerMap.put(school, lkList.stream().filter(lk -> lk.getIdKlasse() != null).collect(Collectors.groupingByConcurrent(LehrerKlasseBaseDto::getIdKlasse, Collectors.mapping(lk -> lk, Collectors.toList()))));
        this.lkMap.put(school, lkList.stream().collect(Collectors.toConcurrentMap(lk -> lk.getId(), lk -> lk, (lk1, lk2) -> lk1)));
        this.lehrerMap.put(school, lkList.stream().collect(Collectors.groupingByConcurrent(LehrerKlasseBaseDto::getIdUser, Collectors.mapping(lk -> lk, Collectors.toList()))));
        lkList.stream().filter(lk -> lk.getDisableKatalog() == false && lk.getFremdlehrer().size() > 0).forEach(lk -> lk.getFremdlehrer().forEach(l -> {
            ConcurrentMap map = (ConcurrentMap)this.lehrerMap.get(school);
            if (!map.containsKey(l.getIduser())) {
                map.put(l.getIduser(), new Vector());
            }
            ((List)map.get(l.getIduser())).add(lk);
        }));
        if (!this.activityMap.containsKey(school)) {
            this.activityMap.put(school, new ConcurrentHashMap());
        }
        Map mapActivities = (Map)this.activityMap.get(school);
        List _act = (List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadActivities());
        List activities = _act.stream().filter(Objects::nonNull).map(a -> {
            if (a.getLkOrder() == null) {
                a.setLkOrder(Integer.valueOf(0));
            }
            return a;
        }).sorted(Comparator.comparing(ActivityBaseDto::getLkOrder)).map(act -> {
            ActivityDto a = new ActivityDto();
            this.modelMapper.map(act, (Object)a);
            mapActivities.put(a.getId(), a);
            if (a.getIdLehrerKlasse() != null && a.getIdLehrerKlasse() > 0 && mapLehrerKlassen.containsKey(a.getIdLehrerKlasse())) {
                ((LehrerKlasseDto)mapLehrerKlassen.get(a.getIdLehrerKlasse())).getActivities().add(a);
            }
            return a;
        }).collect(Collectors.toList());
        activities.stream().filter(a -> a.getIdParentFolder() != null && a.getIdParentFolder() > 0).map(a -> {
            if (a.getFolderOrder() == null) {
                a.setFolderOrder(Integer.valueOf(-1));
            }
            return a;
        }).sorted(Comparator.comparing(ActivityBaseDto::getFolderOrder)).forEach(a -> {
            if (mapActivities.containsKey(a.getIdParentFolder())) {
                ((ActivityDto)mapActivities.get(a.getIdParentFolder())).getActivities().add(a);
            }
        });
        Map students = ((List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((String)school).lehrerKlasse.loadSchuelerKlasseAll())).stream().collect(Collectors.groupingBy(SchuelerKlasseBaseDto::getIdUser, Collectors.mapping(s -> s, Collectors.toList())));
        this.studentMap.put(school, new ConcurrentHashMap(students));
    }

    public List<SchuljahrDto> loadLehrerSchuljahre(int idUser, String school) {
        List lks;
        this.addSchool(school);
        if (!this.lehrerMap.containsKey(school)) {
            this.addSchool(school);
        }
        if ((lks = (List)((ConcurrentMap)this.lehrerMap.get(school)).get(idUser)) == null) {
            return new Vector<SchuljahrDto>();
        }
        HashMap mapKlassen = new HashMap();
        lks.forEach(lk -> {
            if (!mapKlassen.containsKey(lk.getIdKlasse())) {
                KlasseDto k = new KlasseDto();
                this.modelMapper.map(((ConcurrentMap)this.klassenMap.get(school)).get(lk.getIdKlasse()), (Object)k);
                mapKlassen.put(k.getId(), k);
            }
            if (!lk.getDisableKatalog().booleanValue()) {
                ((KlasseDto)mapKlassen.get(lk.getIdKlasse())).getLehrerKlassen().add(lk);
            }
        });
        HashMap mapSchuljahre = new HashMap();
        mapKlassen.values().stream().sorted(Comparator.comparing(KlasseBaseDto::getName)).forEach(k -> {
            if (!mapSchuljahre.containsKey(k.getIdSchuljahr())) {
                SchuljahrDto sj = new SchuljahrDto();
                this.modelMapper.map(((ConcurrentMap)this.schuljahrMap.get(school)).get(k.getIdSchuljahr()), (Object)sj);
                mapSchuljahre.put(sj.getId(), sj);
            }
            Collections.sort(k.getLehrerKlassen(), Comparator.comparing(LehrerKlasseDto::getAbkGegenstand));
            ((SchuljahrDto)mapSchuljahre.get(k.getIdSchuljahr())).getKlassen().add(k);
        });
        Vector<SchuljahrDto> sjs = new Vector<SchuljahrDto>(mapSchuljahre.values());
        Collections.sort(sjs, Comparator.comparing(SchuljahrBaseDto::getName));
        return sjs;
    }

    private void removeNotVisible(List<ActivityDto> list) {
        Iterator<ActivityDto> iter = list.iterator();
        while (iter.hasNext()) {
            ActivityDto a = iter.next();
            this.removeNotVisible(a.getActivities());
            if (a.getVisible() != null && a.getVisible().booleanValue()) continue;
            iter.remove();
        }
    }

    public List<SchuljahrDto> loadStudentSchuljahre(int idUser, String school) {
        if (!this.studentMap.containsKey(school)) {
            this.addSchool(school);
        }
        HashMap mapKlassen = new HashMap();
        ((List)((ConcurrentMap)this.studentMap.get(school)).get(idUser)).forEach(sk -> ((List)((ConcurrentMap)this.klasseLehrerMap.get(school)).get(sk.getIdKlasse())).forEach(lk -> {
            if (!mapKlassen.containsKey(lk.getIdKlasse())) {
                KlasseDto k = new KlasseDto();
                this.modelMapper.map(((ConcurrentMap)this.klassenMap.get(school)).get(lk.getIdKlasse()), (Object)k);
                mapKlassen.put(k.getId(), k);
            }
            ((KlasseDto)mapKlassen.get(lk.getIdKlasse())).getLehrerKlassen().add(lk);
        }));
        HashMap mapSchuljahre = new HashMap();
        mapKlassen.values().stream().sorted(Comparator.comparing(KlasseBaseDto::getName)).forEach(k -> {
            if (!mapSchuljahre.containsKey(k.getIdSchuljahr())) {
                SchuljahrDto sj = new SchuljahrDto();
                this.modelMapper.map(((ConcurrentMap)this.schuljahrMap.get(school)).get(k.getIdSchuljahr()), (Object)sj);
                mapSchuljahre.put(sj.getId(), sj);
            }
            Collections.sort(k.getLehrerKlassen(), Comparator.comparing(LehrerKlasseDto::getAbkGegenstand));
            ((SchuljahrDto)mapSchuljahre.get(k.getIdSchuljahr())).getKlassen().add(k);
        });
        Vector sjs = new Vector(mapSchuljahre.values());
        Collections.sort(sjs, Comparator.comparing(SchuljahrBaseDto::getName));
        return new Vector<SchuljahrDto>(mapSchuljahre.values());
    }

    public String changeActivityVisibility(int idActivity, boolean visible, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).lehrerKlasse.changeActivityVisibility(idActivity, visible));
        ActivityDto a = (ActivityDto)((ConcurrentMap)this.activityMap.get(token.getSchool())).get(idActivity);
        if (a.getIdTest() != null && a.getIdTest() > 0) {
            this.testsService.changeVisible(a.getIdTest().intValue(), visible, token);
        }
        a.setVisible(Boolean.valueOf(visible));
        return "";
    }

    private ActivityDto changeActivityInTree(ActivityDto actInTree, ActivityDto a, LettoToken token) {
        if (actInTree == null) {
            if (a.getIdParentFolder() != null && a.getIdParentFolder() > 0) {
                ActivityDto parent = this.loadActivity(a.getIdParentFolder().intValue(), token);
                if (parent == null) {
                    throw new MsgException("errNoParentFolderDefined");
                }
                int pos = a.getFolderOrder();
                if (pos < 0) {
                    pos = parent.getActivities().size();
                }
                if (pos > parent.getActivities().size()) {
                    pos = parent.getActivities().size();
                }
                parent.getActivities().add(pos, a);
            } else {
                LehrerKlasseDto lk = this.loadLehrerKlasse(a.getIdLehrerKlasse().intValue(), token);
                if (lk == null) {
                    throw new MsgException("errNoLkDefined");
                }
                int pos = a.getLkOrder();
                if (pos < 0) {
                    pos = lk.getActivities().size();
                }
                if (pos > lk.getActivities().size()) {
                    pos = lk.getActivities().size();
                }
                lk.getActivities().add(pos, a);
            }
            ((ConcurrentMap)this.activityMap.get(token.getSchool())).put(a.getId(), a);
            return a;
        }
        actInTree.setName(a.getName());
        actInTree.setVisible(a.getVisible());
        actInTree.setIdDokument(a.getIdDokument());
        actInTree.setIdTest(a.getIdTest());
        actInTree.setIdQuestion(a.getIdQuestion());
        actInTree.setIdLink(a.getIdLink());
        actInTree.setTyp(a.getTyp());
        actInTree.setId(a.getId());
        ((ConcurrentMap)this.activityMap.get(token.getSchool())).put(actInTree.getId(), actInTree);
        return actInTree;
    }

    public ActivityChangeDto saveChangeActivity(ActivityChangeDto dto, LettoToken token) {
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        ActivityDto a = dto.getIdAct() > 0 ? this.loadActivity(dto.getIdAct(), token) : null;
        switch (1.$SwitchMap$at$letto$data$dto$activity$ActivityChangeDto$CHANGE_MODE[dto.getMode().ordinal()]) {
            case 1: {
                if (a == null) {
                    throw new MsgException("act.err.act_not_existing");
                }
                DtoAndMsg.check((DtoAndMsg)data.lehrerKlasse.changeActivityVisibility(dto.getIdAct(), dto.isVisible()));
                a.setVisible(Boolean.valueOf(dto.isVisible()));
                if (a.getIdTest() != null && a.getIdTest() > 0) {
                    this.testsService.changeVisible(a.getIdTest().intValue(), dto.isVisible(), token);
                }
                return null;
            }
            case 2: {
                if (a == null) {
                    throw new MsgException("act.err.act_not_existing");
                }
                DtoAndMsg.check((DtoAndMsg)data.lehrerKlasse.changeActivityName(dto.getIdAct(), dto.getName()));
                a.setName(dto.getName());
                if (a.getIdTest() != null && a.getIdTest() > 0) {
                    this.testsService.changeName(a.getIdTest().intValue(), dto.getName(), token);
                }
                return null;
            }
            case 3: {
                ActivityDto act = (ActivityDto)DtoAndMsg.get((DtoAndMsg)data.tests.saveTest(dto));
                dto.setRetVal(this.changeActivityInTree(a, act, token));
                this.testsService.clearTestCache(act.getIdTest().intValue(), token);
                dto.setTestInhalt(this.testsService.loadTestInhalt(act.getIdTest().intValue(), token));
                return dto;
            }
            case 4: 
            case 5: 
            case 6: {
                ActivityChangeDto ret = (ActivityChangeDto)DtoAndMsg.get((DtoAndMsg)data.tests.saveActivity(dto));
                this.changeActivityInTree(a, ret.getRetVal(), token);
                return ret;
            }
            case 7: {
                if (a.getActivities().size() > 0) {
                    throw new MsgException("errActivityFolderNotEmpty");
                }
                DtoAndMsg.check((DtoAndMsg)data.lehrerKlasse.deleteActivity(dto.getIdAct()));
                this.deleteActivityFromCache(dto.getIdAct(), token);
                return null;
            }
            case 8: {
                DtoAndMsg.check((DtoAndMsg)data.lehrerKlasse.deleteActivity(dto.getIdAct()));
                this.deleteActivityFromCache(dto.getIdAct(), token);
                return null;
            }
        }
        return null;
    }

    private ActivityDto reloadActivityInHash(int idAct, LettoToken token) {
        ActivityBaseDto a = (ActivityBaseDto)this.microServiceConfiguration.getDataService((LettoToken)token).lehrerKlasse.loadActivityById(idAct).getData();
        ActivityDto existing = this.loadActivity(idAct, token);
        if (existing == null) {
            if (a.getIdParentFolder() > 0) {
                ActivityDto par = this.loadActivity(a.getIdParentFolder().intValue(), token);
                existing = new ActivityDto();
                this.modelMapper.map((Object)a, (Object)existing);
                par.getActivities().add(existing);
            }
        } else {
            this.modelMapper.map((Object)a, (Object)existing);
        }
        return existing;
    }

    private void deleteActivityFromCache(int id, LettoToken token) {
        ActivityDto a = (ActivityDto)((ConcurrentMap)this.activityMap.get(token.getSchool())).get(id);
        if (a.getIdParentFolder() != null && a.getIdParentFolder() > 0) {
            ActivityDto parent = this.loadActivity(a.getIdParentFolder().intValue(), token);
            parent.getActivities().remove(a);
        } else if (a.getIdLehrerKlasse() != null && a.getIdLehrerKlasse() > 0) {
            ((LehrerKlasseDto)((ConcurrentMap)this.lkMap.get(token.getSchool())).get(a.getIdLehrerKlasse())).getActivities().remove(a);
        }
        ((ConcurrentMap)this.activityMap.get(token.getSchool())).remove(a.getId());
    }

    private ActivityDto loadActivity(int id, LettoToken token) {
        try {
            return (ActivityDto)((ConcurrentMap)this.activityMap.get(token.getSchool())).get(id);
        }
        catch (Exception e) {
            return null;
        }
    }

    private LehrerKlasseDto loadLehrerKlasse(int id, LettoToken token) {
        try {
            return (LehrerKlasseDto)((ConcurrentMap)this.lkMap.get(token.getSchool())).get(id);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InetlinksBaseDto loadInetLink(int id, LettoToken token) {
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        return (InetlinksBaseDto)DtoAndMsg.get((DtoAndMsg)data.lehrerKlasse.loadInetLink(id));
    }

    public List<ActivityDto> insHtmlQuestion(InsertHtmlActivities act, LettoToken token) {
        List ret = (List)DtoAndMsg.get((DtoAndMsg)this.ds((LettoToken)token).lehrerKlasse.insertHtmlActivity(act));
        Vector<ActivityDto> activities = new Vector<ActivityDto>();
        for (RetHtmlActivity r : ret) {
            ActivityDto a = new ActivityDto();
            a.setId(Integer.valueOf(r.getIdActivity()));
            a.setName(r.getName());
            a.setIdActivityTyp(Integer.valueOf(r.getIdActivityTyp()));
            a.setTyp("HtmlQuestion");
            a.setImg("htmlquestion.png");
            a.setIdQuestion(Integer.valueOf(r.getIdQuestion()));
            a.setIdParentFolder(Integer.valueOf(act.getIdParent()));
            a.setIDLK(Integer.valueOf(act.getIdLk()));
            if (a.getIdParentFolder() <= 0) {
                a.setIdLehrerKlasse(a.getIDLK());
            }
            this.changeActivityInTree(null, a, token);
            activities.add(a);
        }
        return activities;
    }

    public ActivityDto cutCopyActivity(Map<String, String> vals, LettoToken token) {
        int idActivity = Integer.parseInt(vals.get("idActivity"));
        int idLk = Integer.parseInt(vals.get("idLk"));
        int idFolder = Integer.parseInt(vals.get("idFolder"));
        int pos = Integer.parseInt(vals.get("pos"));
        boolean copy = Boolean.parseBoolean(vals.get("copy"));
        ActivityBaseDto act = (ActivityBaseDto)DtoAndMsg.get((DtoAndMsg)this.ds((LettoToken)token).lehrerKlasse.cutCopyActivity(idActivity, idLk, idFolder, pos, copy));
        ActivityDto a = new ActivityDto();
        this.modelMapper.map((Object)act, (Object)a);
        this.changeActivityInTree(null, a, token);
        return a;
    }

    private RestLettoDataService ds(LettoToken token) {
        return this.microServiceConfiguration.getDataService(token);
    }

    public void clearCache(LettoToken token) {
        if (this.studentMap.containsKey(token.getSchool())) {
            this.studentMap.remove(token.getSchool());
        }
        if (this.lehrerMap.containsKey(token.getSchool())) {
            this.lehrerMap.remove(token.getSchool());
        }
        if (this.klasseLehrerMap.containsKey(token.getSchool())) {
            this.klasseLehrerMap.remove(token.getSchool());
        }
        if (this.lkMap.containsKey(token.getSchool())) {
            this.lkMap.remove(token.getSchool());
        }
        if (this.klassenMap.containsKey(token.getSchool())) {
            this.klassenMap.remove(token.getSchool());
        }
        if (this.schuljahrMap.containsKey(token.getSchool())) {
            this.schuljahrMap.remove(token.getSchool());
        }
        if (this.activityMap.containsKey(token.getSchool())) {
            this.activityMap.remove(token.getSchool());
        }
    }

    public List<UserDto> loadStudentsInKlasse(int idKlasse, LettoToken token) {
        RestLehrerKlasse lkService = this.microServiceConfiguration.getDataService((String)token.getSchool()).lehrerKlasse;
        return (List)DtoAndMsg.get((DtoAndMsg)lkService.loadSchuelerByKlasse(idKlasse));
    }
}

