/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service;

import at.letto.data.dto.question.list.QuestionKompetenzDTO;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.lehrplan.dto.kompetenz.KompetenzSchulstufeDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.CategoryService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionListService {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    CategoryService categoryService;

    public List<QuestionListDTO> loadQuestionsInCategory(int idCateg, int idTests, LettoToken token) {
        List ret = (List)DtoAndMsg.get((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).question.loadQuestionsInCategory(idCateg, idTests));
        this.setKompetenzen(ret);
        return ret;
    }

    public void setKompetenzen(List<QuestionListDTO> qlist) {
        List<QuestionKompetenzDTO> komp = qlist.stream().map(q -> q.getKompetenzen()).flatMap(Collection::stream).collect(Collectors.toList());
        Set idsThema = komp.stream().map(k -> k.getIdThema()).collect(Collectors.toSet());
        if (idsThema.size() > 0) {
            try {
                Map<Integer, KompetenzSchulstufeDto> themen = this.microServiceConfiguration.getLehrplanService().loadKompetenzen(new Vector(idsThema)).getThemen().stream().collect(Collectors.toMap(t -> t.getId(), t -> t, (t1, t2) -> t1));
                komp.forEach(k -> {
                    k.setKompetenz("");
                    if (themen.get(k.getIdThema()) != null) {
                        k.setKompetenz(((KompetenzSchulstufeDto)themen.get(k.getIdThema())).getKompetenz());
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

