/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service.config;

import at.letto.data.dto.config.ConfigInterface;
import at.letto.data.dto.config.GlobalConfigDto;
import at.letto.data.dto.config.UserConfigDto;
import at.letto.data.dto.user.UserDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.edit.dto.conf.AbosDto;
import at.letto.edit.dto.conf.SchoolLoginDto;
import at.letto.edit.dto.conf.UserLettoConfigDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.CategoryService;
import at.letto.lettoedit.service.UserService;
import at.letto.security.LettoToken;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.tools.JSON;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ConfigService {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    UserService userService;
    public boolean licenseGlobal = false;
    public ConcurrentHashMap<String, ConcurrentHashMap<String, GlobalConfigDto>> conf = new ConcurrentHashMap();
    public ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<Integer, UserConfigDto>>> confUser = new ConcurrentHashMap();

    private void loadConfigForSchule(String school, int idSchule) {
        RestLettoDataService data = this.microServiceConfiguration.getDataService(school);
        this.conf.put(school, new ConcurrentHashMap());
        this.confUser.put(school, new ConcurrentHashMap());
        if (!data.ping()) {
            return;
        }
        ((List)data.config.loadAllGlobalConf().getData()).forEach(cfg -> {
            if (cfg.getIdSchule() == null || cfg.getIdSchule() <= 0) {
                if (!((ConcurrentHashMap)this.conf.get(school)).containsKey(cfg.getName())) {
                    ConcurrentHashMap x = (ConcurrentHashMap)this.conf.get(school);
                    x.put(cfg.getName(), cfg);
                }
            } else {
                ConcurrentHashMap x = (ConcurrentHashMap)this.conf.get(school);
                x.put(cfg.getName(), cfg);
            }
        });
        try {
            String configFile = ((GlobalConfigDto)((ConcurrentHashMap)this.conf.get(school)).get("configFile")).getText();
            File f = new File(configFile);
            if (f.exists()) {
                HashMap template = new HashMap();
                Path path = Paths.get(f.toURI());
                String confContent = Files.readAllLines(path, StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
                Map confHash = (Map)JSON.jsonToObj((String)confContent, template.getClass());
                confHash.keySet().forEach(k -> {
                    if (k.equals("licenseGlobal")) {
                        this.licenseGlobal = ((String)confHash.get(k)).equals("1");
                    } else {
                        GlobalConfigDto x = (GlobalConfigDto)((ConcurrentHashMap)this.conf.get(-1)).get(k);
                        x.setText((String)confHash.get(k));
                    }
                });
            }
        }
        catch (Exception configFile) {
            // empty catch block
        }
        ConcurrentHashMap uConf = (ConcurrentHashMap)this.confUser.get(school);
        ((List)data.config.loadAllUserConf().getData()).forEach(cfg -> {
            if (!uConf.containsKey(cfg.getName())) {
                uConf.put(cfg.getName(), new ConcurrentHashMap());
            }
            ((ConcurrentHashMap)uConf.get(cfg.getName())).put(cfg.getIdUser(), cfg);
        });
    }

    private void checkSchule(LettoToken token) {
        if (!this.conf.containsKey(token.getSchool()) || ((ConcurrentHashMap)this.conf.get(token.getSchool())).size() == 0) {
            this.loadConfigForSchule(token.getSchool(), token.getIdSchule().intValue());
        }
    }

    public void checkSchule(String school, int idSchule) {
        if (!this.conf.containsKey(school) || ((ConcurrentHashMap)this.conf.get(school)).size() == 0) {
            this.loadConfigForSchule(school, idSchule);
        }
    }

    public String setGlobal(GlobalConfigDto c, LettoToken token) {
        this.checkSchule(token);
        if (c == null) {
            throw new MsgException("configNotDefined");
        }
        try {
            int id = ((GlobalConfigDto)((ConcurrentHashMap)this.conf.get(token.getSchool())).get(c.getName())).getId();
            c.setId(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).config.setGlobal(c));
        ((ConcurrentHashMap)this.conf.get(token.getSchool())).put(c.getName(), c);
        return "";
    }

    public void delete(GlobalConfigDto c, LettoToken token) {
        this.checkSchule(token);
        DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).config.deleteGlobalConf(c.getName()));
        try {
            ((ConcurrentHashMap)this.conf.get(token.getSchool())).remove(c.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String deleteGlobalConf(String key, LettoToken token) {
        try {
            GlobalConfigDto c = (GlobalConfigDto)((ConcurrentHashMap)this.conf.get(token.getIdSchule())).get(key);
            this.delete(c, token);
            return "";
        }
        catch (Exception e) {
            throw new MsgException("noSchoolAndConfigKey");
        }
    }

    public String deleteUserConf(String key, LettoToken token) {
        this.checkSchule(token);
        try {
            UserConfigDto c = (UserConfigDto)((ConcurrentHashMap)((ConcurrentHashMap)this.confUser.get(token.getSchool())).get(key)).get(token.getIdUser());
            DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).config.deleteUserConf(key, token.getIdUser().intValue()));
            ((ConcurrentHashMap)((ConcurrentHashMap)this.confUser.get(token.getSchool())).get(key)).remove(token.getIdUser());
        }
        catch (Exception e) {
            throw new MsgException("noUserConfigFound");
        }
        return "";
    }

    public GlobalConfigDto getGlobalConf(String key, LettoToken token) {
        this.checkSchule(token);
        try {
            return (GlobalConfigDto)((ConcurrentHashMap)this.conf.get(token.getSchool())).get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String loadSchulImage(ServiceSchuleDto school) {
        this.checkSchule(school.getShortname(), school.getId());
        try {
            return ((GlobalConfigDto)((ConcurrentHashMap)this.conf.get(school.getShortname())).get("image")).getText();
        }
        catch (Exception e) {
            return "";
        }
    }

    public List<UserConfigDto> loadUserConfigs(String key, LettoToken token) {
        this.checkSchule(token);
        try {
            return new Vector<UserConfigDto>(((ConcurrentHashMap)((ConcurrentHashMap)this.confUser.get(token.getSchool())).get(key)).values());
        }
        catch (Exception e) {
            return null;
        }
    }

    public UserConfigDto get(String key, LettoToken token) {
        int idUser = token.getIdUser();
        this.checkSchule(token);
        try {
            UserConfigDto erg = (UserConfigDto)((ConcurrentHashMap)((ConcurrentHashMap)this.confUser.get(token.getSchool())).get(key)).get(idUser);
            if (erg != null) {
                return erg;
            }
        }
        catch (Exception erg) {
            // empty catch block
        }
        try {
            GlobalConfigDto c = (GlobalConfigDto)((ConcurrentHashMap)this.conf.get(token.getSchool())).get(key);
            return new UserConfigDto(c.getName(), c.getText(), c.getTyp());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T> T loadConf(String key, Class<T> typ, LettoToken token) {
        UserConfigDto x = this.get(key, token);
        if (x == null) {
            System.out.println(key + " not found");
            return null;
        }
        return (T)ConfigService.load((String)x.getText(), typ);
    }

    public boolean loadBoolean(String key, LettoToken token) {
        Boolean ret = (Boolean)this.loadConf(key, Boolean.class, token);
        if (ret == null) {
            return false;
        }
        return ret;
    }

    public String loadString(String key, LettoToken token) {
        String ret = (String)this.loadConf(key, String.class, token);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public int loadInteger(String key, LettoToken token) {
        Integer ret = (Integer)this.loadConf(key, Integer.class, token);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    public UserLettoConfigDto loadUserConf(LettoToken token) {
        UserLettoConfigDto conf = new UserLettoConfigDto();
        conf.setMaximaForSave(this.loadBoolean("maximaForSave", token));
        conf.setAllowEmptyQuest(this.loadBoolean("allowEmptyQuest", token));
        conf.setShowWarningEmptyQuest(this.loadBoolean("showWarningEmptyQuest", token));
        conf.setShowQuestionCountParameter(this.loadBoolean("showQuestionCountParameter", token));
        conf.setQuestChangeTestSolved(this.loadInteger("questChangeTestSolved", token));
        conf.setDocInitParameter(this.loadString("DocInit", token));
        conf.setDocInitQuestionParameter(this.loadString("DocInitQuestion", token));
        conf.setDocInitTestParameter(this.loadString("DocInitTest", token));
        conf.setDocEndParameter(this.loadString("DocEnd", token));
        conf.setDocStartQuestionParameter(this.loadString("DocStartQuestion", token));
        conf.setDocStartTestParameter(this.loadString("DocStartTest", token));
        conf.setDarkDesign(this.loadBoolean("darkDesign", token));
        conf.setLang(this.loadString("language", token));
        String abos = this.loadString("abos", token);
        AbosDto abo = null;
        try {
            abo = (AbosDto)JSON.jsonToObj((String)abos, AbosDto.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (abo == null) {
            abo = new AbosDto();
            abo.setUseAbosCategory(this.loadBoolean("useAbosCategory", token));
            abo.setUseAbosUsers(this.loadBoolean("useAbosUsers", token));
            abo.setChangeAbosPossible(this.loadBoolean("changeAbosPossible", token));
            abo.setAboCategories(this.loadString("aboCategories", token));
            abo.setAboUsers(this.loadString("aboUsers", token));
        }
        CategoryService catService = this.microServiceConfiguration.getCatService();
        String cats = catService.loadRoot(token).getCategories().stream().map(c -> c.getName()).collect(Collectors.joining(","));
        abo.setAllCatgories(cats);
        String users = catService.loadUsers(token).stream().collect(Collectors.joining(","));
        abo.setAllUsers(users);
        abos = JSON.objToJson((Object)abo);
        conf.setAbos(abos);
        return conf;
    }

    public String saveUserConf(UserLettoConfigDto conf, LettoToken token) {
        this.save("maximaForSave", (Object)conf.isMaximaForSave(), token);
        this.save("allowEmptyQuest", (Object)conf.isAllowEmptyQuest(), token);
        this.save("showWarningEmptyQuest", (Object)conf.isShowWarningEmptyQuest(), token);
        this.save("showQuestionCountParameter", (Object)conf.isShowQuestionCountParameter(), token);
        this.save("questChangeTestSolved", (Object)conf.getQuestChangeTestSolved(), token);
        this.save("DocInit", (Object)conf.getDocInitParameter(), token);
        this.save("DocInitQuestion", (Object)conf.getDocInitQuestionParameter(), token);
        this.save("DocInitTest", (Object)conf.getDocInitTestParameter(), token);
        this.save("DocEnd", (Object)conf.getDocEndParameter(), token);
        this.save("DocStartQuestion", (Object)conf.getDocStartQuestionParameter(), token);
        this.save("DocStartTest", (Object)conf.getDocStartTestParameter(), token);
        this.save("darkDesign", (Object)conf.isDarkDesign(), token);
        this.save("language", (Object)conf.getLang(), token);
        String abos = null;
        try {
            AbosDto abo = (AbosDto)JSON.jsonToObj((String)conf.getAbos(), AbosDto.class);
            abo.setAllCatgories("");
            abo.setAllUsers("");
            abos = JSON.objToJson((Object)abo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (abos != null) {
            this.save("abos", abos, token);
        }
        return "";
    }

    public static <T> T load(String txt, Class<T> typ) {
        try {
            if (typ.getSimpleName().equals("String")) {
                return (T)txt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return (T)(txt != null ? new ObjectMapper().readValue(txt, typ) : null);
        }
        catch (Exception e) {
            try {
                return (T)new ObjectMapper().readValue("0", typ);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public String set(UserConfigDto c, LettoToken token) {
        int idUser = token.getIdUser();
        this.checkSchule(token);
        c.setIdUser(idUser);
        DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).config.set(c));
        if (!((ConcurrentHashMap)this.confUser.get(token.getSchool())).containsKey(c.getName())) {
            ((ConcurrentHashMap)this.confUser.get(token.getSchool())).put(c.getName(), new ConcurrentHashMap());
        }
        ((ConcurrentHashMap)((ConcurrentHashMap)this.confUser.get(token.getSchool())).get(c.getName())).put(idUser, c);
        return "";
    }

    public String save(String key, Object val, LettoToken token) {
        UserConfigDto c = null;
        try {
            if (!((ConcurrentHashMap)this.confUser.get(token.getSchool())).containsKey(key)) {
                ((ConcurrentHashMap)this.confUser.get(token.getSchool())).put(key, new ConcurrentHashMap());
            }
            if (!UserConfigDto.setConfDto((Object)val, (ConfigInterface)(c = (UserConfigDto)((ConcurrentHashMap)((ConcurrentHashMap)this.confUser.get(token.getSchool())).get(key)).get(token.getIdUser())))) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            c = new UserConfigDto(key, val);
        }
        this.set(c, token);
        return "";
    }

    public List<SchoolLoginDto> loadSchulen() {
        List<SchoolLoginDto> schulen = this.microServiceConfiguration.getSetupService().getSchulen().stream().map(s -> new SchoolLoginDto(s.getId(), s.getShortname(), s.getSchulname(), "", false, "", s.getDataUri())).collect(Collectors.toList());
        schulen.forEach(s -> {
            this.checkSchule(s.getShortname(), s.getId());
            try {
                s.setImage(((GlobalConfigDto)((ConcurrentHashMap)this.conf.get(s.getShortname())).get("image")).getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.setShowWerbung(new File("/opt/letto/public/werbung_" + s.getShortname() + ".html").exists());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object path = "";
                try {
                    path = "public/werbung_" + s.getShortname() + ".html";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                s.setWerbung((String)path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return schulen;
    }

    public String changeUserPwd(HashMap<String, String> vals, LettoToken token) {
        this.checkSchule(token);
        int idUser = Integer.parseInt(vals.get("idUser"));
        String pwd = vals.get("pwd");
        boolean temp = false;
        DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).users.changePassword(idUser, pwd, temp));
        return "";
    }

    public String changeUser(UserDto u, LettoToken token) {
        this.checkSchule(token);
        DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).users.changeUser(u));
        return "";
    }
}

