/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service.testservice;

import at.letto.data.dto.beuteilungsschema.BeurteilungsartDTO;
import at.letto.data.dto.beuteilungsschema.BeurteilungsconfigDTO;
import at.letto.data.dto.enums.AnswerMode;
import at.letto.data.dto.tests.TestBereichDetailsDto;
import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.TestEigenschaftsDto;
import at.letto.data.dto.tests.TestVersuchDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.edit.dto.testquestion.NextQuestionAndOldAnswerDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.beurteilung.BeurteilungService;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.lettoedit.service.testservice.TestQuestionService;
import at.letto.lettoedit.service.testservice.TestsService;
import at.letto.question.dto.QuestionWithAnswer;
import at.letto.security.LettoToken;
import at.letto.tools.Cmd;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.enums.Score;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import jakarta.annotation.PostConstruct;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TestQuestionService {
    @Lazy
    @Autowired
    private ConfigService configService;
    @Lazy
    @Autowired
    private MicroServiceConfiguration mc;
    @Lazy
    @Autowired
    private TestsService testsService;
    @Lazy
    @Autowired
    private BeurteilungService beurteilungService;

    @PostConstruct
    public void init() {
    }

    public boolean isCheckInTestPossible(TestEigenschaftsDto test, LettoToken token) {
        if (test == null) {
            return true;
        }
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(test.getIdLk(), token);
        if (schema == null) {
            return false;
        }
        String mode = test.getMode();
        BeurteilungsartDTO ba = schema.getBeurteilungsart(mode, "", true);
        if (ba == null) {
            ba = (BeurteilungsartDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurtConfig.loadBeurteilungsartByBezeichner(mode));
            if (ba == null) {
                return false;
            }
            schema.getBeurteilungsartHash().put(mode, ba);
        }
        return ba.getBeurteilungsart().isCheckPossible();
    }

    public boolean isCheckPossible(TestEigenschaftsDto test, QuestionWithAnswer qa, LettoToken token) {
        if (this.isCheckInTestPossible(test, token)) {
            if (qa == null) {
                return false;
            }
            QuestionType typ = qa.getAngabe().getQuestionType();
            return typ != QuestionType.MoodleEssay;
        }
        return false;
    }

    private boolean isShowTestResults(int idVersuch, LettoToken token) {
        TestVersuchDto v = (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.mc.getDataService((LettoToken)token).tests.loadTestVersuchSimple(idVersuch));
        if (v == null) {
            throw new MsgException("test_err_testversuch_does_not_exist");
        }
        TestEigenschaftsDto t = this.testsService.loadTestEigenschaften(v.getIdTest(), token);
        if (t == null) {
            throw new MsgException("test_err_test_does_not_exist");
        }
        if (!(!v.isFinished() || t.isStop() && t.getTestStop() != null && t.getTestStop().before(new Date()))) {
            return this.isCheckInTestPossible(t, token);
        }
        return true;
    }

    public boolean isStop(TestEigenschaftsDto t) {
        if (t == null) {
            return true;
        }
        return t.isStop() && t.getTestStop().before(new Date());
    }

    private Info status(int idTd, LettoToken token) {
        TestDetailDto td = (TestDetailDto)DtoAndMsg.get((DtoAndMsg)this.mc.getDataService((LettoToken)token).td.loadTestDetailById(idTd));
        if (td == null) {
            throw new MsgException("test_err_testdetail_does_not_exist");
        }
        TestVersuchDto v = (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.mc.getDataService((LettoToken)token).tests.loadTestVersuchSimple(td.getIdTestVersuch()));
        if (v == null) {
            throw new MsgException("test_err_testversuch_does_not_exist");
        }
        TestEigenschaftsDto t = this.testsService.loadTestEigenschaften(v.getIdTest(), token);
        if (t == null) {
            throw new MsgException("test_err_test_does_not_exist");
        }
        boolean testStop = this.isStop(t);
        return new Info(this, td, v, t, testStop);
    }

    public QuestionWithAnswer loadQuestionFromDetail(int idTd, LettoToken token) {
        Info i = this.status(idTd, token);
        QuestionWithAnswer ret = i.v.isFinished() && i.testStop ? (QuestionWithAnswer)DtoAndMsg.get((DtoAndMsg)this.mc.getTestQuestionService().loadTestQuestionWithResults(i.td.getIdQuestion(), i.td.getSelektor(), i.td.getDataset(), token.getToken())) : (QuestionWithAnswer)DtoAndMsg.get((DtoAndMsg)this.mc.getTestQuestionService().loadTestQuestion(i.td.getIdQuestion(), i.td.getSelektor(), i.td.getDataset(), token.getToken()));
        TestAntwortDto ta = i.td.getTestAntwort();
        if (ta != null) {
            ret.setAntwort(ta);
        }
        boolean checkPossible = this.isCheckPossible(i.t, ret, token);
        Object buttons = "";
        if (!i.v.isFinished() && !i.testStop) {
            buttons = i.t.isOnRamp() ? "" : "next_quest";
            buttons = (String)buttons + ",save";
            if (checkPossible && !i.t.isOnRamp() && !i.t.isAbzugBeiMehrfachantwort()) {
                buttons = (String)buttons + ",check";
            }
            if (checkPossible && i.t.isOnRamp()) {
                buttons = (String)buttons + ",check_next";
            }
            if (i.t.isAbzugBeiMehrfachantwort() && ret.getAngabe().getPruefenAbzug() > 0.0 && !i.t.isOnRamp() && i.t.isAbzugBeiMehrfachantwort()) {
                buttons = (String)buttons + ",check_penalty";
            }
            if (!i.testStop && ret.getAngabe().isAddDocumentsPossible()) {
                buttons = (String)buttons + ",add_document";
            }
            if (i.t.getFeedback().equals((Object)"FeedbackQuestion") && !Cmd.isEmpty((String)ret.getAngabe().getFeedback())) {
                buttons = (String)buttons + ",help";
            }
        }
        ret.getAngabe().setButtons((String)buttons);
        ret.getAntwort().setIdDetail(idTd);
        ret.getAntwort().setIdTest(i.td.getIdTest());
        return ret;
    }

    public TestAntwortDto score(AnswerMode mode, TestAntwortDto a, boolean clearLehrerBeurteilung, LettoToken token) {
        Info i = this.status(a.getIdDetail(), token);
        if (i.canWrite()) {
            if (a.getIdQuestion() == 0) {
                a.setIdQuestion(i.td.getIdQuestion());
            }
            if (Cmd.isEmpty((String)a.getDataset())) {
                a.setDataset(i.td.getDataset());
            }
            if (a.getIdTest() == 0) {
                a.setIdTest(i.td.getIdTest());
            }
            TestAntwortDto erg_antwort = (TestAntwortDto)DtoAndMsg.get((DtoAndMsg)this.mc.getQuestionService().score(a, token.getToken()));
            erg_antwort.setPoints(erg_antwort.getPoints() * i.td.getPoints() / i.td.getPointsQuestion());
            return this.saveTestAnswerToDatabase(erg_antwort, token);
        }
        throw new MsgException("err_edit_test_stopped");
    }

    private TestDetailDto findNextQuestion(Info i, int idTd) {
        int j = 0;
        TestDetailDto next = null;
        for (TestBereichDetailsDto b : i.v.getBereiche()) {
            int k = 0;
            for (TestDetailDto td : b.getTestDetails()) {
                if (td.getId() == idTd) {
                    if (b.getTestDetails().size() >= k) {
                        next = (TestDetailDto)b.getTestDetails().get(k + 1);
                        break;
                    }
                    if (i.v.getBereiche().size() >= j) {
                        try {
                            next = (TestDetailDto)((TestBereichDetailsDto)i.v.getBereiche().get(j + 1)).getTestDetails().get(0);
                        }
                        catch (Exception exception) {}
                    } else {
                        throw new MsgException("err_edit_no_next_question");
                    }
                }
                ++k;
            }
            if (next != null) break;
            ++j;
        }
        if (next == null) {
            throw new MsgException("err_edit_no_next_question_found");
        }
        return next;
    }

    public TestAntwortDto saveTestAnswerToDatabase(TestAntwortDto a, LettoToken token) {
        int idTd = a.getIdDetail();
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).td.saveStudentAnswerToDB(a));
        return a;
    }

    public NextQuestionAndOldAnswerDto scoreNext(TestAntwortDto a, LettoToken token) {
        Info i = this.status(a.getIdDetail(), token);
        if (i.canWrite()) {
            TestAntwortDto erg_antwort = (TestAntwortDto)DtoAndMsg.get((DtoAndMsg)this.mc.getQuestionService().score(a, token.getToken()));
            erg_antwort = this.saveTestAnswerToDatabase(erg_antwort, token);
            TestDetailDto next = this.findNextQuestion(i, a.getIdDetail());
            QuestionWithAnswer q = this.loadQuestionFromDetail(next.getIdQuestion(), token);
            return new NextQuestionAndOldAnswerDto(q.getAngabe(), q.getAntwort(), q.getErgebnisseText(), erg_antwort);
        }
        throw new MsgException("err_edit_test_stopped");
    }

    public NextQuestionAndOldAnswerDto saveNext(TestAntwortDto a, LettoToken token) {
        Info i = this.status(a.getIdDetail(), token);
        if (i.canWrite()) {
            TestAntwortDto erg_antwort = this.saveTestAnswerToDatabase(a, token);
            TestDetailDto next = this.findNextQuestion(i, a.getIdDetail());
            QuestionWithAnswer q = this.loadQuestionFromDetail(next.getIdQuestion(), token);
            return new NextQuestionAndOldAnswerDto(q.getAngabe(), q.getAntwort(), q.getErgebnisseText(), erg_antwort);
        }
        throw new MsgException("err_edit_test_stopped");
    }

    public TestAntwortDto scorePenalty(TestAntwortDto a, LettoToken token) {
        Info i = this.status(a.getIdDetail(), token);
        if (i.canWrite()) {
            TestAntwortDto erg_antwort = (TestAntwortDto)DtoAndMsg.get((DtoAndMsg)this.mc.getTestQuestionService().scorePenalty(a, token.getToken()));
            return this.saveTestAnswerToDatabase(erg_antwort, token);
        }
        throw new MsgException("err_edit_test_stopped");
    }

    public TestAntwortDto saveAnswer(TestAntwortDto a, LettoToken token) {
        Info i = this.status(a.getIdDetail(), token);
        if (i.canWrite()) {
            a.setBewertung(Score.NotScored);
            return this.saveTestAnswerToDatabase(a, token);
        }
        throw new MsgException("err_edit_test_stopped");
    }

    public RestLettoDataService data(LettoToken token) {
        return this.mc.getDataService(token);
    }
}

