/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service.testservice;

import at.letto.data.dto.ObjAndMsg;
import at.letto.data.dto.activitytype.ActivitytypeBaseDto;
import at.letto.data.dto.beurteilung.StudentDto;
import at.letto.data.dto.beurteilung.StudentGroupDto;
import at.letto.data.dto.beuteilungsschema.BeurteilungsartDTO;
import at.letto.data.dto.beuteilungsschema.BeurteilungsconfigDTO;
import at.letto.data.dto.beuteilungsschema.NoteAndSymbol;
import at.letto.data.dto.dashboard.DashboardAllDto;
import at.letto.data.dto.gruppierung.InitTestInfoDto;
import at.letto.data.dto.testFrage.InsertTestFrageDto;
import at.letto.data.dto.tests.CreateEmptyTestVersuchDTO;
import at.letto.data.dto.tests.FragenGruppierung;
import at.letto.data.dto.tests.TestBereichDetailsDto;
import at.letto.data.dto.tests.TestBereichDto;
import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.TestEigenschaftsDto;
import at.letto.data.dto.tests.TestFrageDto;
import at.letto.data.dto.tests.TestGruppeDto;
import at.letto.data.dto.tests.TestInhaltDto;
import at.letto.data.dto.tests.TestVersuchDto;
import at.letto.data.dto.tests.score.TestScoreDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.edit.FeedbackVersuch;
import at.letto.edit.dto.test.TestVersucheAndTest;
import at.letto.edit.dto.testquestion.MoveTestFrageDto;
import at.letto.edit.dto.testresult.DetailResultlDto;
import at.letto.edit.dto.testresult.FrageResultDto;
import at.letto.edit.dto.testresult.HeaderResultsDto;
import at.letto.edit.dto.testresult.ResultsConfigDto;
import at.letto.edit.dto.testresult.TestGruppeResultsDto;
import at.letto.edit.dto.testresult.TestResultsDto;
import at.letto.edit.dto.testresult.VersuchResultDto;
import at.letto.globalinterfaces.IdEntity;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.beurteilung.BeurteilungService;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.lettoedit.service.testservice.MoveTestQuestions;
import at.letto.lettoedit.service.testservice.cache.CacheTest;
import at.letto.question.dto.score.CreateAnswerForQuestion;
import at.letto.question.restclient.QuestionRestService;
import at.letto.security.LettoToken;
import at.letto.tools.Cmd;
import at.letto.tools.Datum;
import at.letto.tools.JSON;
import at.letto.tools.enums.Score;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import jakarta.annotation.PostConstruct;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TestsService {
    private static CacheTest<TestInhaltDto> testCache;
    @Lazy
    @Autowired
    private ConfigService configService;
    @Lazy
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Lazy
    @Autowired
    private BeurteilungService beurteilungService;
    private ModelMapper mapper = new ModelMapper();
    private static Collator collator;
    Map<Integer, List<ActivitytypeBaseDto>> activityTypesMap = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        testCache = new CacheTest(500, this.microServiceConfiguration);
    }

    public int getAnzahlFragenInTestversuch(int idTestversuch, LettoToken token) {
        return (Integer)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.getAnzahlFragenInTestversuch(idTestversuch));
    }

    public TestEigenschaftsDto loadTestEigenschaften(int idTest, LettoToken token) {
        return this.loadTestInhalt(idTest, token).getTestEigenschaften();
    }

    public TestEigenschaftsDto loadTestEigenschaftenFromDb(int idTest, LettoToken token) {
        return (TestEigenschaftsDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestEigenschaften(idTest));
    }

    public TestEigenschaftsDto loadTestEigenschaftenByActivityFromDb(int idActivity, LettoToken token) {
        return (TestEigenschaftsDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestEigenschaftenByActivityId(idActivity));
    }

    public NoteAndSymbol getTestNote(TestVersuchDto v, TestEigenschaftsDto test, BeurteilungsconfigDTO schema, LettoToken token) {
        double proz;
        NoteAndSymbol erg = new NoteAndSymbol("", "");
        if (v == null) {
            return erg;
        }
        if (v.getPunkteIst() == null || v.getPunkteSoll() == null || v.getPunkteSoll() == -1.0) {
            return erg;
        }
        if (v.getPunkteSoll() <= 0.0) {
            return new NoteAndSymbol("--- X ---", "--- X ---");
        }
        try {
            proz = v.getPunkteIst() / v.getPunkteSoll() * 100.0;
        }
        catch (Exception e) {
            proz = 0.0;
        }
        try {
            BeurteilungsartDTO ba = (BeurteilungsartDTO)schema.getBeurteilungsartHash().get(test.getMode());
            if (ba == null) {
                BeurteilungsconfigDTO schDef = (BeurteilungsconfigDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurtConfig.findSchemaForBeurteilungsart(test.getMode()));
                ba = (BeurteilungsartDTO)schDef.getBeurteilungsartHash().get(test.getMode());
            }
            erg = ba.getNoteAndSymbol(Double.valueOf(proz));
        }
        catch (Exception e) {
            throw new MsgException("Keine Beurteilungen f\u00fcr diesen Test definiert! Keine Beurteilungen f\u00fcr diesen Test definiert!");
        }
        return erg;
    }

    private int getRandom(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public TestVersuchDto findLastTestVersuch(int idUser, int idTest, LettoToken token) {
        return this.findTestVersucheByUserId(idUser, idTest, token).getTestVersuche().stream().sorted(new /* Unavailable Anonymous Inner Class!! */).reduce((v1, v2) -> v2).orElse(null);
    }

    public TestVersucheAndTest findTestVersucheByUserId(int idUser, int idTest, LettoToken token) {
        TestEigenschaftsDto t = this.loadTestEigenschaften(idTest, token);
        TestEigenschaftsDto test = new TestEigenschaftsDto();
        if (!t.isVisible() && token.isStudent()) {
            throw new MsgException("err_test_not visible");
        }
        this.mapper.map((Object)t, (Object)test);
        test.setPassword("");
        List v = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersucheByUserId(idUser, idTest));
        return new TestVersucheAndTest(v, test);
    }

    private List<TestVersuchDto> findTestVersucheByUserAndId(int idUser, int idTest, LettoToken token) {
        return (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersucheByUserId(idUser, idTest));
    }

    public TestVersuchDto loadTestVersuch(int idTestversuch, int idTest, boolean checkFocus, LettoToken token) {
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        if (!test.getTestEigenschaften().isVisible() && token.isStudent()) {
            throw new MsgException("err_test_not visible");
        }
        TestVersuchDto v = (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersuchComplete(idTestversuch, test));
        if (v == null) {
            throw new MsgException("err_test_versuch_not_existing", new String[]{"" + idTestversuch, "" + idTest});
        }
        if (!v.isFinished() && !this.isTestAvailable(test.getTestEigenschaften(), new Date())) {
            throw new MsgException("err_test_time_error", new String[]{"" + idTestversuch, "" + idTest});
        }
        if (checkFocus && !v.isFinished() && test.getTestEigenschaften().isDontLeave() && !v.isFocusLostCleared()) {
            v.setFinished(true);
            Object protokoll = v.getFocusLostProtokoll();
            if (protokoll == null) {
                protokoll = "";
            }
            protokoll = (String)protokoll + "C:" + Datum.simpleTimeFormat.format(new Date()) + "\n";
            v.setFocusLostProtokoll((String)protokoll);
            v.setFocusLost(true);
            v.setBereiche(new Vector());
            return v;
        }
        if (v.isFinished()) {
            if (v.isFocusLost()) {
                throw new MsgException("err_test_focuslost_not_cleared");
            }
            v.setProzent(v.getPunkteIst() / v.getPunkteSoll());
            BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(test.getTestEigenschaften().getIdLk(), token);
            v.setNoteAndSymbol(this.getTestNote(v, test.getTestEigenschaften(), schema, token));
            if (!this.checkShowTestVersuchResults(v, test, token)) {
                v.setBereiche(new Vector());
                return v;
            }
        } else if (test.getTestEigenschaften().isFixReihenfolge()) {
            v.setIdDetailStart(this.getIdNextDetail(v, test, token));
        }
        return v;
    }

    private boolean checkShowTestVersuchResults(TestVersuchDto v, TestInhaltDto test, LettoToken token) {
        TestEigenschaftsDto t;
        if (!(!v.isFinished() || (t = test.getTestEigenschaften()).isStop() && t.getTestStop() != null && t.getTestStop().before(new Date()))) {
            String mode = t.getMode();
            BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(t.getIdLk(), token);
            BeurteilungsartDTO ba = schema.getBeurteilungsart(mode, "", true);
            if (ba == null) {
                ba = (BeurteilungsartDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurtConfig.loadBeurteilungsartByBezeichner(mode));
                if (ba == null) {
                    return false;
                }
                schema.getBeurteilungsartHash().put(mode, ba);
            }
            return ba.getBeurteilungsart().isCheckPossible();
        }
        return true;
    }

    private TestVersuchDto reloadTestVersuch(int idTestversuch, TestInhaltDto test, LettoToken token) {
        return (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersuchComplete(idTestversuch, test));
    }

    public TestVersuchDto loadTestVersuchSimple(int idTestversuch, LettoToken token) {
        return (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersuchSimple(idTestversuch));
    }

    public List<TestVersuchDto> loadTestVersucheSimple(int idTest, LettoToken token) {
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(test.getTestEigenschaften().getIdLk(), token);
        collator.setStrength(1);
        List<TestVersuchDto> versuche = ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersucheSimple(idTest))).stream().sorted(Comparator.comparing(TestVersuchDto::getFullname, collator)).collect(Collectors.toList());
        versuche.forEach(v -> {
            try {
                v.setProzent(v.getPunkteIst() / v.getPunkteSoll());
                v.setNoteAndSymbol(this.getTestNote(v, test.getTestEigenschaften(), schema, token));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return versuche;
    }

    public TestInhaltDto loadTestInhalt(int idTest, LettoToken token) {
        if (idTest <= 0) {
            return null;
        }
        return (TestInhaltDto)testCache.load(idTest, token);
    }

    public void changeName(int idTest, String name, LettoToken token) {
        TestEigenschaftsDto t = this.loadTestEigenschaften(idTest, token);
        if (t == null) {
            throw new MsgException("errTestNotFound");
        }
        t.setName(name);
    }

    public void changeVisible(int idTest, boolean visible, LettoToken token) {
        TestEigenschaftsDto t = this.loadTestEigenschaften(idTest, token);
        if (t == null) {
            throw new MsgException("errTestNotFound");
        }
        t.setVisible(visible);
    }

    public void clearTestCache(int idTest, LettoToken token) {
        testCache.remove(idTest, token);
    }

    public TestInhaltDto loadTestInhaltFromDatabase(int idTest, LettoToken token) {
        return (TestInhaltDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestFull(idTest));
    }

    public TestVersuchDto createTestVersuchForStudent(Map<String, String> vals, LettoToken token) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idUser = Integer.parseInt(vals.get("idUser"));
        int idGruppe = Integer.parseInt(vals.get("idGruppe"));
        String pwd = vals.get("pwd");
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        TestEigenschaftsDto t = test.getTestEigenschaften();
        if (!t.isVisible()) {
            throw new MsgException("err_test_not visible");
        }
        if (!Cmd.isEmpty((String)t.getPassword()) && !t.getPassword().equals(pwd)) {
            throw new MsgException("err_test_open_wrong_password");
        }
        if (!this.isNewTestVersuchAvailable(test, this.findTestVersucheByUserAndId(idUser, idTest, token))) {
            throw new MsgException("err_test_open_no_further_trials");
        }
        return this.createTestVersuch(test, idUser, idGruppe, false, token);
    }

    public TestVersuchDto createTestVersuch(TestInhaltDto test, int idUser, int idGruppe, boolean forceBlocked, LettoToken token) {
        TestVersuchDto v = new TestVersuchDto();
        v.setIdUser(idUser);
        v.setIdTest(test.getIdTest());
        if (idGruppe < 0) {
            idGruppe = ((TestGruppeDto)test.getTestGruppen().get(0)).getId();
        }
        v.setIdTestGruppe(idGruppe);
        v.setStartDatum(new Date());
        v.setFinished(false);
        if (forceBlocked) {
            v.setPunkteSoll(Double.valueOf(-1.0));
            v.setPunkteIst(Double.valueOf(-1.0));
            v.setFinished(true);
        }
        return this.adaptTo(v, test, token);
    }

    public TestVersuchDto saveTestVersuchAll(TestVersuchDto testVersuchDto, LettoToken token) {
        return (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.saveTestVersuch(testVersuchDto, false));
    }

    private List<Integer> findQuestonsToRemove(TestVersuchDto v, TestGruppeDto g) {
        List idsTestfragenInTest = g.getBereiche().stream().map(b -> b.getGruppierungen()).flatMap(Collection::stream).map(gr -> gr.getTestFragen()).flatMap(Collection::stream).map(tf -> tf.getId()).collect(Collectors.toList());
        return v.getBereiche().stream().map(b -> b.getTestDetails()).flatMap(Collection::stream).filter(td -> !idsTestfragenInTest.contains(td.getIdTestFrage())).map(td -> td.getIdTestFrage()).collect(Collectors.toList());
    }

    public TestVersuchDto adaptTo(TestVersuchDto v, TestInhaltDto t, LettoToken token) {
        return this.adaptToDatabase(v, t, token);
    }

    public TestVersuchDto adaptToDatabase(TestVersuchDto v, TestInhaltDto t, LettoToken token) {
        return this.adaptToDatabase(v, t, true, token);
    }

    public TestVersuchDto adaptToDatabase(TestVersuchDto v, TestInhaltDto t, boolean save, LettoToken token) {
        v = (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.adaptTestVersuch(v, t));
        if (t.getTestEigenschaften().isFragenMischen()) {
            // empty if block
        }
        return v;
    }

    public boolean isTestAvailable(TestEigenschaftsDto test, Date d) {
        if (test.getTestStart() != null && d.before(test.getTestStart())) {
            return false;
        }
        return !test.isStop() || test.getTestStop() == null || !d.after(test.getTestStop());
    }

    public boolean isNewTestVersuchAvailable(TestInhaltDto test, List<TestVersuchDto> versuche) {
        if (test == null) {
            return false;
        }
        boolean openTest = false;
        if (test.getTestEigenschaften().getMode() == null) {
            return false;
        }
        if (versuche != null) {
            int vAnz = versuche.size();
            int erl = test.getTestEigenschaften().getErlaubteVersuche();
            if (vAnz > 0 && vAnz >= erl && erl > 0) {
                return false;
            }
            for (TestVersuchDto v : versuche) {
                if (v.isFinished()) continue;
                openTest = true;
            }
        }
        if (openTest) {
            return false;
        }
        return this.isTestAvailable(test.getTestEigenschaften(), new Date());
    }

    public TestInhaltDto closeTest(TestInhaltDto test, LettoToken token) {
        Date stop = new Date();
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.stopTest(test.getIdTest(), stop, true));
        test.getTestEigenschaften().setStop(true);
        test.getTestEigenschaften().setTestStop(stop);
        testCache.put((IdEntity)test, token);
        return test;
    }

    public void insertEmptyVersuche(int idTest, LettoToken token) {
        HashSet<Integer> idTests = new HashSet<Integer>(1);
        idTests.add(idTest);
        ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadStudentsForCreateVersuch(idTests))).forEach(i -> this.startTestUser(i, token));
    }

    public List<TestVersuchDto> findOpenTestVersucheByTestId(int idTest, LettoToken token) {
        return (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadOpenTestVersucheByTestId(idTest));
    }

    public String rescoreX(int idTestVersuch, int idTest, boolean closeVersuch, boolean rescoreTestFragen, boolean rescoreNotScored, boolean clearLehrerBeurteilung) {
        return "";
    }

    public double calcTestSum(TestInhaltDto t, int idGruppe) {
        return t.getTestGruppen().stream().filter(g -> g.getId() == idGruppe).findFirst().map(g -> g.getBereiche().stream().map(b -> b.getGruppierungen()).flatMap(Collection::stream).map(gr -> gr.getAnz() == 0 ? gr.getTestFragen().stream().mapToDouble(TestFrageDto::getPoints).sum() : gr.getTestFragen().stream().findFirst().map(tf1 -> tf1.getPoints() * (double)gr.getAnz()).orElse(0.0).doubleValue()).mapToDouble(s -> s).sum()).orElse(0.0);
    }

    public TestAntwortDto loadAntwortForTestDetail(TestDetailDto td, int idTest, LettoToken token) {
        TestAntwortDto a = null;
        if (td.getTestAntwortJson() != null && !td.getTestAntwortJson().isEmpty()) {
            try {
                a = (TestAntwortDto)JSON.jsonToObj((String)td.getTestAntwortJson(), TestAntwortDto.class);
                a.setIdDetail(td.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (a == null && (a = (TestAntwortDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).td.loadLastTestAntwort(td.getId()))) != null) {
            a.setIdDetail(td.getId());
            td.setTestAntwortJson(JSON.objToJson((Object)a));
            DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).td.saveTestDetailAnswer(td.getId(), td.getTestAntwortJson()));
        }
        return a;
    }

    public boolean isCheckPossibleForTest(int idTest, LettoToken token) {
        TestEigenschaftsDto test = this.loadTestInhalt(idTest, token).getTestEigenschaften();
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(test.getIdLk(), token);
        if (test == null) {
            return true;
        }
        if (schema == null) {
            return false;
        }
        String mode = test.getMode();
        BeurteilungsartDTO ba = schema.getBeurteilungsart(mode, "", true);
        if (ba == null) {
            ba = (BeurteilungsartDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurtConfig.loadBeurteilungsartByBezeichner(mode));
            if (ba == null) {
                return false;
            }
            schema.getBeurteilungsartHash().put(mode, ba);
        }
        return ba.getBeurteilungsart().isCheckPossible();
    }

    public ObjAndMsg<VersuchResultDto> sperrenTestVersuch(ResultsConfigDto conf, LettoToken token) {
        int idVersuch = conf.getIdTestVersuch();
        boolean showNoGroups = conf.isShowNoGroups();
        TestVersuchDto v = this.loadTestVersuchSimple(idVersuch, token);
        v.setFinished(true);
        v.setFocusLostCleared(false);
        v.setFocusLost(true);
        Object protokoll = v.getFocusLostProtokoll();
        if (protokoll == null) {
            protokoll = "";
        }
        protokoll = (String)protokoll + "S:" + Datum.simpleTimeFormat.format(new Date()) + "\n";
        v.setFocusLostProtokoll((String)protokoll);
        TestVersuchDto ret = this.saveTestVersuchAll(v, token);
        return new ObjAndMsg((Object)this.mapToResult(ret, this.loadTestInhalt(v.getIdTest(), token), showNoGroups, token));
    }

    private VersuchResultDto mapToResult(TestVersuchDto v, TestInhaltDto t, boolean showNoGroups, LettoToken token) {
        VersuchResultDto vResult = new VersuchResultDto(v.getId(), v.getIdLk(), v.getIdUser(), v.getIdTestGruppe(), v.getFullname(), v.getSokratesId(), "", v.getSchuelergruppe(), v.isFinished(), v.getPunkteIst(), v.getPunkteSoll(), v.getProzent(), v.getNote(), Datum.formatDateTime((Date)v.getStartDatum()), Datum.formatDateTime((Date)v.getStopDatum()), v.isFocusLost(), v.isFocusLostCleared(), v.getFocusLostProtokoll(), v.getIndexStartQuestion(), v.getReihenfolge(), new Vector());
        List gruppenListe = this.loadHeader(t, showNoGroups);
        Map<Integer, TestGruppeResultsDto> mapGroupById = gruppenListe.stream().collect(Collectors.toMap(TestGruppeResultsDto::getIdGruppe, g -> g));
        TestGruppeResultsDto gruppe = mapGroupById.get(v.getIdTestGruppe());
        if (gruppe != null) {
            vResult.setDetails(this.getEmptyList(gruppe.getHeader().size()));
            v.getBereiche().stream().map(b -> b.getTestDetails()).flatMap(Collection::stream).forEach(td -> {
                int pos = gruppe.findFragenPos(td.getIdTestFrage());
                if (pos >= 0) {
                    DetailResultlDto tdRes = this.mapTo(td);
                    tdRes.setUser(v.getFullname());
                    if (vResult.getDetails().get(pos) == null) {
                        vResult.getDetails().set(pos, tdRes);
                    } else {
                        while (pos < vResult.getDetails().size() && vResult.getDetails().get(pos) != null) {
                            ++pos;
                        }
                        if (pos < vResult.getDetails().size()) {
                            vResult.getDetails().set(pos, tdRes);
                        }
                    }
                }
            });
        }
        this.addGruppenInfo(vResult, t.getTestEigenschaften().getId(), token);
        return vResult;
    }

    public int getIdNextDetail(TestVersuchDto v, TestInhaltDto t, LettoToken token) {
        if (t.getTestEigenschaften().isFixReihenfolge()) {
            String index = v.getIndexStartQuestion();
            if (!Cmd.isEmpty((String)index)) {
                this.saveTestVersuchStartPos(v.getId(), "", token);
                try {
                    String[] x = index.split("-");
                    int ber = 0;
                    int i = 0;
                    if (x.length == 2) {
                        ber = Integer.parseInt(x[0]) - 1;
                        i = Integer.parseInt(x[1]) - 1;
                    } else if (x.length == 1) {
                        i = Integer.parseInt(x[0]) - 1;
                    }
                    if (i >= 0 && ber >= 0) {
                        return ((TestDetailDto)((TestBereichDetailsDto)v.getBereiche().get(ber)).getTestDetails().get(i)).getId();
                    }
                }
                catch (Exception exception) {}
            } else {
                return v.getBereiche().stream().map(b -> b.getTestDetails()).flatMap(Collection::stream).filter(td -> td.getTestAntwortJson() == null || td.getTestAntwortJson().isEmpty()).findFirst().map(td -> td.getId()).orElse(0);
            }
        }
        return v.getBereiche().stream().findFirst().map(b -> b.getTestDetails().stream().findFirst().map(td -> td.getId()).orElse(0)).orElse(0);
    }

    public void saveTestVersuchStartPos(int idVersuch, String pos, LettoToken token) {
        DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.saveTestVersuchStartPos(idVersuch, pos));
    }

    public TestResultsDto loadTestResults(ResultsConfigDto conf, LettoToken token) {
        return this.loadTestResults(conf.getIdTest(), conf.isAllStudents(), false, conf.isShowNoGroups(), token);
    }

    public TestResultsDto loadTestResultsInput(ResultsConfigDto conf, LettoToken token) {
        return this.loadTestResults(conf.getIdTest(), conf.isAllStudents(), true, conf.isShowNoGroups(), token);
    }

    private TestResultsDto loadTestResults(int idTest, boolean allStudents, boolean inputTable, boolean showNoGroups, LettoToken token) {
        TestInhaltDto t = this.loadTestInhalt(idTest, token);
        System.out.println("Testinhalt geladen");
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(t.getTestEigenschaften().getIdLk(), token);
        TestEigenschaftsDto test = t.getTestEigenschaften();
        int idLk = test.getIdLk();
        if (idLk <= 0 && test.getIdKlassenbeurteilung() > 0) {
            idLk = (Integer)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadIdLkBeurteilung(test.getIdKlassenbeurteilung()));
            test.setIdLk(idLk);
        }
        List versuche = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersucheSimple(idTest));
        System.out.println(versuche.size() + " Testversuche geladen");
        versuche.forEach(v -> {
            try {
                v.setProzent(v.getPunkteIst() / v.getPunkteSoll());
                v.setNoteAndSymbol(this.getTestNote(v, t.getTestEigenschaften(), schema, token));
            }
            catch (Exception e) {
                v.setProzent(0.0);
            }
        });
        List students = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadStudents(idLk));
        List<VersuchResultDto> vers = versuche.stream().filter(v -> students.stream().anyMatch(s -> s.getId() == v.getIdUser())).map(v -> {
            Optional<StudentDto> s = students.stream().filter(st -> st.getId() == v.getIdUser()).findFirst();
            if (s.isPresent()) {
                return new VersuchResultDto(v.getId(), v.getIdLk(), v.getIdUser(), v.getIdTestGruppe(), v.getFullname(), v.getSokratesId(), "", v.getSchuelergruppe(), v.isFinished(), v.getPunkteIst(), v.getPunkteSoll(), v.getProzent(), v.getNote(), Datum.formatDateTime((Date)v.getStartDatum()), Datum.formatDateTime((Date)v.getStopDatum()), v.isFocusLost(), v.isFocusLostCleared(), v.getFocusLostProtokoll(), v.getIndexStartQuestion(), v.getReihenfolge(), new Vector());
            }
            return null;
        }).filter(v -> v != null).collect(Collectors.toList());
        System.out.println(vers.size() + " Testversuche umgewandelt in VersuchsResult");
        List tds = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).td.loadTestDetailsByTestId(idTest));
        System.out.println(tds.size() + " TestDetails geladen");
        tds.stream().filter(td -> !Cmd.isEmpty((String)td.getTestAntwortJson())).forEach(td -> td.getTestAntwort());
        Set idsMissingAnswers = tds.stream().filter(td -> Cmd.isEmpty((String)td.getTestAntwortJson())).map(TestDetailDto::getId).collect(Collectors.toSet());
        List answers = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).td.loadLastTestAnswers(idsMissingAnswers));
        System.out.println(answers.size() + " Testantworten geladen");
        Map<Integer, TestDetailDto> tdMapId = tds.stream().collect(Collectors.toMap(TestDetailDto::getId, td -> td));
        for (TestAntwortDto answer : answers) {
            Object td2;
            if (answer == null || (td2 = tdMapId.get(answer.getIdDetail())) == null) continue;
            td2.setTestAntwort(answer);
            td2.setTestAntwortJson(JSON.objToJson((Object)answer));
            DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).td.saveTestDetailAnswer(td2.getId(), td2.getTestAntwortJson()));
        }
        System.out.println("Testdetails JSON Answer in DB gespeichert");
        List gruppenListe = this.loadHeader(t, showNoGroups);
        Map<Integer, TestGruppeResultsDto> mapGroupById = gruppenListe.stream().collect(Collectors.toMap(TestGruppeResultsDto::getIdGruppe, g -> g));
        for (VersuchResultDto v3 : vers) {
            if (!mapGroupById.containsKey(v3.getIdGruppe())) continue;
            mapGroupById.get(v3.getIdGruppe()).getVersuche().add(v3);
        }
        TestGruppeResultsDto firstGroup = (TestGruppeResultsDto)gruppenListe.get(0);
        if (allStudents) {
            System.out.println(students.size() + " Studenten geladen");
            if (allStudents && firstGroup != null) {
                List leereVersuche = students.stream().filter(s -> versuche.stream().noneMatch(v -> v.getIdUser() == s.getId())).map(s -> {
                    VersuchResultDto v = new VersuchResultDto();
                    v.setIdUser(s.getId());
                    v.setFullname(s.getFullName2());
                    v.setSokratesId(s.getSokratesID());
                    if (inputTable) {
                        v.setDetails(firstGroup.getHeader().stream().filter(h -> h.getFragen() != null && h.getFragen().size() > 0).map(h -> {
                            FrageResultDto tf = (FrageResultDto)h.getFragen().get(0);
                            return new DetailResultlDto(0, 0, tf.getIdFrage(), h.getIdGruppeFragen(), "", Double.valueOf(0.0), 0, tf.getFragenName(), "", new Vector(), new Vector(), new Vector(), v.getFullname());
                        }).collect(Collectors.toList()));
                    }
                    return v;
                }).collect(Collectors.toList());
                firstGroup.getVersuche().addAll(leereVersuche);
                vers.addAll(leereVersuche);
                System.out.println(leereVersuche.size() + " Leere Versuche angelegt");
            }
        }
        boolean gruppenInfo = this.addGruppenInfo(t.getTestEigenschaften().getIdLk(), vers, token);
        System.out.println("Beginn Einbauen der TestDetails in die Testversuche");
        vers.forEach(v -> {
            TestGruppeResultsDto gruppe = (TestGruppeResultsDto)mapGroupById.get(v.getIdGruppe());
            if (gruppe != null) {
                v.setDetails(this.getEmptyList(gruppe.getHeader().size()));
            }
        });
        Map<Integer, VersuchResultDto> mapVersuche = vers.stream().collect(Collectors.toMap(VersuchResultDto::getId, v -> v, (v1, v2) -> v1));
        System.out.println(mapVersuche.size() + "TestVersuchsMap");
        Map<Integer, List<TestDetailDto>> mapIdVersuchToTds = tds.stream().collect(Collectors.groupingBy(d -> d.getIdTestVersuch()));
        mapVersuche.values().forEach(v -> {
            List d = (List)mapIdVersuchToTds.get(v.getId());
            if (d != null) {
                Vector<TestDetailDto> sorted = new Vector<TestDetailDto>();
                for (String p : v.getReihenfolge().replaceAll("\\[", "").replaceAll("\\]", "").split(",")) {
                    try {
                        int x = Integer.parseInt(p.trim());
                        if (d.get(x) == null) continue;
                        sorted.add((TestDetailDto)d.get(x));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                mapIdVersuchToTds.put(v.getId(), sorted);
            }
        });
        tds.forEach(td -> {
            VersuchResultDto v;
            TestGruppeResultsDto gruppe;
            if (mapVersuche.containsKey(td.getIdTestVersuch()) && (gruppe = (TestGruppeResultsDto)mapGroupById.get((v = (VersuchResultDto)mapVersuche.get(td.getIdTestVersuch())).getIdGruppe())) != null) {
                int pos;
                td.setBpNrSchueler(((List)mapIdVersuchToTds.get(v.getId())).indexOf(td) + 1);
                if (pos >= 0) {
                    DetailResultlDto tdRes = this.mapTo(td);
                    tdRes.setUser(v.getFullname());
                    if (v.getDetails().get(pos) == null) {
                        v.getDetails().set(pos, tdRes);
                    } else {
                        for (pos = gruppe.findFragenPos(td.getIdTestFrage()); pos < v.getDetails().size() && v.getDetails().get(pos) != null; ++pos) {
                        }
                        if (pos < v.getDetails().size()) {
                            v.getDetails().set(pos, tdRes);
                        }
                    }
                }
            }
        });
        System.out.println("Ende: " + gruppenListe.size() + " -- " + ((TestGruppeResultsDto)gruppenListe.get(0)).getHeader());
        collator.setStrength(1);
        gruppenListe.stream().forEach(g -> g.setVersuche(g.getVersuche().stream().sorted(Comparator.comparing(VersuchResultDto::getFullname, collator)).collect(Collectors.toList())));
        return new TestResultsDto(gruppenListe, t.getTestEigenschaften().getName(), gruppenInfo);
    }

    private boolean addGruppenInfo(int idLk, List<VersuchResultDto> versuche, LettoToken token) {
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(idLk, token);
        String lkConf = (String)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadLehrerKlasseConfig(idLk));
        boolean gruppenInfo = false;
        String groupFilter = "";
        if (!Cmd.isEmpty((String)lkConf)) {
            lkConf = lkConf.replaceAll("^\\[", "").replaceAll("\\]$", "");
            List showTestModes = Arrays.asList(lkConf.split(",")).stream().map(m -> m.trim()).collect(Collectors.toList());
            gruppenInfo = showTestModes.contains("groups");
            groupFilter = showTestModes.stream().filter(c -> c.startsWith("grSel:")).findFirst().orElse("").replaceAll("grSel:", "").trim();
        } else {
            gruppenInfo = schema.isGruppierung();
        }
        if (gruppenInfo) {
            Map<Integer, StudentGroupDto> mapGruppen = ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadStudentGroups(idLk))).stream().collect(Collectors.toMap(g -> g.getIdUser(), g -> g, (g1, g2) -> g2));
            versuche.forEach(v -> {
                if (mapGruppen.containsKey(v.getIdUser())) {
                    v.setSchuelergruppe(((StudentGroupDto)mapGruppen.get(v.getIdUser())).getGruppenName());
                }
            });
        }
        if (!Cmd.isEmpty((String)groupFilter)) {
            Iterator<VersuchResultDto> iter = versuche.iterator();
            while (iter.hasNext()) {
                if (!iter.hasNext()) continue;
                VersuchResultDto v2 = iter.next();
                try {
                    if (groupFilter.startsWith(v2.getSchuelergruppe())) continue;
                    iter.remove();
                }
                catch (Exception exception) {}
            }
        }
        return gruppenInfo;
    }

    private boolean addGruppenInfo(VersuchResultDto v, int idTest, LettoToken token) {
        Map<Integer, StudentGroupDto> mapGruppen;
        int idLk = this.loadTestInhalt(idTest, token).getTestEigenschaften().getIdLk();
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(idLk, token);
        if (schema == null) {
            return false;
        }
        String lkConf = (String)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadLehrerKlasseConfig(idLk));
        boolean showGroups = false;
        if (!Cmd.isEmpty((String)lkConf)) {
            lkConf = lkConf.replaceAll("^\\[", "").replaceAll("\\]$", "");
            List showTestModes = Arrays.asList(lkConf.split(",")).stream().map(m -> m.trim()).collect(Collectors.toList());
            showGroups = showTestModes.contains("groups");
        } else {
            showGroups = schema.isGruppierung();
        }
        boolean gruppenInfo = schema.isGruppierung();
        if (showGroups && (mapGruppen = ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadStudentGroups(idLk))).stream().collect(Collectors.toMap(g -> g.getIdUser(), g -> g, (g1, g2) -> g2))).containsKey(v.getIdUser())) {
            v.setSchuelergruppe(mapGruppen.get(v.getIdUser()).getGruppenName());
        }
        return gruppenInfo;
    }

    private <T> List<T> getEmptyList(int n) {
        Vector<Object> erg = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            erg.add(null);
        }
        return erg;
    }

    private DetailResultlDto mapTo(TestDetailDto td) {
        DetailResultlDto res = new DetailResultlDto();
        res.setId(td.getId());
        res.setIdTestVersuch(td.getIdTestVersuch());
        res.setIdTestFrage(td.getIdTestFrage());
        res.setFragenName(td.getFragenname());
        if (!Cmd.isEmpty((String)td.getFeedbackFilename())) {
            res.setFeedbackDocument(this.microServiceConfiguration.getImageService().getURL(td.getFeedbackFilename()));
        }
        res.setFiles(td.getFiles());
        res.setBpNr(td.getBpNrSchueler());
        res.setColorClass(this.getFeedbackColor(td.getTestAntwort()));
        res.setPoints(td.getTestAntwort() != null ? Double.valueOf(td.getTestAntwort().getPoints()) : null);
        return res;
    }

    private List<TestGruppeResultsDto> loadHeader(TestInhaltDto t, boolean showNoGroups) {
        Vector<TestGruppeResultsDto> gruppen = new Vector<TestGruppeResultsDto>();
        t.getTestGruppen().forEach(g -> {
            TestGruppeResultsDto gr = new TestGruppeResultsDto();
            gr.setName(g.getGruppenName());
            gr.setIdGruppe(g.getId());
            int i = 0;
            int countGroup = 0;
            for (TestBereichDto b : g.getBereiche()) {
                for (FragenGruppierung fg : b.getGruppierungen()) {
                    if (fg.getAnz() == 0 || showNoGroups) {
                        for (TestFrageDto tf : fg.getTestFragen()) {
                            gr.getHeader().add(new HeaderResultsDto(tf, i++));
                        }
                        continue;
                    }
                    ++countGroup;
                    for (int j = 0; j < fg.getAnz(); ++j) {
                        gr.getHeader().add(new HeaderResultsDto(fg, i++, countGroup, j + 1));
                    }
                }
            }
            gruppen.add(gr);
        });
        return gruppen;
    }

    public void insertTestVersucheForAllStudents(int idTests, LettoToken token) {
        HashSet<Integer> ids = new HashSet<Integer>();
        ids.add(idTests);
        this.insertNotwendigeSchuelerVersuche(ids, token);
    }

    private boolean check(TestAntwortDto a, boolean clearLehrerBeurteilung) {
        if (a == null) {
            return false;
        }
        if (!a.isManuellScored()) {
            return true;
        }
        return clearLehrerBeurteilung;
    }

    public String updateTestFragePoints(int idTestfrage, int idTest, double points, LettoToken token) {
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        TestFrageDto testfrage = test.getTestGruppen().stream().map(g -> g.getBereiche()).flatMap(Collection::stream).map(b -> b.getGruppierungen()).flatMap(Collection::stream).map(gr -> gr.getTestFragen()).flatMap(Collection::stream).filter(tf -> tf.getId() == idTestfrage).findFirst().get();
        if (testfrage == null) {
            throw new MsgException("tf.err.testfrage_not_found");
        }
        if (testfrage.getGruppierung() > 0) {
            DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.updateTestFragePointsInGruppe(testfrage.getGruppierung(), points));
            test.getTestGruppen().stream().map(g -> g.getBereiche()).flatMap(Collection::stream).map(b -> b.getGruppierungen()).flatMap(Collection::stream).filter(gr -> gr.getTestFragen().stream().anyMatch(f -> f.getId() == testfrage.getId())).map(gr -> gr.getTestFragen()).flatMap(Collection::stream).forEach(tf -> tf.setPoints(points));
        } else {
            DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.updateTestFragePoints(testfrage.getId(), points));
            testfrage.setPoints(points);
        }
        return "";
    }

    public String delTestVersuch(int id, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.delTestVersuch(id));
        TestVersuchDto v = (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersuchSimple(id));
        if (v == null) {
            throw new MsgException("Testversuch wurde in DB nicht gefunden");
        }
        TestEigenschaftsDto t = this.loadTestEigenschaften(v.getIdTest(), token);
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(t.getIdLk(), token);
        if (t == null) {
            throw new RuntimeException("Test zu Testversuch existert nicht!");
        }
        if (t.getIdKlassenbeurteilung() > 0) {
            this.beurteilungService.saveInKlassenBeurteilung("", 0.0, v.getIdUser(), t.getIdKlassenbeurteilung(), schema.getId(), token);
        }
        if (t.getIdBeurteilung() > 0) {
            this.beurteilungService.saveInBeurteilung("", 0.0, v.getIdUser(), t.getIdBeurteilung(), schema.getId(), token);
        }
        return "";
    }

    public String getFeedback(Score bewertung) {
        return FeedbackVersuch.getFeedback((Score)bewertung);
    }

    public String getFeedbackColor(TestAntwortDto answer) {
        return FeedbackVersuch.getFeedbackColor((TestAntwortDto)answer);
    }

    public ObjAndMsg<VersuchResultDto> blockTestVersuch(ResultsConfigDto conf, LettoToken token) {
        int idUser = conf.getIdUser();
        int idTest = conf.getIdTest();
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        int gruppenNr = this.getRandom(0, test.getTestGruppen().size() - 1);
        int idGruppe = ((TestGruppeDto)test.getTestGruppen().get(gruppenNr)).getId();
        TestVersuchDto testVersuch = this.createTestVersuch(test, idUser, idGruppe, true, token);
        return new ObjAndMsg((Object)this.mapToResult(testVersuch, test, conf.isShowNoGroups(), token));
    }

    public ObjAndMsg<VersuchResultDto> createTestVersuchResult(ResultsConfigDto conf, LettoToken token) {
        int idUser = conf.getIdUser();
        int idTest = conf.getIdTest();
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        int gruppenNr = this.getRandom(0, test.getTestGruppen().size() - 1);
        int idGruppe = ((TestGruppeDto)test.getTestGruppen().get(gruppenNr)).getId();
        TestVersuchDto testVersuch = this.createTestVersuch(test, idUser, idGruppe, false, token);
        return new ObjAndMsg((Object)this.mapToResult(testVersuch, test, conf.isShowNoGroups(), token));
    }

    public void closeTestVersuche(Set<Integer> idTests, LettoToken token) {
        idTests.forEach(id -> {
            List vers = this.loadTestVersucheSimple(id.intValue(), token);
            vers.forEach(v -> {
                v.setFinished(true);
                this.saveTestVersuchAll(v, token);
            });
        });
    }

    public static <T> Consumer<T> withCounter(BiConsumer<Integer, T> consumer) {
        AtomicInteger counter = new AtomicInteger(0);
        return item -> consumer.accept(counter.getAndIncrement(), item);
    }

    public RestLettoDataService data(LettoToken token) {
        return this.microServiceConfiguration.getDataService(token);
    }

    public void insertNotwendigeSchuelerVersuche(Set<Integer> idTests, LettoToken token) {
        List x = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadStudentsForCreateVersuch(idTests));
        x.stream().collect(Collectors.groupingBy(a -> a.getIdTest()));
        x.forEach(i -> this.startTestUser(i, token));
    }

    public TestVersuchDto startTestUser(CreateEmptyTestVersuchDTO i, LettoToken token) {
        Date d = new Date();
        TestInhaltDto test = (TestInhaltDto)testCache.load(i.getIdTest(), token);
        TestVersuchDto v = new TestVersuchDto();
        v.setIdUser(i.getIdUser());
        v.setIdTest(i.getIdTest());
        try {
            v.setIdTestGruppe(((TestGruppeDto)test.getTestGruppen().get(0)).getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        v.setStartDatum(d);
        v.setOpenTestTime(test.getTestEigenschaften().getDauer() * 60);
        v.setUsedForKatalog(true);
        return (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.adaptTestVersuch(v, test));
    }

    public List<TestFrageDto> moveTestfrage(MoveTestFrageDto dto, LettoToken token) {
        int from = dto.getFrom();
        int to = dto.getTo();
        int idBereich = dto.getIdBereich();
        int idTest = dto.getIdTest();
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        List tfs = MoveTestQuestions.moveTestfrage((int)from, (int)to, (int)idBereich, (TestInhaltDto)test);
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.saveFragenOrder(tfs));
        return tfs;
    }

    public String delTestFrage(int idTest, int idTestfrage, LettoToken token) {
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        boolean found = false;
        block0: for (TestGruppeDto g : test.getTestGruppen()) {
            for (TestBereichDto b : g.getBereiche()) {
                for (FragenGruppierung gr : b.getGruppierungen()) {
                    for (TestFrageDto tf : gr.getTestFragen()) {
                        if (tf.getId() != idTestfrage) continue;
                        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.delTestFrage(tf.getId()));
                        gr.getTestFragen().remove(tf);
                        found = true;
                        break block0;
                    }
                }
            }
        }
        if (!found) {
            throw new MsgException("tf.err.not.exists");
        }
        return "";
    }

    public String isolateTestFrage(int idTest, List<TestFrageDto> testfragen, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.isolateTestFrage(testfragen));
        TestInhaltDto test = this.loadTestInhalt(idTest, token);
        List tfs = test.getTestGruppen().stream().map(g -> g.getBereiche()).flatMap(Collection::stream).map(b -> b.getGruppierungen()).flatMap(Collection::stream).map(gr -> gr.getTestFragen()).flatMap(Collection::stream).filter(tf -> testfragen.stream().anyMatch(x -> x.getId() == tf.getId())).collect(Collectors.toList());
        for (TestFrageDto tf2 : tfs) {
            tf2.setIdCategory(0);
        }
        return "";
    }

    public InitTestInfoDto loadInitTestInfo(Map<String, String> vals, LettoToken token) {
        TestInhaltDto test;
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idParentFolder = Integer.parseInt(vals.get("idParentFolder"));
        int idLk = Integer.parseInt(vals.get("idLk"));
        InitTestInfoDto info = (InitTestInfoDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadInitTestInfo(idTest, idParentFolder, idLk));
        TestInhaltDto testInhaltDto = test = idTest > 0 ? this.loadTestInhalt(idTest, token) : new TestInhaltDto();
        if (idTest == 0) {
            TestEigenschaftsDto testEigenschaften = new TestEigenschaftsDto();
            test.setTestEigenschaften(testEigenschaften);
        }
        info.getGruppierungen().stream().filter(gr -> gr.getTests().stream().anyMatch(t -> t.getId().intValue() == test.getIdTest())).findFirst().ifPresent(gr -> test.getTestEigenschaften().setGruppierungen(gr));
        info.setTest(test);
        info.setTestbereiche((String)this.configService.loadConf("testBereiche", String.class, token));
        info.setSchema(this.beurteilungService.getSchema(idLk, token));
        info.setDefaultSchema(this.beurteilungService.getDefaultSchema(token));
        return info;
    }

    public List<ActivitytypeBaseDto> loadActivityTypes(LettoToken token) {
        Integer idSchule = token.getIdSchule();
        if (!this.activityTypesMap.containsKey(idSchule)) {
            this.activityTypesMap.put(idSchule, (List)this.data((LettoToken)token).lehrerKlasse.loadActivityTypes().getData());
        }
        return (List)this.activityTypesMap.get(idSchule);
    }

    public String insertTestQuestion(InsertTestFrageDto dto, LettoToken token) {
        int idGruppe = dto.getIdGruppe();
        List idQuestions = dto.getIdQuestions();
        String erg = (String)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.insertTestQuestion(dto));
        testCache.remove(dto.getIdTest(), token);
        return erg;
    }

    public TestVersuchDto scoreTestVersuchStudent(Map<String, String> vals, LettoToken token) {
        int idTest;
        TestInhaltDto test;
        TestVersuchDto v = this.rescoreTestVersuch(vals, token);
        if (v.isFinished() && !this.checkShowTestVersuchResults(v, test = this.loadTestInhalt(idTest = Integer.parseInt(vals.get("idTest")), token), token)) {
            v.setBereiche(new Vector());
            return v;
        }
        return v;
    }

    public String storeProzentTestVersuch(Map<String, String> vals, LettoToken token) {
        int idTestVersuch = Integer.parseInt(vals.get("idVersuch"));
        double proz = Double.parseDouble(vals.get("proz"));
        double ist = Double.parseDouble(vals.get("ist"));
        double soll = Double.parseDouble(vals.get("soll"));
        this.microServiceConfiguration.getDataService((LettoToken)token).tests.storeProzentTestVersuch(idTestVersuch, proz, ist, soll);
        return "";
    }

    public TestVersuchDto rescoreTestVersuch(Map<String, String> vals, LettoToken token) {
        int idTestVersuch = Integer.parseInt(vals.get("idVersuch"));
        int idTest = Integer.parseInt(vals.get("idTest"));
        boolean closeVersuch = Boolean.parseBoolean(vals.get("closeVersuch"));
        boolean rescoreTestQuestions = true;
        boolean rescoreNotScored = Boolean.parseBoolean(vals.get("rescoreNotScored"));
        boolean clearLehrerBeurteilung = Boolean.parseBoolean(vals.get("clearLehrerBeurteilung"));
        QuestionRestService qService = this.microServiceConfiguration.getQuestionService();
        TestInhaltDto t = this.loadTestInhalt(idTest, token);
        if (t == null) {
            throw new MsgException("test_err_test_does_not_exist");
        }
        TestVersuchDto v = (TestVersuchDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestVersuchComplete(idTestVersuch, t));
        if (v == null) {
            throw new MsgException("test_err_testversuch_does_not_exist", new String[]{"" + idTestVersuch});
        }
        if (v.isFinished() && v.getPunkteSoll() != null && v.getPunkteSoll() < 0.0) {
            return v;
        }
        List ans = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.loadTestAnswersJsonFromVersuch(idTestVersuch));
        List missingAnswers = new Vector();
        if (rescoreNotScored) {
            List requestAnswers = ans.stream().filter(td -> Cmd.isEmpty((String)td.getJsonAnswer())).map(td -> v.getBereiche().stream().map(b -> b.getTestDetails()).flatMap(Collection::stream).filter(d -> td.getIdDetail() == d.getId()).findFirst()).filter(td -> td.isPresent()).map(td -> (TestDetailDto)td.get()).map(td -> new CreateAnswerForQuestion(td.getIdQuestion(), td.getId(), td.getSelektor(), td.getDataset())).collect(Collectors.toList());
            missingAnswers = (List)DtoAndMsg.get((DtoAndMsg)qService.loadQuestionAnswers(requestAnswers, token.getToken()));
        }
        List answers = ans.stream().filter(a -> !Cmd.isEmpty((String)a.getJsonAnswer())).map(a -> {
            TestAntwortDto an = (TestAntwortDto)JSON.jsonToObj((String)a.getJsonAnswer(), TestAntwortDto.class);
            v.getBereiche().stream().map(b -> b.getTestDetails()).flatMap(Collection::stream).filter(d -> d.getId() == a.getIdDetail()).findFirst().ifPresent(td -> {
                an.setIdTest(td.getIdTest());
                if (Cmd.isEmpty((String)an.getDataset())) {
                    an.setDataset(td.getDataset());
                }
                an.setIdQuestion(td.getIdQuestion());
                an.setIdDetail(td.getId());
                an.setDsNr(td.getSelektor());
            });
            return an;
        }).filter(a -> rescoreTestQuestions || a.getBewertung() == null || a.getBewertung().equals((Object)Score.NotScored)).filter(a -> clearLehrerBeurteilung || a.getBewertung() == null || !a.isManuellScored()).collect(Collectors.toList());
        answers.addAll(missingAnswers);
        List scoredAnswers = (List)DtoAndMsg.get((DtoAndMsg)qService.scoreAll(answers, false, t.getTestEigenschaften().isAbzugBeiMehrfachantwort(), token.getToken()));
        for (TestAntwortDto a2 : answers) {
            for (TestBereichDetailsDto b2 : v.getBereiche()) {
                boolean i = false;
                for (TestDetailDto td2 : b2.getTestDetails()) {
                    if (td2.getId() != a2.getIdDetail()) continue;
                    td2.setTestAntwort(a2);
                    td2.setTestAntwortJson(JSON.objToJson((Object)a2));
                }
            }
        }
        AtomicReference<Double> punkteIst = new AtomicReference<Double>(0.0);
        AtomicReference<Double> punkteMax = new AtomicReference<Double>(0.0);
        v.getBereiche().stream().map(b -> b.getTestDetails()).flatMap(Collection::stream).forEach(td -> {
            scoredAnswers.stream().filter(a -> a.getIdDetail() == td.getId()).findFirst().ifPresent(a -> {
                td.setTestAntwort(a);
                td.setTestAntwortJson(JSON.objToJson((Object)a));
            });
            double soll = td.getPoints();
            TestAntwortDto a2 = td.getTestAntwort();
            double ist = (a2 != null ? a2.getPoints() : 0.0) * td.getPoints() / td.getPointsQuestion();
            punkteMax.updateAndGet(v1 -> new Double(v1 + soll));
            if (ist > soll) {
                a2.setPoints(ist);
            }
            punkteIst.updateAndGet(v1 -> new Double(v1 + (ist > soll ? soll : ist)));
        });
        v.setPunkteIst(punkteIst.get());
        v.setPunkteSoll(punkteMax.get());
        if (closeVersuch) {
            v.setFinished(true);
            v.setStopDatum(new Date());
        }
        BeurteilungsconfigDTO schema = this.beurteilungService.getSchema(t.getTestEigenschaften().getIdLk(), token);
        NoteAndSymbol note = null;
        try {
            if (v.getPunkteSoll() <= 0.0) {
                v.setProzent(0.0);
            } else {
                v.setProzent(v.getPunkteIst() / v.getPunkteSoll());
            }
            note = this.getTestNote(v, t.getTestEigenschaften(), schema, token);
            if (v.isFinished()) {
                v.setNoteAndSymbol(note);
            }
        }
        catch (Exception e) {
            v.setProzent(0.0);
        }
        TestScoreDto testScore = new TestScoreDto(scoredAnswers, v);
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).tests.scoreTestVersuch(testScore));
        return v;
    }

    public String saveTestVersuch(TestVersuchDto v, LettoToken token) {
        return (String)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.saveTestVersuchProperties(v));
    }

    public DashboardAllDto loadDashboard(int idUser, int idSj, LettoToken token) {
        return (DashboardAllDto)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).tests.dashBoard(idUser, idSj));
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public MicroServiceConfiguration getMicroServiceConfiguration() {
        return this.microServiceConfiguration;
    }

    public BeurteilungService getBeurteilungService() {
        return this.beurteilungService;
    }

    public ModelMapper getMapper() {
        return this.mapper;
    }

    public Map<Integer, List<ActivitytypeBaseDto>> getActivityTypesMap() {
        return this.activityTypesMap;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setMicroServiceConfiguration(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
    }

    public void setBeurteilungService(BeurteilungService beurteilungService) {
        this.beurteilungService = beurteilungService;
    }

    public void setMapper(ModelMapper mapper) {
        this.mapper = mapper;
    }

    public void setActivityTypesMap(Map<Integer, List<ActivitytypeBaseDto>> activityTypesMap) {
        this.activityTypesMap = activityTypesMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestsService)) {
            return false;
        }
        TestsService other = (TestsService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ConfigService this$configService = this.getConfigService();
        ConfigService other$configService = other.getConfigService();
        if (this$configService == null ? other$configService != null : !this$configService.equals(other$configService)) {
            return false;
        }
        MicroServiceConfiguration this$microServiceConfiguration = this.getMicroServiceConfiguration();
        MicroServiceConfiguration other$microServiceConfiguration = other.getMicroServiceConfiguration();
        if (this$microServiceConfiguration == null ? other$microServiceConfiguration != null : !this$microServiceConfiguration.equals(other$microServiceConfiguration)) {
            return false;
        }
        BeurteilungService this$beurteilungService = this.getBeurteilungService();
        BeurteilungService other$beurteilungService = other.getBeurteilungService();
        if (this$beurteilungService == null ? other$beurteilungService != null : !this$beurteilungService.equals(other$beurteilungService)) {
            return false;
        }
        ModelMapper this$mapper = this.getMapper();
        ModelMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        Map this$activityTypesMap = this.getActivityTypesMap();
        Map other$activityTypesMap = other.getActivityTypesMap();
        return !(this$activityTypesMap == null ? other$activityTypesMap != null : !((Object)this$activityTypesMap).equals(other$activityTypesMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestsService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigService $configService = this.getConfigService();
        result = result * 59 + ($configService == null ? 43 : $configService.hashCode());
        MicroServiceConfiguration $microServiceConfiguration = this.getMicroServiceConfiguration();
        result = result * 59 + ($microServiceConfiguration == null ? 43 : $microServiceConfiguration.hashCode());
        BeurteilungService $beurteilungService = this.getBeurteilungService();
        result = result * 59 + ($beurteilungService == null ? 43 : $beurteilungService.hashCode());
        ModelMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        Map $activityTypesMap = this.getActivityTypesMap();
        result = result * 59 + ($activityTypesMap == null ? 43 : ((Object)$activityTypesMap).hashCode());
        return result;
    }

    public String toString() {
        return "TestsService(configService=" + this.getConfigService() + ", microServiceConfiguration=" + this.getMicroServiceConfiguration() + ", beurteilungService=" + this.getBeurteilungService() + ", mapper=" + this.getMapper() + ", activityTypesMap=" + this.getActivityTypesMap() + ")";
    }

    static {
        collator = Collator.getInstance(Locale.GERMAN);
    }
}

