/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.tools;

import at.letto.globalinterfaces.IdEntity;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.tools.Cache;
import at.letto.security.LettoToken;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Cache<T extends IdEntity> {
    final int maxSize;
    protected MicroServiceConfiguration microServiceConfiguration;
    public final ConcurrentHashMap<String, ConcurrentHashMap<Integer, DataWithDate>> cache = new ConcurrentHashMap();

    public Cache(int maxSize, MicroServiceConfiguration microServiceConfiguration) {
        this.maxSize = maxSize;
        this.microServiceConfiguration = microServiceConfiguration;
    }

    public int size() {
        int sum = 0;
        for (Map x : this.cache.values()) {
            sum += x.values().size();
        }
        return sum;
    }

    public T load(int id, LettoToken token) {
        String schule = token.getSchool();
        if (!this.cache.containsKey(schule)) {
            this.cache.put(schule, new ConcurrentHashMap());
        }
        if (((ConcurrentHashMap)this.cache.get(schule)).containsKey(id)) {
            ((DataWithDate)((ConcurrentHashMap)this.cache.get((Object)schule)).get((Object)Integer.valueOf((int)id))).lastUsed = new Date();
            return (T)((DataWithDate)((ConcurrentHashMap)this.cache.get((Object)schule)).get((Object)Integer.valueOf((int)id))).data;
        }
        if (this.size() >= this.maxSize) {
            ((ConcurrentHashMap)this.cache.get(schule)).values().stream().sorted(new DateComparator(this)).skip(this.maxSize / 2).findFirst().map(d -> d.lastUsed).ifPresent(date -> ((ConcurrentHashMap)this.cache.get(schule)).values().removeIf(s -> s.lastUsed.before((Date)date)));
        }
        IdEntity daten = this.loadData(id, token);
        try {
            DataWithDate s = new DataWithDate(this);
            s.lastUsed = new Date();
            s.data = daten;
            ((ConcurrentHashMap)this.cache.get(schule)).put(id, s);
            return (T)((DataWithDate)((ConcurrentHashMap)this.cache.get((Object)schule)).get((Object)Integer.valueOf((int)id))).data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void remove(int id, LettoToken token) {
        String idSchule = token.getSchool();
        ConcurrentHashMap x = (ConcurrentHashMap)this.cache.get(idSchule);
        if (x == null) {
            return;
        }
        if (x.containsKey(id)) {
            x.remove(id);
        }
    }

    public void put(T data, LettoToken token) {
        String schule = token.getSchool();
        if (!this.cache.containsKey(schule)) {
            this.cache.put(schule, new ConcurrentHashMap());
        }
        try {
            DataWithDate s = new DataWithDate(this);
            s.lastUsed = new Date();
            s.data = data;
            ((ConcurrentHashMap)this.cache.get(schule)).put(data.getId(), s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract T loadData(int var1, LettoToken var2);
}

