/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.controller;

import at.letto.export.dto.ExportResultDto;
import at.letto.export.dto.ImportResultDto;
import at.letto.export.dto.api.ExportRequestDto;
import at.letto.export.dto.api.ImportRequestDto;
import at.letto.export.dto.api.InfoResultDto;
import at.letto.exportservice.service.ExportImportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ApiController {
    @Autowired
    private ExportImportService exportImportService;

    @PostMapping(value={"/export/auth/user/export"})
    public ResponseEntity<ExportResultDto> exportData(@RequestBody ExportRequestDto exportRequestDto) {
        ExportResultDto result = this.exportImportService.exportData(exportRequestDto.getExportDto(), exportRequestDto.getTransferID(), exportRequestDto.getParams());
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/export/auth/user/import"})
    public ResponseEntity<ImportResultDto> importData(@RequestBody ImportRequestDto importRequestDto) {
        ImportResultDto result = this.exportImportService.importData(importRequestDto.getImportDto(), importRequestDto.getTransferID(), importRequestDto.getParams(), importRequestDto.getImportClasses());
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/export/auth/user/info"})
    public ResponseEntity<InfoResultDto> infoData() {
        InfoResultDto result = this.exportImportService.infoData();
        return ResponseEntity.ok((Object)result);
    }
}

