/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.service;

import at.letto.service.base.BaseImageService;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.WebGet;
import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LocalImageService {
    static final Logger LOGGER = LoggerFactory.getLogger(LocalImageService.class);
    public String hostUrl = "";
    private BaseImageService images = null;
    private HashMap<String, BaseImageService> photos = new HashMap();
    private HashMap<String, BaseImageService> plugins = new HashMap();

    public void init(String servername) {
        File file;
        block16: {
            Vector<Object> hosts = new Vector<Object>();
            if (servername != null && servername.trim().length() > 0) {
                hosts.add("https://" + servername);
                hosts.add("http://" + servername);
            }
            hosts.add("https://host.docker.internal");
            hosts.add("https://172.17.0.1");
            hosts.add("https://localhost");
            hosts.add("http://localhost");
            LOGGER.info("Start Image-Service (servername=" + servername + ")");
            this.hostUrl = null;
            String name = ENCRYPT.generateKey((int)20);
            file = new File("/opt/letto/docker/storage/images/" + name + ".txt");
            try {
                Cmd.writefile((String)name, (File)file);
                String x = Files.readAllLines(file.toPath()).get(0).trim();
                if (x.equals(name)) {
                    for (String string : hosts) {
                        if (this.hostUrl != null) continue;
                        try {
                            String w = WebGet.getUrlString((String)(string + "/images/" + name + ".txt")).trim();
                            if (!w.equals(name)) continue;
                            this.hostUrl = string;
                        }
                        catch (Exception exception) {}
                    }
                    break block16;
                }
                LOGGER.error("Cannot write Testfile correctly for image-service! No imageservice is installed!");
                file.delete();
                return;
            }
            catch (Exception ex) {
                LOGGER.error("Cannot write Testfile for image-service! No imageservice is installed!");
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.hostUrl == null) {
            LOGGER.error("Image-Url kann nicht gefunden werden - Image-Service nicht installiert!");
            return;
        }
        LOGGER.info("Image-Url: " + this.hostUrl + "/images");
        try {
            this.images = new BaseImageService("/opt/letto/docker/storage/images", this.hostUrl + "/images", true);
        }
        catch (Exception ex) {
            LOGGER.error("Cannot initialize BaseImageService!");
        }
    }

    public BaseImageService images() {
        return this.images;
    }

    public BaseImageService photos(String school) {
        if (this.photos.containsKey(school) && this.photos.get(school) != null) {
            return (BaseImageService)this.photos.get(school);
        }
        try {
            BaseImageService imageService = new BaseImageService("c:/opt/letto/docker/storage/photos/" + school, this.hostUrl + "/photos/" + school, true);
            this.photos.put(school, imageService);
            return imageService;
        }
        catch (Exception ex) {
            LOGGER.error("Cannot initialize PluginImageService for school " + school + "!");
            return null;
        }
    }

    public BaseImageService plugins(String school) {
        if (this.plugins.containsKey(school) && this.plugins.get(school) != null) {
            return (BaseImageService)this.plugins.get(school);
        }
        try {
            BaseImageService imageService = new BaseImageService("c:/opt/letto/docker/storage/plugins/" + school, this.hostUrl + "/plugins/" + school, true);
            this.plugins.put(school, imageService);
            return imageService;
        }
        catch (Exception ex) {
            LOGGER.error("Cannot initialize PluginImageService for school " + school + "!");
            return null;
        }
    }
}

