/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.service.threads;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.export.dto.FileTransferDto;
import at.letto.export.dto.ImportDto;
import at.letto.export.dto.ImportExportDto;
import at.letto.export.dto.ImportResultDto;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.export.dto.questions.ExportQuestionV1;
import at.letto.exportservice.dto.ImportMode;
import at.letto.exportservice.dto.ImportParams;
import at.letto.exportservice.dto.ImportStatusAndResult;
import at.letto.exportservice.service.CmdService;
import at.letto.exportservice.service.ExportImportService;
import at.letto.exportservice.service.threads.ImportServiceThread;
import at.letto.exportservice.xml.XMLconfig;
import at.letto.exportservice.xml.XMLfile;
import at.letto.tools.Cmd;
import at.letto.tools.Datum;
import at.letto.tools.ENCRYPT;
import at.letto.tools.JSON;
import at.letto.tools.WebGet;
import at.letto.tools.rest.DtoAndMsg;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.web.client.RestTemplate;

public class ImportServiceThread
extends CmdThread {
    public static final Logger LOGGER = LoggerFactory.getLogger(ImportServiceThread.class);
    public final ImportDto importDto;
    public final String transferID;
    public final HashMap<String, String> params;
    public final List<String> importClasses;
    public final ExportImportService exportImportService;
    public final CmdService cmdService;
    public final ImportStatusAndResult result;
    private String errormsg = "";
    private boolean haserror = false;
    private ImportParams importParams = new ImportParams();
    private String backlink;
    private boolean jsonfile;
    private String validString;
    private long valid = 3600L;

    public ImportServiceThread(ExportImportService exportImportService, ImportDto importDto, String transferID, HashMap<String, String> params, List<String> importClasses) {
        super(exportImportService.cmdService.getRootPath(), exportImportService.cmdService.getCmdCharset(), CmdThread.CmdMode.BASH, new String[0]);
        this.importDto = importDto;
        this.transferID = transferID;
        this.params = params;
        this.importClasses = importClasses;
        this.cmdService = exportImportService.cmdService;
        this.exportImportService = exportImportService;
        this.result = new ImportStatusAndResult(transferID, this);
        exportImportService.importStatusAndResultHashMap.put(transferID, this.result);
        this.importParams.setExportImportService(exportImportService);
        this.saveData();
    }

    public void error(String msg) {
        this.errormsg = msg;
        this.haserror = true;
        throw new RuntimeException(msg);
    }

    public void task() {
        LOGGER.info("Start Import THREAD " + this.transferID);
        try {
            this.doImport();
        }
        catch (RuntimeException ex) {
            if (!this.haserror) {
                this.haserror = true;
                this.errormsg = "RuntimeException " + ex.getMessage();
            }
        }
        catch (Exception ex) {
            this.haserror = true;
            this.errormsg = ex.getClass().getName() + " " + ex.getMessage();
        }
        catch (Error er) {
            this.haserror = true;
            this.errormsg = er.getClass().getName() + " " + er.getMessage();
        }
        if (this.haserror) {
            this.htmlErr(this.errormsg);
            this.result.getImportResultDto().setResult("ERROR");
            this.result.getImportResultDto().setMsg(this.errormsg);
            LOGGER.error("Import(" + this.transferID + ") error : " + this.errormsg);
        } else {
            this.result.getImportResultDto().setResult("OK");
        }
        this.result.getImportResultDto().setValidToLong(Datum.nowDateInteger() + this.valid);
        this.result.finish();
        this.saveData();
        if (this.backlink.length() > 0 && this.result.isBacklinkActive()) {
            RestTemplate restTemplate = new RestTemplate();
            HttpEntity request = new HttpEntity((Object)this.transferID);
            String response = null;
            try {
                response = (String)restTemplate.postForObject(this.backlink, (Object)request, String.class, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.error("Backlink " + this.backlink + " not reachable!");
            }
        }
        this.result.setBacklinkActive(false);
    }

    public void saveData() {
        this.exportImportService.saveImportData(this.transferID, this.result, this);
    }

    private String getParam(String param) {
        String result = "";
        if (this.params.containsKey(param)) {
            result = (String)this.params.get(param);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    private void doImport() {
        this.importParams.setKey(this.getParam("key").trim());
        this.backlink = this.getParam("backlink").trim();
        this.validString = this.getParam("valid").trim();
        this.jsonfile = this.getParam("jsonfile").trim().equalsIgnoreCase("true");
        this.valid = ExportImportService.parseValidString((long)this.valid, (String)this.validString);
        this.result.getImportResultDto().setValidToLong(Datum.nowDateInteger() + this.valid);
        this.importParams.setBase64(this.getParam("base64").trim().equalsIgnoreCase("true"));
        this.importParams.setImportMode(ImportMode.parse((String)this.getParam("mode")));
        ImportResultDto importResultDto = this.result.getImportResultDto();
        importResultDto.setMsg("Load Importfile");
        FileTransferDto f = this.importDto.getFile();
        File file = new File("/opt/letto/docker/storage/" + f.getFilePath());
        if (!file.exists()) {
            switch (1.$SwitchMap$at$letto$exportservice$dto$ImportMode[this.importParams.getImportMode().ordinal()]) {
                case 1: {
                    file = new File("/opt/letto/docker/storage/export/import/" + this.transferID + "/importdata.lto");
                    break;
                }
                case 2: {
                    file = new File("/opt/letto/docker/storage/export/import/" + this.transferID + "/importdata.xml");
                    break;
                }
                case 3: {
                    file = new File("/opt/letto/docker/storage/export/import/" + this.transferID + "/importdata.json");
                    break;
                }
                default: {
                    file = new File("/opt/letto/docker/storage/export/import/" + this.transferID + "/importdata.txt");
                }
            }
            file.delete();
            if (f.getContent() != null && f.getContent().length() > 0) {
                Cmd.writefile((String)f.getContent(), (File)file);
            } else if (f.getBase64Content() != null && f.getBase64Content().length() > 0) {
                try {
                    Cmd.writefile((String)ENCRYPT.base64DecodeString((String)f.getBase64Content()), (File)file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (!file.exists() && f.getUrl() != null && f.getUrl().length() > 0) {
            WebGet.readFileFromURL((String)f.getUrl(), (File)file);
        }
        if (!file.exists()) {
            this.error("Daten k\u00f6nne nicht importiert werden da keine Daten vorhanden sind!");
        }
        f.setFile(file);
        ImportExportDto data = null;
        if (this.importParams.getImportMode() == ImportMode.LTO || this.importParams.getImportMode() == ImportMode.MOODLEXML || this.importParams.getImportMode() == ImportMode.AUTO) {
            XMLconfig xmlconfig = new XMLconfig();
            try {
                data = XMLfile.loadXML((File)file, (XMLconfig)xmlconfig, (ImportParams)this.importParams);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (data == null && (this.importParams.getImportMode() == ImportMode.JSON || this.importParams.getImportMode() == ImportMode.AUTO)) {
            try {
                data = (ImportExportDto)JSON.jsonToObj((File)file, ImportExportDto.class);
            }
            catch (Exception xmlconfig) {
                // empty catch block
            }
        }
        if (data != null) {
            importResultDto.setMsg("Save Data");
            data = data.downgrade(this.importClasses);
            String dataServiceUrl = this.getParam("dataserviceurl").trim();
            if (this.jsonfile) {
                File output = new File("/opt/letto/docker/storage/export/import/" + this.transferID + "/data.json");
                try {
                    JSON.objToJson((Object)data, (File)output);
                }
                catch (Exception ex) {
                    this.error("JSON-Zieldatei kann nicht geschrieben werden!");
                }
                importResultDto.setGeneratedFile(FileTransferDto.generate((File)output));
            }
            boolean dataserviceimportok = false;
            if (dataServiceUrl.length() > 0) {
                int idSchule = 0;
                try {
                    idSchule = Integer.parseInt(this.getParam("dataserviceIdSchule").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String school = this.getParam("dataserviceSchool").trim();
                String user = this.getParam("dataserviceUser").trim();
                String password = this.getParam("dataservicePassword").trim();
                int idCategory = 0;
                try {
                    idCategory = Integer.parseInt(this.getParam("idcategory").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String importcategory = this.getParam("importcategory").trim().toLowerCase();
                String importquestion = this.getParam("importquestion").trim().toLowerCase();
                RestLettoDataService dataService = null;
                dataService = new RestLettoDataService(dataServiceUrl, user, password, idSchule, school);
                if (dataService == null) {
                    this.error("Dataservice kann nicht verbunden werden!!");
                }
                if (data instanceof ExportCategoryV1) {
                    int idCat = this.saveCategory(dataService, (ExportCategoryV1)data, idCategory, importcategory, importquestion);
                    this.result.getImportResultDto().setMsg("imported Category ID:" + idCat);
                } else if (data instanceof ExportQuestionV1) {
                    DtoAndMsg dto = dataService.export.saveQuestion(idCategory, importquestion, (ExportQuestionV1)data);
                    if (!dto.checkOk()) {
                        this.error("cannot import data into database!");
                    }
                    this.result.getImportResultDto().setMsg("imported Question ID:" + dto.getMsg());
                } else {
                    this.error("Direkter data-service Zugriff ist noch nicht implementiert!");
                }
            }
            if (!this.jsonfile && !dataserviceimportok) {
                importResultDto.setImportDto(data);
            }
        }
        importResultDto.setMsg("Finished");
        this.result.getImportResultDto().setValidToLong(Datum.nowDateInteger() + this.valid);
    }

    private int saveCategory(RestLettoDataService dataService, ExportCategoryV1 category, int idCategory, String importcategory, String importquestion) {
        boolean sc = !importcategory.equals("self") && !importcategory.equals("none");
        DtoAndMsg dto = dataService.export.saveCategory(idCategory, sc, importquestion, category);
        if (dto.checkOk()) {
            idCategory = (Integer)dto.getData();
            for (ExportCategoryV1 c : category.getCategories()) {
                this.saveCategory(dataService, c, idCategory, importcategory.equals("self") ? "root" : importcategory, importquestion);
            }
        } else {
            idCategory = 0;
        }
        return idCategory;
    }
}

