/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.xml;

import at.letto.export.dto.ImportExportDto;
import at.letto.exportservice.dto.ImportParams;
import at.letto.exportservice.service.threads.XmlImport;
import at.letto.exportservice.xml.XMLconfig;
import at.letto.exportservice.xml.XMLfile;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLfileLTO
extends XMLfile {
    public static final String LETTO_XML_V1 = "101";

    public boolean checkRootElementName(String element) {
        String name = this.getElementName(element);
        return name.equals("letto");
    }

    public void readContentPrepare(Vector<String> inhalt) {
        for (int i = 0; i < inhalt.size(); ++i) {
            inhalt.set(i, inhalt.get(i).replaceAll("[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F]", ""));
        }
    }

    public ImportExportDto parseXMLnode(Element root, XMLconfig conf, ImportParams importParams) {
        if (root.getNodeName().equals("letto") && root.getNodeType() == 1) {
            NamedNodeMap attr_quiz = root.getAttributes();
            for (int k = 0; k < attr_quiz.getLength(); ++k) {
                if (attr_quiz.item(k).getNodeType() == 2 && attr_quiz.item(k).getNodeName().equals("mode")) {
                    String mode = attr_quiz.item(k).getNodeValue();
                    conf.set("version", mode);
                }
                if (attr_quiz.item(k).getNodeType() != 2 || !attr_quiz.item(k).getNodeName().equals("databaseinfo")) continue;
                conf.set("databaseinfo", attr_quiz.item(k).getNodeValue());
            }
            NodeList c = root.getChildNodes();
            for (int i = 0; i < c.getLength(); ++i) {
                Node node = c.item(i);
                if (node.getNodeType() != 1) continue;
                switch (node.getNodeName()) {
                    case "category": {
                        return XmlImport.parseCategory(null, (Node)node, (XMLconfig)conf, (ImportParams)importParams);
                    }
                    case "test": {
                        return XmlImport.parseCategory(null, (Node)node, (XMLconfig)conf, (ImportParams)importParams);
                    }
                    case "question": {
                        return XmlImport.parseQuestion(null, (Node)node, (ImportParams)importParams);
                    }
                }
            }
        } else {
            throw new RuntimeException("XML kann nicht geparst werden!");
        }
        return null;
    }
}

