/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.xml;

import at.letto.export.dto.ImportExportDto;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.exportservice.dto.ImportParams;
import at.letto.exportservice.xml.XMLconfig;
import at.letto.exportservice.xml.XMLfile;
import at.letto.tools.enums.QuestionType;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLfileMoodle
extends XMLfile {
    public static final String MOODLE_V1 = "10";
    public static final String MOODLE_V2 = "20";
    public static final String MOODLE_V2_SQL = "21";
    public static final String MOODLE_V2_SQL_Online = "22";
    private ExportCategoryV1 rootCategory = new ExportCategoryV1();
    private ExportCategoryV1 actualCategory;

    public XMLfileMoodle() {
        this.rootCategory.setName("");
        this.actualCategory = this.rootCategory;
    }

    public boolean checkRootElementName(String element) {
        String name = this.getElementName(element);
        return name.equals("quiz");
    }

    public void readContentPrepare(Vector<String> inhalt) {
        for (int i = 0; i < inhalt.size(); ++i) {
            inhalt.set(i, inhalt.get(i).replaceAll("\\$course\\$\\/", "").replaceAll("\\$system\\$\\/", ""));
        }
    }

    public ImportExportDto parseXMLnode(Element root, XMLconfig conf, ImportParams importParams) {
        if (root.getNodeName().equals("quiz") && root.getNodeType() == 1) {
            conf.set("version", MOODLE_V2);
            NamedNodeMap attr_quiz = root.getAttributes();
            for (int k = 0; k < attr_quiz.getLength(); ++k) {
                String mode;
                if (attr_quiz.item(k).getNodeType() == 2 && attr_quiz.item(k).getNodeName().equals("mode") && (mode = attr_quiz.item(k).getNodeValue()).length() > 0) {
                    conf.set("version", mode);
                }
                if (attr_quiz.item(k).getNodeType() != 2 || !attr_quiz.item(k).getNodeName().equals("databaseinfo")) continue;
                conf.set("databaseinfo", attr_quiz.item(k).getNodeValue());
            }
            NodeList c = root.getChildNodes();
            for (int i = 0; i < c.getLength(); ++i) {
                Node node = c.item(i);
                if (!node.getNodeName().equals("question") || node.getNodeType() != 1) continue;
                NamedNodeMap attr = node.getAttributes();
                for (int j = 0; j < attr.getLength(); ++j) {
                    if (attr.item(j).getNodeType() != 2 || !attr.item(j).getNodeName().equals("type")) continue;
                    if (attr.item(j).getNodeValue().equals("category")) {
                        this.XMLgetCategory(node);
                        continue;
                    }
                    if (attr.item(j).getNodeValue().equals("test")) {
                        this.XMLgetCategory(node);
                        continue;
                    }
                    if (this.XMLgetQuestion(this.actualCategory, attr.item(j).getNodeValue(), node, conf.getString("version"), importParams)) continue;
                    System.out.println("Fragentyp " + attr.item(j).getNodeValue() + "unbekannt!\n");
                }
            }
        }
        return this.rootCategory;
    }

    private boolean XMLgetQuestion(ExportCategoryV1 c, String typ, Node n, String version, ImportParams importParams) {
        QuestionType qt = QuestionType.getType((String)typ);
        return qt != null;
    }

    private void XMLgetCategory(Node n) {
        NodeList c = n.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            Node cat = c.item(i);
            if (!cat.getNodeName().equals("category") || cat.getNodeType() != 1) continue;
            NodeList c1 = cat.getChildNodes();
            for (int j = 0; j < c1.getLength(); ++j) {
                Node ctext = c1.item(j);
                if (!ctext.getNodeName().equals("text") || ctext.getNodeType() != 1) continue;
                NodeList c2 = ctext.getChildNodes();
                for (int k = 0; k < c2.getLength(); ++k) {
                    if (c2.item(k).getNodeType() == 3) {
                        this.addCategoryPath(c2.item(k).getNodeValue());
                        continue;
                    }
                    if (c2.item(k).getNodeType() != 4) continue;
                    this.addCategoryPath(c2.item(k).getNodeValue());
                }
            }
        }
    }

    public ExportCategoryV1 addCategoryPath(String categorypath) {
        return this.addCategoryPath(categorypath, false);
    }

    public ExportCategoryV1 addCategoryPath(String categorypath, boolean add) {
        String[] ac = categorypath.split("/");
        this.actualCategory = this.rootCategory;
        try {
            for (int i = 0; i < ac.length; ++i) {
                boolean a = ac.length - 1 == i ? add : false;
                ExportCategoryV1 newCategory = new ExportCategoryV1();
                newCategory.setName(ac[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Die Kategorie " + categorypath + " kann nicht hinzugef\u00fcgt werden!");
            return null;
        }
        return this.actualCategory;
    }
}

