/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.setupservice.config.MicroServiceConfiguration;
import org.apache.catalina.connector.Connector;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
public class TomcatConfiguration {
    private MicroServiceConfiguration microServiceConfiguration;
    private int httpPort;
    private int httpsPort;
    private int ajpPort;

    public TomcatConfiguration(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.httpPort = this.microServiceConfiguration.getSetupHttpPort();
        this.httpsPort = this.microServiceConfiguration.getSetupHttpsPort();
        this.ajpPort = this.microServiceConfiguration.getSetupAjpPort();
    }

    @Bean
    public ServletWebServerFactory servletHTTPContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.microServiceConfiguration.createAjpConnector(this.ajpPort)});
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.microServiceConfiguration.createStandardConnector(this.httpPort)});
        return tomcat;
    }

    @Bean
    public WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> webServerFactoryCustomizer() {
        return this.microServiceConfiguration.webServerFactoryCustomizer();
    }

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:locale/messages");
        messageSource.setCacheSeconds(10);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getAjpPort() {
        return this.ajpPort;
    }
}

