/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setupservice.component.LettoSetupComponent;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.model.SicherungLocalDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DownloadService;
import at.letto.setupservice.service.InstallService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.UpdateService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class SicherungLocalController {
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    SetupConfiguration setupConfiguration;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private LettoSetupComponent lettoSetupComponent;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private InstallService installService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private DownloadService downloadService;

    @RequestMapping(value={"/setup/session/sicherunglocal"})
    public String sicherungLocal(@ModelAttribute SicherungLocalDto sicherungLocalDto, Model model) {
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = sicherungLocalDto.getUserAction();
        if (button != null) {
            switch (button) {
                case "cancel": {
                    return "redirect:/setup/session/welcome";
                }
                case "ok": {
                    return "redirect:/setup/session/welcomeanalyze";
                }
            }
        }
        model.addAttribute("sicherungLocalDto", (Object)sicherungLocalDto);
        return "sicherunglocal";
    }

    @PostMapping(value={"/setup/session/uploadlettosql"})
    public String uploadFile(@RequestParam(value="file") MultipartFile file, RedirectAttributes attributes) {
        if (file.isEmpty()) {
            attributes.addFlashAttribute("message", (Object)"Please select a file to upload.");
            return "redirect:/setup/session/sicherunglocal";
        }
        String fileName = StringUtils.cleanPath((String)file.getOriginalFilename());
        try {
            Path path = fileName.endsWith(".gz") ? Paths.get("/sicherung/letto-upload.sql.gz", new String[0]) : Paths.get("/sicherung/letto-upload.sql", new String[0]);
            Files.copy(file.getInputStream(), path, StandardCopyOption.REPLACE_EXISTING);
            this.analyzeService.setOwnerLetto(new String[]{path.toString()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        attributes.addFlashAttribute("message", (Object)("You successfully uploaded " + fileName + "!"));
        return "redirect:/setup/session/sicherunglocal";
    }

    public TomcatConfiguration getTomcatConfiguration() {
        return this.tomcatConfiguration;
    }

    public SetupConfiguration getSetupConfiguration() {
        return this.setupConfiguration;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public LettoSetupComponent getLettoSetupComponent() {
        return this.lettoSetupComponent;
    }

    public MicroServiceConfiguration getMicroServiceConfiguration() {
        return this.microServiceConfiguration;
    }

    public LettoService getLettoService() {
        return this.lettoService;
    }

    public DockerConfiguration getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public AnalyzeService getAnalyzeService() {
        return this.analyzeService;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }

    public InstallService getInstallService() {
        return this.installService;
    }

    public CmdService getCmdService() {
        return this.cmdService;
    }

    public DockerService getDockerService() {
        return this.dockerService;
    }

    public DownloadService getDownloadService() {
        return this.downloadService;
    }

    public void setTomcatConfiguration(TomcatConfiguration tomcatConfiguration) {
        this.tomcatConfiguration = tomcatConfiguration;
    }

    public void setSetupConfiguration(SetupConfiguration setupConfiguration) {
        this.setupConfiguration = setupConfiguration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setLettoSetupComponent(LettoSetupComponent lettoSetupComponent) {
        this.lettoSetupComponent = lettoSetupComponent;
    }

    public void setMicroServiceConfiguration(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
    }

    public void setLettoService(LettoService lettoService) {
        this.lettoService = lettoService;
    }

    public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.dockerConfiguration = dockerConfiguration;
    }

    public void setAnalyzeService(AnalyzeService analyzeService) {
        this.analyzeService = analyzeService;
    }

    public void setUpdateService(UpdateService updateService) {
        this.updateService = updateService;
    }

    public void setInstallService(InstallService installService) {
        this.installService = installService;
    }

    public void setCmdService(CmdService cmdService) {
        this.cmdService = cmdService;
    }

    public void setDockerService(DockerService dockerService) {
        this.dockerService = dockerService;
    }

    public void setDownloadService(DownloadService downloadService) {
        this.downloadService = downloadService;
    }
}

