/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.controller.FileViewController;
import at.letto.setupservice.model.DockerInitEnvDto;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class HttpLettoStatusController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private FileViewController fileViewController;

    @RequestMapping(value={"/config/session/admin/dockerlettostatus"})
    public String dockerLettoStatusDocker(@ModelAttribute DockerInitEnvDto dockerInitEnvDto, HttpServletRequest request, Model model) {
        model.addAttribute("action", (Object)"/config/session/admin/dockerlettostatus");
        return this.dockerLettoStatus(dockerInitEnvDto, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/dockerlettostatus"})
    public String dockerLettoStatusLocal(@ModelAttribute DockerInitEnvDto dockerInitEnvDto, HttpServletRequest request, Model model) {
        model.addAttribute("action", (Object)"/setup/session/admin/dockerlettostatus");
        return this.dockerLettoStatus(dockerInitEnvDto, request, model);
    }

    public String dockerLettoStatus(@ModelAttribute DockerInitEnvDto dockerInitEnvDto, HttpServletRequest request, Model model) {
        model.addAttribute("dockerService", (Object)this.dockerService);
        Object msg = "";
        String button = dockerInitEnvDto.getUserAction();
        if (button != null) {
            switch (button) {
                case "refresh": {
                    this.dockerService.analyzeBackground(false);
                    break;
                }
                case "reload": {
                    break;
                }
                case "back": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "systemPrune": {
                    CmdThread t = this.cmdService.cmdScriptForeground(4000L, new String[]{"docker system prune -a -f"});
                    this.dockerService.calcDockerStatus();
                    msg = "Docker system pruned! " + t.lastOutputLine(3);
                    break;
                }
                case "imagesPrune": {
                    CmdThread t = this.cmdService.cmdScriptForeground(4000L, new String[]{"docker image prune -a -f"});
                    this.dockerService.calcDockerStatus();
                    msg = "Docker system pruned! " + t.lastOutputLine(3);
                    break;
                }
                case "volumePrune": {
                    CmdThread t = this.cmdService.cmdScriptForeground(4000L, new String[]{"docker volume prune -f"});
                    this.dockerService.calcDockerStatus();
                    msg = "Docker volumes pruned! " + t.lastOutputLine(3);
                    break;
                }
                case "networkPrune": {
                    CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker network prune -f"});
                    this.dockerService.calcDockerStatus();
                    msg = "Docker networks pruned! " + t.lastOutputLine(3);
                    break;
                }
                default: {
                    String volumename;
                    if (button.startsWith("Log")) {
                        String container = button.substring(3);
                        if (container.length() <= 0) break;
                        return this.fileViewController.viewLogfile(container, model, this.dockerService.dockerLettoStatusEP());
                    }
                    if (button.startsWith("Start")) {
                        String container = button.substring(5);
                        if (container.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker start " + container});
                        this.dockerService.calcDockerStatus();
                        msg = "container " + container + " started!";
                        break;
                    }
                    if (button.startsWith("Stop")) {
                        String container = button.substring(4);
                        if (container.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker stop " + container});
                        this.dockerService.calcDockerStatus();
                        msg = "container " + container + " stopped!";
                        break;
                    }
                    if (button.startsWith("Restart")) {
                        String container = button.substring(7);
                        if (container.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker restart " + container});
                        this.dockerService.calcDockerStatus();
                        msg = "container " + container + " restarted!";
                        break;
                    }
                    if (button.startsWith("Remove")) {
                        String container = button.substring(6);
                        if (container.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker rm " + container});
                        this.dockerService.calcDockerStatus();
                        msg = "container " + container + " removed!";
                        break;
                    }
                    if (button.startsWith("NWcreate")) {
                        String networkname = button.substring(8);
                        if (networkname.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker network create " + networkname});
                        this.dockerService.calcDockerStatus();
                        msg = "network " + networkname + " created!";
                        break;
                    }
                    if (button.startsWith("VOLcreate")) {
                        String volumename2 = button.substring(9);
                        if (volumename2.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker volume create " + volumename2});
                        this.dockerService.calcDockerStatus();
                        msg = "volume " + volumename2 + " created!";
                        break;
                    }
                    if (button.startsWith("VOLclear")) {
                        String volumename3 = button.substring(8);
                        if (volumename3.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker volume rm " + volumename3, "docker volume create " + volumename3});
                        msg = "volume " + volumename3 + " cleared!";
                        this.dockerService.calcDockerStatus();
                        break;
                    }
                    if (button.startsWith("DN")) {
                        String networkname = button.substring(2);
                        if (networkname.length() <= 0) break;
                        CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker network rm " + networkname});
                        msg = "network " + networkname + " deleted!";
                        this.dockerService.calcDockerStatus();
                        break;
                    }
                    if (!button.startsWith("DV") || (volumename = button.substring(8)).length() <= 0) break;
                    CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker volume rm " + volumename});
                    msg = "volume " + volumename + " deleted!";
                    this.dockerService.calcDockerStatus();
                    break;
                }
            }
        }
        model.addAttribute("msg", msg);
        return "dockerlettostatus";
    }
}

