/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.model.properties;

import at.letto.setupservice.model.properties.LettoProperty;
import at.letto.tools.Cmd;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public abstract class PropertiesFile {
    private Vector<LettoProperty> propertyVector = new Vector();
    private File propertyFile = null;
    private HashMap<String, LettoProperty> propertyHashtable = new HashMap();

    public PropertiesFile(String propertyFileName) {
        this(new File(propertyFileName));
    }

    public PropertiesFile(File propertyFile) {
        this.propertyFile = propertyFile;
        this.loadTemplateList(this.getPropertyTemplate());
        LettoProperty lettoProperty = null;
        LettoProperty lastProperty = null;
        if (propertyFile != null) {
            try {
                if (!propertyFile.exists()) {
                    propertyFile.createNewFile();
                    propertyFile.delete();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot create Property File " + propertyFile.getAbsolutePath());
            }
            try {
                for (String s : Cmd.readfile((File)propertyFile)) {
                    lettoProperty = LettoProperty.newPropertyFromFile((String)s);
                    if (lastProperty != null && lastProperty.getPropertyMode() == LettoProperty.PropertyMode.COMMENT && lettoProperty.getPropertyMode() == LettoProperty.PropertyMode.PROPERTY) {
                        lettoProperty = LettoProperty.newProperty((String)lettoProperty.getName(), (String)lettoProperty.getProperty(), (String)lastProperty.getHelp());
                    }
                    this.setProperty(lettoProperty);
                    lastProperty = lettoProperty;
                }
            }
            catch (Exception exception) {}
        } else {
            throw new RuntimeException("Property File is null!");
        }
    }

    public abstract String[][] getPropertyTemplate();

    public void loadTemplateList(String[][] templateList) {
        for (String[] prop : templateList) {
            LettoProperty lettoProperty = prop.length == 0 ? LettoProperty.newLine() : (prop.length == 1 ? LettoProperty.newComment((String)prop[0]) : LettoProperty.newProperty((String)(prop.length > 0 ? prop[0] : ""), (String)(prop.length > 1 ? prop[1] : ""), (String)(prop.length > 2 ? prop[2] : "")));
            this.setProperty(lettoProperty);
        }
    }

    public void loadTemplate(String[][] ... templates) {
        for (String[][] template : templates) {
            try {
                this.loadTemplateList(template);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean existsPropertiesFile() {
        return this.propertyFile.exists();
    }

    public boolean saveFile(String filename) {
        this.propertyFile = new File(filename);
        return this.save();
    }

    public boolean saveFile(File file) {
        this.propertyFile = file;
        return this.save();
    }

    public boolean save() {
        try {
            Vector<CallSite> data = new Vector<CallSite>();
            for (LettoProperty lettoProperty : this.propertyVector) {
                data.add((CallSite)((Object)("" + lettoProperty)));
            }
            return Cmd.writelnfile(data, (File)this.propertyFile);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public LettoProperty setProperty(LettoProperty lettoProperty) {
        if (lettoProperty.getPropertyMode() == LettoProperty.PropertyMode.PROPERTY) {
            String name = lettoProperty.getName();
            boolean found = false;
            for (int i = 0; i < this.propertyVector.size(); ++i) {
                LettoProperty lp = (LettoProperty)this.propertyVector.get(i);
                if (lp.getPropertyMode() != LettoProperty.PropertyMode.PROPERTY || !lp.getName().equals(lettoProperty.getName())) continue;
                if (found) {
                    this.propertyVector.removeElementAt(i);
                    --i;
                    continue;
                }
                found = true;
                this.propertyVector.set(i, lettoProperty);
            }
            if (!found) {
                this.propertyVector.add(lettoProperty);
            }
            this.propertyHashtable.put(name, lettoProperty);
            return lettoProperty;
        }
        this.propertyVector.add(lettoProperty);
        return lettoProperty;
    }

    public LettoProperty setProperty(String name, String property) {
        LettoProperty oldProperty;
        LettoProperty lettoProperty = LettoProperty.newProperty((String)name, (String)property);
        if (this.propertyHashtable.containsKey(name) && (oldProperty = (LettoProperty)this.propertyHashtable.get(name)).getPropertyMode() == LettoProperty.PropertyMode.PROPERTY) {
            lettoProperty = LettoProperty.newProperty((String)name, (String)property, (String)oldProperty.getHelp());
        }
        return this.setProperty(lettoProperty);
    }

    public LettoProperty setProperty(String name, String property, String help) {
        LettoProperty lettoProperty = LettoProperty.newProperty((String)name, (String)property, (String)help);
        return this.setProperty(lettoProperty);
    }

    public LettoProperty setProperty(String name, Boolean property) {
        return this.setProperty(name, property != null ? property.toString() : "");
    }

    public LettoProperty setProperty(String name, Boolean property, String help) {
        return this.setProperty(name, property != null ? property.toString() : "", help);
    }

    public LettoProperty setProperty(String name, Integer property) {
        return this.setProperty(name, property != null ? property.toString() : "");
    }

    public LettoProperty setProperty(String name, Integer property, String help) {
        return this.setProperty(name, property != null ? property.toString() : "", help);
    }

    public LettoProperty setProperty(String name, Double property) {
        return this.setProperty(name, property != null ? property.toString() : "");
    }

    public LettoProperty setProperty(String name, Double property, String help) {
        return this.setProperty(name, property != null ? property.toString() : "", help);
    }

    public LettoProperty setProperty(String name, boolean property) {
        return this.setProperty(name, "" + property);
    }

    public LettoProperty setProperty(String name, boolean property, String help) {
        return this.setProperty(name, "" + property, help);
    }

    public LettoProperty setProperty(String name, int property) {
        return this.setProperty(name, "" + property);
    }

    public LettoProperty setProperty(String name, int property, String help) {
        return this.setProperty(name, "" + property, help);
    }

    public LettoProperty setProperty(String name, long property) {
        return this.setProperty(name, "" + property);
    }

    public LettoProperty setProperty(String name, long property, String help) {
        return this.setProperty(name, "" + property, help);
    }

    public String getPropertyString(String name) {
        LettoProperty lettoProperty = null;
        if (this.propertyHashtable.containsKey(name)) {
            lettoProperty = (LettoProperty)this.propertyHashtable.get(name);
        } else if (this.propertyHashtable.containsKey(name.replaceAll("\\.", "_"))) {
            lettoProperty = (LettoProperty)this.propertyHashtable.get(name.replaceAll("\\.", "_"));
        } else if (this.propertyHashtable.containsKey(name.replaceAll("_", "."))) {
            lettoProperty = (LettoProperty)this.propertyHashtable.get(name.replaceAll("_", "."));
        }
        if (lettoProperty != null && lettoProperty.getPropertyMode() == LettoProperty.PropertyMode.PROPERTY) {
            String property = lettoProperty.getProperty();
            return property;
        }
        return null;
    }

    public Integer getPropertyInt(String name) {
        try {
            String property = this.getPropertyString(name);
            int x = Integer.parseInt(property);
            return x;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getPropertyint(String name) {
        try {
            String property = this.getPropertyString(name);
            int x = Integer.parseInt(property);
            return x;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long getPropertylong(String name) {
        try {
            String property = this.getPropertyString(name);
            long x = Long.parseLong(property);
            return x;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public Double getPropertyDouble(String name) {
        try {
            String property = this.getPropertyString(name);
            double x = Double.parseDouble(property);
            return x;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Boolean getPropertyBoolean(String name) {
        try {
            String property = this.getPropertyString(name);
            boolean x = Boolean.parseBoolean(property);
            return x;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getPropertyboolean(String name) {
        try {
            String property = this.getPropertyString(name);
            boolean x = Boolean.parseBoolean(property);
            return x;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List<String> getPropertyStringList(String name) {
        try {
            ArrayList<String> ret = new ArrayList<String>();
            String property = this.getPropertyString(name);
            for (String s : property.split(",")) {
                ret.add(s.trim());
            }
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }
}

