/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.model.DockerEditSchoolDto;
import at.letto.setupservice.model.docker.DockerStatusDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.ResourcenService;
import at.letto.setupservice.service.SetupUpdateService;
import at.letto.setupservice.service.UpdateService;
import at.letto.tools.Cmd;
import at.letto.tools.Datum;
import at.letto.tools.ENCRYPT;
import at.letto.tools.threads.ThreadStatus;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class DatabaseService {
    public DockerService dockerService;
    @Autowired
    public DockerConfiguration dockerConfiguration;
    @Autowired
    public CmdService cmdService;
    @Autowired
    AnalyzeService analyzeService;
    @Autowired
    UpdateService updateService;
    @Autowired
    SetupUpdateService setupUpdateService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private ResourcenService resourcenService;
    private boolean dumpRunning = false;

    private String q(String data) {
        return this.quoteSql(data);
    }

    public void checkDatabaseDockerConfig() {
        File f = this.microServiceConfiguration.getMysqlEnvFile();
        if (!f.exists()) {
            Vector<Object> data = new Vector<Object>();
            data.add("MYSQL_ROOT_PASSWORD=" + this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword());
            data.add("MYSQL_PORT=13306");
            data.add("MYSQL_DUMP_PATH=" + this.dockerConfiguration.getLettoEnvFile().getMysqlDumpPath());
            data.add("MYSQL_BACKUP_PATH=" + this.dockerConfiguration.getLettoEnvFile().getMysqlBackupPath());
            data.add("MYSQL_HOST=letto-mysql");
            data.add("SERVER_NAME=" + this.dockerConfiguration.getLettoEnvFile().getServerName());
            data.add("PHP_MYADMIN_HOST=" + this.dockerConfiguration.getLettoEnvFile().getPhpMyadminHost());
            Cmd.writelnfile(data, (File)f);
        }
        if (!(f = this.microServiceConfiguration.getMysqlYmlFile()).exists()) {
            this.dockerService.createMysqlYml();
        }
    }

    public boolean checkDatabaseAccess(String url, String user, String password) {
        try {
            Connection con = DriverManager.getConnection(url, user, password);
            con.close();
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public String execute(Connection con, String sqlStatement) {
        try {
            Statement stmt = con.createStatement(1005, 1008);
            stmt.execute(sqlStatement);
            return "";
        }
        catch (SQLException throwables) {
            Object msg = throwables.getMessage();
            msg = (String)msg + " Statement: " + sqlStatement + "! ";
            return msg;
        }
    }

    public Vector<Vector<String>> executeQuery(Connection con, String sqlStatement) {
        Vector<Vector<String>> ret = new Vector<Vector<String>>();
        try {
            int c;
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sqlStatement);
            ResultSetMetaData metaData = rs.getMetaData();
            int rows = metaData.getColumnCount();
            Vector<String> row = new Vector<String>();
            for (c = 1; c <= rows; ++c) {
                row.add(metaData.getColumnName(c));
            }
            ret.add(row);
            while (rs.next()) {
                row = new Vector();
                for (c = 1; c <= rows; ++c) {
                    row.add(rs.getString(c));
                }
                ret.add(row);
            }
            return ret;
        }
        catch (SQLException throwables) {
            String string = throwables.getMessage() + "! ";
            return null;
        }
    }

    public String quoteSql(String data) {
        data = ((String)data).replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'");
        data = "'" + (String)data + "'";
        return data;
    }

    public String getLettoMysqlPort() {
        String port = this.dockerConfiguration.getLettoEnvFile().getMysqlPort();
        if (port == null || port.length() == 0) {
            return "13306";
        }
        return port;
    }

    public String checkServerAddress(String address) {
        if (this.dockerService.isDockerRunning()) {
            return address;
        }
        if (address.startsWith("letto-mysql.nw-letto")) {
            return "localhost:" + this.getLettoMysqlPort();
        }
        return address;
    }

    public boolean checkDatabaseSchool6500(SchuleEnv schule, Connection con) {
        int i;
        Vector data = null;
        data = this.executeQuery(con, "describe user");
        boolean ok = false;
        if (data != null && data.size() > 1) {
            for (i = 1; i < data.size(); ++i) {
                if (!((String)((Vector)data.get(i)).get(0)).trim().equalsIgnoreCase("id") || !((String)((Vector)data.get(i)).get(5)).trim().equalsIgnoreCase("auto_increment")) continue;
                ok = true;
            }
        }
        if (!ok) {
            return false;
        }
        data = this.executeQuery(con, "describe lehrerKlasse");
        ok = false;
        if (data != null && data.size() > 1) {
            for (i = 1; i < data.size(); ++i) {
                if (!((String)((Vector)data.get(i)).get(0)).trim().equalsIgnoreCase("id") || !((String)((Vector)data.get(i)).get(5)).trim().equalsIgnoreCase("auto_increment")) continue;
                ok = true;
            }
        }
        if (!ok) {
            return false;
        }
        ok = false;
        if (data != null && data.size() > 1) {
            for (i = 1; i < data.size(); ++i) {
                if (!((String)((Vector)data.get(i)).get(0)).trim().equalsIgnoreCase("KURSKENNUNG")) continue;
                ok = true;
            }
        }
        if (!ok) {
            return false;
        }
        data = this.executeQuery(con, "describe category");
        ok = false;
        if (data != null && data.size() > 1) {
            for (i = 1; i < data.size(); ++i) {
                if (!((String)((Vector)data.get(i)).get(0)).trim().equalsIgnoreCase("id") || !((String)((Vector)data.get(i)).get(5)).trim().equalsIgnoreCase("auto_increment")) continue;
                ok = true;
            }
        }
        if (!ok) {
            return false;
        }
        ok = false;
        if (data != null && data.size() > 1) {
            for (i = 1; i < data.size(); ++i) {
                if (!((String)((Vector)data.get(i)).get(0)).trim().equalsIgnoreCase("CATEGORYLINK")) continue;
                ok = true;
            }
        }
        return ok;
    }

    public void calcDatabaseStatus(DockerStatusDto dockerStatus) {
        block25: {
            dockerStatus.setDatabaseSchoolLettoLoginOk(new HashMap());
            dockerStatus.setDatabaseSchoolLettoLoginPasswordOk(new HashMap());
            dockerStatus.setDatabaseSchoolLettoLoginExists(new HashMap());
            dockerStatus.setDatabaseSchoolLettoLoginAdd(new HashMap());
            dockerStatus.setDatabaseSchoolLettoLoginDatabaseAdd(new HashMap());
            dockerStatus.setDatabaseSchoolLettoDatabaseAdd(new HashMap());
            dockerStatus.setDatabaseSchoolLettoExists(new HashMap());
            dockerStatus.setDatabaseSchoolLettoDocker(new HashMap());
            Vector schulen = this.dockerConfiguration.getLettoEnvFile().getSchulen();
            for (Object schule : schulen) {
                dockerStatus.getDatabaseSchoolLettoDocker().put(((SchuleEnv)schule).school, ((SchuleEnv)schule).mysqlHost.startsWith("letto-mysql.nw-letto"));
                dockerStatus.getDatabaseSchoolLettoLoginOk().put(((SchuleEnv)schule).school, false);
                dockerStatus.getDatabaseSchoolLettoLoginPasswordOk().put(((SchuleEnv)schule).school, false);
                dockerStatus.getDatabaseSchoolLettoLoginExists().put(((SchuleEnv)schule).school, false);
                dockerStatus.getDatabaseSchoolLettoLoginAdd().put(((SchuleEnv)schule).school, false);
                dockerStatus.getDatabaseSchoolLettoLoginDatabaseAdd().put(((SchuleEnv)schule).school, false);
                dockerStatus.getDatabaseSchoolLettoDatabaseAdd().put(((SchuleEnv)schule).school, false);
                dockerStatus.getDatabaseSchoolLettoExists().put(((SchuleEnv)schule).school, false);
            }
            dockerStatus.setDatabaseRootLoginOk(false);
            dockerStatus.setDatabaseLTILoginOk(false);
            dockerStatus.setDatabaseLTILoginPasswordOk(false);
            dockerStatus.setDatabaseLTILoginExists(false);
            dockerStatus.setDatabaseLTILoginAdd(false);
            dockerStatus.setDatabaseLTILoginDatabaseAdd(false);
            dockerStatus.setDatabaseLTIDatabaseAdd(false);
            dockerStatus.setDatabaseLTIExists(false);
            dockerStatus.setDatabaseLTIDocker(false);
            dockerStatus.setDatabaseLettoLoginOk(false);
            dockerStatus.setDatabaseLettoLoginExists(false);
            dockerStatus.setDatabaseLettoLoginAdd(false);
            dockerStatus.setDatabaseLTIDocker(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiHost().startsWith("letto-mysql.nw-letto"));
            String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiHost()) + "/" + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase();
            String databaseUser = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser();
            String databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiPassword();
            dockerStatus.setDatabaseLTILoginOk(this.checkDatabaseAccess(databaseUrl, databaseUser, databasePassword));
            databaseUrl = "jdbc:mysql://" + this.checkServerAddress(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiHost());
            databaseUser = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser();
            databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiPassword();
            dockerStatus.setDatabaseLTILoginPasswordOk(this.checkDatabaseAccess(databaseUrl, databaseUser, databasePassword));
            databaseUrl = "jdbc:mysql://" + this.checkServerAddress("letto-mysql.nw-letto");
            databaseUser = "letto";
            databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword();
            dockerStatus.setDatabaseLettoLoginOk(this.checkDatabaseAccess(databaseUrl, databaseUser, databasePassword));
            String restkey = this.dockerConfiguration.getSetupEnvFile().getLettoRestkey().trim();
            for (SchuleEnv schule : schulen) {
                databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
                if (this.checkDatabaseAccess(databaseUrl, databaseUser = schule.mysqlUser, databasePassword = schule.mysqlPassword)) {
                    dockerStatus.getDatabaseSchoolLettoLoginOk().put(schule.school, true);
                    String databaseRestkey = this.loadRestkeyFromDatabase(schule.envID).trim();
                    String databaseLicense = this.loadLizenzFromDatabase(schule.envID).trim();
                    dockerStatus.getDatabaseSchoolRestKey().put(schule.school, databaseRestkey != null ? databaseRestkey : "");
                    dockerStatus.getDatabaseSchoolLicense().put(schule.school, databaseLicense != null ? databaseLicense : "");
                } else {
                    dockerStatus.getDatabaseSchoolRestKey().put(schule.school, "");
                    dockerStatus.getDatabaseSchoolLicense().put(schule.school, "");
                }
                if (!this.checkDatabaseAccess(databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost), databaseUser = schule.mysqlUser, databasePassword = schule.mysqlPassword)) continue;
                dockerStatus.getDatabaseSchoolLettoLoginPasswordOk().put(schule.school, true);
            }
            databaseUrl = "jdbc:mysql://" + this.checkServerAddress("letto-mysql.nw-letto") + "/mysql";
            databaseUser = "root";
            databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword();
            Connection con = null;
            Vector data = null;
            try {
                con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
                dockerStatus.setDatabaseRootLoginOk(true);
                data = this.executeQuery(con, "show databases");
                if (data != null && data.size() > 1) {
                    for (int r = 1; r < data.size(); ++r) {
                        String db = (String)((Vector)data.get(r)).get(0);
                        if (this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase().equals(db) && dockerStatus.isDatabaseLTIDocker()) {
                            dockerStatus.setDatabaseLTIExists(true);
                        }
                        for (Object schule : schulen) {
                            boolean isDocker;
                            boolean bl = isDocker = dockerStatus.getDatabaseSchoolLettoDocker().containsKey(((SchuleEnv)schule).school) && (Boolean)dockerStatus.getDatabaseSchoolLettoDocker().get(((SchuleEnv)schule).school) != false;
                            if (!((SchuleEnv)schule).mysqlDatabase.equals(db) || !isDocker) continue;
                            dockerStatus.getDatabaseSchoolLettoExists().put(((SchuleEnv)schule).school, true);
                        }
                    }
                }
                if ((data = this.executeQuery(con, "select Host,User from user")) != null && data.size() > 1) {
                    for (int r = 1; r < data.size(); ++r) {
                        String host = (String)((Vector)data.get(r)).get(0);
                        String user = (String)((Vector)data.get(r)).get(1);
                        if (user.equals("letto")) {
                            dockerStatus.setDatabaseLettoLoginExists(true);
                        }
                        if (this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser().equals(user) && dockerStatus.isDatabaseLTIDocker()) {
                            dockerStatus.setDatabaseLTILoginExists(true);
                        }
                        for (SchuleEnv schule : schulen) {
                            boolean isDocker;
                            boolean bl = isDocker = dockerStatus.getDatabaseSchoolLettoDocker().containsKey(schule.school) && (Boolean)dockerStatus.getDatabaseSchoolLettoDocker().get(schule.school) != false;
                            if (!schule.mysqlUser.equals(user) || !isDocker) continue;
                            dockerStatus.getDatabaseSchoolLettoLoginExists().put(schule.school, true);
                        }
                    }
                }
                con.close();
                if (!dockerStatus.isDatabaseLettoLoginExists()) {
                    dockerStatus.setDatabaseLettoLoginAdd(true);
                }
                if (dockerStatus.isDatabaseLTIDocker()) {
                    if (!dockerStatus.isDatabaseLTIExists() && !dockerStatus.isDatabaseLTILoginExists()) {
                        dockerStatus.setDatabaseLTILoginDatabaseAdd(true);
                    }
                    if (!dockerStatus.isDatabaseLTIExists()) {
                        dockerStatus.setDatabaseLTIDatabaseAdd(true);
                    }
                    if (!dockerStatus.isDatabaseLTILoginExists()) {
                        dockerStatus.setDatabaseLTILoginAdd(true);
                    }
                }
                for (SchuleEnv schule : schulen) {
                    boolean pwOk;
                    boolean isDocker = dockerStatus.getDatabaseSchoolLettoDocker().containsKey(schule.school) && (Boolean)dockerStatus.getDatabaseSchoolLettoDocker().get(schule.school) != false;
                    if (!isDocker) continue;
                    boolean dbExists = dockerStatus.getDatabaseSchoolLettoExists().containsKey(schule.school) && (Boolean)dockerStatus.getDatabaseSchoolLettoExists().get(schule.school) == true;
                    boolean loginExists = dockerStatus.getDatabaseSchoolLettoLoginExists().containsKey(schule.school) && (Boolean)dockerStatus.getDatabaseSchoolLettoLoginExists().get(schule.school) == true;
                    boolean bl = pwOk = dockerStatus.getDatabaseSchoolLettoLoginPasswordOk().containsKey(schule.school) && (Boolean)dockerStatus.getDatabaseSchoolLettoLoginPasswordOk().get(schule.school) == true;
                    if (!dbExists && !loginExists) {
                        dockerStatus.getDatabaseSchoolLettoLoginDatabaseAdd().put(schule.school, true);
                    }
                    if (!dbExists) {
                        dockerStatus.getDatabaseSchoolLettoDatabaseAdd().put(schule.school, true);
                    }
                    if (loginExists) continue;
                    dockerStatus.getDatabaseSchoolLettoLoginAdd().put(schule.school, true);
                }
            }
            catch (Exception throwables) {
                if (con == null) break block25;
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public void importDatabaseDump(CmdThread thread, int id, String filename) {
        if (this.dumpRunning) {
            thread.htmlErr("Another Dump is actually running, cannot start Database-Dump");
            return;
        }
        this.dumpRunning = true;
        try {
            boolean schoolIsRunning;
            SchuleEnv schule = null;
            Vector schulelist = this.dockerConfiguration.getLettoEnvFile().getSchulen();
            for (SchuleEnv s : schulelist) {
                if (s.envID != id) continue;
                schule = s;
            }
            if (schule == null) {
                thread.htmlErr("school " + id + " cannot be loaded!");
                throw new RuntimeException("msg");
            }
            thread.htmlOut("school " + schule.school + " wird geladen von " + filename);
            String school = schule.school;
            thread.htmlOut("Import from SQL-dump to docker-container letto-mysql!");
            thread.htmlOut("check if school-container is running");
            if (!this.dockerService.isDockerContainerRunning("letto-mysql")) {
                thread.htmlErr("docker-container letto-mysql is not running! please start it first!");
                throw new RuntimeException("msg");
            }
            boolean bl = schoolIsRunning = this.dockerService.schoolIsRunning(school) > 0;
            if (filename.endsWith(".gz")) {
                if (!this.dockerService.isDockerRunning() && !this.dockerService.isDockerContainerRunning("letto-setup")) {
                    thread.htmlErr("docker-container letto-setup is not running! please start it first!");
                    throw new RuntimeException("msg");
                }
                filename = filename.substring(0, filename.length() - 3);
                File fgz = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename + ".gz");
                File f = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename);
                if (!fgz.exists()) {
                    thread.htmlErr("file " + filename + ".gz not exists!");
                    throw new RuntimeException("msg");
                }
                if (f.exists()) {
                    f.delete();
                }
                if (schoolIsRunning) {
                    thread.runCmd(new String[]{"docker stop letto-data-" + school, "docker stop letto-server-" + school});
                }
                if (this.dockerService.isDockerRunning()) {
                    thread.runCmd(new String[]{"gunzip " + this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename + ".gz", "docker exec -i letto-mysql import " + filename + " " + schule.mysqlDatabase});
                } else {
                    thread.runCmd(new String[]{"docker exec -i letto-setup gunzip /opt/letto/docker/storage/database-dump/" + filename + ".gz"});
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    thread.runCmd(new String[]{"docker exec -i letto-mysql import " + filename + " " + schule.mysqlDatabase});
                }
                if (schoolIsRunning) {
                    thread.runCmd(new String[]{"docker start letto-data-" + school, "docker start letto-server-" + school});
                }
            } else {
                File f = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename);
                if (!f.exists()) {
                    thread.htmlErr("Dumpfile nicht auffindbar! Daten nicht eingespielt!");
                    throw new RuntimeException("msg");
                }
                if (schoolIsRunning) {
                    thread.runCmd(new String[]{"docker stop letto-data-" + school, "docker stop letto-server-" + school});
                }
                thread.runCmd(new String[]{"docker exec -i letto-mysql import " + filename + " " + schule.mysqlDatabase});
                if (schoolIsRunning) {
                    thread.runCmd(new String[]{"docker start letto-data-" + school, "docker start letto-server-" + school});
                }
            }
            String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
            String databaseUser = schule.mysqlUser;
            String databasePassword = schule.mysqlPassword;
            Connection con = null;
            Vector data = null;
            String msg = "";
            try {
                con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
                data = this.executeQuery(con, "select id,NAME from schule");
                if (data != null && data.size() > 1) {
                    boolean found = false;
                    for (int i = 1; i < data.size(); ++i) {
                        if (!((String)((Vector)data.get(i)).get(1)).trim().equalsIgnoreCase(schule.schulname.trim())) continue;
                        found = true;
                        schule.idSchuleData = Integer.parseInt((String)((Vector)data.get(i)).get(0));
                    }
                    if (!found) {
                        schule.idSchuleData = Integer.parseInt((String)((Vector)data.get(1)).get(0));
                    }
                }
                boolean check6500 = this.checkDatabaseSchool6500(schule, con);
                con.close();
                this.dockerConfiguration.getLettoEnvFile().setSchulen(schulelist);
                this.dockerConfiguration.saveConfiguration();
                this.dockerService.analyze(false);
                if (!check6500) {
                    if (!this.dockerService.isDockerRunning() && !this.dockerService.isDockerContainerRunning("letto-setup")) {
                        thread.htmlErr("docker-container letto-setup is not running! please start it and after that run check6500!");
                        throw new RuntimeException("msg");
                    }
                    String cmd = schule.cmdMysql() + "</download/changes6500.sql";
                    if (this.dockerService.isDockerRunning()) {
                        thread.runCmd(new String[]{cmd});
                    } else {
                        thread.runCmd(new String[]{"docker exec -i letto-setup " + cmd});
                    }
                }
            }
            catch (Exception ex) {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                thread.htmlErr("Fehler beim Datenbankimport!");
                throw new RuntimeException("msg");
            }
        }
        catch (Exception ex) {
            this.dumpRunning = false;
            throw ex;
        }
        this.dumpRunning = false;
    }

    public void importDatabaseLtiDump(CmdThread thread, String filename) {
        block17: {
            if (this.dumpRunning) {
                thread.htmlErr("Another Dump is actually running, cannot start Database-Dump");
                return;
            }
            this.dumpRunning = true;
            try {
                thread.htmlOut("LTI-Database wird geladen von " + filename);
                thread.htmlOut("Import from SQL-dump to docker-container letto-mysql!");
                thread.htmlOut("check if lti-container is running");
                if (!this.dockerService.isDockerContainerRunning("letto-mysql")) {
                    thread.htmlErr("docker-container letto-mysql is not running! please start it first!");
                    throw new RuntimeException("msg");
                }
                String database = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase();
                boolean ltiIsRunning = this.dockerService.isDockerContainerRunning("letto-lti");
                if (filename.endsWith(".gz")) {
                    if (!this.dockerService.isDockerRunning() && !this.dockerService.isDockerContainerRunning("letto-setup")) {
                        thread.htmlErr("docker-container letto-setup is not running! please start it first!");
                        throw new RuntimeException("msg");
                    }
                    filename = filename.substring(0, filename.length() - 3);
                    File fgz = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename + ".gz");
                    File f = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename);
                    if (!fgz.exists()) {
                        thread.htmlErr("file " + filename + ".gz not exists!");
                        throw new RuntimeException("msg");
                    }
                    if (f.exists()) {
                        f.delete();
                    }
                    if (ltiIsRunning) {
                        thread.runCmd(new String[]{"docker stop letto-lti"});
                    }
                    if (this.dockerService.isDockerRunning()) {
                        thread.runCmd(new String[]{"gunzip " + this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename + ".gz", "docker exec -i letto-mysql import " + filename + " " + database});
                    } else {
                        thread.runCmd(new String[]{"docker exec -i letto-setup gunzip /opt/letto/docker/storage/database-dump/" + filename + ".gz"});
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        thread.runCmd(new String[]{"docker exec -i letto-mysql import " + filename + " " + database});
                    }
                    if (ltiIsRunning) {
                        thread.runCmd(new String[]{"docker start letto-lti"});
                    }
                    break block17;
                }
                File f = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename);
                if (!f.exists()) {
                    thread.htmlErr("Dumpfile nicht auffindbar! Daten nicht eingespielt!");
                    throw new RuntimeException("msg");
                }
                if (ltiIsRunning) {
                    thread.runCmd(new String[]{"docker stop letto-lti"});
                }
                thread.runCmd(new String[]{"docker exec -i letto-mysql import " + filename + " " + database});
                if (ltiIsRunning) {
                    thread.runCmd(new String[]{"docker start letto-lti"});
                }
            }
            catch (Exception ex) {
                this.dumpRunning = false;
                throw ex;
            }
        }
        this.dumpRunning = false;
    }

    public void createDatabaseDump(CmdThread cmdThread, int id, boolean stopLetto) {
        if (this.dumpRunning) {
            cmdThread.htmlErr("Another Dump is actually running, cannot start Database-Dump");
            return;
        }
        this.dumpRunning = true;
        try {
            boolean schoolIsRunning;
            SchuleEnv schule = null;
            Vector schulelist = this.dockerConfiguration.getLettoEnvFile().getSchulen();
            for (SchuleEnv s : schulelist) {
                if (s.envID != id) continue;
                schule = s;
            }
            if (schule == null) {
                cmdThread.htmlErr("school " + id + " cannot be loaded!");
                throw new RuntimeException("msg");
            }
            String school = schule.school;
            String filename = "letto_" + school + ".sql";
            if (!this.dockerService.isDockerContainerRunning("letto-mysql")) {
                cmdThread.htmlErr("docker-container letto-mysql is not running! please start it first!");
                throw new RuntimeException("msg");
            }
            cmdThread.htmlOut("check if school-container is running");
            boolean bl = schoolIsRunning = this.dockerService.schoolIsRunning(school) > 0;
            if (schoolIsRunning && stopLetto) {
                cmdThread.runCmd(new String[]{"docker stop letto-data-" + school, "docker stop letto-server-" + school});
            }
            cmdThread.runCmd(new String[]{"docker exec -i letto-mysql export " + schule.mysqlDatabase + " " + filename});
            if (schoolIsRunning && stopLetto) {
                cmdThread.runCmd(new String[]{"docker start letto-data-" + school, "docker start letto-server-" + school});
            }
        }
        catch (Exception ex) {
            this.dumpRunning = false;
            throw ex;
        }
        this.dumpRunning = false;
    }

    public void createDatabaseLtiDump(CmdThread cmdThread, boolean stopLti) {
        if (this.dumpRunning) {
            cmdThread.htmlErr("Another Dump is actually running, cannot start Database-Dump");
            return;
        }
        this.dumpRunning = true;
        try {
            String filename = "lettolti.sql";
            if (!this.dockerService.isDockerContainerRunning("letto-mysql")) {
                cmdThread.htmlErr("docker-container letto-mysql is not running! please start it first!");
                throw new RuntimeException("msg");
            }
            String database = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase();
            cmdThread.htmlOut("check if lti-container is running");
            boolean ltiIsRunning = this.dockerService.isDockerContainerRunning("letto-lti");
            if (ltiIsRunning && stopLti) {
                cmdThread.runCmd(new String[]{"docker stop letto-lti"});
            }
            cmdThread.runCmd(new String[]{"docker exec -i letto-mysql export " + database + " " + filename});
            if (ltiIsRunning && stopLti) {
                cmdThread.runCmd(new String[]{"docker start letto-lti"});
            }
        }
        catch (Exception ex) {
            this.dumpRunning = false;
            throw ex;
        }
        this.dumpRunning = false;
    }

    public CmdThread databaseDump(int id) {
        ExportDatabaseDump cmdThread = new ExportDatabaseDump(this, id);
        cmdThread.start();
        this.cmdService.addThread((CmdThread)cmdThread);
        return cmdThread;
    }

    public CmdThread loadDatabaseDump(int id) {
        SchuleEnv schule = this.dockerService.getSchuleEnv(id);
        String school = schule.school;
        String filename = "letto_" + school + ".sql";
        if (new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename + ".gz").exists()) {
            return this.loadDatabaseDump(id, filename + ".gz");
        }
        if (new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename).exists()) {
            return this.loadDatabaseDump(id, filename);
        }
        return CmdThread.createThreadMessage((String)("Dumpfile " + filename + "nicht auffindbar! Daten nicht eingespielt!"));
    }

    public CmdThread loadDatabaseDump(int id, String filename) {
        ImportDatabaseDump cmdThread = new ImportDatabaseDump(this, id, filename);
        cmdThread.start();
        this.cmdService.addThread((CmdThread)cmdThread);
        return cmdThread;
    }

    public String change6500(int id) {
        SchuleEnv schule = null;
        Vector schulelist = this.dockerConfiguration.getLettoEnvFile().getSchulen();
        for (SchuleEnv s : schulelist) {
            if (s.envID != id) continue;
            schule = s;
        }
        if (schule == null) {
            return "Cannot load school !";
        }
        return this.change6500(schule);
    }

    public String change6500(SchuleEnv schule) {
        CmdThread t;
        if (!this.dockerService.isDockerRunning() && !this.dockerService.isDockerContainerRunning("letto-setup")) {
            return "docker-container letto-setup is not running! please start it and after that run check6500!";
        }
        String cmd = schule.cmdMysql() + "</download/changes6500.sql";
        if (!this.dockerService.isDockerRunning()) {
            cmd = "docker exec -i letto-setup " + cmd;
        }
        if ((t = this.cmdService.cmdScriptForeground(3600000L, true, new String[]{cmd})).getThreadStatus() != ThreadStatus.FINISHED) {
            return "Database not correctly changed! <br>" + t.getHtmlOutput() + "! ";
        }
        return "";
    }

    public boolean checkDatabaseSchool6500(int id) {
        SchuleEnv schule = null;
        Vector schulelist = this.dockerConfiguration.getLettoEnvFile().getSchulen();
        for (SchuleEnv s : schulelist) {
            if (s.envID != id) continue;
            schule = s;
        }
        if (schule == null) {
            return false;
        }
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
        String databaseUser = schule.mysqlUser;
        String databasePassword = schule.mysqlPassword;
        Connection con = null;
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            boolean ret = this.checkDatabaseSchool6500(schule, con);
            con.close();
            return ret;
        }
        catch (Exception ex) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public String createDatabaseLtiUser() {
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress("letto-mysql.nw-letto") + "/mysql";
        String databaseUser = "root";
        String databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword();
        Connection con = null;
        Object data = null;
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            this.execute(con, "CREATE USER if not exists " + this.q(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser()) + "@'%' IDENTIFIED WITH mysql_native_password BY " + this.q(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiPassword()));
            this.execute(con, "GRANT ALL PRIVILEGES ON " + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser() + " . * TO " + this.q(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser()) + "@'%'");
            this.execute(con, "GRANT ALL PRIVILEGES ON " + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase() + " . * TO " + this.q(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser()) + "@'%'");
            this.execute(con, "flush privileges");
            con.close();
            return "";
        }
        catch (SQLException throwables) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "cannot create user " + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser();
        }
    }

    public String createDatabaseLti() {
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress("letto-mysql.nw-letto");
        String databaseUser = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser();
        String databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlLtiPassword();
        Connection con = null;
        Object data = null;
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            this.execute(con, "drop database if exists " + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase());
            this.execute(con, "create database if not exists " + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase());
            con.close();
            return "";
        }
        catch (SQLException throwables) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "Cannot create database " + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiDatabase();
        }
    }

    public String setPassword(String user, String password) {
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress("letto-mysql.nw-letto") + "/mysql";
        String databaseUser = "root";
        String databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword();
        Connection con = null;
        Object data = null;
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            this.execute(con, "SET PASSWORD FOR " + this.q(user) + "@'%' = " + this.q(password));
            con.close();
            return "";
        }
        catch (SQLException throwables) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "cannot create user " + this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser();
        }
    }

    public void resetMysqlRootLogin() {
        CmdThread t = this.cmdService.cmdScriptForeground(30000L, new String[]{"docker exec -i letto-mysql /init-db.sh"});
        if (!this.dockerService.getDockerStatus().isDatabaseLTILoginExists()) {
            this.createDatabaseLtiUser();
        }
        if (!this.dockerService.getDockerStatus().isDatabaseLettoLoginExists()) {
            this.createDatabaseLettoUser();
        }
    }

    public String createDatabaseLtiSetPassword() {
        return this.setPassword(this.dockerConfiguration.getLettoEnvFile().getMysqlLtiUser(), this.dockerConfiguration.getLettoEnvFile().getMysqlLtiPassword());
    }

    public String DatabaseSchoolSetPassword(int id) {
        SchuleEnv schule = this.dockerService.getSchuleEnv(id);
        return this.setPassword(schule.mysqlUser, schule.mysqlPassword);
    }

    public String createDatabaseLettoUser() {
        String password = this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword();
        for (SchuleEnv schule : this.dockerConfiguration.getLettoEnvFile().getSchulen()) {
            if (!schule.mysqlUser.equals("letto")) continue;
            password = schule.mysqlPassword;
        }
        return this.createDatabaseLettoUser("letto", this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword(), null, "letto-mysql.nw-letto");
    }

    public String createDatabaseLettoUser(String user, String password, String database, String host) {
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(host) + "/mysql";
        String databaseUser = "root";
        String databasePassword = this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword();
        Connection con = null;
        Object data = null;
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            this.execute(con, "CREATE USER if not exists " + this.q(user) + "@'%' IDENTIFIED WITH mysql_native_password BY " + this.q(password));
            this.execute(con, "GRANT USAGE ON *.* TO " + this.q(user) + "@'%'");
            this.execute(con, "ALTER USER " + this.q(user) + "@'%' REQUIRE NONE WITH MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0");
            this.execute(con, "GRANT ALL PRIVILEGES ON " + user + ".* TO " + this.q(user) + "@'%'");
            this.execute(con, "GRANT ALL PRIVILEGES ON `" + user + "_%`.* TO " + this.q(user) + "@'%'");
            if (database != null && database.length() > 0) {
                this.execute(con, "GRANT ALL PRIVILEGES ON " + database + ".* TO " + this.q(user) + "@'%'");
            }
            this.execute(con, "flush privileges");
            con.close();
            return "";
        }
        catch (SQLException throwables) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "cannot create user " + user;
        }
    }

    public String createDatabaseSchoolLettoUser(int id) {
        SchuleEnv schule = this.dockerService.getSchuleEnv(id);
        if (schule == null) {
            return "school " + id + " does not exist";
        }
        return this.createDatabaseLettoUser(schule.mysqlUser, schule.mysqlPassword, schule.mysqlDatabase, schule.mysqlHost);
    }

    public void createDatabaseSchool(CmdThread cmdThread, int id, DockerEditSchoolDto dockerEditSchoolDto) {
        Vector schulen = this.dockerService.getSchulenEnv();
        SchuleEnv schule = null;
        for (SchuleEnv s : schulen) {
            if (s.envID != id) continue;
            schule = s;
        }
        if (schule == null) {
            cmdThread.htmlErr("school " + id + " cannot be loaded! ");
            throw new RuntimeException("msg");
        }
        schule.idSchuleData = 1;
        schule.idSchuleLizenz = 0;
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost);
        String databaseUser = schule.mysqlUser;
        String databasePassword = schule.mysqlPassword;
        Connection con = null;
        Object data = null;
        Object msg = "";
        if (dockerEditSchoolDto == null) {
            dockerEditSchoolDto = this.loadEditSchoolDto(id);
        }
        if (dockerEditSchoolDto == null) {
            dockerEditSchoolDto = new DockerEditSchoolDto();
        }
        try {
            cmdThread.htmlOut("drop and create database " + schule.mysqlDatabase);
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            this.execute(con, "drop database if exists " + schule.mysqlDatabase);
            this.execute(con, "create database if not exists " + schule.mysqlDatabase);
            con.close();
            String initdbFilename = this.dockerService.getDatabaseDumpDirectoryPath() + "/initdb.sql";
            File initdb = new File(initdbFilename);
            msg = (String)msg + this.resourcenService.copyTextFileFromResource("sql/initdb.sql", initdb);
            if (initdb.exists() && initdb.isFile() && initdb.canRead()) {
                cmdThread.htmlOut("create school in database ");
                String cmd = "docker exec -i letto-mysql import initdb " + schule.mysqlDatabase;
                cmdThread.runCmd(new String[]{cmd});
            } else {
                cmdThread.htmlErr("Database deleted but not correctly installed (initdb.sql not found)!");
            }
            databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            if (dockerEditSchoolDto.getAdminglobal().length() > 0) {
                cmdThread.htmlOut("set global administrator name: " + dockerEditSchoolDto.getAdminglobal());
                if (dockerEditSchoolDto.getAdminglobalpassword() != null && dockerEditSchoolDto.getAdminglobalpassword().length() > 0) {
                    this.execute(con, "UPDATE user SET `NAME`=" + this.q(dockerEditSchoolDto.getAdminglobal().trim()) + ", `NACHNAME`=" + this.q(dockerEditSchoolDto.getAdminglobal().trim()) + ", `PASSWORD`=" + this.q(new BCryptPasswordEncoder().encode((CharSequence)dockerEditSchoolDto.getAdminglobalpassword().trim())) + ", PASSWORT=" + this.q(ENCRYPT.md5falsch((String)dockerEditSchoolDto.getAdminglobalpassword().trim())) + ", TEMPPASSWORT='' WHERE id='1'");
                } else {
                    this.execute(con, "UPDATE user SET `NAME`=" + this.q(dockerEditSchoolDto.getAdminglobal()) + ", TEMPPASSWORT='' WHERE id='1'");
                }
            }
            if (dockerEditSchoolDto.getAdminschule().length() > 0) {
                cmdThread.htmlOut("set school administrator name : " + dockerEditSchoolDto.getAdminschule());
                if (dockerEditSchoolDto.getAdminschulepassword() != null && dockerEditSchoolDto.getAdminschulepassword().length() > 0) {
                    this.execute(con, "UPDATE user SET `NAME`=" + this.q(dockerEditSchoolDto.getAdminschule().trim()) + ", `NACHNAME`=" + this.q(dockerEditSchoolDto.getAdminschule().trim()) + ", `PASSWORD`=" + this.q(new BCryptPasswordEncoder().encode((CharSequence)dockerEditSchoolDto.getAdminschulepassword().trim())) + ", PASSWORT=" + this.q(ENCRYPT.md5falsch((String)dockerEditSchoolDto.getAdminschulepassword().trim())) + ", TEMPPASSWORT='' WHERE id='2'");
                } else {
                    this.execute(con, "UPDATE user SET `NAME`=" + this.q(dockerEditSchoolDto.getAdminschule()) + ", TEMPPASSWORT='' WHERE id='2'");
                }
            }
            cmdThread.htmlOut("set school data to database");
            this.execute(con, "UPDATE globalconfig SET TEXT=" + this.q(dockerEditSchoolDto.getLizenz()) + " WHERE id='1'");
            this.execute(con, "UPDATE schule SET ADRESSE=" + this.q(dockerEditSchoolDto.getSchuladresse()) + ", ANSPRECHPARTNER=" + this.q(dockerEditSchoolDto.getSchulansprechpartner()) + ", DIREKTOR=" + this.q(dockerEditSchoolDto.getSchuldirektor()) + ", EMAIL=" + this.q(dockerEditSchoolDto.getSchulemail()) + ", INFO=" + this.q(dockerEditSchoolDto.getSchulinfo()) + ", `NAME`=" + this.q(dockerEditSchoolDto.getSchulname()) + ", SCHULKENNZAHL=" + this.q(dockerEditSchoolDto.getSchulskz()) + ", TELEFON=" + this.q(dockerEditSchoolDto.getSchultel()) + ", WEB=" + this.q(dockerEditSchoolDto.getSchulweb()) + " WHERE id='1'");
            if (dockerEditSchoolDto.getAbteilungkuerzel().trim().length() == 0) {
                dockerEditSchoolDto.setAbteilungkuerzel(dockerEditSchoolDto.getSchulkuerzel());
            }
            if (dockerEditSchoolDto.getAbteilungname().trim().length() == 0) {
                dockerEditSchoolDto.setAbteilungname(dockerEditSchoolDto.getSchulname());
            }
            this.execute(con, "UPDATE abteilung SET AV=" + this.q(dockerEditSchoolDto.getAbteilungvorstand()) + ", EMAIL=" + this.q(dockerEditSchoolDto.getAbteilungemail()) + ", INFO=" + this.q(dockerEditSchoolDto.getAbteilunginfo()) + ", KURZBEZEICHNUNG=" + this.q(dockerEditSchoolDto.getAbteilungkuerzel()) + ", TELEFON=" + this.q(dockerEditSchoolDto.getAbteilungtel()) + ", `NAME`=" + this.q(dockerEditSchoolDto.getAbteilungname()) + ", WEB=" + this.q(dockerEditSchoolDto.getAbteilungweb()) + ", `abteilungs_ORDER`='1' WHERE id='1'");
            Date d = new Date();
            int startyear = 2021;
            startyear = Datum.month((Date)d) > 7 ? Datum.year((Date)d) : Datum.year((Date)d) - 1;
            this.execute(con, "UPDATE schuljahr SET `BIS` = '" + (startyear + 1) + "-08-31', `NAME` = '" + startyear + "/" + (startyear + 1) % 100 + "', `SEMESTER` = '" + (startyear + 1) + "-02-10', `VON` = '" + startyear + "-08-01' WHERE (`id` = '1');");
            for (String imagename : this.resourcenService.getImagesFileResources()) {
                String res;
                String tp = this.dockerService.getImagesDirectoryPath();
                File targetdir = new File(tp + "/" + imagename.substring(0, 2));
                if (!targetdir.exists()) {
                    targetdir.mkdirs();
                }
                if ((res = this.resourcenService.copyFileFromResource("images/" + imagename, tp + "/" + imagename.substring(0, 2) + "/" + imagename)) == null || res.length() <= 0) continue;
                cmdThread.htmlErr(res);
            }
            msg = (String)msg + this.resourcenService.copyTextFileFromResource("sql/initdb.sql", initdb);
            con.close();
            this.dockerConfiguration.getLettoEnvFile().setSchulen(schulen);
            this.dockerConfiguration.saveConfiguration();
            this.dockerService.analyze(false);
            cmdThread.htmlOut("database created");
            return;
        }
        catch (SQLException throwables) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            cmdThread.htmlErr("school " + id + " cannot be loaded! ");
            return;
        }
    }

    public String loadRestkeyFromDatabase(int envId) {
        SchuleEnv schule = this.dockerService.getSchuleEnv(envId);
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
        String databaseUser = schule.mysqlUser;
        String databasePassword = schule.mysqlPassword;
        Connection con = null;
        Vector data = null;
        String msg = "";
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            String restkey = "";
            data = this.executeQuery(con, "select TEXT,id from globalconfig where NAME='restkey' || NAME='restKey'");
            if (data != null && data.size() > 1) {
                for (int i = 1; i < data.size(); ++i) {
                    if (((Vector)data.get(i)).get(0) == null || ((String)((Vector)data.get(i)).get(0)).trim().length() <= 0) continue;
                    restkey = (String)((Vector)data.get(i)).get(0);
                }
            }
            con.close();
            return restkey;
        }
        catch (Exception ex) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "";
        }
    }

    public String loadLizenzFromDatabase(int envId) {
        SchuleEnv schule = this.dockerService.getSchuleEnv(envId);
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
        String databaseUser = schule.mysqlUser;
        String databasePassword = schule.mysqlPassword;
        Connection con = null;
        Vector data = null;
        String msg = "";
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            String lizenz = "";
            data = this.executeQuery(con, "select TEXT,id from globalconfig where NAME='lizenz' and idSchule='" + schule.idSchuleData + "'");
            if (data != null && data.size() > 1) {
                for (int i = 1; i < data.size(); ++i) {
                    if (((Vector)data.get(i)).get(0) == null || ((String)((Vector)data.get(i)).get(0)).trim().length() <= 0) continue;
                    lizenz = (String)((Vector)data.get(i)).get(0);
                }
            } else {
                data = this.executeQuery(con, "select TEXT,id from globalconfig where NAME='lizenz' and idSchule");
                if (data != null && data.size() > 1) {
                    for (int i = 1; i < data.size(); ++i) {
                        if (((Vector)data.get(i)).get(0) == null || ((String)((Vector)data.get(i)).get(0)).trim().length() <= 0) continue;
                        lizenz = (String)((Vector)data.get(i)).get(0);
                    }
                }
            }
            con.close();
            return lizenz;
        }
        catch (Exception ex) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "";
        }
    }

    public DockerEditSchoolDto loadEditSchoolDto(int envId) {
        DockerEditSchoolDto dockerEditSchoolDto;
        block43: {
            SchuleEnv schule = this.dockerService.getSchuleEnv(envId);
            String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
            String databaseUser = schule.mysqlUser;
            String databasePassword = schule.mysqlPassword;
            Connection con = null;
            Vector data = null;
            String msg = "";
            dockerEditSchoolDto = new DockerEditSchoolDto();
            try {
                dockerEditSchoolDto.setEnvId(envId);
                dockerEditSchoolDto.setMysqlLettoHost(schule.mysqlHost);
                dockerEditSchoolDto.setMysqlLettoDatabase(schule.mysqlDatabase);
                dockerEditSchoolDto.setMysqlLettoPassword(schule.mysqlPassword);
                dockerEditSchoolDto.setMysqlLettoUser(schule.mysqlUser);
                dockerEditSchoolDto.setSchulkuerzel(schule.school);
                dockerEditSchoolDto.setSchulname(schule.schulname);
                dockerEditSchoolDto.setLizenz(schule.licence);
                dockerEditSchoolDto.setIdSchuleLizenz(schule.idSchuleLizenz);
                dockerEditSchoolDto.setIdSchule(schule.idSchuleData);
                con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
                data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISGLOBAL=1 and (NAME like 'adminglobal%') and idSchule='" + schule.idSchuleData + "'");
                if (data != null && data.size() > 1) {
                    dockerEditSchoolDto.setAdminglobal((String)((Vector)data.get(1)).get(0));
                    dockerEditSchoolDto.setIdAdminGlobal(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                    dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                    dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                } else {
                    data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISGLOBAL=1 and (NAME like 'adminglobal%')");
                    if (data != null && data.size() > 1) {
                        dockerEditSchoolDto.setAdminglobal((String)((Vector)data.get(1)).get(0));
                        dockerEditSchoolDto.setIdAdminGlobal(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                        dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                        dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                    } else {
                        data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISGLOBAL=1 and idSchule='" + schule.idSchuleData + "'");
                        if (data != null && data.size() > 1) {
                            dockerEditSchoolDto.setAdminglobal((String)((Vector)data.get(1)).get(0));
                            dockerEditSchoolDto.setIdAdminGlobal(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                            dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                            dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                        } else {
                            data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISGLOBAL=1");
                            if (data != null && data.size() > 1) {
                                dockerEditSchoolDto.setAdminglobal((String)((Vector)data.get(1)).get(0));
                                dockerEditSchoolDto.setIdAdminGlobal(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                                dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                                dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                            }
                        }
                    }
                }
                data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISADMIN=1 and ISGLOBAL=0 and (NAME like 'admin%') and idSchule='" + schule.idSchuleData + "'");
                if (data != null && data.size() > 1) {
                    dockerEditSchoolDto.setAdminschule((String)((Vector)data.get(1)).get(0));
                    dockerEditSchoolDto.setIdAdminSchule(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                    dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                    dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                } else {
                    data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISADMIN=1 and ISGLOBAL=0 and idSchule='" + schule.idSchuleData + "'");
                    if (data != null && data.size() > 1) {
                        dockerEditSchoolDto.setAdminschule((String)((Vector)data.get(1)).get(0));
                        dockerEditSchoolDto.setIdAdminSchule(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                        dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                        dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                    } else {
                        data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISADMIN=1 and idSchule='" + schule.idSchuleData + "'");
                        if (data != null && data.size() > 1) {
                            dockerEditSchoolDto.setAdminschule((String)((Vector)data.get(1)).get(0));
                            dockerEditSchoolDto.setIdAdminSchule(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                            dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                            dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                        } else {
                            data = this.executeQuery(con, "select NAME,id,password,passwort from user where ISADMIN=1");
                            if (data != null && data.size() > 1) {
                                dockerEditSchoolDto.setAdminschule((String)((Vector)data.get(1)).get(0));
                                dockerEditSchoolDto.setIdAdminSchule(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                                dockerEditSchoolDto.setAdminglobalpasswordencoded((String)((Vector)data.get(1)).get(2));
                                dockerEditSchoolDto.setAdminglobalpasswortencoded((String)((Vector)data.get(1)).get(3));
                            }
                        }
                    }
                }
                data = this.executeQuery(con, "select id,ADRESSE,ANSPRECHPARTNER,DIREKTOR,EMAIL,INFO,NAME,SCHULKENNZAHL,TELEFON,WEB from schule where id>0");
                int idSchule = 0;
                if (data != null && data.size() > 1) {
                    idSchule = Integer.parseInt((String)((Vector)data.get(1)).get(0));
                    dockerEditSchoolDto.setIdSchule(Integer.parseInt((String)((Vector)data.get(1)).get(0)));
                    if (((Vector)data.get(1)).get(5) != null) {
                        dockerEditSchoolDto.setSchulinfo((String)((Vector)data.get(1)).get(5));
                    }
                    if (((Vector)data.get(1)).get(6) != null) {
                        dockerEditSchoolDto.setSchulname((String)((Vector)data.get(1)).get(6));
                    }
                    if (((Vector)data.get(1)).get(1) != null) {
                        dockerEditSchoolDto.setSchuladresse((String)((Vector)data.get(1)).get(1));
                    }
                    if (((Vector)data.get(1)).get(2) != null) {
                        dockerEditSchoolDto.setSchulansprechpartner((String)((Vector)data.get(1)).get(2));
                    }
                    if (((Vector)data.get(1)).get(4) != null) {
                        dockerEditSchoolDto.setSchulemail((String)((Vector)data.get(1)).get(4));
                    }
                    if (((Vector)data.get(1)).get(3) != null) {
                        dockerEditSchoolDto.setSchuldirektor((String)((Vector)data.get(1)).get(3));
                    }
                    if (((Vector)data.get(1)).get(7) != null) {
                        dockerEditSchoolDto.setSchulskz((String)((Vector)data.get(1)).get(7));
                    }
                    if (((Vector)data.get(1)).get(8) != null) {
                        dockerEditSchoolDto.setSchultel((String)((Vector)data.get(1)).get(8));
                    }
                    if (((Vector)data.get(1)).get(9) != null) {
                        dockerEditSchoolDto.setSchulweb((String)((Vector)data.get(1)).get(9));
                    }
                    if ((data = this.executeQuery(con, "select id,AV,EMAIL,INFO,KURZBEZEICHNUNG,NAME,TELEFON,WEB from abteilung where idSchule=" + idSchule)) != null && data.size() > 1) {
                        if (((Vector)data.get(1)).get(0) != null) {
                            dockerEditSchoolDto.setIdAbteilung(Integer.parseInt((String)((Vector)data.get(1)).get(0)));
                        }
                        if (((Vector)data.get(1)).get(4) != null) {
                            dockerEditSchoolDto.setAbteilungkuerzel((String)((Vector)data.get(1)).get(4));
                        }
                        if (((Vector)data.get(1)).get(5) != null) {
                            dockerEditSchoolDto.setAbteilungname((String)((Vector)data.get(1)).get(5));
                        }
                        if (((Vector)data.get(1)).get(3) != null) {
                            dockerEditSchoolDto.setAbteilunginfo((String)((Vector)data.get(1)).get(3));
                        }
                        if (((Vector)data.get(1)).get(1) != null) {
                            dockerEditSchoolDto.setAbteilungvorstand((String)((Vector)data.get(1)).get(1));
                        }
                        if (((Vector)data.get(1)).get(2) != null) {
                            dockerEditSchoolDto.setAbteilungemail((String)((Vector)data.get(1)).get(2));
                        }
                        if (((Vector)data.get(1)).get(6) != null) {
                            dockerEditSchoolDto.setAbteilungtel((String)((Vector)data.get(1)).get(6));
                        }
                        if (((Vector)data.get(1)).get(7) != null) {
                            dockerEditSchoolDto.setAbteilungweb((String)((Vector)data.get(1)).get(7));
                        }
                    }
                }
                if ((data = this.executeQuery(con, "select TEXT,id from globalconfig where NAME='lizenz' and idSchule='" + idSchule + "'")) != null && data.size() > 1) {
                    dockerEditSchoolDto.setLizenz((String)((Vector)data.get(1)).get(0));
                    dockerEditSchoolDto.setIdLizenzcode(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                } else {
                    data = this.executeQuery(con, "select TEXT,id from globalconfig where NAME='lizenz'");
                    if (data != null && data.size() > 1) {
                        dockerEditSchoolDto.setLizenz((String)((Vector)data.get(1)).get(0));
                        dockerEditSchoolDto.setIdLizenzcode(Integer.parseInt((String)((Vector)data.get(1)).get(1)));
                    }
                }
                Integer lz = this.getLehreranzahl(schule, con);
                Integer slz = this.getSchuelerLizenzen(schule, con);
                Integer sz = this.getSchueleranzahl(schule, con);
                if (lz != null) {
                    dockerEditSchoolDto.setLehrerAnzahl(lz.intValue());
                }
                if (slz != null) {
                    dockerEditSchoolDto.setSchuelerLizenzAnzahl(slz.intValue());
                }
                if (sz != null) {
                    dockerEditSchoolDto.setSchuelerAnzahl(sz.intValue());
                }
                con.close();
            }
            catch (Exception ex) {
                if (con == null) break block43;
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return dockerEditSchoolDto;
    }

    public String restkeyInDatabase(int envId) {
        block7: {
            Connection con = null;
            try {
                SchuleEnv schule = this.dockerConfiguration.getLettoEnvFile().getSchule(envId);
                String school = schule.school;
                String restkey = this.dockerService.getRestKey();
                if (restkey != null && restkey.length() > 0) {
                    String databasePassword;
                    String databaseUser;
                    String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
                    con = DriverManager.getConnection(databaseUrl, databaseUser = schule.mysqlUser, databasePassword = schule.mysqlPassword);
                    Vector data = this.executeQuery(con, "select * from globalconfig where NAME='restKey'");
                    if (data == null || data.size() < 2) {
                        String sql = "INSERT INTO globalconfig (DISABLESCHOOLEDIT,EDITABLE,HELP,NAME,TEXT,TYP,VISIBLE) VALUES (1,0,'Identifikation f\u00fcr Lizenz-Server','restKey','" + restkey + "',0,0)";
                        this.execute(con, sql);
                    } else {
                        String sql = "UPDATE globalconfig SET TEXT='" + restkey + "' WHERE NAME='restKey'";
                        this.execute(con, sql);
                    }
                    this.dockerService.getDockerStatus().getDatabaseSchoolRestKey().put(school, restkey);
                    con.close();
                    return "Restkey is set to " + restkey + " in School-database!";
                }
            }
            catch (Exception ex) {
                if (con == null) break block7;
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return "cannot set restkey!";
    }

    public String licenseInDatabase(SchuleEnv schule) {
        block7: {
            Connection con = null;
            try {
                String school = schule.school;
                String license = schule.licence;
                if (license != null && license.length() > 0) {
                    String databasePassword;
                    String databaseUser;
                    String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
                    con = DriverManager.getConnection(databaseUrl, databaseUser = schule.mysqlUser, databasePassword = schule.mysqlPassword);
                    Vector data = this.executeQuery(con, "select * from globalconfig where NAME='lizenz'");
                    if (data == null || data.size() < 2) {
                        String sql = "INSERT INTO globalconfig (DISABLESCHOOLEDIT,EDITABLE,HELP,NAME,TEXT,TYP,VISIBLE) VALUES (0,0,'Lizenz Code','lizenz','" + license + "',0,0)";
                        this.execute(con, sql);
                    } else {
                        String sql = "UPDATE globalconfig SET TEXT='" + license + "' WHERE NAME='lizenz'";
                        this.execute(con, sql);
                    }
                    this.dockerService.getDockerStatus().getDatabaseSchoolLicense().put(school, license);
                    con.close();
                    return "License is set for school " + school + " in School-database!";
                }
            }
            catch (Exception ex) {
                if (con == null) break block7;
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return "cannot set License!";
    }

    public String resetSchuelerLizenzen(SchuleEnv schule) {
        block5: {
            Connection con = null;
            try {
                String school = schule.school;
                String license = schule.licence;
                if (license != null && license.length() > 0) {
                    String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
                    String databaseUser = schule.mysqlUser;
                    String databasePassword = schule.mysqlPassword;
                    con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
                    String sql = "UPDATE user SET useSchoolLicence=0 where idschule=" + this.q("" + schule.idSchuleData);
                    String msg = this.execute(con, sql);
                    con.close();
                    return msg;
                }
            }
            catch (Exception ex) {
                if (con == null) break block5;
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return "cannot reset student-licenses!";
    }

    public Integer getLehreranzahl(SchuleEnv schule, Connection con) {
        Vector data = null;
        try {
            String sql = "SELECT count(idSchule) from user where idschule=" + this.q("" + schule.idSchuleData) + " and isTeacher=1";
            data = this.executeQuery(con, sql);
            int ret = 0;
            if (data != null && data.size() > 1) {
                ret = Integer.parseInt((String)((Vector)data.get(1)).get(0));
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Integer getSchueleranzahl(SchuleEnv schule, Connection con) {
        Vector data = null;
        try {
            String sql = "SELECT count(idSchule) from user where idschule=" + this.q("" + schule.idSchuleData) + " and isStudent=1";
            data = this.executeQuery(con, sql);
            int ret = 0;
            if (data != null && data.size() > 1) {
                ret = Integer.parseInt((String)((Vector)data.get(1)).get(0));
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Integer getSchuelerLizenzen(SchuleEnv schule, Connection con) {
        Vector data = null;
        try {
            String sql = "SELECT count(idSchule) from user where idschule=" + this.q("" + schule.idSchuleData) + " and useSchoolLicence=1 and isStudent=1";
            data = this.executeQuery(con, sql);
            int ret = 0;
            if (data != null && data.size() > 1) {
                ret = Integer.parseInt((String)((Vector)data.get(1)).get(0));
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Integer getSchuelerLizenzen(SchuleEnv schule) {
        block5: {
            Object data = null;
            Connection con = null;
            try {
                String school = schule.school;
                String license = schule.licence;
                if (license != null && license.length() > 0) {
                    String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
                    String databaseUser = schule.mysqlUser;
                    String databasePassword = schule.mysqlPassword;
                    con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
                    Integer ret = this.getSchuelerLizenzen(schule, con);
                    con.close();
                    return ret;
                }
            }
            catch (Exception ex) {
                if (con == null) break block5;
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void saveEditSchoolDtoToDatabase(CmdThread cmdThread, SchuleEnv schule, DockerEditSchoolDto dockerEditSchoolDto) {
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(schule.mysqlHost) + "/" + schule.mysqlDatabase;
        String databaseUser = schule.mysqlUser;
        String databasePassword = schule.mysqlPassword;
        Connection con = null;
        Vector data = null;
        if (dockerEditSchoolDto == null) {
            cmdThread.htmlErr("dockerInitEnvDto is null, nothing saved!");
            return;
        }
        try {
            String msg;
            String msg2;
            int uid;
            String passwort;
            String password;
            String pwd;
            String name;
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            Object sql = "";
            if (dockerEditSchoolDto.getAdminglobal() != null && dockerEditSchoolDto.getAdminglobal().trim().length() > 0) {
                name = dockerEditSchoolDto.getAdminglobal().trim();
                pwd = null;
                password = null;
                passwort = null;
                if (dockerEditSchoolDto.getAdminglobalpassword() != null && dockerEditSchoolDto.getAdminglobalpassword().trim().length() > 0) {
                    pwd = dockerEditSchoolDto.getAdminglobalpassword().trim();
                    password = new BCryptPasswordEncoder().encode((CharSequence)pwd);
                    passwort = ENCRYPT.md5falsch((String)pwd);
                } else if (dockerEditSchoolDto.getAdminglobalpasswordencoded().length() > 0 && dockerEditSchoolDto.getAdminglobalpasswortencoded().length() > 0) {
                    password = dockerEditSchoolDto.getAdminglobalpasswordencoded();
                    passwort = dockerEditSchoolDto.getAdminglobalpasswortencoded();
                }
                uid = 0;
                data = this.executeQuery(con, "select id,`NAME`,idSchule from user where `NAME`='" + name + "'");
                if (schule.idSchuleData == 0) {
                    cmdThread.htmlErr("no school is defined! cannot add user !");
                } else if (data != null && data.size() > 1) {
                    uid = Integer.parseInt((String)((Vector)data.get(1)).get(0));
                    sql = "UPDATE user SET idSchule=" + this.q("" + schule.idSchuleData) + ", MULTIPLELOGIN=1, ISGLOBAL=1, ISADMIN=1 ";
                    if (pwd != null) {
                        sql = (String)sql + ", `PASSWORD`=" + this.q(password) + ", PASSWORT=" + this.q(passwort) + ", TEMPPASSWORT=''";
                    }
                    if ((msg2 = this.execute(con, (String)(sql = (String)sql + " WHERE id='" + uid + "'"))).length() > 0) {
                        cmdThread.htmlErr(msg2);
                    }
                } else {
                    if (password == null) {
                        pwd = this.dockerService.dockerConfiguration.getSetupEnvFile().getAdminPassword();
                        password = new BCryptPasswordEncoder().encode((CharSequence)pwd);
                        passwort = ENCRYPT.md5falsch((String)pwd);
                    }
                    if ((msg2 = this.execute(con, (String)(sql = "insert into user (idSchule,MULTIPLELOGIN,ISGLOBAL,ISADMIN,`NAME`,PERSNO,TEL,`PASSWORD`,PASSWORT,TEMPPASSWORT) VALUES (" + this.q("" + schule.idSchuleData) + ",1,1,1," + this.q(name) + ",'',''," + this.q(password) + "," + this.q(passwort) + ",'')"))).length() > 0) {
                        cmdThread.htmlErr(msg2);
                    }
                }
            }
            if (dockerEditSchoolDto.getAdminschule() != null && dockerEditSchoolDto.getAdminschule().trim().length() > 0) {
                name = dockerEditSchoolDto.getAdminschule().trim();
                pwd = null;
                password = null;
                passwort = null;
                if (dockerEditSchoolDto.getAdminschulepassword() != null && dockerEditSchoolDto.getAdminschulepassword().trim().length() > 0) {
                    pwd = dockerEditSchoolDto.getAdminschulepassword().trim();
                    password = new BCryptPasswordEncoder().encode((CharSequence)pwd);
                    passwort = ENCRYPT.md5falsch((String)pwd);
                } else if (dockerEditSchoolDto.getAdminschulepasswordencoded().length() > 0 && dockerEditSchoolDto.getAdminschulepasswortencoded().length() > 0) {
                    password = dockerEditSchoolDto.getAdminschulepasswordencoded();
                    passwort = dockerEditSchoolDto.getAdminschulepasswortencoded();
                }
                uid = 0;
                data = this.executeQuery(con, "select id,`NAME`,idSchule from user where `NAME`=" + this.q(name) + " AND idSchule='" + schule.idSchuleData + "'");
                if (schule.idSchuleData == 0) {
                    cmdThread.htmlErr("no school is defined! cannot add user !");
                } else if (data != null && data.size() > 1) {
                    uid = Integer.parseInt((String)((Vector)data.get(1)).get(0));
                    sql = "UPDATE user SET idSchule=" + this.q("" + schule.idSchuleData) + ", MULTIPLELOGIN=1, ISADMIN=1, ISTEACHER=1 ";
                    if (pwd != null) {
                        sql = (String)sql + ", `PASSWORD`=" + this.q(password) + ", PASSWORT=" + this.q(passwort) + ", TEMPPASSWORT=''";
                    }
                    if ((msg2 = this.execute(con, (String)(sql = (String)sql + " WHERE id='" + uid + "'"))).length() > 0) {
                        cmdThread.htmlErr(msg2);
                    }
                } else {
                    if (password == null) {
                        pwd = this.dockerService.dockerConfiguration.getSetupEnvFile().getAdminPassword();
                        password = new BCryptPasswordEncoder().encode((CharSequence)pwd);
                        passwort = ENCRYPT.md5falsch((String)pwd);
                    }
                    if ((msg2 = this.execute(con, (String)(sql = "insert into user (idSchule,MULTIPLELOGIN,ISGLOBAL,ISADMIN,ISTEACHER,`NAME`,PERSNO,TEL,`PASSWORD`,PASSWORT,TEMPPASSWORT) VALUES (" + this.q("" + schule.idSchuleData) + ",1,0,1,1," + this.q(name) + ",'',''," + this.q(password) + "," + this.q(passwort) + ",'')"))).length() > 0) {
                        cmdThread.htmlErr(msg2);
                    }
                }
            }
            if (dockerEditSchoolDto.getLizenz() != null && dockerEditSchoolDto.getLizenz().length() > 0 && (msg = this.execute(con, "UPDATE globalconfig SET TEXT=" + this.q(dockerEditSchoolDto.getLizenz().trim()) + " WHERE id='" + dockerEditSchoolDto.getIdLizenzcode() + "'")).length() > 0) {
                cmdThread.htmlErr(msg);
            }
            if (this.dockerService.getRestKey() == null || this.dockerService.getRestKey().length() < 1) {
                System.out.println("Set Restkey from Database!");
            }
            if (schule.idSchuleData == 0) {
                cmdThread.htmlErr("no school is defined! cannot update school-Data !");
            } else {
                sql = "";
                if (dockerEditSchoolDto.getSchuladresse() != null && dockerEditSchoolDto.getSchuladresse().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "ADRESSE=" + this.q(dockerEditSchoolDto.getSchuladresse());
                }
                if (dockerEditSchoolDto.getSchulansprechpartner() != null && dockerEditSchoolDto.getSchulansprechpartner().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "ANSPRECHPARTNER=" + this.q(dockerEditSchoolDto.getSchulansprechpartner());
                }
                if (dockerEditSchoolDto.getSchuldirektor() != null && dockerEditSchoolDto.getSchuldirektor().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "DIREKTOR=" + this.q(dockerEditSchoolDto.getSchuldirektor());
                }
                if (dockerEditSchoolDto.getSchulemail() != null && dockerEditSchoolDto.getSchulemail().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "EMAIL=" + this.q(dockerEditSchoolDto.getSchulemail());
                }
                if (dockerEditSchoolDto.getSchulinfo() != null && dockerEditSchoolDto.getSchulinfo().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "INFO=" + this.q(dockerEditSchoolDto.getSchulinfo());
                }
                if (dockerEditSchoolDto.getSchulname() != null && dockerEditSchoolDto.getSchulname().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "`NAME`=" + this.q(dockerEditSchoolDto.getSchulname());
                }
                if (dockerEditSchoolDto.getSchulskz() != null && dockerEditSchoolDto.getSchulskz().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "SCHULKENNZAHL=" + this.q(dockerEditSchoolDto.getSchulskz());
                }
                if (dockerEditSchoolDto.getSchultel() != null && dockerEditSchoolDto.getSchultel().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "TELEFON=" + this.q(dockerEditSchoolDto.getSchultel());
                }
                if (dockerEditSchoolDto.getSchulweb() != null && dockerEditSchoolDto.getSchulweb().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "WEB=" + this.q(dockerEditSchoolDto.getSchulweb());
                }
                if (((String)sql).length() > 0 && (msg = this.execute(con, (String)(sql = "UPDATE schule SET " + (String)sql + " WHERE id=" + this.q("" + dockerEditSchoolDto.getIdSchule())))).length() > 0) {
                    cmdThread.htmlErr(msg);
                }
            }
            if (dockerEditSchoolDto.getIdAbteilung() == 0) {
                cmdThread.htmlErr("no department is defined! cannot add department !");
            } else {
                sql = "";
                if (dockerEditSchoolDto.getAbteilungvorstand() != null && dockerEditSchoolDto.getAbteilungvorstand().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "AV=" + this.q(dockerEditSchoolDto.getAbteilungvorstand());
                }
                if (dockerEditSchoolDto.getAbteilungemail() != null && dockerEditSchoolDto.getAbteilungemail().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "EMAIL=" + this.q(dockerEditSchoolDto.getAbteilungemail());
                }
                if (dockerEditSchoolDto.getAbteilunginfo() != null && dockerEditSchoolDto.getAbteilunginfo().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "INFO=" + this.q(dockerEditSchoolDto.getAbteilunginfo());
                }
                if (dockerEditSchoolDto.getAbteilungkuerzel() != null && dockerEditSchoolDto.getAbteilungkuerzel().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "KURZBEZEICHNUNG=" + this.q(dockerEditSchoolDto.getAbteilungkuerzel());
                }
                if (dockerEditSchoolDto.getAbteilungtel() != null && dockerEditSchoolDto.getAbteilungtel().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "TELEFON=" + this.q(dockerEditSchoolDto.getAbteilungtel());
                }
                if (dockerEditSchoolDto.getAbteilungname() != null && dockerEditSchoolDto.getAbteilungname().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "`NAME`=" + this.q(dockerEditSchoolDto.getAbteilungname());
                }
                if (dockerEditSchoolDto.getAbteilungweb() != null && dockerEditSchoolDto.getAbteilungweb().length() > 0) {
                    sql = (String)sql + (((String)sql).length() > 0 ? ", " : "") + "WEB=" + this.q(dockerEditSchoolDto.getAbteilungweb());
                }
                if (((String)sql).length() > 0 && (msg = this.execute(con, (String)(sql = "UPDATE abteilung SET " + (String)sql + " WHERE id='" + dockerEditSchoolDto.getIdAbteilung() + "'"))).length() > 0) {
                    cmdThread.htmlErr(msg);
                }
            }
            con.close();
        }
        catch (Exception throwables) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throwables.printStackTrace();
            cmdThread.htmlErr(throwables.getMessage());
            cmdThread.htmlErr(" school database " + schule.mysqlDatabase + "cannnot be connected");
        }
    }

    public Connection getConnection(String host, String databaseUser, String databasePassword) {
        return this.getConnection(host, null, databaseUser, databasePassword);
    }

    public Connection getConnection(String host, String database, String databaseUser, String databasePassword) {
        if (host == null || host.trim().length() == 0 || databaseUser == null || databaseUser.trim().length() == 0 || databasePassword == null || databasePassword.trim().length() == 0) {
            return null;
        }
        String databaseUrl = database == null || database.trim().length() == 0 ? "jdbc:mysql://" + this.checkServerAddress(host) : "jdbc:mysql://" + this.checkServerAddress(host) + "/" + database;
        Connection con = null;
        Object data = null;
        String msg = "";
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
            return con;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean checkConnection(String host, String databaseUser, String databasePassword) {
        Connection con = this.getConnection(host, databaseUser, databasePassword);
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public Connection use(String host, String database, String databaseUser, String databasePassword) {
        if (host == null || host.trim().length() == 0 || database == null || database.trim().length() == 0 || databaseUser == null || databaseUser.trim().length() == 0 || databasePassword == null || databasePassword.trim().length() == 0) {
            return null;
        }
        String databaseUrl = "jdbc:mysql://" + this.checkServerAddress(host) + "/" + database;
        Connection con = null;
        Object data = null;
        String msg = "";
        try {
            con = DriverManager.getConnection(databaseUrl, databaseUser, databasePassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean existsDatabase(Connection con, String database) {
        if (con == null || database == null || database.trim().length() == 0) {
            return false;
        }
        database = database.trim();
        Vector data = null;
        data = this.executeQuery(con, "show databases");
        if (data != null && data.size() > 1) {
            for (int r = 1; r < data.size(); ++r) {
                String db = (String)((Vector)data.get(r)).get(0);
                if (!database.equals(db)) continue;
                return true;
            }
        }
        return false;
    }

    public int countTables(Connection con) {
        if (con == null) {
            return 0;
        }
        Vector data = null;
        data = this.executeQuery(con, "show tables");
        int ret = data.size();
        return ret > 0 ? ret - 1 : 0;
    }

    public void setDumpRunning(boolean dumpRunning) {
        this.dumpRunning = dumpRunning;
    }

    public boolean isDumpRunning() {
        return this.dumpRunning;
    }
}

