/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.dto.LettoConfigurationDto;
import at.letto.setupservice.model.properties.PropertiesFile;
import at.letto.setupservice.service.AnalyzeService;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LettoConfigurationService {
    private PropertiesFile propertiesFile;
    @Autowired
    private AnalyzeService analyzeService;

    public String getLettoSetupConfigFilename() {
        return this.analyzeService.getRootPath() + "/letto.conf";
    }

    public boolean isConfigFilePresent() {
        File file = new File(this.getLettoSetupConfigFilename());
        return file.exists();
    }

    public LettoConfigurationDto loadLettoConfig(String filename) {
        return this.loadLettoConfig(new File(filename));
    }

    public LettoConfigurationDto loadLettoConfig(File file) {
        if (file.exists()) {
            // empty if block
        }
        return null;
    }
}

