/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.service.DockerService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogFileService {
    @Autowired
    DockerService dockerService;
    public boolean administrateLogfileWithDockerSetup = false;
    public static final long MIN_LOGFILE_SIZE = 100000L;

    public File getLogfileSystemStatus() {
        return new File(this.dockerService.getLogDirectoryPath() + "/setup/systemstatus.log");
    }

    public void archiveLogFiles() {
        this.archiveLogFile(this.getLogfileSystemStatus(), 100000L);
    }

    public void archiveLogFile(File logfile, long minSize) {
        if (this.dockerService.getAdminLogfileWithDocker() == this.dockerService.isDockerRunning()) {
            if (!logfile.exists() || !logfile.isFile()) {
                return;
            }
            long size = logfile.length();
            if (size < minSize) {
                return;
            }
            try {
                File af = new File(logfile.getAbsolutePath() + ".old7");
                if (af.exists()) {
                    af.delete();
                }
                for (int i = 6; i > 0; --i) {
                    af = new File(logfile.getAbsolutePath() + ".old" + i);
                    File afn = new File(logfile.getAbsolutePath() + ".old" + (i + 1));
                    af.renameTo(afn);
                }
                af = new File(logfile.getAbsolutePath());
                File afn = new File(logfile.getAbsolutePath() + ".old1");
                af.renameTo(afn);
                if (!logfile.exists()) {
                    logfile.createNewFile();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void logSystemStatus() {
        try (FileWriter fw = new FileWriter(this.getLogfileSystemStatus(), true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.println(this.dockerService.getSystemStatusDto());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

