/*
 * Decompiled with CFR 0.152.
 */
package at.letto.pluginsourcecode.config;

import at.letto.pluginsourcecode.config.MicroServiceConfiguration;
import org.apache.catalina.connector.Connector;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
public class TomcatConfiguration {
    private MicroServiceConfiguration microServiceConfiguration;
    private int httpPort;
    private int httpsPort;
    private int ajpPort;

    public TomcatConfiguration(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.httpPort = this.microServiceConfiguration.getPluginsourcecodeHttpPort();
        this.httpsPort = this.microServiceConfiguration.getPluginsourcecodeHttpsPort();
        this.ajpPort = this.microServiceConfiguration.getPluginsourcecodeAjpPort();
    }

    @Bean
    public ServletWebServerFactory servletHTTPContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.microServiceConfiguration.createAjpConnector(this.ajpPort)});
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.microServiceConfiguration.createStandardConnector(this.httpPort)});
        return tomcat;
    }

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:locale/messages");
        messageSource.setCacheSeconds(10);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getAjpPort() {
        return this.ajpPort;
    }
}

