/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.controller;

import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.config.StartupConfiguration;
import at.letto.questionservice.service.CategoryService;
import at.letto.questionservice.service.dto.Category;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class CategoryController {
    @Autowired
    CategoryService categoryService;
    @Autowired
    MicroServiceConfiguration mc;
    @Autowired
    StartupConfiguration startup;
    private ResponseToolsObject r = new ResponseToolsObject("Questionservice", "CategoryController");
    private boolean deleteActive = false;
    private boolean showIds = false;

    @RequestMapping(value={"/question/open/cat_main"})
    public String index(@RequestParam(value="path", required=false) String path, Model model) {
        model.addAttribute("maincats", (Object)this.categoryService.getCategories());
        model.addAttribute("name", (Object)"Name");
        model.addAttribute("deleteActive", (Object)this.deleteActive);
        model.addAttribute("showIds", (Object)this.showIds);
        this.categoryService.searchFromPath(path, model);
        return "index";
    }

    @RequestMapping(value={"/question/open"})
    public String index1(@RequestParam(value="path", required=false) String path, Model model) {
        model.addAttribute("baseadress", (Object)this.mc.getBaseadress());
        model.addAttribute("maincats", (Object)this.categoryService.getCategories());
        model.addAttribute("name", (Object)"Name");
        model.addAttribute("deleteActive", (Object)this.deleteActive);
        model.addAttribute("showIds", (Object)this.showIds);
        String cpFile = this.mc.getCopyright();
        this.categoryService.searchFromPath(path, model);
        return "index";
    }

    @PostMapping(value={"/question/open/cat_loadtree"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<List<Category>>> loadCategories() {
        return this.r.getResponse(CategoryService::loadCategories, (Object)this.categoryService);
    }

    @PostMapping(value={"/question/open/cat_upload"})
    @CrossOrigin
    public String uploadFile(@RequestParam(value="file") MultipartFile file, RedirectAttributes attributes) {
        this.categoryService.uploadFile(file, attributes);
        return "redirect:/" + this.mc.getBaseadress() + "/open";
    }

    @RequestMapping(value={"/question/open/delcat/{name}"})
    public String view(@PathVariable(value="name") String name, Model model) {
        this.categoryService.delMainCat(name);
        return "redirect:/" + this.mc.getBaseadress() + "/open";
    }

    @RequestMapping(value={"/question/open/toogleRemove"})
    public String toggleRemove() {
        this.deleteActive = !this.deleteActive;
        return "redirect:/" + this.mc.getBaseadress() + "/open";
    }

    @RequestMapping(value={"/question/open/toogleIds"})
    public String toggleIds() {
        this.showIds = !this.showIds;
        return "redirect:/" + this.mc.getBaseadress() + "/open";
    }
}

