/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.controller;

import at.letto.data.dto.enums.AnswerMode;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.question.dto.QuestionWithAnswer;
import at.letto.questionservice.dto.score.AntwortMitErgebnis;
import at.letto.questionservice.security.QuestionSecret;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.preview.PreviewService;
import at.letto.questionservice.service.score.ScoreService;
import at.letto.security.LettoToken;
import at.letto.security.TokenTest;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class QuestionController {
    @Autowired
    QuestionSecret questionSecret;
    @Autowired
    QuestionRenderService questionService;
    @Autowired
    PreviewService previewService;
    @Autowired
    ScoreService scoreService;
    private ResponseToolsObject r = new ResponseToolsObject("Questionservice", "QuestionController");

    @GetMapping(value={"/question/open/token"})
    @CrossOrigin
    public ResponseEntity<String> temptoken() {
        return ResponseEntity.ok((Object)TokenTest.getLehrerToken().getToken());
    }

    @GetMapping(value={"/question/open/loadQuestion"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<QuestionWithAnswer>> loadQuestionById(@RequestParam Integer idQuestion, @RequestParam Integer dsNr) {
        return this.r.getResponse(QuestionRenderService::loadQuestion, (Object)this.questionService, (Object)idQuestion, (Object)dsNr, (Object)"", (Object)null);
    }

    @PostMapping(value={"/question/open/score"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> score_open(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(ScoreService::score, (Object)this.scoreService, (Object)AnswerMode.beurteilen, (Object)dto, (Object)false, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/open/score_res"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<AntwortMitErgebnis>> scoreWithResultsOpen(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(ScoreService::scoreWithResults, (Object)this.scoreService, (Object)AnswerMode.beurteilen, (Object)dto, (Object)false, (Object)this.loadToken());
    }

    @GetMapping(value={"/question/open/questions_in_cat"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> loadQuestionsInCategoryGet(@RequestParam Integer idCat) {
        return this.r.getResponse(QuestionRenderService::loadQuestionsInCategory, (Object)this.questionService, (Object)idCat, (Object)this.loadToken());
    }

    @GetMapping(value={"/question/open/questions_in_path"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> loadQuestionsInCategoryGet(@RequestParam String path) {
        return this.r.getResponse(QuestionRenderService::loadQuestionsInCategory, (Object)this.questionService, (Object)path, (Object)this.loadToken());
    }

    @GetMapping(value={"/question/open/question_clear_cache"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<String>> clearCacheQuestion(@RequestParam Integer id, @RequestParam Boolean clearQuestion) {
        return this.r.getResponse(QuestionRenderService::clearCache, (Object)this.questionService, (Object)id, (Object)this.loadSchool(), (Object)clearQuestion);
    }

    @GetMapping(value={"/question/open/question_clear_cache_all"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<String>> clearCacheQuestionAll(@RequestParam Boolean clearQuestion) {
        return this.r.getResponse(QuestionRenderService::clearCacheAll, (Object)this.questionService, (Object)this.loadSchool(), (Object)clearQuestion);
    }

    private LettoToken loadToken() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return (LettoToken)authentication.getDetails();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String loadSchool() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return ((LettoToken)authentication.getDetails()).getSchool();
        }
        catch (Exception e) {
            return "";
        }
    }
}

