/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.controller;

import at.letto.question.dto.validation.ParseInputDto;
import at.letto.question.dto.validation.ValidationAnswerDto;
import at.letto.question.dto.validation.ValidationFormDto;
import at.letto.questionservice.security.QuestionSecret;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.preview.PreviewService;
import at.letto.questionservice.service.score.ScoreService;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ValidationController {
    @Autowired
    QuestionSecret questionSecret;
    @Autowired
    QuestionRenderService questionService;
    @Autowired
    PreviewService previewService;
    @Autowired
    ScoreService scoreService;
    private ResponseToolsObject r = new ResponseToolsObject("Questionservice", "ValidationController");

    @PostMapping(value={"/question/open/question_parse_eingabe"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<String>> parseEingabeTex(@RequestBody ParseInputDto input) {
        if (input.getSecret() != this.questionSecret.getQuestionSecret()) {
            return ResponseEntity.ok((Object)new DtoAndMsg(""));
        }
        return this.r.getResponse(PreviewService::parseEingabeTex, (Object)this.previewService, (Object)input.getValInfo());
    }

    @PostMapping(value={"/question/open/question_validate_eingabe"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<List<ValidationAnswerDto>>> validateEingabe(@RequestBody ValidationFormDto input) {
        if (input.getSecret() != this.questionSecret.getQuestionSecret()) {
            return ResponseEntity.ok((Object)new DtoAndMsg(""));
        }
        return this.r.getResponse(PreviewService::validateInput, (Object)this.previewService, (Object)input.getValInfos());
    }
}

