/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.dto.renderedQuestion;

import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.TestEigenschaftsDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.question.dto.renderedQuestion.html.QuestionHtmlDTO;
import at.letto.questionservice.dto.renderedQuestion.InputSubQuestion;
import at.letto.questionservice.dto.renderedQuestion.ScoreInfo;
import at.letto.questionservice.dto.score.ErgQuestionDto;
import at.letto.questionservice.service.MatchingService;
import at.letto.tools.enums.Score;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class InputQuestion {
    private int idTestDetail;
    private TestAntwortDto input;
    private TestAntwortDto inputOld;
    private ErgQuestionDto ergebnis;
    private QuestionHtmlDTO angabe;
    private TestDetailDto testDetail;
    private TestEigenschaftsDto test;
    private boolean antwortMischen;
    private List<String> answerTexte;
    private List<InputSubQuestion> subQuestions;
    public static final String RED = "#FFDDDD";
    public static final String GREEN = "#E5FFDA";
    public static final String YELLOW = "#FFFFBB";
    public static final String GREY = "#DDDDDD";
    public static final String BLUE = "#DDDDFF";
    public static final String RED_L = "#FF9999";
    public static final String GREEN_L = "#99FF99";
    public static final String YELLOW_L = "#FFFF99";
    public static DecimalFormat df = new DecimalFormat("#.00");

    public List<String> getAnswerTexte() {
        if (this.answerTexte == null) {
            this.answerTexte = this.angabe.getSubQuestions().stream().map(sq -> sq.getAnswers()).flatMap(Collection::stream).map(a -> a.getHtmlText()).distinct().collect(Collectors.toList());
            if (this.antwortMischen) {
                this.answerTexte = MatchingService.mischen((List)this.answerTexte);
            }
        }
        return this.answerTexte;
    }

    public InputSubQuestion getFirstSubquestion() {
        if (this.subQuestions.size() == 0) {
            this.subQuestions.add(new InputSubQuestion(this));
        }
        return (InputSubQuestion)this.subQuestions.get(0);
    }

    public String getFeedback(Score bewertung) {
        if (bewertung == null) {
            return "";
        }
        if (bewertung == Score.FALSCH) {
            return "Falsch";
        }
        if (bewertung == Score.OK) {
            return "Richtig";
        }
        if (bewertung == Score.TEILWEISE_OK) {
            return "Teilweise Richtig";
        }
        if (bewertung == Score.EINHEITENFEHLER) {
            return "Einheitenfehler";
        }
        if (bewertung == Score.FALSCH_Lehrer) {
            return "Falsch (vom Lehrer beurteilt)";
        }
        if (bewertung == Score.OK_Lehrer) {
            return "Richtig (vom Lehrer beurteilt)";
        }
        if (bewertung == Score.TEILWEISE_OK_Lehrer) {
            return "Teilweise Richtig (vom Lehrer beurteilt)";
        }
        if (bewertung == Score.EINHEITENFEHLER_Lehrer) {
            return "Einheitenfehler (vom Lehrer beurteilt)";
        }
        if (bewertung == Score.MEHRFACHANTWORT_OK) {
            return "Richtig nach mehrfacher Beantwortung";
        }
        if (bewertung == Score.MEHRFACHANTWORT_TW_RICHTIG) {
            return "Teiweise Richtig nach mehrfacher Beantwortung";
        }
        return "";
    }

    public String getFeedbackColor(TestAntwortDto answer) {
        if (answer == null) {
            return "";
        }
        Score bewertung = answer.getBewertung();
        if (bewertung == null) {
            return "";
        }
        double points = answer.getPoints();
        if (points <= 1.0E-4 && bewertung == Score.OK) {
            return GREEN;
        }
        if (bewertung == Score.NotScored) {
            return GREY;
        }
        if (bewertung == Score.ANGABEFEHLER_EH) {
            return BLUE;
        }
        if (bewertung == Score.FALSCH) {
            return RED;
        }
        if (bewertung == Score.OK) {
            return GREEN;
        }
        if (bewertung == Score.TEILWEISE_OK) {
            return YELLOW;
        }
        if (bewertung == Score.EINHEITENFEHLER) {
            return YELLOW;
        }
        if (bewertung == Score.FALSCH_Lehrer) {
            return RED_L;
        }
        if (bewertung == Score.OK_Lehrer) {
            return GREEN_L;
        }
        if (bewertung == Score.TEILWEISE_OK_Lehrer) {
            return YELLOW_L;
        }
        if (bewertung == Score.EINHEITENFEHLER_Lehrer) {
            return YELLOW_L;
        }
        if (bewertung == Score.MEHRFACHANTWORT_OK) {
            return GREEN;
        }
        if (bewertung == Score.MEHRFACHANTWORT_TW_RICHTIG) {
            return YELLOW;
        }
        return "";
    }

    public String getFeedback() {
        return this.getFeedback(this.input.getBewertung());
    }

    public String getFeedbackColor() {
        return this.getFeedbackColor(this.input);
    }

    public void recalcPointsSubquestions() {
        this.input.setPoints(this.input.getSqAntworten().stream().mapToDouble(sq -> sq.getIst()).sum());
    }

    public String getEingabeKurzf() {
        String eingabe = this.getFirstSubquestion().getInput().getFirstAnswer().getInput();
        if (eingabe.length() > 80) {
            return eingabe.substring(0, 80);
        }
        return eingabe;
    }

    public String getPunkte() {
        double points = this.input.getPoints();
        try {
            return df.format(points).replaceAll(",", ".");
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isEmpty() {
        if (this.input.getBewertung() != null && !this.input.getBewertung().equals((Object)Score.NotScored)) {
            return true;
        }
        return !this.input.getSqAntworten().stream().anyMatch(sq -> !sq.isEmpty()) || this.input.getBewertung() != null && !this.input.getBewertung().equals((Object)Score.NotScored);
    }

    public boolean isEmptyAnswer() {
        if (this.input.getBewertung() != null && !this.input.getBewertung().equals((Object)Score.NotScored)) {
            return false;
        }
        return !this.input.getSqAntworten().stream().anyMatch(sq -> !sq.isEmpty());
    }

    @JsonIgnore
    public String getBewertungsColor() {
        return ScoreInfo.getColorClassString((Score)this.input.getBewertung(), (double)1.0);
    }

    @JsonIgnore
    public String getBewertungsImg() {
        return ScoreInfo.getImageName((Score)this.input.getBewertung(), (double)1.0);
    }

    @JsonIgnore
    public String getBewertungsText() {
        return ScoreInfo.getBewertungsString((Score)this.input.getBewertung(), (double)this.input.getPoints());
    }

    @JsonIgnore
    public String getDataset() {
        try {
            return this.getErgebnis().getDataset();
        }
        catch (Exception e) {
            return "";
        }
    }

    @JsonIgnore
    public int getId() {
        try {
            return this.getErgebnis().getId();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getIdTestDetail() {
        return this.idTestDetail;
    }

    public TestAntwortDto getInput() {
        return this.input;
    }

    public TestAntwortDto getInputOld() {
        return this.inputOld;
    }

    public ErgQuestionDto getErgebnis() {
        return this.ergebnis;
    }

    public QuestionHtmlDTO getAngabe() {
        return this.angabe;
    }

    public TestDetailDto getTestDetail() {
        return this.testDetail;
    }

    public TestEigenschaftsDto getTest() {
        return this.test;
    }

    public boolean isAntwortMischen() {
        return this.antwortMischen;
    }

    public List<InputSubQuestion> getSubQuestions() {
        return this.subQuestions;
    }

    public void setIdTestDetail(int idTestDetail) {
        this.idTestDetail = idTestDetail;
    }

    public void setInput(TestAntwortDto input) {
        this.input = input;
    }

    public void setInputOld(TestAntwortDto inputOld) {
        this.inputOld = inputOld;
    }

    public void setErgebnis(ErgQuestionDto ergebnis) {
        this.ergebnis = ergebnis;
    }

    public void setAngabe(QuestionHtmlDTO angabe) {
        this.angabe = angabe;
    }

    public void setTestDetail(TestDetailDto testDetail) {
        this.testDetail = testDetail;
    }

    public void setTest(TestEigenschaftsDto test) {
        this.test = test;
    }

    public void setAntwortMischen(boolean antwortMischen) {
        this.antwortMischen = antwortMischen;
    }

    public void setAnswerTexte(List<String> answerTexte) {
        this.answerTexte = answerTexte;
    }

    public void setSubQuestions(List<InputSubQuestion> subQuestions) {
        this.subQuestions = subQuestions;
    }

    public InputQuestion(int idTestDetail, TestAntwortDto input, TestAntwortDto inputOld, ErgQuestionDto ergebnis, QuestionHtmlDTO angabe, TestDetailDto testDetail, TestEigenschaftsDto test, boolean antwortMischen, List<String> answerTexte, List<InputSubQuestion> subQuestions) {
        this.idTestDetail = idTestDetail;
        this.input = input;
        this.inputOld = inputOld;
        this.ergebnis = ergebnis;
        this.angabe = angabe;
        this.testDetail = testDetail;
        this.test = test;
        this.antwortMischen = antwortMischen;
        this.answerTexte = answerTexte;
        this.subQuestions = subQuestions;
    }

    public InputQuestion() {
    }
}

