/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.dto.renderedQuestion;

import at.letto.data.dto.tests.testAnswer.TestAnswerDetailDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortSqDto;
import at.letto.globalinterfaces.LettoPlugin;
import at.letto.math.calculate.CalcComplex;
import at.letto.math.calculate.CalcDouble;
import at.letto.math.calculate.CalcDoubleEinheit;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.CalcError;
import at.letto.math.calculate.CalcLong;
import at.letto.math.calculate.CalcRational;
import at.letto.math.calculate.ScoreTools;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.plugins.enums.InputElement;
import at.letto.question.dto.renderedQuestion.html.AnswerHtmlDTO;
import at.letto.question.dto.renderedQuestion.html.SubQuestionHtmlDTO;
import at.letto.questionservice.dto.renderedQuestion.InputAnswer;
import at.letto.questionservice.dto.renderedQuestion.InputQuestion;
import at.letto.questionservice.dto.renderedQuestion.InputSubQuestion;
import at.letto.questionservice.dto.renderedQuestion.MatchingInfo;
import at.letto.questionservice.dto.renderedQuestion.ScoreInfo;
import at.letto.questionservice.dto.score.ErgAnswerDto;
import at.letto.questionservice.dto.score.ErgSubquestionDto;
import at.letto.questionservice.service.MatchingService;
import at.letto.questionservice.service.score.ScoreService;
import at.letto.tools.enums.AntwortenMischen;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.enums.SQMODE;
import at.letto.tools.enums.Score;
import at.letto.tools.tex.Tex;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class InputSubQuestion {
    private InputQuestion parent;
    private SubQuestionHtmlDTO angabe;
    private TestAntwortSqDto input;
    private TestAntwortSqDto inputOld;
    private ErgSubquestionDto ergebnis;
    private List<InputAnswer> answers;
    public Score scored = Score.NotScored;
    private MatchingInfo matchingInfos = null;
    protected int[] reihenfolgeLinks;
    private int[] reihenfolgeRechts;

    public MatchingInfo getMatchingInfo() {
        this.matchingInfos = this.matchingInfos != null ? this.matchingInfos : MatchingService.getMatchingInfos((InputSubQuestion)this);
        return this.matchingInfos;
    }

    public InputSubQuestion(InputQuestion parent) {
        this.parent = parent;
    }

    public InputSubQuestion(SubQuestionHtmlDTO angabe, TestAntwortSqDto input, InputQuestion parent) {
        int i;
        this.parent = parent;
        this.angabe = angabe;
        this.input = input;
        if (input == null) {
            return;
        }
        this.inputOld = input.clone();
        int diff = angabe.getAnswers().size() - input.getAntworten().size();
        if (diff > 0) {
            for (i = 0; i < diff; ++i) {
                input.getAntworten().add(new TestAnswerDetailDto());
            }
        } else {
            for (i = 0; i < diff; ++i) {
                angabe.getAnswers().add(new AnswerHtmlDTO());
            }
        }
        this.answers = new Vector();
        for (i = 0; i < angabe.getAnswers().size(); ++i) {
            this.answers.add(new InputAnswer((AnswerHtmlDTO)angabe.getAnswers().get(i), (TestAnswerDetailDto)input.getAntworten().get(i), this));
        }
    }

    public List<InputAnswer> getAnswersSorted() {
        if (this.getAngabe().getAntwortenMischen() != AntwortenMischen.Nicht_mischen) {
            MatchingService.checkReihenfolge((InputSubQuestion)this, (int)this.angabe.getAnswers().size(), (int)0);
        } else {
            this.reihenfolgeLinks = null;
        }
        return this.getAnswersSorted(this.answers, this.reihenfolgeLinks);
    }

    public List<InputAnswer> getAnswersSorted(List<InputAnswer> toSort, int[] reihenfolge) {
        if (reihenfolge == null || toSort == null || toSort.size() != reihenfolge.length) {
            return toSort;
        }
        ArrayList<InputAnswer> ans = new ArrayList<InputAnswer>();
        for (int i = 0; i < toSort.size(); ++i) {
            InputAnswer a = toSort.get(reihenfolge[i]);
            ans.add(a);
        }
        return ans;
    }

    public String loadAnswerHtml(String inp) {
        if (inp == null || inp.isEmpty()) {
            return "";
        }
        return this.angabe.getAnswers().stream().filter(a -> a.getShortAnswer().equals(inp)).map(a -> a.getHtmlAnswer()).findFirst().orElse("");
    }

    public void deleteZuordnung(InputAnswer a) {
        a.getInput().setInput("");
        this.matchingInfos = null;
    }

    public void resetSubQuestion() {
        if (this.getAnswers() != null) {
            for (InputAnswer a : this.getAnswers()) {
                a.getInput().setInput("");
            }
        }
        this.matchingInfos = null;
        if (this.getInput() != null) {
            this.getInput().setScored(Score.NotScored);
        }
        this.scored = Score.NotScored;
    }

    public List<InputAnswer> getFeedbackMatching() {
        block0: for (InputAnswer a : this.answers) {
            if (a.getAnswer().equals(a.getAnswerServer()) || a.getAnswerServer().isEmpty()) continue;
            for (InputAnswer x : this.answers) {
                if (!x.getHtmlText().equals(a.getHtmlText()) || !a.getAnswer().equals(x.getAnswerServer())) continue;
                String inp = a.getAnswerServer();
                a.setAnswerServer(x.getAnswerServer());
                x.setAnswerServer(inp);
                continue block0;
            }
        }
        return this.answers;
    }

    public String getAnswerTextSubQuest() {
        return ScoreService.getAnswerTextSubQuest((InputSubQuestion)this);
    }

    public String getKorrekteLoesung() {
        SQMODE mode = this.angabe.getMode();
        if (mode == SQMODE.MULTICHOICE || mode == SQMODE.SINGLECHOICE) {
            Object ret = "";
            for (InputAnswer a : this.answers) {
                if (!(a.getErg().getFraction() > 0.0)) continue;
                ret = (String)ret + (((String)ret).length() > 0 ? " | " : "") + a.getHtmlText();
            }
            return ret;
        }
        if (this.angabe.getParent().getQuestionType() == QuestionType.MoodleEssay) {
            return "";
        }
        if (this.answers == null) {
            return "";
        }
        for (InputAnswer a : this.answers) {
            if (a.getErg().getFraction() != 100.0) continue;
            switch (1.$SwitchMap$at$letto$tools$enums$SQMODE[mode.ordinal()]) {
                case 1: {
                    return a.getAnswer();
                }
                case 2: {
                    try {
                        return a.getErg().getErg().toString(a.getErg().getZielEinheit());
                    }
                    catch (Exception exception) {
                        return "keine Antwort berechnet!";
                    }
                }
                case 3: 
                case 4: {
                    return a.getHtmlText();
                }
                case 5: {
                    return "SINGLECHOICE";
                }
                case 6: {
                    return "MULTIPLECHOICE";
                }
                case 7: {
                    return "PLUGIN:" + a.getHtmlText();
                }
                case 8: {
                    return a.getHtmlText();
                }
                case 9: {
                    return a.getHtmlText();
                }
                case 10: {
                    return "ZUORDNUNG";
                }
            }
        }
        return "";
    }

    public String parseEingabeTex(String value) {
        SQMODE mode = this.angabe.getMode();
        switch (1.$SwitchMap$at$letto$tools$enums$SQMODE[mode.ordinal()]) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return " ";
            }
            case 2: 
            case 13: {
                if (this.getAnswers().size() <= 0) break;
                InputAnswer a = (InputAnswer)this.getAnswers().get(0);
                CalcErgebnis wert = a.getErg().getErg();
                if (wert == null || wert instanceof CalcError) {
                    wert = new CalcLong(0L);
                }
                try {
                    ZielEinheit ze = new ZielEinheit();
                    try {
                        ze = new ZielEinheit(a.getErg().getEinheit());
                        if (ze.getMode() == ZielEinheit.MODE.EINHEIT) {
                            ZielEinheit.PRINTMODE pm = ze.getPrintmode();
                            boolean calc = ze.isCalc();
                            ze = new ZielEinheit();
                            ze.setPrintmode(pm);
                            ze.setCalc(calc);
                        }
                    }
                    catch (Exception pm) {
                        // empty catch block
                    }
                    switch (1.$SwitchMap$at$letto$math$einheiten$ZielEinheit$MODE[ze.getMode().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            CalcErgebnis e = this.parseAnswer(value, wert, ze, true);
                            if (e == null || e instanceof CalcError) {
                                return " ";
                            }
                            String tex = e.toTex(ze);
                            if (tex.length() == 0) {
                                tex = " ";
                            }
                            return tex;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            return Tex.stringToTex((String)value);
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    return " ";
                }
            }
        }
        return " ";
    }

    public CalcErgebnis parseAnswer(String serverEingabe, CalcErgebnis wert, ZielEinheit ze, boolean vorschau) {
        CalcErgebnis a = ScoreTools.parseAnswer((String)serverEingabe, (CalcErgebnis)wert, (ZielEinheit)ze, (boolean)vorschau, null);
        return a;
    }

    public List<String> getErgTexte() {
        return ScoreService.getErgTexte((InputSubQuestion)this);
    }

    public InputElement getInputElement() {
        LettoPlugin pi = this.angabe.getPlugin();
        if (pi == null) {
            return InputElement.TextField;
        }
        return pi.getInputElement();
    }

    public int getFieldSize() {
        try {
            CalcErgebnis erg = ((ErgAnswerDto)this.ergebnis.getErgAnswers().get(0)).getErg();
            if (erg == null) {
                return 5;
            }
            if (erg instanceof CalcDouble || erg instanceof CalcDoubleEinheit || erg instanceof CalcLong) {
                return 10;
            }
            if (erg instanceof CalcRational) {
                return 15;
            }
            if (erg instanceof CalcComplex) {
                return 20;
            }
            int n = erg.toString().length();
            return n > 10 ? n : 10;
        }
        catch (Exception exception) {
            return 10;
        }
    }

    public String getBewertungsColor() {
        if (this.input == null) {
            return "";
        }
        return this.input.getSoll() > 0.0 ? ScoreInfo.getColorClassString((Score)this.input.getScored(), (double)1.0) : "";
    }

    public String getBewertungsImg() {
        if (this.input == null) {
            return "";
        }
        return ScoreInfo.getImageName((Score)this.input.getScored(), (double)1.0);
    }

    public InputQuestion getParent() {
        return this.parent;
    }

    public SubQuestionHtmlDTO getAngabe() {
        return this.angabe;
    }

    public TestAntwortSqDto getInput() {
        return this.input;
    }

    public TestAntwortSqDto getInputOld() {
        return this.inputOld;
    }

    public ErgSubquestionDto getErgebnis() {
        return this.ergebnis;
    }

    public List<InputAnswer> getAnswers() {
        return this.answers;
    }

    public Score getScored() {
        return this.scored;
    }

    public MatchingInfo getMatchingInfos() {
        return this.matchingInfos;
    }

    public int[] getReihenfolgeLinks() {
        return this.reihenfolgeLinks;
    }

    public int[] getReihenfolgeRechts() {
        return this.reihenfolgeRechts;
    }

    public void setParent(InputQuestion parent) {
        this.parent = parent;
    }

    public void setAngabe(SubQuestionHtmlDTO angabe) {
        this.angabe = angabe;
    }

    public void setInput(TestAntwortSqDto input) {
        this.input = input;
    }

    public void setInputOld(TestAntwortSqDto inputOld) {
        this.inputOld = inputOld;
    }

    public void setErgebnis(ErgSubquestionDto ergebnis) {
        this.ergebnis = ergebnis;
    }

    public void setAnswers(List<InputAnswer> answers) {
        this.answers = answers;
    }

    public void setScored(Score scored) {
        this.scored = scored;
    }

    public void setMatchingInfos(MatchingInfo matchingInfos) {
        this.matchingInfos = matchingInfos;
    }

    public void setReihenfolgeLinks(int[] reihenfolgeLinks) {
        this.reihenfolgeLinks = reihenfolgeLinks;
    }

    public void setReihenfolgeRechts(int[] reihenfolgeRechts) {
        this.reihenfolgeRechts = reihenfolgeRechts;
    }

    public InputSubQuestion() {
    }
}

