/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.dto.renderedQuestion;

import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.ScoreInfoDto;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.question.dto.SubQuestionRenderDTO;
import at.letto.questionservice.dto.renderedQuestion.ScoreInfo;
import at.letto.tools.enums.Score;
import java.util.HashMap;

public class ScoreInfo {
    public Double punkte = 0.0;
    public Double sollpunkte = 0.0;
    public Score status = Score.NotScored;
    private CalcErgebnis schuelerErgebnis;
    private ZielEinheit zielEinheit;
    private String htmlScoreInfo = "";
    public HashMap<SubQuestionRenderDTO, ScoreInfo> subInfo = new HashMap();
    public SubQuestionRenderDTO sq = null;
    public static final String OK_Img = "wahr.png";
    public static final String MEHRFACH_OK_Img = "mfok.jpg";
    public static final String MEHRFACH_PART_Img = "mfpart.jpg";
    public static final String FALSE_Img = "falsch.png";
    public static final String NO_Img = "";
    public static final String PART_Img = "teilrichtig.png";

    public ScoreInfo(double proz, double punkte) {
        if (proz > 100.0) {
            proz = 100.0;
        }
        if (proz < 0.0) {
            proz = 0.0;
        }
        this.status = (proz *= 0.01) > 0.98 ? Score.OK : (proz > 0.001 ? Score.TEILWEISE_OK : Score.FALSCH);
        this.punkte = punkte * proz;
    }

    public ScoreInfo(Double punkte, Score status) {
        this.punkte = punkte;
        this.status = status;
    }

    public ScoreInfo(Double punkteIst, double punkteSoll, Score Err) {
        this.punkte = punkteIst;
        this.status = Score.OK;
        if (punkteIst < punkteSoll) {
            this.status = Score.TEILWEISE_OK;
        }
        if (punkteIst < 0.05 * punkteSoll) {
            this.status = Score.FALSCH;
        }
        if (Err != null) {
            this.status = Err;
        }
    }

    public ScoreInfo(CalcErgebnis schuelerErgebnis, ZielEinheit ze, double punkteIst, double punkteSoll, Score Err) {
        this.schuelerErgebnis = schuelerErgebnis;
        this.zielEinheit = ze;
        this.punkte = punkteIst;
        this.status = Score.OK;
        this.sollpunkte = punkteSoll;
        if (punkteIst < punkteSoll) {
            this.status = Score.TEILWEISE_OK;
        }
        if (punkteIst < 0.05 * punkteSoll) {
            this.status = Score.FALSCH;
        }
        if (Err != null) {
            this.status = Err;
        }
    }

    public ScoreInfo(ScoreInfoDto dto) {
        this.punkte = dto.getPunkte();
        this.sollpunkte = dto.getSollpunkte();
        this.status = dto.getStatus();
        this.schuelerErgebnis = dto.getSchuelerErgebnis();
        this.zielEinheit = dto.getZielEinheit();
        this.htmlScoreInfo = dto.getHtmlScoreInfo();
        this.subInfo = new HashMap();
        this.sq = null;
    }

    public String getText() {
        String statusTxt = NO_Img;
        switch (1.$SwitchMap$at$letto$tools$enums$Score[this.status.ordinal()]) {
            case 1: {
                statusTxt = "nicht beurteilt";
                break;
            }
            case 2: {
                statusTxt = "Einheitenfehler";
                break;
            }
            case 3: {
                statusTxt = "falsche Eingabe";
                break;
            }
            case 4: {
                statusTxt = "richtig beantwortet";
                break;
            }
        }
        return statusTxt;
    }

    public static String getColorClassString(Score bewertung, double points) {
        if (points < 1.0E-7 || bewertung == null) {
            return NO_Img;
        }
        switch (1.$SwitchMap$at$letto$tools$enums$Score[bewertung.ordinal()]) {
            case 4: 
            case 5: {
                return "ergTrue";
            }
            case 6: 
            case 7: {
                return "ergTrueLehrer";
            }
            case 3: {
                return "ergFalse";
            }
            case 8: {
                return "ergFalseLehrer";
            }
            case 2: 
            case 9: 
            case 10: {
                return "ergPartTrue";
            }
            case 11: 
            case 12: 
            case 13: {
                return "ergPartTrueLehrer";
            }
            case 14: {
                return "angabeFehler";
            }
        }
        return null;
    }

    public static String getBewertungsString(Score bewertung, double points) {
        if (bewertung == null) {
            return "Frage noch nicht beantwortet";
        }
        if (points < 1.0E-7) {
            return NO_Img;
        }
        switch (1.$SwitchMap$at$letto$tools$enums$Score[bewertung.ordinal()]) {
            case 4: {
                return "Frage richtig beantwortet";
            }
            case 3: {
                return "Falsche Antwort";
            }
            case 2: {
                return "Einheitenfehler bei der Beantwortung";
            }
            case 10: {
                return "Beantwortung teilweise richtig";
            }
            case 14: {
                return "Angabefehler in der Angabe";
            }
        }
        return null;
    }

    public static String getImageName(Score bewertung, double points) {
        if (points < 1.0E-7) {
            return NO_Img;
        }
        if (bewertung == null) {
            return null;
        }
        switch (1.$SwitchMap$at$letto$tools$enums$Score[bewertung.ordinal()]) {
            case 4: 
            case 7: {
                return OK_Img;
            }
            case 5: 
            case 6: {
                return MEHRFACH_OK_Img;
            }
            case 9: 
            case 12: {
                return MEHRFACH_PART_Img;
            }
            case 3: {
                return FALSE_Img;
            }
            case 2: {
                return PART_Img;
            }
            case 10: 
            case 13: {
                return PART_Img;
            }
            case 14: {
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                break;
            }
            case 15: {
                break;
            }
            case 1: {
                break;
            }
            case 16: {
                break;
            }
        }
        return null;
    }

    public static String getText(Score bewertung, double points) {
        if (points < 1.0E-7) {
            return NO_Img;
        }
        switch (1.$SwitchMap$at$letto$tools$enums$Score[bewertung.ordinal()]) {
            case 4: {
                return "<html><font color=green><b>Richtig</b></font></html>";
            }
            case 3: {
                return "<html><font color=red><b>Falsch</b></font></html>";
            }
            case 2: {
                return "<html><font color=orange><b>Einheitenfehler</b></font></html>";
            }
            case 10: {
                return "<html><font color=orange><b>teilweise richtig</b></font></html>";
            }
        }
        return null;
    }

    public CalcErgebnis getSchuelerErgebnis() {
        return this.schuelerErgebnis;
    }

    public ZielEinheit getZielEinheit() {
        return this.zielEinheit;
    }

    public String toString() {
        return this.getText() + "(" + this.punkte + ")";
    }

    public String getHtmlScoreInfo() {
        return this.htmlScoreInfo;
    }

    public void setHtmlScoreInfo(String htmlScoreInfo) {
        this.htmlScoreInfo = htmlScoreInfo;
    }

    public ScoreInfo() {
    }
}

