/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.questionservice.dto.renderedQuestion.InputAnswer;
import at.letto.questionservice.dto.renderedQuestion.InputSubQuestion;
import at.letto.questionservice.dto.renderedQuestion.MatchingInfo;
import at.letto.questionservice.service.MatchingService;
import at.letto.tools.VectorTools;
import at.letto.tools.enums.AntwortenMischen;
import at.letto.tools.enums.SQMODE;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public class MatchingService {
    public static MatchingInfo getMatchingInfos(InputSubQuestion sq) {
        if (sq.getMatchingInfos() == null) {
            sq.setMatchingInfos(MatchingService.loadMatchingInfos((InputSubQuestion)sq));
        }
        return sq.getMatchingInfos();
    }

    public static void clearMatchingInfos(InputSubQuestion sq) {
        sq.setMatchingInfos(null);
    }

    public static MatchingInfo loadMatchingInfos(InputSubQuestion sq) {
        if (sq == null) {
            return new MatchingInfo();
        }
        if (sq.getAnswers() == null) {
            return new MatchingInfo();
        }
        MatchingInfo info = new MatchingInfo();
        info.setLeft(new ArrayList());
        info.setOpenLeft(new ArrayList());
        info.setRight(new ArrayList());
        info.setAnswered(new ArrayList());
        ArrayList<InputAnswer> rightAnswered = new ArrayList<InputAnswer>();
        for (InputAnswer a : sq.getAnswers()) {
            if (a.isText()) {
                info.getLeft().add(a);
            }
            if (a.isAnswer()) {
                info.getRight().add(a);
            }
            if (a.isAnswered()) {
                info.getAnswered().add(a);
                for (InputAnswer ax : sq.getAnswers()) {
                    if (!a.getInput().getInput().equals(ax.getHtml().getShortAnswer()) || rightAnswered.contains(ax)) continue;
                    rightAnswered.add(ax);
                    break;
                }
            }
            if (a.isAnswered() || a.getHtml().getHtmlText() == null || a.getHtml().getHtmlText().isEmpty()) continue;
            info.getOpenLeft().add(a);
        }
        MatchingService.checkReihenfolge((InputSubQuestion)sq, (int)info.getLeft().size(), (int)info.getRight().size());
        info.setLeftUnsorted(info.getLeft());
        info.setLeft(sq.getAnswersSorted(info.getLeft(), sq.getReihenfolgeLinks()));
        info.setRight(sq.getAnswersSorted(info.getRight(), sq.getReihenfolgeRechts()));
        ArrayList ol = new ArrayList(info.getLeft());
        ol.retainAll(info.getOpenLeft());
        info.setOpenLeft(ol);
        info.setOpenRight(new ArrayList(info.getRight()));
        for (InputAnswer x : rightAnswered) {
            info.getOpenRight().remove(x);
        }
        return info;
    }

    public static void reihenfolgeFestlegen(InputSubQuestion inp, int anzLinks, int anzRechts) {
        SQMODE mode = inp.getAngabe().getMode();
        AntwortenMischen shuffleAnswers = inp.getAngabe().getAntwortenMischen();
        if (!inp.getParent().isAntwortMischen()) {
            shuffleAnswers = AntwortenMischen.Nicht_mischen;
        }
        if (shuffleAnswers == null) {
            return;
        }
        switch (1.$SwitchMap$at$letto$tools$enums$AntwortenMischen[shuffleAnswers.ordinal()]) {
            case 1: {
                inp.setReihenfolgeLinks(VectorTools.getSortedZahlen((int)anzLinks));
                inp.setReihenfolgeRechts(VectorTools.getSortedZahlen((int)anzRechts));
                break;
            }
            case 2: {
                inp.setReihenfolgeLinks(VectorTools.getZufallszahlen((int)anzLinks));
                inp.setReihenfolgeRechts(VectorTools.getZufallszahlen((int)anzRechts));
                break;
            }
            case 3: {
                inp.setReihenfolgeLinks(VectorTools.getZufallszahlen((int)anzLinks));
                inp.setReihenfolgeRechts(VectorTools.getSortedZahlen((int)anzRechts));
                break;
            }
            case 4: {
                inp.setReihenfolgeLinks(VectorTools.getSortedZahlen((int)anzLinks));
                inp.setReihenfolgeRechts(VectorTools.getZufallszahlen((int)anzRechts));
                break;
            }
        }
    }

    public static void checkReihenfolge(InputSubQuestion inp, int sizeLeft, int sizeRight) {
        if (inp.getReihenfolgeLinks() == null && inp.getReihenfolgeRechts() == null) {
            MatchingService.reihenfolgeFestlegen((InputSubQuestion)inp, (int)sizeLeft, (int)sizeRight);
        }
        if (inp.getReihenfolgeLinks() != null && inp.getReihenfolgeLinks().length != sizeLeft) {
            MatchingService.reihenfolgeFestlegen((InputSubQuestion)inp, (int)sizeLeft, (int)sizeRight);
        }
        if (inp.getReihenfolgeRechts() != null && inp.getReihenfolgeRechts().length != sizeRight) {
            MatchingService.reihenfolgeFestlegen((InputSubQuestion)inp, (int)sizeLeft, (int)sizeRight);
        }
    }

    public static List<String> mischen(List<String> texte) {
        Vector<String> gemischt = new Vector<String>();
        for (int x : VectorTools.getZufallszahlen((int)texte.size())) {
            gemischt.add(texte.get(x));
        }
        return gemischt;
    }
}

