/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.globalinterfaces.ImageService;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.cache.QuestionCache;
import at.letto.questionservice.service.cache.QuestionFileCache;
import at.letto.questionservice.service.cache.QuestionScheduler;
import at.letto.security.LettoToken;
import at.letto.tools.Cmd;
import at.letto.tools.JSON;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class QuestionCacheService {
    private final QuestionRenderService questionRenderService;
    private final MicroServiceConfiguration mc;
    private QuestionCache questionCache = null;
    @Value(value="${letto.question.preRender}")
    private boolean preRender;
    @Value(value="${letto.question.cache}")
    private boolean useCache;
    QuestionScheduler questionScheduler = new QuestionScheduler();
    private boolean timerstate = false;

    public QuestionCacheService(MicroServiceConfiguration mc, @Lazy QuestionRenderService questionRenderService) {
        this.mc = mc;
        this.questionRenderService = questionRenderService;
        this.questionCache = new QuestionFileCache(this.cachePath(), mc.getBaseadress());
    }

    private String cachePath() {
        Object cachePath = this.mc.getPathQuestions();
        if (!((String)cachePath).endsWith("/")) {
            cachePath = (String)cachePath + "/";
        }
        return cachePath;
    }

    @PostConstruct
    public void init() {
        if (this.preRender) {
            Timer t = new Timer();
            long delay = 5000L;
            t.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, delay, delay);
        }
    }

    public void preRenderQuestions() {
        this.timerstate = true;
        Map r = this.questionScheduler.loadRenderIDs();
        for (String s : r.keySet()) {
            for (Integer id : (List)r.get(s)) {
                QuestionRenderDTO qrender = this.getQuestionCache().loadQuestionRenderDto(id.intValue(), s);
                if (qrender == null) continue;
                for (int ds = 0; ds < 40; ++ds) {
                    this.questionRenderService.doPrepareQuestion(qrender, ds, "", "");
                }
            }
        }
        this.timerstate = false;
    }

    public void preRenderQuestionsOld() {
        for (File f : new File(this.mc.getCachePath(null)).listFiles(File::isDirectory)) {
            if (!f.isDirectory()) continue;
            Arrays.stream(f.listFiles()).filter(fi -> fi.getName().equals("question.json")).findFirst().ifPresent(q -> {
                try {
                    String ret = Files.lines(q.toPath(), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
                    QuestionRenderDTO qrender = (QuestionRenderDTO)JSON.jsonToObj((String)ret, QuestionRenderDTO.class);
                    if (qrender != null) {
                        for (int ds = 0; ds < 40; ++ds) {
                            this.questionRenderService.doPrepareQuestion(qrender, ds, "", "");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public void addQuestionToStorage(QuestionRenderDTO q, LettoToken token) {
        ImageService imgService = this.mc.getImageService();
        q.getMoodleTexte().stream().map(t -> t.getFiles()).flatMap(Collection::stream).forEach(f -> {
            String md5 = f.getMd5();
            String filename = md5 + "." + f.getExtension();
            if (!Cmd.isEmpty((String)f.getInhalt())) {
                imgService.saveImage(f.getInhalt(), filename);
            }
            f.setInhalt("");
        });
        String school = token == null ? "" : token.getSchool();
        this.questionCache.cacheQuestionRenderDto(q, school, true);
        if (this.preRender) {
            this.questionScheduler.addQuestion(school, q.getId());
        }
    }

    public QuestionCache getQuestionCache() {
        return this.questionCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }
}

