/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.ServerConfiguration;
import at.letto.data.dto.category.CategorySortDTO;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.globalinterfaces.CalcParamsQuestionInfo;
import at.letto.globalinterfaces.ImageService;
import at.letto.globalinterfaces.LettoFile;
import at.letto.globalinterfaces.LettoPlugin;
import at.letto.globalinterfaces.LettoQuestion;
import at.letto.math.VarHash;
import at.letto.math.calculate.CalcComplex;
import at.letto.math.calculate.CalcComplexEinheit;
import at.letto.math.calculate.CalcDouble;
import at.letto.math.calculate.CalcDoubleEinheit;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.CalcError;
import at.letto.math.calculate.CalcLong;
import at.letto.math.calculate.CalcNumerical;
import at.letto.math.calculate.CalcPhysical;
import at.letto.math.calculate.CalcRational;
import at.letto.math.calculate.CalcString;
import at.letto.math.calculate.CalcToleranz;
import at.letto.math.calculate.Calculate;
import at.letto.math.calculate.ParserCache;
import at.letto.math.calculate.params.CalcParams;
import at.letto.math.dto.CalcErgebnisDto;
import at.letto.math.dto.VarHashDto;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.math.enums.CALCMODE;
import at.letto.math.html.HTMLParser;
import at.letto.math.html.HTMLmain;
import at.letto.math.plugins.PluginInfo;
import at.letto.plugins.interfaces.PluginDto;
import at.letto.question.dto.AnswerRenderDTO;
import at.letto.question.dto.CalcMaximaDto;
import at.letto.question.dto.DatasetrenderDTO;
import at.letto.question.dto.QuestionFileDTO;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.question.dto.QuestionTextDTO;
import at.letto.question.dto.QuestionWithAnswer;
import at.letto.question.dto.SubQuestionRenderDTO;
import at.letto.question.dto.VarHashes;
import at.letto.question.dto.VarhashMode;
import at.letto.question.dto.ZwischenErgebnisDto;
import at.letto.question.dto.datasetResults.DatasetItem;
import at.letto.question.dto.renderedQuestion.html.AnswerHtmlDTO;
import at.letto.question.dto.renderedQuestion.html.QuestionHtmlDTO;
import at.letto.question.dto.renderedQuestion.html.SubQuestionHtmlDTO;
import at.letto.question.dto.score.CreateAnswerForQuestion;
import at.letto.question.dto.score.SqErgebnisseText;
import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.dto.renderedQuestion.InputQuestion;
import at.letto.questionservice.dto.renderedQuestion.InputSubQuestion;
import at.letto.questionservice.dto.renderedQuestion.QuestionInfo;
import at.letto.questionservice.dto.score.ErgAnswerDto;
import at.letto.questionservice.dto.score.ErgQuestionDto;
import at.letto.questionservice.dto.score.ErgSubquestionDto;
import at.letto.questionservice.service.ClozePart;
import at.letto.questionservice.service.DatasetService;
import at.letto.questionservice.service.InputQuestionService;
import at.letto.questionservice.service.LettoDataset;
import at.letto.questionservice.service.MaximaService;
import at.letto.questionservice.service.MischenService;
import at.letto.questionservice.service.QuestionCacheService;
import at.letto.questionservice.service.QuestionCalc;
import at.letto.questionservice.service.QuestionFile;
import at.letto.questionservice.service.QuestionMapper;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.QuestionText;
import at.letto.questionservice.service.SubQuestionService;
import at.letto.questionservice.service.cache.QuestionCache;
import at.letto.questionservice.service.plugins.QuestionPluginService;
import at.letto.questionservice.service.score.ScoreService;
import at.letto.questionservice.service.tools.ResourceReader;
import at.letto.security.LettoToken;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.JSON;
import at.letto.tools.LettoConfigDto;
import at.letto.tools.LicenseKey;
import at.letto.tools.dto.FileDTO;
import at.letto.tools.enums.AntwortenMischen;
import at.letto.tools.enums.LueckentextMode;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.enums.SQMODE;
import at.letto.tools.html.HTMLMODE;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import at.letto.tools.threads.LettoTimer;
import jakarta.annotation.PostConstruct;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QuestionRenderService {
    @Autowired
    DatasetService dsService;
    @Autowired
    MicroServiceConfiguration mc;
    @Autowired
    QuestionCacheService questionCacheService;
    @Autowired
    SubQuestionService sqService;
    @Autowired
    DatasetService datasetService;
    @Autowired
    MaximaService maxima;
    @Value(value="${letto.maxima.maximaPath}")
    private String maximaPath;
    private String lettoMac;
    @Value(value="classpath:letto.mac")
    private Resource lettoMacResource;
    @Value(value="${letto.license}")
    private String license;
    private LettoConfigDto lettoConfigDto;
    private ModelMapper mapper = new ModelMapper();
    public static Pattern imgPattern = Pattern.compile("[<\\[]\\s*(?<name>IMG(?<nr>[0-9]+)?)\\s*[>\\]]");
    public static final String splitAnswer = "<n>";
    public static final String splitAnswerDetail = "<d>";
    public static final String splitCloze = "<c>";
    public static Pattern qPattern = Pattern.compile("[<\\[]\\s*(?<name>Q(?<nr>[0-9]+)?)\\s*[>\\]]");
    private static Pattern pFZ = Pattern.compile("^(?<fz>[a-zA-Z]+[a-zA-Z0-9_]*)$");
    private static Pattern pFZopt = Pattern.compile("^[a-zA-Z]*opt[a-zA-Z]*\\(\\s*(?<fz>[a-zA-Z]+[a-zA-Z0-9_]*)\\s*\\)$");
    private String textFeedback = "";
    private static final String encryptSecret = "encryptedQuestion";

    @PostConstruct
    public void init() {
        LicenseKey key = new LicenseKey(this.license);
        this.lettoMac = ResourceReader.asString((Resource)this.lettoMacResource);
        this.lettoConfigDto = new LettoConfigDto(key, this.maximaPath, this.lettoMac);
    }

    public QuestionCache getQuestionCache() {
        return this.questionCacheService.getQuestionCache();
    }

    public void postLoadQuestion(QuestionCalc q) {
    }

    public VarHash getMaximaConst(QuestionRenderDTO q) {
        String[] s = q.getMaximaAngabe().split(";::;");
        if (s.length > 0) {
            return new VarHash(s[0]);
        }
        return new VarHash();
    }

    private VarHash getMaximaErg(QuestionRenderDTO q) {
        String[] s = q.getMaximaAngabe().split(";::;");
        if (s.length == 2) {
            return new VarHash(s[1]);
        }
        return new VarHash();
    }

    public static String getMaximaDefs(QuestionRenderDTO q) {
        Object maxDefs = "";
        if (q.isKonstanteMitProzent()) {
            return "";
        }
        Vector<String> deflist = new Vector<String>();
        for (String s : new String[]{"i", "j", "pi", "e"}) {
            deflist.add(s);
        }
        for (DatasetrenderDTO d : q.getDatasetDefinitions()) {
            for (int i = 0; i < deflist.size(); ++i) {
                if (!((String)deflist.get(i)).equals(d.getName())) continue;
                deflist.remove(i--);
            }
        }
        for (String s : deflist) {
            maxDefs = s.equals("j") ? (String)maxDefs + s + ":%i" : (String)maxDefs + s + ":%" + s;
            maxDefs = (String)maxDefs + "$";
        }
        return maxDefs;
    }

    private void getWerte(QuestionRenderDTO q, VarHash vars, Integer nr) {
        for (DatasetrenderDTO def : q.getDatasetDefinitions()) {
            this.dsService.getWerte(def, nr.intValue(), vars);
        }
        vars.addHashtableCalcErgebnis(this.getMaximaConst(q));
    }

    public QuestionCalc loadDataset(QuestionCalc qc, int dsNr, String dataset) {
        QuestionRenderDTO q = qc.getQ();
        VarHash consts = q.isKonstanteMitProzent() ? new VarHash() : Calculate.getConstants((Calculate.CONST)Calculate.CONST.PHYSIC);
        qc.setConsts(consts);
        VarHash vars = qc.getVars();
        if (dataset != null && !dataset.isEmpty()) {
            this.ladeAngabeWerte(q, dataset, vars);
        } else {
            this.getWerte(q, vars, Integer.valueOf(dsNr));
        }
        VarHash cvars = qc.getCvars();
        cvars.addHashtableCalcErgebnis(consts);
        cvars.addHashtableCalcErgebnis(vars);
        VarHash mc = this.getMaximaConst(q);
        VarHash mv = this.getMaximaErg(q);
        VarHash varsMaxima = qc.getVarsMaxima();
        varsMaxima.addHashtableCalcErgebnis(mc);
        CalcParams cp = new CalcParams(ZielEinheit.OPTMODE.NONE, CALCMODE.MAXIMA, (CalcParamsQuestionInfo)qc);
        cp.setSymbolicMode(q.isUseSymbolicMode());
        for (String name : mv.keySet()) {
            varsMaxima.putInsertVars(name, mv.get(name), mc, cp);
        }
        VarHash mvars = qc.getMVars();
        mvars.addHashtableCalcErgebnis(cvars);
        cp.setSymbolicMode(q.isUseSymbolicMode());
        for (String name : varsMaxima.keySet()) {
            mvars.putInsertVars(name, varsMaxima.get(name), cvars, cp);
        }
        return qc;
    }

    private VarHash ladeAngabeWerte(QuestionRenderDTO q, String dataset, VarHash vars) {
        if (vars == null) {
            vars = Calculate.getConstants((Calculate.CONST)Calculate.CONST.PHYSIC);
        }
        if (dataset == null) {
            return vars;
        }
        dataset = dataset.replaceAll(":", "=");
        for (String ds : dataset.split(";")) {
            String[] x;
            DatasetrenderDTO qDs;
            if (Cmd.isEmpty((String)ds) || (qDs = this.getDataset(q, (x = ds.split("="))[0].trim())) == null || x.length <= 1) continue;
            this.dsService.setDatasetWert(qDs, x[1], vars);
        }
        return vars;
    }

    public DatasetrenderDTO getDataset(QuestionRenderDTO q, String name) {
        for (DatasetrenderDTO x : q.getDatasetDefinitions()) {
            if (!x.getName().equals(name)) continue;
            return x;
        }
        return null;
    }

    public String getTestDataset(QuestionCalc qc) {
        if (qc.getVars() == null) {
            return "";
        }
        return qc.getVars().buildString();
    }

    public void loadPlugins(QuestionCalc qc) {
        QuestionRenderDTO q = qc.getQ();
        qc.setPluginList(QuestionPluginService.loadPlugins((MicroServiceConfiguration)this.mc, (String)q.getPlugins()));
        q.getSubQuestions().stream().filter(sq -> sq.getMode() == SQMODE.PLUGIN).forEach(sq -> {
            LettoPlugin qp = this.sqService.getPlugin(qc, sq);
            if (qp != null && qp.isJavaScript()) {
                ImageService imgageService = this.mc.getPluginImageService(qc.getSchool());
                try {
                    PluginDto pluginDto = qp.loadPluginDto("input;" + this.sqService.getPluginParams(sq), (LettoQuestion)qc, imgageService, this.getPluginNr(qc));
                    pluginDto.setPig(false);
                    pluginDto.setResult(true);
                    sq.setPluginDto(pluginDto);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public int getPluginNr(QuestionCalc qc) {
        qc.setPluginNr(qc.getPluginNr() + 1);
        return qc.getPluginNr();
    }

    public LettoPlugin getPlugin(QuestionCalc qc, String name) {
        LinkedHashMap plist = qc.getPluginList();
        if (plist.containsKey(name)) {
            return (LettoPlugin)((HashMap)plist).get(name);
        }
        return null;
    }

    public List<LettoDataset> getLettoDatasetDefinitions(QuestionRenderDTO q) {
        Vector<LettoDataset> lds = new Vector<LettoDataset>();
        for (DatasetrenderDTO mds : q.getDatasetDefinitions()) {
            LettoDataset ds = new LettoDataset();
            this.mapper.map((Object)mds, (Object)ds);
            lds.add(ds);
        }
        return lds;
    }

    public ZielEinheit getZielEinheit(AnswerRenderDTO an) {
        List ds = this.getLettoDatasetDefinitions(an.getParent().getParent()).stream().map(d -> d).collect(Collectors.toList());
        ZielEinheit ze = new ZielEinheit(an.getEinheit(), ds);
        String maxima = an.getMaxima().trim();
        Matcher m = pFZ.matcher(maxima);
        if (m.find()) {
            ze.setFormelzeichen(m.group("fz"));
        } else {
            m = pFZopt.matcher(maxima);
            if (m.find()) {
                ze.setFormelzeichen(m.group("fz"));
            }
        }
        return ze;
    }

    public void setEinheit(AnswerRenderDTO an, String einheit) {
        QuestionType qTyp;
        if (einheit == an.getEinheit() || (qTyp = an.getParent().getParent().getQuestionType()) == QuestionType.MoodleCalculated || qTyp == QuestionType.MoodleCalculated_Multi || qTyp == QuestionType.MoodleCalculated_Simple || qTyp == QuestionType.MoodleNumerical) {
            // empty if block
        }
        an.setEinheit(einheit);
    }

    public void calcResults(QuestionCalc qc, boolean loadPlugins, boolean callMaxima, String school) {
        QuestionRenderDTO q = qc.getQ();
        q.setMaximaResult("");
        if (loadPlugins) {
            this.loadPlugins(qc);
        }
        if (q.isPreCalc() || callMaxima) {
            this.calcMaxima(qc, school);
        }
        VarHash vars = new VarHash();
        for (String v : qc.getConsts().keySet()) {
            vars.putGet(qc.getConsts(), v);
        }
        for (String v : qc.getVars().keySet()) {
            vars.putGet(qc.getVars(), v);
        }
        for (int j = 0; j < q.getSubQuestions().size(); ++j) {
            SubQuestionRenderDTO sq = (SubQuestionRenderDTO)q.getSubQuestions().get(j);
            qc.setErg(j, (CalcErgebnis)new CalcString(""));
            boolean useFolgefehlerVar = !vars.containsKey(sq.getName());
            double frac = 0.0;
            if (sq.getMode() == SQMODE.MULTICHOICE) {
                qc.setErg(j, (CalcErgebnis)new CalcString(""));
            }
            block17: for (int a = 0; a < sq.getAnswers().size(); ++a) {
                AnswerRenderDTO an = (AnswerRenderDTO)sq.getAnswers().get(a);
                ZielEinheit ze = new ZielEinheit();
                try {
                    ze = this.getZielEinheit(an);
                    try {
                        switch (1.$SwitchMap$at$letto$tools$enums$SQMODE[sq.getMode().ordinal()]) {
                            case 1: {
                                CalcString erg = this.calcLoesung(qc, an.getText(), new ZielEinheit(), this.getToleranz(an), false);
                                qc.setErg(j, (CalcErgebnis)erg);
                                if (!(an.getFraction() > frac)) break;
                                frac = an.getFraction();
                                qc.setErg(j, (CalcErgebnis)erg);
                                break;
                            }
                            case 2: {
                                CalcString erg;
                                try {
                                    erg = this.calcLoesung(qc, an.getText(), ze, this.getToleranz(an), false);
                                    qc.setErgAntwort(j, a, (CalcErgebnis)erg);
                                    qc.setErg(j, (CalcErgebnis)erg);
                                    if (!(an.getFraction() > frac)) continue block17;
                                    frac = an.getFraction();
                                    qc.setErg(j, (CalcErgebnis)erg);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            case 3: {
                                qc.setErg(j, (CalcErgebnis)new CalcString(an.getText()));
                                Object textanswer = an.getText();
                                if (!(an.getFraction() > 0.0)) break;
                                if (((QuestionCalc.ErgSubQuestion)qc.getErgebnisse().get(j)).getSqErgebnis().toStringUnquoted().trim().length() == 0) {
                                    qc.setErg(j, (CalcErgebnis)new CalcString((String)textanswer));
                                    break;
                                }
                                qc.setErg(j, (CalcErgebnis)new CalcString(((QuestionCalc.ErgSubQuestion)qc.getErgebnisse().get(j)).getSqErgebnis().toStringUnquoted() + "|&|" + (String)textanswer));
                                break;
                            }
                            case 4: {
                                Object textanswer = ((QuestionCalc.ErgSubQuestion)qc.getErgebnisse().get(j)).getSqErgebnis().toString() + " " + qc.getErgAntwort(j, a).toString();
                                if (a == 0) {
                                    qc.setErg(j, (CalcErgebnis)new CalcString((String)textanswer));
                                    break;
                                }
                                qc.setErg(j, (CalcErgebnis)new CalcString(((QuestionCalc.ErgSubQuestion)qc.getErgebnisse().get(j)).getSqErgebnis().toStringUnquoted() + "|&|" + (String)textanswer));
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                CalcString erg = new CalcString(an.getText());
                                qc.setErg(j, (CalcErgebnis)erg);
                                if (!(an.getFraction() > frac)) break;
                                frac = an.getFraction();
                                qc.setErg(j, (CalcErgebnis)erg);
                                break;
                            }
                            case 10: {
                                CalcString erg = this.calcLoesung(qc, an.getText(), ze, this.getToleranz(an), true);
                                qc.setErgAntwort(j, a, (CalcErgebnis)erg);
                                if (!(an.getFraction() > frac)) break;
                                frac = an.getFraction();
                                qc.setErg(j, (CalcErgebnis)erg);
                            }
                        }
                    }
                    catch (Exception e) {
                        qc.setErg(j, (CalcErgebnis)new CalcString("Antwort konnte nicht berechnet werden"));
                    }
                    continue;
                }
                catch (Exception ex) {
                    qc.setErg(j, (CalcErgebnis)new CalcString("ZielEinheit falsch! Antwort konnte nicht berechnet werden"));
                }
            }
            if (!useFolgefehlerVar) continue;
            vars.put(sq.getName(), ((QuestionCalc.ErgSubQuestion)qc.getErgebnisse().get(j)).getSqErgebnis());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void loadTexte(QuestionCalc qc) {
        block14: {
            q = qc.getQ();
            for (SubQuestionRenderDTO sub : q.getSubQuestions()) {
                this.sqService.reihenfolgeFestlegen(sub);
            }
            clozeQuestions /* !! */  = new Vector<ClozePart>();
            qc.setClozeQuestions(clozeQuestions /* !! */ );
            text = QuestionText.getQuestionText((QuestionRenderDTO)q).getText().trim();
            text = this.getAngabeMitZahlen(qc, text);
            matcher = QuestionRenderService.qPattern.matcher(text);
            start = 0;
            listSubquestions = new Vector<String>();
            while (matcher.find()) {
                t = text.substring(start, matcher.start()).trim();
                t = this.insImg(qc, (String)t, QuestionText.getQuestionText((QuestionRenderDTO)q), Boolean.valueOf(false)).trim();
                name = matcher.group("name");
                sq = null;
                if (listSubquestions.contains(name)) {
                    t = (String)t + "<p><strong><span style=\"color:#ff0000\">Die Teilfrage " + name + " wird doppelt verwendet!</span></strong></p>";
                    clozeQuestions /* !! */ .add(new ClozePart((String)t, null));
                } else {
                    listSubquestions.add(name);
                    sq = this.findSubQuestion(q, name);
                    if (sq != null) {
                        clozeQuestions /* !! */ .add(new ClozePart((String)t, sq));
                    } else {
                        t = (String)t + "<p><strong><span style=\"color:#ff0000\">Die Teilfrage " + matcher.group("name") + " existiert nicht</span></strong></p>";
                        clozeQuestions /* !! */ .add(new ClozePart((String)t, null));
                    }
                }
                start = matcher.end();
            }
            rest = text.substring(start);
            finalClozeQuestions = clozeQuestions /* !! */ ;
            nichtzugeord = q.getSubQuestions().stream().filter((Predicate<SubQuestionRenderDTO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$loadTexte$4(java.util.List at.letto.question.dto.SubQuestionRenderDTO ), (Lat/letto/question/dto/SubQuestionRenderDTO;)Z)(finalClozeQuestions)).collect(Collectors.toList());
            if (rest.trim().length() <= 0) break block14;
            t = this.insImg(qc, rest, QuestionText.getQuestionText((QuestionRenderDTO)q), Boolean.valueOf(false));
            if (nichtzugeord.size() <= 0) ** GOTO lbl-1000
            v0 = q.getQuestionType();
            q.getQuestionType();
            if (!v0.equals((Object)QuestionType.MoodleClozeCalc)) {
                v1 = (SubQuestionRenderDTO)nichtzugeord.remove(0);
            } else lbl-1000:
            // 2 sources

            {
                v1 = null;
            }
            x = v1;
            clozeQuestions /* !! */ .add(new ClozePart(t, x));
        }
        v2 = q.getQuestionType();
        q.getQuestionType();
        if (v2.equals((Object)QuestionType.MoodleEssay)) {
            while (nichtzugeord.size() > 0) {
                clozeQuestions /* !! */ .add(new ClozePart("", (SubQuestionRenderDTO)nichtzugeord.remove(0)));
            }
        }
        p = Pattern.compile("(?<txt>.*?)\\[Q\\d+\\]", 32);
        text = QuestionText.getGeneralFeedback((QuestionRenderDTO)q).getText();
        text = this.getAngabeMitZahlen(qc, text);
        this.textFeedback = text = this.insImg(qc, text, QuestionText.getGeneralFeedback((QuestionRenderDTO)q), Boolean.valueOf(false)).trim();
        for (SubQuestionRenderDTO sq : q.getSubQuestions()) {
            sqFeedbackPattern = Pattern.compile("\\[" + sq.getName() + "\\](?<txt>.*?)($|(\\[Q))", 32);
            m1 = sqFeedbackPattern.matcher(this.textFeedback);
            feedb = m1.find() != false ? m1.group("txt") : "";
            n = new HTMLmain(feedb, HTMLParser.HTMLPARSEMODE.GUI);
            feedb = n.toString(HTMLMODE.GUI, null, null, -1);
            feedb = this.insImg(qc, feedb, QuestionText.getGeneralFeedback((QuestionRenderDTO)q), Boolean.valueOf(false)).trim();
            sq.setTextFeedback(feedb);
        }
        qc.setFeedback(this.textFeedback);
        v3 = q.getQuestionType();
        q.getQuestionType();
        dblClick = v3 == QuestionType.MoodleMatching;
        dblClick = true;
        for (SubQuestionRenderDTO sq : q.getSubQuestions()) {
            for (AnswerRenderDTO a : sq.getAnswers()) {
                outp = HTMLMODE.HTML;
                textImg = this.getHtmlText(qc, a.getText(), Boolean.valueOf(dblClick), outp);
                answerImg = this.getHtmlText(qc, a.getAnswer(), Boolean.valueOf(dblClick), HTMLMODE.HTML);
                a.setTextHtml(textImg);
                a.setAnswerImg(answerImg);
            }
        }
        if (clozeQuestions /* !! */ .size() == 0) {
            clozeQuestions /* !! */  = q.getSubQuestions().stream().map((Function<SubQuestionRenderDTO, ClozePart>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$loadTexte$5(at.letto.question.dto.SubQuestionRenderDTO ), (Lat/letto/question/dto/SubQuestionRenderDTO;)Lat/letto/questionservice/service/ClozePart;)()).collect(Collectors.toList());
        }
    }

    public SubQuestionRenderDTO findSubQuestion(QuestionRenderDTO q, String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            return null;
        }
        for (SubQuestionRenderDTO qx : q.getSubQuestions()) {
            if (!name.equals(qx.getName())) continue;
            return qx;
        }
        return null;
    }

    public String getHtmlText(QuestionCalc qc, String txt, Boolean dblClick, HTMLMODE output) {
        txt = this.getAngabeMitZahlen(qc, txt, output).replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return this.insImg(qc, txt, QuestionText.getQuestionText((QuestionRenderDTO)qc.getQ()), dblClick);
    }

    public String getSubQuestionFeedback(QuestionRenderDTO q, SubQuestionRenderDTO sq) {
        QuestionText.getGeneralFeedback((QuestionRenderDTO)q).getText();
        return "";
    }

    public SubQuestionRenderDTO getFirstSubquestion(QuestionRenderDTO q) {
        if (q.getSubQuestions().size() < 1) {
            SubQuestionRenderDTO sq = new SubQuestionRenderDTO(q);
            sq.setName("Q0");
            q.getSubQuestions().add(sq);
        }
        return (SubQuestionRenderDTO)q.getSubQuestions().get(0);
    }

    public void removeEmptySubquestions(QuestionRenderDTO q) {
        if (q.getQuestionType() == QuestionType.MoodleClozeCalc) {
            Iterator i = q.getSubQuestions().iterator();
            while (i.hasNext()) {
                SubQuestionRenderDTO sq = (SubQuestionRenderDTO)i.next();
                if (sq.getName() != null && !sq.getName().isEmpty()) continue;
                i.remove();
            }
        }
    }

    public void removeEmptyAnswers(QuestionRenderDTO q) {
        if (q.getQuestionType() == QuestionType.MoodleMultichoice || q.getQuestionType() == QuestionType.MoodleMatching || q.getQuestionType() == QuestionType.MoodleClozeCalc) {
            for (SubQuestionRenderDTO sq : q.getSubQuestions()) {
                if (sq.getMode() == SQMODE.ZUORDNUNG || sq.getMode() == SQMODE.MULTICHOICE || sq.getMode() == SQMODE.CALCULATED || sq.getMode() == SQMODE.SINGLECHOICE) {
                    Iterator i = sq.getAnswers().iterator();
                    while (i.hasNext()) {
                        AnswerRenderDTO a = (AnswerRenderDTO)i.next();
                        if (!a.getText().isEmpty() || !a.getFeedback().isEmpty() || !a.getAnswer().isEmpty() || !a.getEinheit().isEmpty() || !a.getMaxima().isEmpty() || sq.getAnswers().size() <= 1) continue;
                        i.remove();
                    }
                }
                if (sq.getAnswers().size() != 0) continue;
                sq.getAnswers().add(new AnswerRenderDTO(sq));
            }
        }
    }

    public void encryt(QuestionRenderDTO q, String name, String key) {
        this.encryt(q, name, key, false);
    }

    public void encryt(QuestionRenderDTO q, String name, String key, boolean force) {
        if (!force && q.getLicenceKey() != null && !q.getLicenceKey().isEmpty()) {
            return;
        }
        q.setMaxima(ENCRYPT.enc((String)("encryptedQuestion" + q.getMaxima()), (String)key));
        String txt = ENCRYPT.enc((String)("encryptedQuestion" + QuestionText.getQuestionText((QuestionRenderDTO)q).getText()), (String)key);
        String md5 = "encryptedQuestion" + ENCRYPT.md5falsch((String)txt);
        QuestionText.getQuestionText((QuestionRenderDTO)q).setText(txt);
        q.setLicenceKey(name + ";" + md5);
    }

    public void decryptQuestion(QuestionRenderDTO q, String key) {
        boolean decryptError = false;
        if (Cmd.isEmpty((String)q.getLicenceKey())) {
            return;
        }
        if (key == null) {
            key = "";
        }
        String md5 = "";
        String txt = QuestionText.getQuestionText((QuestionRenderDTO)q).getText();
        try {
            md5 = q.getLicenceKey().split(";")[1];
            txt = ENCRYPT.decrypt((String)txt, (char[])key.toCharArray());
            if (txt.startsWith("encryptedQuestion")) {
                txt = txt.replaceFirst("encryptedQuestion", "");
            } else {
                decryptError = true;
            }
            q.setMaxima(ENCRYPT.decrypt((String)q.getMaxima(), (char[])key.toCharArray()));
            if (q.getMaxima().startsWith("encryptedQuestion")) {
                q.setMaxima(q.getMaxima().replaceFirst("encryptedQuestion", ""));
            } else {
                decryptError = true;
            }
            QuestionText.getQuestionText((QuestionRenderDTO)q).setText(txt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        q.setLicenceKey("");
    }

    public String getPluginContext() {
        StringBuilder piDef = new StringBuilder();
        return "initPluginContextMenues('" + piDef.toString().replaceAll("\\\\", "") + "');";
    }

    public CalcErgebnis calcLoesung(QuestionCalc qc, String loesung, ZielEinheit zielEinheit, CalcToleranz toleranz, boolean logError) {
        VarHash vars;
        VarHash ds = qc.getVars();
        QuestionRenderDTO q = qc.getQ();
        CalcError erg = null;
        CalcParams cp = new CalcParams(zielEinheit.calcOptmodeLoesung(), CALCMODE.LOESUNG, toleranz, (CalcParamsQuestionInfo)qc, true, q.isUseSymbolicMode());
        try {
            vars = zielEinheit.getVars(ds);
            for (String key : ds.keySet()) {
                if (!key.matches("^Q\\d+$") || vars.containsKey(key)) continue;
                vars.putGet(ds, key);
            }
            vars.addHashtableCalcErgebnis(this.getMaximaConst(q));
            cp = cp.setVars(vars);
            cp = cp.setSymbolicMode(zielEinheit.isSuchMuster() || q.isUseSymbolicMode());
            erg = ParserCache.getCache().calculate(loesung, vars, cp);
        }
        catch (Exception e) {
            erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, e.getMessage());
        }
        LettoTimer.checkInterrupt();
        switch (1.$SwitchMap$at$letto$math$einheiten$ZielEinheit$MODE[zielEinheit.getMode().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (erg != null && erg instanceof CalcLong) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Im Einheiten Mode " + zielEinheit.getMode() + " muss das Ergebnis eine Ganzzahl sein!");
                break;
            }
            case 5: {
                if (erg != null && erg instanceof CalcLong || erg instanceof CalcRational) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Im Einheiten Mode " + zielEinheit.getMode() + " muss das Ergebnis eine Ganzzahl oder ein Bruch von Ganzzahlen sein!");
                break;
            }
            case 6: {
                if (erg != null && erg instanceof CalcNumerical) {
                    if (erg instanceof CalcComplexEinheit || erg instanceof CalcComplex) {
                        erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "komplexe Zahl ist nicht als Farbcode interpretierbar!");
                    }
                    erg = new CalcDouble(erg.toDouble());
                    break;
                }
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Ergebnis ist nicht als Farbcode interpretierbar!");
                break;
            }
            case 7: {
                if (!(erg instanceof CalcNumerical)) {
                    erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                }
                if (!(erg instanceof CalcPhysical)) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert ohne Einheit sein!");
                break;
            }
            case 8: {
                if (erg != null) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                break;
            }
            case 9: {
                if (erg instanceof CalcNumerical) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                break;
            }
        }
        if (zielEinheit.isSuchMuster() && !zielEinheit.testSchuelereingabeSuchmuster(erg.toString())) {
            try {
                vars = zielEinheit.getVars(ds);
                vars.addHashtableCalcErgebnis(this.getMaximaConst(q));
                erg = ParserCache.getCache().calculate(loesung, vars, cp);
                if (!zielEinheit.testSchuelereingabeSuchmuster(erg.toString())) {
                    erg = new CalcError(CalcError.Fehler.MUSTERFEHLER, erg.toString() + "<->" + zielEinheit.calcSuchmuster());
                }
            }
            catch (Exception e) {
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, e.getMessage());
            }
        }
        List datasets = this.getLettoDatasetDefinitions(q).stream().map(d -> d).collect(Collectors.toList());
        zielEinheit.addDatasets(datasets);
        erg = erg.setZielEinheit(zielEinheit);
        return erg;
    }

    public CalcToleranz getToleranz(AnswerRenderDTO a) {
        return new CalcToleranz(a.getTolerance());
    }

    private final String getAngabeMitZahlen(QuestionCalc qc, String angabe) {
        return this.getAngabeMitZahlen(qc, angabe, HTMLMODE.HTML);
    }

    private final String getAngabeMitZahlen(QuestionCalc qc, String Angabe, HTMLMODE output) {
        LinkedHashMap pList = qc.getPluginList();
        for (String key : ((HashMap)pList).keySet()) {
            Matcher m = Pattern.compile("^(?<vorher>.*)\\[PI\\s" + key + "\\](?<inhalt>.+)\\[\\/PI\\s" + key + "\\](?<nachher>.*)$", 40).matcher((CharSequence)Angabe);
            while (m.find()) {
                String vorher = m.group("vorher");
                String inhalt = m.group("inhalt");
                String nachher = m.group("nachher");
                Angabe = vorher + ((LettoPlugin)((HashMap)pList).get(key)).modifyAngabe(inhalt, (LettoQuestion)qc) + nachher;
            }
        }
        HTMLmain n = new HTMLmain((String)Angabe, HTMLParser.HTMLPARSEMODE.GUI);
        QuestionTextDTO qt = QuestionText.getQuestionText((QuestionRenderDTO)qc.getQ());
        qt.setLettoFiles(new Vector());
        qt.getFiles().forEach(f -> {
            QuestionFile f1 = new QuestionFile(this.mc.getImageService());
            this.mapper.map(f, (Object)f1);
            qt.getLettoFiles().add(f1);
        });
        String s = n.toString(output, qt.getLettoFiles(), (LettoQuestion)qc, qc.getMVars(), true);
        return s;
    }

    private String insImg(QuestionCalc qc, String Angabe, QuestionTextDTO t, Boolean dblClick) {
        try {
            Angabe = Angabe.replaceAll("\\&quot;", "\"");
            Angabe = this.insPlugins(Angabe, qc, dblClick.booleanValue());
            Matcher matcher = imgPattern.matcher(Angabe);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                QuestionFileDTO file;
                String ImgNr = matcher.group("nr");
                Integer i = Integer.parseInt(ImgNr);
                if (i < 0 || (file = (QuestionFileDTO)t.getFiles().get(i)) == null) continue;
                List lfs = t.getLettoFiles();
                QuestionFile f = null;
                if (lfs == null || lfs.size() <= i) {
                    f = new QuestionFile(this.mc.getImageService());
                    this.mapper.map((Object)file, (Object)f);
                } else {
                    f = (LettoFile)t.getLettoFiles().get(i);
                }
                String img = f.getImageWeb(dblClick.booleanValue());
                matcher.appendReplacement(buffer, img);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgException exc = new MsgException(e.getStackTrace().toString());
            throw exc;
        }
    }

    private String insPlugins(String t, QuestionCalc question, boolean dblClick) {
        List pluginInfos = PluginInfo.searchForPlugins((String)t, (LettoQuestion)question);
        Object erg = "";
        int start = 0;
        for (int i = 0; i < pluginInfos.size(); ++i) {
            PluginInfo info = (PluginInfo)pluginInfos.get(i);
            int end = info.posStart;
            erg = (String)erg + t.substring(start, end);
            if (info.typ.equals("PIA")) {
                start = info.startPluginMsg;
                while (i + 1 < pluginInfos.size() && ((PluginInfo)pluginInfos.get((int)(i + 1))).posStart < info.posEnd) {
                    end = ((PluginInfo)pluginInfos.get((int)(i + 1))).posStart;
                    erg = (String)erg + t.substring(start, end);
                    erg = (String)erg + ((PluginInfo)pluginInfos.get(i + 1)).toHtml((LettoQuestion)question, dblClick);
                    start = ((PluginInfo)pluginInfos.get((int)(i + 1))).posEnd;
                    ++i;
                }
                end = info.endPluginMsg;
                erg = (String)erg + t.substring(start, end);
            } else {
                String ret = this.toHtml(info, (LettoQuestion)question, dblClick, question.getSchool());
                if (ret.contains("<JAVASCRIPT>")) {
                    String[] x = ret.split("<JAVASCRIPT>");
                    question.setJsPlugins(question.getJsPlugins() + x[1] + "\n");
                    ret = x[0];
                }
                erg = (String)erg + ret;
            }
            start = info.posEnd;
        }
        erg = (String)erg + t.substring(start);
        return erg;
    }

    public String toHtml(PluginInfo pi, LettoQuestion q, boolean dblClick, String school) {
        if (pi.getPluginObj() == null) {
            return "<br/>Plugin not defined<br/>";
        }
        ImageService imageService = this.mc.getPluginImageService(school);
        if (pi.getTyp().equals("PIG")) {
            if (pi.getPluginObj().isJavaScript()) {
                String name = pi.getPluginObj().getName();
                PluginDto pluginDto = pi.getPluginObj().loadPluginDto(pi.getParams(), q, imageService, q.getPluginNr());
                pluginDto.setPig(true);
                pluginDto.setResult(false);
                String jsInit = pi.getPluginObj().getInitPluginJS() + "(`" + JSON.objToJson((Object)pluginDto) + "`, true); \n";
                QuestionPluginService piObj = (QuestionPluginService)pi.getPluginObj();
                piObj.setInitScripts(piObj.getInitScripts() + jsInit);
                String html = "<input class='" + pluginDto.getTagName() + "_inp hiddenPlugin'/>\n<div id='" + pluginDto.getTagName() + "_div' style='width:100%'></div><br/>\n";
                html = html + "<JAVASCRIPT>" + pi.getPluginObj().getInitPluginJS() + "(`" + JSON.objToJson((Object)pluginDto) + "`, true);\n";
                return html;
            }
            FileDTO fileDTO = pi.getPluginObj().getImage(pi.getParams(), q, imageService);
            String path = imageService.getURL(fileDTO.getFilename());
            return QuestionRenderService.getImageWeb((String)path, (String)fileDTO.getAlternate(), (String)fileDTO.htmlImageWidth(), (boolean)true) + "<BR/>";
        }
        if (pi.getTyp().equals("PIT")) {
            String txt = pi.getPluginObj().getHTML(pi.getParams(), q);
            return txt + "<BR/>";
        }
        return "";
    }

    static String getImageWeb(String link, String alternateText, String width, boolean dblClick) {
        if (!Cmd.isEmpty((String)link)) {
            return String.format("<img on%sclick='openImg(\"%s\")' src=\"%s\" alt=\"%s\" style=\"width:%s;\">", dblClick ? "dbl" : "", link, link, alternateText, width);
        }
        return "";
    }

    public String loadDataset(int id, int dsNr, LettoToken token) {
        QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
        QuestionCalc qc = new QuestionCalc(qrender, token.getSchool());
        LicenseKey key = new LicenseKey(this.license);
        LettoConfigDto lettoConfigDto = new LettoConfigDto(key, this.maximaPath, this.lettoMac);
        qc.setLettoConfigDto(lettoConfigDto);
        this.postLoadQuestion(qc);
        this.loadDataset(qc, dsNr, "");
        return this.getTestDataset(qc);
    }

    public QuestionInfo doPrepareQuestion(QuestionRenderDTO q, int dsNr, String dataset, String school) {
        return this.prepareQuestion((QuestionRenderDTO)q, (int)dsNr, (String)dataset, (String)school).qi;
    }

    public PrepareQuest prepareQuestion(QuestionRenderDTO q, int dsNr, String dataset, String school) {
        String cp_hinweis;
        SubQuestionRenderDTO sq2;
        QuestionCache cache = this.getQuestionCache();
        QuestionInfo qi = cache.loadQuestionInfoFromCache(dataset, q.getId(), school);
        if (qi != null) {
            return new PrepareQuest(this, qi, null);
        }
        if (ServerConfiguration.service == null) {
            ServerConfiguration.service = new Config(this);
        }
        QuestionCalc qc = new QuestionCalc(q, school);
        LicenseKey key = new LicenseKey(this.license);
        LettoConfigDto lettoConfigDto = new LettoConfigDto(key, this.maximaPath, this.lettoMac);
        qc.setLettoConfigDto(lettoConfigDto);
        String decryptKey = this.decryptQuestion(q);
        this.postLoadQuestion(qc);
        if (Cmd.isEmpty((String)dataset)) {
            this.loadDataset(qc, dsNr, "");
            dataset = this.getTestDataset(qc);
            qc.setDataset(dataset);
            cache.cacheDataset((int)qc.getId(), dsNr, dataset, school);
            cache.cacheVarHash(dataset, q.getId(), school, VarhashMode.vars, qc);
            qi = cache.loadQuestionInfoFromCache(dataset, q.getId(), school);
            if (qi != null) {
                return new PrepareQuest(this, qi, null);
            }
        } else {
            this.loadDataset(qc, 0, dataset);
            qc.setDataset(dataset);
        }
        this.calcResults(qc, true, false, school);
        this.loadTexte(qc);
        if (!q.getQuestionType().equals((Object)QuestionType.MoodleClozeCalc) && Cmd.isEmpty((String)(sq2 = q.getFirstSubquestion()).getName())) {
            sq2.setName("Q0");
        }
        AtomicBoolean renderError = new AtomicBoolean(false);
        QuestionHtmlDTO htmlDTO = new QuestionHtmlDTO();
        htmlDTO.setIdQuestion(q.getId());
        htmlDTO.setName(q.getName());
        htmlDTO.setPluginDefinition(q.getPlugins());
        htmlDTO.setQuestionType(q.getQuestionType());
        htmlDTO.setSingle(q.getSingle());
        htmlDTO.setAddDocumentsPossible(q.isAddDocumentsPossible());
        htmlDTO.setPlugins(qc.getPluginList());
        htmlDTO.setJsPlugins(qc.getJsPlugins());
        htmlDTO.setFeedback(qc.getFeedback());
        htmlDTO.setRandomDataset(q.isRandomDataset());
        String cp = "";
        if (q.getQuestionInfo() != null && q.getQuestionInfo().contains("copyright:")) {
            String cp_hinweis2;
            Pattern p = Pattern.compile("copyright:\\s*(\\w*)");
            Matcher m = p.matcher(q.getQuestionInfo());
            if (m.find()) {
                cp = m.group(1);
            }
            if (!Cmd.isEmpty((String)cp) && !Cmd.isEmpty((String)(cp_hinweis2 = ResourceReader.asStringFromPath((String)("copyright/" + cp + ".html"))))) {
                cp = cp_hinweis2;
            }
        }
        if (Cmd.isEmpty((String)cp) && !Cmd.isEmpty((String)this.mc.getCopyright()) && !Cmd.isEmpty((String)(cp_hinweis = ResourceReader.asStringFromPath((String)("copyright/" + (cp = this.mc.getCopyright()) + ".html"))))) {
            cp = cp_hinweis;
        }
        htmlDTO.setCopyright(cp);
        double penalty = 0.0;
        try {
            penalty = new CalcToleranz(q.getAbzug()).getToleranz();
        }
        catch (Exception cp_hinweis2) {
            // empty catch block
        }
        htmlDTO.setPruefenAbzug(penalty);
        htmlDTO.setSubQuestions(qc.getClozeQuestions().stream().map(cq -> {
            SubQuestionHtmlDTO sq = new SubQuestionHtmlDTO(htmlDTO);
            String angabe = cq.getAngabe();
            if (angabe.contains("{=")) {
                renderError.set(true);
            }
            sq.setHtmlText(angabe);
            if (cq.getSq() != null) {
                sq.setEh(((AnswerRenderDTO)cq.getSq().getAnswers().get(0)).getEinheit());
            }
            if (cq.getSq() != null) {
                sq.setIdSq((int)cq.getSq().getId());
                try {
                    sq.setValidierungsInfo(this.sqService.getFirstErg(qc, cq.getSq()).getValidationInfo());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (q.getSingle() != null && q.getSingle().equals((Object)LueckentextMode.CaseSensitive)) {
                    sq.setMode(SQMODE.TEXT);
                } else if (q.getSingle() != null && q.getSingle().equals((Object)LueckentextMode.RegularExpression)) {
                    sq.setMode(SQMODE.REGEXP);
                } else {
                    sq.setMode(cq.getSq().getMode());
                }
                sq.setName(cq.getSq().getName());
                sq.setZielTyp(this.sqService.getFirstAnswer(cq.getSq()).getAnswer().getClass().getSimpleName());
                sq.setFeedback(cq.getSq().getTextFeedback());
                sq.setAnswers(cq.getSq().getAnswers().stream().map(a -> {
                    AnswerHtmlDTO an = new AnswerHtmlDTO();
                    an.setText(a.getText());
                    an.setHtmlText(a.getTextHtml());
                    an.setHtmlAnswer(a.getAnswerImg());
                    an.setShortAnswer(a.getAnswer());
                    an.setZielEinheit(this.getZielEinheit(a));
                    an.setFeedback(a.getFeedback());
                    return an;
                }).collect(Collectors.toList()));
                if (!Cmd.isEmpty((String)this.sqService.getPluginName(cq.getSq()))) {
                    try {
                        sq.setPluginDto(cq.getSq().getPluginDto().toJson());
                        sq.setPluginName(this.sqService.getPluginName(cq.getSq()));
                        sq.setPluginTyp(((LettoPlugin)htmlDTO.getPlugins().get(sq.getPluginName())).getTyp());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SQMODE mode = cq.getSq().getMode();
                AntwortenMischen shuffleAnswers = sq.getAntwortenMischen();
                if (shuffleAnswers == null) {
                    shuffleAnswers = cq.getSq().getShuffleAnswers();
                }
                if (shuffleAnswers == null && (mode == SQMODE.MULTICHOICE || mode == SQMODE.SINGLECHOICE || mode == SQMODE.ZUORDNUNG || sq.getParent().getQuestionType() == QuestionType.MoodleCloze && sq.getParent().getSingle() == LueckentextMode.DragAndDrop)) {
                    shuffleAnswers = AntwortenMischen.Mischen;
                }
                sq.setAntwortenMischen(shuffleAnswers);
            }
            return sq;
        }).collect(Collectors.toList()));
        htmlDTO.getSubQuestions().addAll(q.getSubQuestions().stream().filter(sq -> sq.getGrade() > 0.0).filter(sq -> htmlDTO.getSubQuestions().stream().noneMatch(x -> x.getName() != null && x.getName().equals(sq.getName()))).map(cq -> {
            SubQuestionHtmlDTO sq = new SubQuestionHtmlDTO(htmlDTO);
            sq.setHtmlText("");
            sq.setVisible(false);
            sq.setIdSq((int)cq.getId());
            sq.setMode(cq.getMode());
            sq.setName(cq.getName());
            sq.setZielTyp(this.sqService.getFirstAnswer(cq).getAnswer().getClass().getSimpleName());
            try {
                sq.setValidierungsInfo(this.sqService.getFirstErg(qc, cq).getValidationInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            sq.setFeedback(cq.getTextFeedback());
            sq.setAnswers(cq.getAnswers().stream().map(a -> {
                AnswerHtmlDTO an = new AnswerHtmlDTO();
                an.setText(a.getText());
                an.setHtmlText(a.getTextHtml());
                an.setHtmlAnswer(a.getAnswerImg());
                an.setShortAnswer(a.getAnswer());
                return an;
            }).collect(Collectors.toList()));
            if (!Cmd.isEmpty((String)this.sqService.getPluginName(cq))) {
                try {
                    sq.setPluginDto(cq.getPluginDto().toJson());
                    sq.setPluginName(this.sqService.getPluginName(cq));
                    sq.setPluginTyp(((LettoPlugin)htmlDTO.getPlugins().get(sq.getPluginName())).getTyp());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SQMODE mode = cq.getMode();
            AntwortenMischen shuffleAnswers = sq.getAntwortenMischen();
            if (shuffleAnswers == null) {
                shuffleAnswers = cq.getShuffleAnswers();
            }
            if (shuffleAnswers == null && (mode == SQMODE.MULTICHOICE || mode == SQMODE.SINGLECHOICE || mode == SQMODE.ZUORDNUNG)) {
                shuffleAnswers = AntwortenMischen.Mischen;
            }
            sq.setAntwortenMischen(shuffleAnswers);
            return sq;
        }).collect(Collectors.toList()));
        ErgQuestionDto erg = new ErgQuestionDto();
        erg.setLettoDatasetDefinitions(this.getLettoDatasetDefinitions(q));
        erg.setMaximaConst(this.getMaximaConst(q));
        erg.setUseSymbolicMode(q.isUseSymbolicMode());
        erg.setUnitPenalty(q.getUnitPenalty());
        erg.setKonstanteMitProzent(q.isKonstanteMitProzent());
        erg.setMaxima(q.getMaxima());
        erg.setDataset(dataset);
        erg.setId(q.getId());
        erg.setPrecalc(q.isPreCalc());
        Object abzug = q.getAbzug();
        if (abzug == null) {
            abzug = "";
        }
        if (!((String)abzug).contains("%")) {
            try {
                abzug = Double.parseDouble((String)abzug) * 100.0 + "%";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        erg.setAbzug((String)abzug);
        erg.setPunkte(q.getPunkte());
        if (q.getQuestionType().equals((Object)QuestionType.MoodleClozeCalc)) {
            erg.setPunkte(q.getSubQuestions().stream().map(sq -> sq.getGrade()).collect(Collectors.summingDouble(Double::doubleValue)).doubleValue());
        }
        erg.setStreng(q.isStreng());
        AtomicBoolean calcError = new AtomicBoolean(false);
        erg.setErgSubquestions(q.getSubQuestions().stream().map(sq -> {
            ErgSubquestionDto ergSq = new ErgSubquestionDto();
            ergSq.setSqName(sq.getName());
            ergSq.setGrade(sq.getGrade());
            ergSq.setSchwierigkeit(sq.getSchwierigkeit());
            ergSq.setErgAnswers(sq.getAnswers().stream().map(a -> {
                ErgAnswerDto ans = new ErgAnswerDto();
                if (q.getSingle() != null && q.getSingle().equals((Object)LueckentextMode.CaseSensitive)) {
                    ans.setEinheit("=");
                } else if (q.getSingle() != null && q.getSingle().equals((Object)LueckentextMode.RegularExpression)) {
                    ans.setEinheit("");
                } else {
                    ans.setEinheit(a.getEinheit());
                }
                CalcErgebnis er = this.sqService.getErg(qc, a);
                if (er != null && er instanceof CalcError) {
                    calcError.set(true);
                }
                ans.setErg(er);
                ans.setFeedback(a.getFeedback());
                ans.setFraction(a.getFraction());
                ans.setText(a.getText());
                ans.setToleranz(this.getToleranz(a));
                ans.setZielEinheit(this.getZielEinheit(a));
                return ans;
            }).collect(Collectors.toList()));
            return ergSq;
        }).collect(Collectors.toList()));
        if (q.getQuestionType().equals((Object)QuestionType.MoodleEssay)) {
            htmlDTO.getFirstSubquestion().setMode(SQMODE.FREITEXT);
        }
        QuestionInfo questionInfo = new QuestionInfo(q.getId(), dataset, dsNr, decryptKey, q.getLicenceKey(), htmlDTO, erg, new Vector(), calcError.get() || renderError.get());
        questionInfo.getHtmlDto().getPlugins().values().forEach(pi -> {
            QuestionPluginService x = (QuestionPluginService)pi;
            x.setPm(null);
        });
        InputQuestion iq = InputQuestionService.loadQuestion((int)-1, (QuestionInfo)questionInfo, null);
        InputQuestionService.addErgebnis((InputQuestion)iq, (ErgQuestionDto)erg);
        Vector<SqErgebnisseText> ergebnisseText = new Vector<SqErgebnisseText>();
        for (InputSubQuestion sq3 : iq.getSubQuestions()) {
            SqErgebnisseText ergText = new SqErgebnisseText(sq3.getAngabe().getName(), new Vector());
            ergText.getAntworten().addAll(ScoreService.getErgTexte((InputSubQuestion)sq3));
            ergebnisseText.add(ergText);
        }
        questionInfo.setErgebnisseText(ergebnisseText);
        cache.cacheQuestionInfo(questionInfo, school);
        cache.cacheVarHash(qc, dataset, school);
        return new PrepareQuest(this, questionInfo, qc);
    }

    private String decryptQuestion(QuestionRenderDTO q) {
        if (!Cmd.isEmpty((String)q.getLicenceKey())) {
            LicenseKey lic = new LicenseKey(this.license);
            String param = q.getLicenceKey().split(";")[0];
            String key = lic.getKeyForBeispielsammlung(param);
            if (key == null) {
                key = "";
            }
            this.decryptQuestion(q, key);
            return key;
        }
        return "";
    }

    public QuestionRenderDTO loadQuestionRenderDto(int id, LettoToken token) {
        String school = token != null ? token.getSchool() : "";
        QuestionRenderDTO qrender = this.getQuestionCache().loadQuestionRenderDto(id, school);
        if (qrender == null) {
            if (token == null) {
                throw new MsgException("noToken");
            }
            QuestionDTO qdto = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)this.mc.getDataService((LettoToken)token).question.loadQuestion(id));
            qrender = QuestionMapper.service.map(qdto, new CycleAvoidingMappingContext());
            this.getQuestionCache().cacheQuestionRenderDto(qrender, school, true);
        }
        if (qrender == null) {
            throw new MsgException("questionNotFound");
        }
        return qrender;
    }

    public QuestionWithAnswer loadQuestion(int id, int dsNr, String dataset, LettoToken token) {
        QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
        String school = token != null ? token.getSchool() : "";
        QuestionInfo erg = this.doPrepareQuestion(qrender, dsNr, "", school);
        erg.getHtmlDto().setPlugins(null);
        MischenService.mischenDerAntworten((QuestionHtmlDTO)erg.getHtmlDto());
        InputQuestion q = InputQuestionService.loadQuestion((int)-1, (QuestionInfo)erg, null);
        return new QuestionWithAnswer(q.getAngabe(), q.getInput(), null);
    }

    public QuestionWithAnswer loadQuestionWithErgebnisse(int id, int dsNr, String dataset, LettoToken token) {
        QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
        String school = token != null ? token.getSchool() : "";
        QuestionInfo erg = this.doPrepareQuestion(qrender, dsNr, "", school);
        erg.getHtmlDto().setPlugins(null);
        MischenService.mischenDerAntworten((QuestionHtmlDTO)erg.getHtmlDto());
        InputQuestion q = InputQuestionService.loadQuestion((int)-1, (QuestionInfo)erg, null);
        return new QuestionWithAnswer(q.getAngabe(), q.getInput(), erg.getErgebnisseText());
    }

    public List<TestAntwortDto> loadQuestionAnswers(List<CreateAnswerForQuestion> ans, LettoToken token) {
        return ans.stream().map(a -> {
            QuestionRenderDTO qrender = this.loadQuestionRenderDto(a.getId(), token);
            String school = token != null ? token.getSchool() : "";
            QuestionInfo erg = this.doPrepareQuestion(qrender, a.getDsNr(), a.getDataset(), school);
            InputQuestion q = InputQuestionService.loadQuestion((int)-1, (QuestionInfo)erg, null);
            q.getInput().setIdDetail(a.getIdTd());
            return q.getInput();
        }).collect(Collectors.toList());
    }

    public List<TestAntwortDto> loadQuestionDatasets(List<CreateAnswerForQuestion> ans, LettoToken token) {
        return ans.stream().map(a -> {
            QuestionRenderDTO qrender = this.loadQuestionRenderDto(a.getId(), token);
            String school = token != null ? token.getSchool() : "";
            QuestionInfo erg = this.doPrepareQuestion(qrender, a.getDsNr(), a.getDataset(), school);
            InputQuestion q = InputQuestionService.loadQuestion((int)-1, (QuestionInfo)erg, null);
            return q.getInput();
        }).collect(Collectors.toList());
    }

    public List<QuestionListDTO> loadQuestionsInCategory(int id, LettoToken token) {
        return (List)DtoAndMsg.get((DtoAndMsg)this.mc.getDataService((LettoToken)token).question.loadQuestionsInCategory(id, -1));
    }

    public List<QuestionListDTO> loadQuestionsInCategory(String path, LettoToken token) {
        CategorySortDTO c = (CategorySortDTO)DtoAndMsg.get((DtoAndMsg)this.mc.getDataService((LettoToken)token).category.loadCategoryByPath(path));
        if (c == null) {
            return new Vector<QuestionListDTO>();
        }
        return this.loadQuestionsInCategory(c.getId(), token);
    }

    public String saveQuestionDto(QuestionDTO q, LettoToken token) {
        QuestionRenderDTO qrender = QuestionMapper.service.map(q, new CycleAvoidingMappingContext());
        this.questionCacheService.addQuestionToStorage(qrender, token);
        return "";
    }

    public CalcMaximaDto calcMaxima(int id, boolean ergebnis, LettoToken token) {
        QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
        QuestionCalc qc = new QuestionCalc(qrender, token.getSchool());
        LicenseKey key = new LicenseKey(this.license);
        LettoConfigDto lettoConfigDto = new LettoConfigDto(key, this.maximaPath, this.lettoMac);
        qc.setLettoConfigDto(lettoConfigDto);
        this.loadDataset(qc, 0, "");
        this.loadPlugins(qc);
        this.calcMaxima(qc, token.getSchool());
        String erg = ergebnis ? qc.getQ().getMaximaResult() : qc.getQ().getMaximaResultErr();
        QuestionDTO q = QuestionMapper.service.mapDto(qrender, new CycleAvoidingMappingContext());
        return new CalcMaximaDto(q, erg);
    }

    public void calcMaxima(QuestionCalc qc, String school) {
        this.maxima.calcMaxima(qc, this.lettoMac);
        QuestionCache cache = this.getQuestionCache();
        cache.cacheMaximaVarHash(qc, school);
        cache.cacheQuestionRenderDto(qc.getQ(), school, false);
    }

    public Map<String, DatasetItem> loadResult(int id, int dsNr, LettoToken token) {
        LinkedHashMap<String, DatasetItem> ret = new LinkedHashMap<String, DatasetItem>();
        CalcParams cp = new CalcParams(ZielEinheit.OPTMODE.NUMERIC);
        QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
        QuestionInfo qi = this.doPrepareQuestion(qrender, dsNr, "", token.getSchool());
        for (ErgSubquestionDto sq : qi.getErgDto().getErgSubquestions()) {
            Optional<SubQuestionRenderDTO> optSq = qrender.getSubQuestions().stream().filter(sub -> sub.getName().equals(sq.getSqName())).findFirst();
            if (optSq.isPresent()) {
                switch (1.$SwitchMap$at$letto$tools$enums$SQMODE[optSq.get().getMode().ordinal()]) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 3: 
                    case 5: {
                        String erg = sq.getErgAnswers().stream().filter(a -> a.getFraction() > 0.0).map(a -> a.getText()).collect(Collectors.joining(","));
                        ret.put(sq.getSqName(), new DatasetItem(dsNr, sq.getSqName(), erg, erg));
                        break;
                    }
                    case 4: {
                        String matchErg = optSq.get().getAnswers().stream().map(a -> a.getText() + "<=>" + a.getAnswer()).collect(Collectors.joining(","));
                        ret.put(sq.getSqName(), new DatasetItem(dsNr, sq.getSqName(), matchErg, matchErg));
                        break;
                    }
                    case 1: 
                    case 6: 
                    case 7: 
                    case 10: {
                        break;
                    }
                    case 2: 
                    case 11: 
                    case 12: 
                    case 13: {
                        if (sq.getErgAnswers().size() <= 0) break;
                        String name = sq.getSqName();
                        ErgAnswerDto a2 = (ErgAnswerDto)sq.getErgAnswers().get(0);
                        ret.put(name, new DatasetItem(dsNr, name, a2.getText(), a2.getErg() != null ? a2.getErg().toTex() : ""));
                    }
                }
                continue;
            }
            if (sq.getErgAnswers().size() <= 0) continue;
            String name = sq.getSqName();
            ErgAnswerDto a3 = (ErgAnswerDto)sq.getErgAnswers().get(0);
            ret.put(name, new DatasetItem(dsNr, name, a3.getText(), a3.getErg() != null ? a3.getErg().toTex() : ""));
        }
        return ret;
    }

    public Map<String, Map<Integer, DatasetItem>> loadAllResults(int id, LettoToken token) {
        CalcParams cp = new CalcParams(ZielEinheit.OPTMODE.NUMERIC);
        LicenseKey key = new LicenseKey(this.license);
        LettoConfigDto lettoConfigDto = new LettoConfigDto(key, this.maximaPath, this.lettoMac);
        QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
        LinkedHashMap<String, Map<Integer, DatasetItem>> ret = new LinkedHashMap<String, Map<Integer, DatasetItem>>();
        for (int i = 0; i < 39; ++i) {
            QuestionInfo qi = this.doPrepareQuestion(qrender, i, "", token.getSchool());
            VarHash vars = this.getQuestionCache().loadVarsFromCache(qi.getDataset(), qi.getId(), token.getSchool());
            for (String k : vars.getVars().keySet()) {
                if (!ret.containsKey(k)) {
                    ret.put(k, new LinkedHashMap());
                }
                ((Map)ret.get(k)).put(i, new DatasetItem(i, k, vars.getString(k), vars.getTex(k)));
            }
            for (ErgSubquestionDto sq : qi.getErgDto().getErgSubquestions()) {
                if (sq.getErgAnswers().size() <= 0) continue;
                String name = sq.getSqName();
                if (!ret.containsKey(name)) {
                    ret.put(name, new LinkedHashMap());
                }
                ErgAnswerDto a = (ErgAnswerDto)sq.getErgAnswers().get(0);
                ((Map)ret.get(name)).put(i, new DatasetItem(i, name, a.getText(), a.getErg().toTex()));
            }
        }
        return ret;
    }

    public Map<String, DatasetItem> changeOneValue(Map<String, String> vals, LettoToken token) {
        int id = Integer.parseInt(vals.get("id"));
        int dsNr = Integer.parseInt(vals.get("dsNr"));
        String param = vals.get("param");
        String val = vals.get("val");
        return this.changeOneValue(id, dsNr, param, val, token);
    }

    public Map<String, DatasetItem> changeOneValue(int id, int dsNr, String param, String val, LettoToken token) {
        QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
        QuestionCalc qc = new QuestionCalc(qrender, token.getSchool());
        LicenseKey key = new LicenseKey(this.license);
        LettoConfigDto lettoConfigDto = new LettoConfigDto(key, this.maximaPath, this.lettoMac);
        qc.setLettoConfigDto(lettoConfigDto);
        LinkedHashMap<String, DatasetItem> ret = new LinkedHashMap<String, DatasetItem>();
        qc.getQ().getDatasetDefinitions().stream().filter(ds -> ds.getName().equals(param)).findFirst().ifPresent(d -> {
            CalcParams cp = new CalcParams(ZielEinheit.OPTMODE.NUMERIC, CALCMODE.LOESUNG);
            CalcErgebnis wert = CalcErgebnis.parse((String)val, (CalcParams)cp);
            if (wert instanceof CalcPhysical) {
                wert = wert.rechenEinheit().getOptEinheit().wertToSIwert((CalcNumerical)((CalcPhysical)wert));
            }
            DatasetService.setDatasetItem((DatasetrenderDTO)d, (int)dsNr, (String)(wert instanceof CalcDoubleEinheit ? "" + ((CalcDoubleEinheit)wert).getSIWertD() : wert.toString()));
            String items = d.getItems();
            this.loadDataset(qc, dsNr, "");
            this.calcResults(qc, true, false, token.getSchool());
            for (String name : qc.getVars().getVars().keySet()) {
                CalcErgebnis erg = qc.getVars().getErgebnis(name);
                ret.put(name, new DatasetItem(dsNr, name, erg.toString(), erg.toTex()));
            }
            int i = 0;
            for (SubQuestionRenderDTO sq : qc.getQ().getSubQuestions()) {
                if (sq.getAnswers() == null || sq.getAnswers().size() <= 0) continue;
                String name = sq.getName();
                CalcErgebnis erg = ((QuestionCalc.ErgSubQuestion)qc.getErgebnisse().get(i++)).getSqErgebnis();
                ret.put(name, new DatasetItem(dsNr, name, erg.toString(), erg.toTex()));
            }
            ret.put("ds_item_values_changed", new DatasetItem(dsNr, items, "", ""));
        });
        return ret;
    }

    public List<ZwischenErgebnisDto> loadVarhash(int id, int dsNr, LettoToken token) {
        QuestionRenderDTO q;
        VarHashDto maxima;
        QuestionCache cache = this.getQuestionCache();
        String dataset = cache.loadDataset(id, dsNr, token.getSchool());
        if (dataset == null) {
            this.loadQuestion(id, dsNr, dataset, token);
            dataset = cache.loadDataset(id, dsNr, token.getSchool());
            if (dataset == null) {
                dataset = "";
            }
        }
        VarHashDto varHashDto = maxima = (q = this.loadQuestionRenderDto(id, token)).isPreCalc() ? cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.maxima) : cache.loadVarhashDtoFromCache("", id, token.getSchool(), VarhashMode.maxima);
        if (maxima == null) {
            if (q.isPreCalc()) {
                this.loadQuestion(id, dsNr, "", token);
                maxima = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.maxima);
            } else {
                this.calcMaxima(id, false, token);
                maxima = cache.loadVarhashDtoFromCache("", id, token.getSchool(), VarhashMode.maxima);
            }
            if (maxima == null) {
                throw new MsgException("qservice.err.maxima.varhash");
            }
        }
        CalcParams cp = new CalcParams(ZielEinheit.OPTMODE.NUMERIC);
        VarHashDto vars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.vars);
        if (vars == null) {
            this.loadQuestion(id, dsNr, dataset, token);
            vars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.vars);
        }
        VarHash varhash = new VarHash(vars);
        Vector<ZwischenErgebnisDto> ret = new Vector<ZwischenErgebnisDto>();
        for (String k : maxima.getVars().keySet()) {
            CalcErgebnis erg = CalcErgebnis.parse((CalcErgebnisDto)maxima.getCalcErgebnisDto(k));
            CalcErgebnis val = erg.insertVars(varhash, cp).optimize(cp);
            ret.add(new ZwischenErgebnisDto(k, erg.toTex(), val.toTex()));
        }
        return ret;
    }

    public VarHashes loadVarhashes(int id, int dsNr, LettoToken token) {
        QuestionCache cache = this.getQuestionCache();
        String dataset = cache.loadDataset(id, dsNr, token.getSchool());
        if (dataset == null) {
            this.loadQuestion(id, dsNr, dataset, token);
            dataset = cache.loadDataset(id, dsNr, token.getSchool());
            if (dataset == null) {
                throw new MsgException("qservice.err.datasetNotOk");
            }
        }
        cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.vars);
        VarHashDto vars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.vars);
        VarHashDto cvars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.cvars);
        VarHashDto mvars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.mvars);
        VarHashDto maxima = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.maxima);
        if (vars == null || cvars == null || mvars == null || maxima == null) {
            QuestionRenderDTO qrender = this.loadQuestionRenderDto(id, token);
            PrepareQuest erg = this.prepareQuestion(qrender, dsNr, "", token.getSchool());
            if (erg.qc != null) {
                dataset = erg.qc.getDataset();
                vars = erg.qc.getVars().toVarHashDto(true);
                cvars = erg.qc.getCvars().toVarHashDto(true);
                mvars = erg.qc.getMVars().toVarHashDto(true);
                maxima = erg.qc.getVarsMaxima().toVarHashDto(true);
            } else {
                dataset = cache.loadDataset(id, dsNr, token.getSchool());
                vars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.vars);
                cvars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.cvars);
                mvars = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.mvars);
                maxima = cache.loadVarhashDtoFromCache(dataset, id, token.getSchool(), VarhashMode.maxima);
            }
            if (vars == null || cvars == null || mvars == null) {
                throw new MsgException("qservice.err.questionCalcErrorVarHashes");
            }
        }
        return new VarHashes(id, dsNr, vars, cvars, maxima, mvars);
    }

    public String clearCache(int id, String school, boolean removeQuestionDto) {
        this.getQuestionCache().clearCache(id, school, removeQuestionDto);
        return "";
    }

    public String clearCacheAll(String school, boolean removeQuestionDto) {
        this.getQuestionCache().clearCache(school, removeQuestionDto);
        return "";
    }

    public LettoConfigDto getLettoConfigDto() {
        return this.lettoConfigDto;
    }

    private static /* synthetic */ ClozePart lambda$loadTexte$5(SubQuestionRenderDTO sq) {
        return new ClozePart("", sq);
    }

    private static /* synthetic */ boolean lambda$loadTexte$4(List finalClozeQuestions, SubQuestionRenderDTO sq) {
        return finalClozeQuestions.stream().noneMatch(cq -> cq.getSqName().equals(sq.getName()));
    }
}

