/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.questionservice.service.SchieberSetting;
import at.letto.tools.rest.MsgException;

public class SchieberSetting {
    String min = "Min.";
    double minVal = 0.0;
    String max = "Max.";
    double maxVal = 100.0;

    public SchieberSetting(String inp) {
        if (inp == null || inp.isEmpty()) {
            return;
        }
        String[] x = inp.split(";");
        if (x.length != 2) {
            return;
        }
        Object errMsg = "";
        try {
            Paar p = new Paar(this, x[0]);
            if (p.name != null) {
                this.min = p.name;
                this.minVal = p.val;
            } else {
                errMsg = "Fehlerhafte Minimalwert-Definition: (" + x[0] + ") ";
            }
            p = new Paar(this, x[1]);
            if (p.name != null) {
                this.max = p.name;
                this.maxVal = p.val;
            } else {
                errMsg = (String)errMsg + "Fehlerhafte Maximalwert-Definition: (" + x[1] + ") ";
            }
        }
        catch (Exception e) {
            throw new MsgException("Fehlerhafte Definition der Schiebereinstellungen!");
        }
        if (!((String)errMsg).isEmpty()) {
            throw new MsgException("Fehlerhafte Definition der Schiebereinstellungen!!");
        }
    }

    public String getMin() {
        return this.min;
    }

    public double getMinVal() {
        return this.minVal;
    }

    public String getMax() {
        return this.max;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public void setMinVal(double minVal) {
        this.minVal = minVal;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public void setMaxVal(double maxVal) {
        this.maxVal = maxVal;
    }

    public SchieberSetting() {
    }
}

