/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service.score;

import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortSqDto;
import at.letto.globalinterfaces.LettoVarHash;
import at.letto.math.VarHash;
import at.letto.questionservice.service.cache.QuestionCache;
import at.letto.tools.LicenseKey;

class QuestionVarHashInfo
implements LettoVarHash {
    private long idQuestion;
    private String dataset;
    private int selektor;
    private VarHash schuelerErgebnisse;
    private LicenseKey license;
    private VarHash vars;
    private VarHash studentInputs;
    private QuestionCache cache;
    private String school;

    public VarHash getVars() {
        if (this.vars == null) {
            this.vars = new VarHash();
            VarHash varsQuestion = this.loadVarHash();
            if (varsQuestion != null) {
                this.vars.addHashtableCalcErgebnis(varsQuestion);
            }
            for (String key : this.schuelerErgebnisse.keySet()) {
                this.vars.putGet(this.schuelerErgebnisse, key);
            }
        }
        return this.vars;
    }

    private VarHash loadVarHash() {
        VarHash erg;
        if (this.studentInputs == null) {
            this.studentInputs = new VarHash();
        }
        if ((erg = this.cache.loadVarsFromCache(this.dataset, (int)this.idQuestion, this.school)) != null) {
            this.studentInputs.addHashtableCalcErgebnis(erg);
        }
        return this.studentInputs;
    }

    public void addStudentInputs(TestAntwortDto a) {
        this.studentInputs = new VarHash();
        for (TestAntwortSqDto sqA : a.getSqAntworten()) {
            this.studentInputs.put(sqA.getSq(), sqA.getFirstAnswer().getInput());
        }
    }

    public long getIdQuestion() {
        return this.idQuestion;
    }

    public String getDataset() {
        return this.dataset;
    }

    public int getSelektor() {
        return this.selektor;
    }

    public VarHash getSchuelerErgebnisse() {
        return this.schuelerErgebnisse;
    }

    public LicenseKey getLicense() {
        return this.license;
    }

    public VarHash getStudentInputs() {
        return this.studentInputs;
    }

    public QuestionCache getCache() {
        return this.cache;
    }

    public String getSchool() {
        return this.school;
    }

    public void setIdQuestion(long idQuestion) {
        this.idQuestion = idQuestion;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setSelektor(int selektor) {
        this.selektor = selektor;
    }

    public void setSchuelerErgebnisse(VarHash schuelerErgebnisse) {
        this.schuelerErgebnisse = schuelerErgebnisse;
    }

    public void setLicense(LicenseKey license) {
        this.license = license;
    }

    public void setVars(VarHash vars) {
        this.vars = vars;
    }

    public void setStudentInputs(VarHash studentInputs) {
        this.studentInputs = studentInputs;
    }

    public void setCache(QuestionCache cache) {
        this.cache = cache;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    public QuestionVarHashInfo(long idQuestion, String dataset, int selektor, VarHash schuelerErgebnisse, LicenseKey license, VarHash vars, VarHash studentInputs, QuestionCache cache, String school) {
        this.idQuestion = idQuestion;
        this.dataset = dataset;
        this.selektor = selektor;
        this.schuelerErgebnisse = schuelerErgebnisse;
        this.license = license;
        this.vars = vars;
        this.studentInputs = studentInputs;
        this.cache = cache;
        this.school = school;
    }
}

