/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service.score;

import at.letto.data.dto.enums.AnswerMode;
import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.TestEigenschaftsDto;
import at.letto.data.dto.tests.testAnswer.TestAnswerDetailDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortSqDto;
import at.letto.globalinterfaces.CalcParamsQuestionInfo;
import at.letto.globalinterfaces.LettoPlugin;
import at.letto.globalinterfaces.LettoVarHash;
import at.letto.math.VarHash;
import at.letto.math.calculate.CalcBoolean;
import at.letto.math.calculate.CalcComplex;
import at.letto.math.calculate.CalcComplexEinheit;
import at.letto.math.calculate.CalcDouble;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.CalcError;
import at.letto.math.calculate.CalcLong;
import at.letto.math.calculate.CalcNumerical;
import at.letto.math.calculate.CalcPhysical;
import at.letto.math.calculate.CalcRational;
import at.letto.math.calculate.CalcString;
import at.letto.math.calculate.CalcToleranz;
import at.letto.math.calculate.ParserCache;
import at.letto.math.calculate.ScoreInfoDto;
import at.letto.math.calculate.ScoreTools;
import at.letto.math.calculate.params.CalcParams;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.math.enums.CALCMODE;
import at.letto.plugins.dto.PluginAnswerDto;
import at.letto.plugins.interfaces.PluginDto;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.question.dto.renderedQuestion.html.AnswerHtmlDTO;
import at.letto.question.dto.renderedQuestion.html.Value;
import at.letto.question.dto.score.ScoreInfoMitErgebnis;
import at.letto.question.dto.score.ScoreMultipleQuestions;
import at.letto.question.dto.score.SqErgebnisseText;
import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.dto.renderedQuestion.InputAnswer;
import at.letto.questionservice.dto.renderedQuestion.InputQuestion;
import at.letto.questionservice.dto.renderedQuestion.InputSubQuestion;
import at.letto.questionservice.dto.renderedQuestion.QuestionInfo;
import at.letto.questionservice.dto.score.AntwortMitErgebnis;
import at.letto.questionservice.service.InputQuestionService;
import at.letto.questionservice.service.QuestionCacheService;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.cache.QuestionCache;
import at.letto.questionservice.service.plugins.QuestionPluginService;
import at.letto.questionservice.service.score.CalcParamsQuestionInfoImpl;
import at.letto.questionservice.service.score.QuestionVarHashInfo;
import at.letto.questionservice.service.score.ScoreService;
import at.letto.security.LettoToken;
import at.letto.tools.Cmd;
import at.letto.tools.JSON;
import at.letto.tools.enums.LueckentextMode;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.enums.SQMODE;
import at.letto.tools.enums.Schwierigkeit;
import at.letto.tools.enums.Score;
import at.letto.tools.html.HTMLtool;
import at.letto.tools.threads.LettoTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScoreService {
    @Autowired
    private QuestionRenderService renderService;
    @Autowired
    private QuestionCacheService cacheService;
    @Autowired
    MicroServiceConfiguration mc;

    public QuestionCache getQuestionCache() {
        return this.cacheService.getQuestionCache();
    }

    public TestAntwortDto score(AnswerMode mode, TestAntwortDto a, boolean clearLehrerBeurteilung, LettoToken token) {
        boolean abzugMehrfachbeantwortung = false;
        return this.scoreWithResults(mode, a, clearLehrerBeurteilung, abzugMehrfachbeantwortung, token).getAntwortAufFrage();
    }

    public TestAntwortDto scorePenalty(AnswerMode mode, TestAntwortDto a, boolean clearLehrerBeurteilung, LettoToken token) {
        boolean abzugMehrfachbeantwortung = true;
        return this.scoreWithResults(mode, a, clearLehrerBeurteilung, abzugMehrfachbeantwortung, token).getAntwortAufFrage();
    }

    public List<TestAntwortDto> scoreAll(ScoreMultipleQuestions dto, LettoToken token) {
        AnswerMode mode = dto.getMode();
        List a = dto.getA();
        boolean clearLehrerBeurteilung = dto.isClearLehrerBeurteilung();
        boolean abzugMehrfachbeantwortung = dto.isAbzugMehrfachbeantwortung();
        return a.stream().map(ans -> {
            QuestionInfo qi;
            if (Cmd.isEmpty((String)ans.getDataset())) {
                String dataset = this.renderService.loadDataset(ans.getIdQuestion(), ans.getDsNr(), token);
                ans.setDataset(dataset);
            }
            if ((qi = this.getQuestionCache().loadQuestionInfoFromCache(ans.getDataset(), ans.getIdQuestion(), this.school(token))) == null) {
                this.renderService.loadQuestion(ans.getIdQuestion(), ans.getDsNr(), ans.getDataset(), token);
            }
            return this.scoreWithResults(mode, ans, clearLehrerBeurteilung, abzugMehrfachbeantwortung, token).getAntwortAufFrage();
        }).collect(Collectors.toList());
    }

    public AntwortMitErgebnis scoreWithResults(AnswerMode mode, TestAntwortDto a, boolean clearLehrerBeurteilung, LettoToken token) {
        boolean abzugMehrfachbeantwortung = false;
        return this.scoreWithResults(mode, a, clearLehrerBeurteilung, abzugMehrfachbeantwortung, token);
    }

    public String school(LettoToken token) {
        return token == null ? this.mc.getBaseadress() : (Cmd.isEmpty((String)token.getSchool()) ? this.mc.getBaseadress() : token.getSchool());
    }

    public AntwortMitErgebnis scoreWithResults(AnswerMode mode, TestAntwortDto a, boolean clearLehrerBeurteilung, boolean abzugMehrfachbeantwortung, LettoToken token) {
        try {
            String school = this.school(token);
            school = Cmd.isEmpty((String)school) ? this.mc.getBaseadress() : school;
            double punkte = 0.0;
            ScoreInfoMitErgebnis erg = mode == AnswerMode.beurteilen || mode == AnswerMode.reScore ? this.score(a, abzugMehrfachbeantwortung, token) : null;
            ScoreInfoDto scoreInfo = erg.getScoreInfo();
            if (scoreInfo == null) {
                a.setBewertung(Score.NotScored);
            } else {
                punkte = scoreInfo.punkte;
                a.setBewertung(scoreInfo.status);
            }
            if (mode != AnswerMode.reScore) {
                a.setTimestamp(new Date());
            }
            if (clearLehrerBeurteilung) {
                a.setManuellScored(false);
            }
            a.setPoints(punkte);
            a.setBewertung(scoreInfo != null ? scoreInfo.status : Score.NotScored);
            if (scoreInfo != null) {
                for (ScoreInfoDto sub : scoreInfo.getSubInfo().values()) {
                    a.getSqAntworten().stream().filter(sq -> sq.getSq().equals(sub.getSq())).findFirst().ifPresent(s -> {
                        s.setScoreInfo(sub.getHtmlScoreInfo());
                        s.setFeedback(sub.getFeedback());
                    });
                }
            }
            return new AntwortMitErgebnis(a, erg.getErgebnisse());
        }
        catch (Exception e) {
            System.out.println("");
            return null;
        }
    }

    public ScoreInfoMitErgebnis score(TestAntwortDto inp, boolean abzugMehrfachbeantwortung, LettoToken token) {
        int id = inp.getIdQuestion();
        String dataset = inp.getDataset();
        QuestionInfo qi = this.getQuestionCache().loadQuestionInfoFromCache(dataset, id, this.school(token));
        if (qi == null) {
            QuestionRenderDTO qrender = this.renderService.loadQuestionRenderDto(id, token);
            qi = this.renderService.doPrepareQuestion(qrender, inp.getDsNr(), dataset, this.school(token));
        }
        TestDetailDto d = new TestDetailDto();
        d.setId(-1);
        d.setIdQuestion(id);
        d.setPoints(qi.getErgDto().getPunkte());
        d.setDataset(inp.getDataset());
        d.setSelektor(-1);
        InputQuestion q = InputQuestionService.loadQuestion((TestDetailDto)d, (QuestionInfo)qi, (TestAntwortDto)inp);
        Vector<SqErgebnisseText> ergebnisseText = new Vector<SqErgebnisseText>();
        for (InputSubQuestion sq : q.getSubQuestions()) {
            SqErgebnisseText erg = new SqErgebnisseText(sq.getAngabe().getName(), new Vector());
            erg.getAntworten().addAll(ScoreService.getErgTexte((InputSubQuestion)sq));
            ergebnisseText.add(erg);
        }
        return new ScoreInfoMitErgebnis(this.score(q, abzugMehrfachbeantwortung, token), ergebnisseText);
    }

    public final ScoreInfoDto score(InputQuestion inp, TestEigenschaftsDto test, LettoToken token) {
        return this.score(inp, test.isAbzugBeiMehrfachantwort(), token);
    }

    public final ScoreInfoDto score(InputQuestion inp, boolean abzugMehrfachbeantwortung, LettoToken token) {
        String school = this.school(token);
        QuestionType questionType = inp.getAngabe().getQuestionType();
        TestDetailDto td = inp.getTestDetail();
        if (questionType == QuestionType.MoodleEssay) {
            return new ScoreInfoDto(null, Double.valueOf(0.0), inp.getErgebnis().getPunkte(), Score.NotScored);
        }
        if (questionType != QuestionType.MoodleClozeCalc && questionType != QuestionType.MoodleCloze) {
            if (inp.getErgebnis().getPunkte() < 0.001) {
                inp.getErgebnis().setPunkte(1.0);
            }
            inp.getFirstSubquestion().getErgebnis().setGrade(inp.getErgebnis().getPunkte());
            if (questionType.equals((Object)QuestionType.MoodleMultichoice)) {
                inp.getAngabe().getFirstSubquestion().setMode(SQMODE.MULTICHOICE);
            }
            if (questionType.equals((Object)QuestionType.MoodleMatching)) {
                inp.getAngabe().getFirstSubquestion().setMode(SQMODE.ZUORDNUNG);
            }
        }
        double erg = 0.0;
        double pts = 0.0;
        ScoreInfoDto res = new ScoreInfoDto(null, null, null);
        VarHash schuelerErgebnisse = new VarHash();
        double punkteTestfrage = td.getPoints();
        double pointsQuestion = 0.0;
        for (InputSubQuestion sq2 : inp.getSubQuestions()) {
            if (sq2.getErgebnis() == null) continue;
            pointsQuestion += sq2.getErgebnis().getGrade();
        }
        double korr = 1.0;
        try {
            korr = pointsQuestion == 0.0 ? 1.0 : punkteTestfrage / pointsQuestion;
        }
        catch (Exception exception) {
            // empty catch block
        }
        QuestionVarHashInfo qVars = new QuestionVarHashInfo((long)td.getIdQuestion(), td.getDataset(), td.getSelektor(), schuelerErgebnisse, td.getLicence(), null, null, this.getQuestionCache(), school);
        qVars.addStudentInputs(inp.getInput());
        boolean penalty = abzugMehrfachbeantwortung && !Cmd.isEmpty((String)inp.getErgebnis().getAbzug());
        Vector sqs = new Vector();
        inp.getErgebnis().getErgSubquestions().stream().map(sq -> sq.getSqName()).forEach(name -> {
            try {
                Optional<InputSubQuestion> tf = inp.getSubQuestions().stream().filter(s -> s.getErgebnis() != null && name.equals(s.getErgebnis().getSqName())).findFirst();
                tf.map(t -> sqs.add(t));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        for (InputSubQuestion sq3 : sqs) {
            if (sq3.getErgebnis() == null) continue;
            ScoreInfoDto i2 = this.scoreSubquestion(sq3, korr, td, qVars, abzugMehrfachbeantwortung, school);
            erg += i2.punkte.doubleValue();
            pts += i2.sollpunkte.doubleValue();
            if (!(i2.getSchuelerErgebnis() == null || i2.getSchuelerErgebnis() instanceof CalcString && i2.getSchuelerErgebnis().toStringUnquoted().trim().length() == 0)) {
                schuelerErgebnisse.put(sq3.getAngabe().getName(), i2.getSchuelerErgebnis());
                qVars.getVars();
                qVars.getVars().put(sq3.getAngabe().getName(), i2.getSchuelerErgebnis());
            }
            i2.sq = sq3.getAngabe().getName();
            res.subInfo.put(sq3.getAngabe().getName(), i2);
            if (i2.status == Score.ANGABEFEHLER_EH) {
                res.status = i2.status;
            }
            if (sq3.getAngabe().getMode() != SQMODE.PLUGIN && sq3.getAngabe().getMode() != SQMODE.BOOLSCH) continue;
            sq3.getInput().setScoreText(i2.getHtmlScoreInfo());
        }
        res.punkte = pts - erg < 0.015 ? pts : erg;
        res.sollpunkte = pts;
        if (res.status == null || res.status != Score.ANGABEFEHLER_EH) {
            if (inp.getErgebnis().isStreng() && !res.subInfo.values().stream().anyMatch(i -> i.status == Score.MEHRFACHANTWORT_OK || i.status == Score.OK) && res.punkte < 0.99 * res.sollpunkte) {
                res.punkte = 0.0;
            }
            res.status = Score.OK;
            if (pts > 0.0 && res.punkte == 0.0) {
                res.status = Score.FALSCH;
            } else if (pts > res.punkte) {
                res.status = Score.TEILWEISE_OK;
            }
            if (res.subInfo.values().stream().allMatch(i -> Score.MEHRFACHANTWORT_OK.equals((Object)i.status) || Score.OK.equals((Object)i.status))) {
                res.status = Score.OK;
            }
        }
        for (ScoreInfoDto si : res.subInfo.values()) {
            if (si.getStatus() == null || si.getStatus() != Score.ANGABEFEHLER_EH) continue;
            res.status = Score.ANGABEFEHLER_EH;
            break;
        }
        return res;
    }

    public ScoreInfoDto scoreSubquestion(InputSubQuestion sq, double korr, TestDetailDto td, QuestionVarHashInfo varsQuestion, boolean abzugMehrfachbeantwortung, String school) {
        Object sqInfo;
        ScoreInfoDto ret = null;
        double grade = sq.getErgebnis().getGrade();
        String inp = ScoreService.getAnswerTextSubQuest((InputSubQuestion)sq);
        ret = this.score(inp, td, varsQuestion, sq, school);
        sq.scored = ret.getStatus();
        double soll = grade * korr;
        double ist = ret.getPunkte() * korr;
        ret.setPunkte(Double.valueOf(ist));
        ret.setSollpunkte(Double.valueOf(soll));
        TestAntwortSqDto tas = sq.getInput();
        TestAntwortSqDto tasOld = sq.getInputOld();
        tas.setSoll(Double.valueOf(soll));
        tas.setIst(Double.valueOf(ist));
        tas.setOrigIst(Double.valueOf(ist));
        tas.setScored(ret.getStatus());
        tas.setScoreText(ret.getHtmlScoreInfo());
        tas.setLehrerScored(false);
        if (!Cmd.isEmpty((String)inp)) {
            try {
                String oldAnswer = ScoreService.getAnswerTextSubQuest((TestAntwortSqDto)tasOld);
                if (oldAnswer != null) {
                    oldAnswer = oldAnswer.replaceAll("<n>", "");
                }
                if (!oldAnswer.equals(inp)) {
                    tas.setScoreAnzahl(tas.getScoreAnzahl() + 1);
                }
            }
            catch (Exception e) {
                tas.setScoreAnzahl(tas.getScoreAnzahl() + 1);
            }
        }
        if (tas.getScoreAnzahl() < 2) {
            return ret;
        }
        if (!abzugMehrfachbeantwortung) {
            return ret;
        }
        if (abzugMehrfachbeantwortung && ist > 0.0 && tas.getScoreAnzahl() > 0) {
            double orig;
            double penalty;
            String abzug = sq.getParent().getErgebnis().getAbzug();
            if (abzug == null || abzug.trim().isEmpty()) {
                abzug = "0";
            }
            try {
                penalty = new CalcToleranz(abzug).getToleranz();
            }
            catch (Exception e) {
                penalty = 0.0;
            }
            if (penalty <= 0.0) {
                return ret;
            }
            double proz = (double)(tas.getScoreAnzahl() - 1) * penalty;
            if (proz > 1.0) {
                proz = 1.0;
            }
            if (proz < 0.0) {
                proz = 0.0;
            }
            if (tasOld.getIst() == null) {
                tasOld.setIst(Double.valueOf(0.0));
            }
            if (tasOld.getOrigIst() == null) {
                tasOld.setOrigIst(Double.valueOf(0.0));
            }
            if (tas.getSoll() == null) {
                tas.setSoll(Double.valueOf(0.0));
            }
            if ((orig = tasOld.getOrigIst().doubleValue()) < tasOld.getIst()) {
                orig = tasOld.getIst();
            }
            ist = orig <= ist ? tasOld.getIst() + (ist - orig) * (1.0 - proz) : (ist < tas.getSoll() ? (ist *= 1.0 - proz) : tas.getSoll());
            if (ist < 0.0) {
                ist = 0.0;
            }
            if (ist > soll) {
                ist = soll;
            }
            if (penalty > 0.0) {
                if (ist > tas.getOrigIst() * 0.99999) {
                    ret.setStatus(Score.OK);
                } else {
                    ret.setStatus(tas.getOrigIst() >= tas.getSoll() * 0.99 ? Score.MEHRFACHANTWORT_OK : Score.MEHRFACHANTWORT_TW_RICHTIG);
                    tas.setScoreInfo(String.format(" (-%.0f%%)", proz * 100.0));
                }
            }
            tas.setScored(ret.getStatus());
            tas.setIst(Double.valueOf(ist));
        }
        if ((sqInfo = tas.getScoreInfo()) != null && !((String)sqInfo).isEmpty()) {
            sqInfo = (String)sqInfo + "\n";
        }
        sqInfo = (String)sqInfo + ret.getHtmlScoreInfo();
        tas.setScoreInfo((String)sqInfo);
        ret.setPunkte(Double.valueOf(ist));
        sq.scored = ret.getStatus();
        return ret;
    }

    public ScoreInfoDto score(String inp, TestDetailDto td, QuestionVarHashInfo varsQuestion, InputSubQuestion sq, String school) {
        String serverEingabe = inp;
        CalcParams cp = new CalcParams(ZielEinheit.OPTMODE.NONE, CALCMODE.EQUALS);
        ScoreInfoDto ret = null;
        SQMODE mode = sq.getAngabe().getMode();
        if (mode == null) {
            return null;
        }
        double grade = sq.getErgebnis().getGrade();
        switch (1.$SwitchMap$at$letto$tools$enums$SQMODE[mode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                ret = null;
                CalcErgebnis eingabewert = null;
                for (InputAnswer a2 : sq.getAnswers()) {
                    try {
                        CalcToleranz toleranz = a2.getErg().getToleranz();
                        CalcErgebnis wert = a2.getErg().getErg();
                        String ausdruck = a2.getErg().getText();
                        boolean schuelerErgebnisseEinsetzen = false;
                        if (!sq.getParent().getErgebnis().getLettoDatasetDefinitions().stream().anyMatch(ds -> ds.getName().matches("Q\\d"))) {
                            for (String vn : varsQuestion.getSchuelerErgebnisse().keySet()) {
                                if (!a2.getErg().getText().contains(vn)) continue;
                                schuelerErgebnisseEinsetzen = true;
                            }
                        }
                        if (schuelerErgebnisseEinsetzen) {
                            ZielEinheit ze = new ZielEinheit();
                            try {
                                ze = a2.getErg().getZielEinheit();
                            }
                            catch (Exception vn) {
                                // empty catch block
                            }
                            wert = this.getLoesung(varsQuestion.getVars(), ausdruck, ze, toleranz, sq.getParent(), school);
                            if (!wert.isNumeric()) {
                                CalcParamsQuestionInfoImpl qp = new CalcParamsQuestionInfoImpl(sq.getParent(), this.getQuestionCache(), school, this.renderService.getLettoConfigDto());
                                wert = wert.optimize(varsQuestion.getVars(), new CalcParams(ZielEinheit.OPTMODE.FULL, CALCMODE.EQUALS, toleranz, (CalcParamsQuestionInfo)qp));
                            }
                        }
                        if (wert != null && !(wert instanceof CalcError)) {
                            ScoreInfoDto info = this.scoreAnswer(sq, serverEingabe, wert, a2.getErg().getEinheit(), grade * a2.getErg().getFraction() / 100.0, toleranz);
                            eingabewert = info.getSchuelerErgebnis();
                            if (info.status == Score.NichtEntschieden || schuelerErgebnisseEinsetzen && !(info.punkte > 0.02)) continue;
                            if (info.status == Score.EINHEITENFEHLER || info.status == Score.EINHEITENFEHLER_Lehrer || info.status == Score.FALSCH_Lehrer && !schuelerErgebnisseEinsetzen) {
                                return info;
                            }
                            ret = info;
                            ret.setHtmlScoreInfo(a2.getErg().getFeedback());
                            ret.status = ret.punkte > 0.98 * grade ? Score.OK : (ret.punkte > 0.02 ? Score.TEILWEISE_OK : Score.FALSCH);
                            ret.feedback = a2.getErg().getFeedback();
                            return ret;
                        }
                        if (schuelerErgebnisseEinsetzen) continue;
                        return new ScoreInfoDto(eingabewert == null ? CalcErgebnis.parse((String)inp, (CalcParams)cp) : eingabewert, new ZielEinheit(), 0.0, grade, Score.ANGABEFEHLER_EH, a2.getErg().getFeedback());
                    }
                    catch (Exception toleranz) {
                    }
                }
                try {
                    varsQuestion.getVars().put(sq.getAngabe().getName(), eingabewert);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new ScoreInfoDto(eingabewert == null ? CalcErgebnis.parse((String)inp, (CalcParams)cp) : eingabewert, new ZielEinheit(), 0.0, grade, Score.FALSCH);
            }
            case 4: {
                double proz = 0.0;
                String ans = "";
                try {
                    ans = sq.getInput().getFirstAnswer().getInput();
                }
                catch (Exception wert) {
                    // empty catch block
                }
                for (InputAnswer a3 : sq.getAnswers()) {
                    int erg = (int)a3.getErg().getFraction();
                    if (!a3.getErg().getText().trim().equals(ans)) continue;
                    proz = erg;
                    break;
                }
                return new ScoreInfoDto((CalcErgebnis)new CalcString(serverEingabe), proz, grade);
            }
            case 5: {
                double proz = 0.0;
                for (InputAnswer a4 : sq.getAnswers()) {
                    int erg = (int)a4.getErg().getFraction();
                    if (sq.getErgebnis().getSchwierigkeit() == Schwierigkeit.Streng && (a4.getInput().isServerCB() && erg == 0 || !a4.getInput().isServerCB() && erg > 0)) {
                        proz = -100.0;
                        break;
                    }
                    proz += a4.getInput().isServerCB() ? (double)erg : 0.0;
                }
                return new ScoreInfoDto((CalcErgebnis)new CalcString(serverEingabe), proz, grade);
            }
            case 6: {
                for (InputAnswer a5 : sq.getAnswers()) {
                    try {
                        Matcher m;
                        ZielEinheit ze;
                        double points = grade * a5.getErg().getFraction() / 100.0;
                        Score sc = a5.getErg().getFraction() > 98.0 ? Score.OK : (a5.getErg().getFraction() > 2.0 ? Score.TEILWEISE_OK : Score.FALSCH);
                        try {
                            ze = new ZielEinheit(a5.getErg().getEinheit());
                        }
                        catch (Exception e) {
                            ze = new ZielEinheit();
                        }
                        String loesung = a5.getErg().getText();
                        serverEingabe = serverEingabe.trim().replaceAll("\\s+", " ");
                        if (ze.getForce() == ZielEinheit.FORCEMODE.FORCE && ze.getMode() == ZielEinheit.MODE.NORMAL) {
                            m = Pattern.compile("^" + loesung + "$", 296).matcher(serverEingabe);
                        } else {
                            loesung = loesung.replaceAll("[\u00fc\u00fc]", "(\u00fc|(ue))").replaceAll("[\u00e4\u00c4]", "(\u00e4|(ae))").replaceAll("[\u00f6\u00d6]", "(\u00f6|(oe))").replaceAll("\u00df", "(\u00df|(sz)|(ss))");
                            m = Pattern.compile("^" + loesung + "$", 298).matcher(serverEingabe);
                        }
                        if (!m.find()) continue;
                        return new ScoreInfoDto((CalcErgebnis)new CalcString(serverEingabe), new ZielEinheit(), points, points, sc);
                    }
                    catch (Exception points) {
                    }
                }
                return new ScoreInfoDto((CalcErgebnis)new CalcString(inp), new ZielEinheit(), 0.0, grade, Score.FALSCH);
            }
            case 7: {
                for (InputAnswer a6 : sq.getAnswers()) {
                    CalcToleranz toleranz = a6.getErg().getToleranz();
                    try {
                        LettoPlugin lpi = this.getPlugin(sq);
                        PluginDto pluginDto = (PluginDto)JSON.jsonToObj((String)sq.getAngabe().getPluginDto(), PluginDto.class);
                        PluginAnswerDto pluginAnswerDto = a6.toPluginAnswerDto(lpi.isAllowJson());
                        ScoreInfoDto info = lpi.score(pluginDto, serverEingabe, toleranz, (LettoVarHash)varsQuestion, pluginAnswerDto, grade * a6.getErg().getFraction() / 100.0);
                        try {
                            varsQuestion.getVars().put(sq.getAngabe().getName(), info.getSchuelerErgebnis());
                        }
                        catch (Exception m) {
                            // empty catch block
                        }
                        if (info.status == Score.NichtEntschieden) continue;
                        ret = info;
                        ret.status = ret.punkte > 0.98 * grade ? Score.OK : (ret.punkte > 0.02 ? Score.TEILWEISE_OK : Score.FALSCH);
                        if (info.status == Score.FALSCH) continue;
                        return ret;
                    }
                    catch (Exception e) {
                        ret = new ScoreInfoDto((CalcErgebnis)new CalcString(inp), new ZielEinheit(), 0.0, grade, Score.FALSCH);
                    }
                }
                if (ret != null) {
                    return ret;
                }
                return new ScoreInfoDto((CalcErgebnis)new CalcString(inp), new ZielEinheit(), 0.0, grade, Score.FALSCH);
            }
            case 8: {
                Score sc;
                double points;
                serverEingabe = serverEingabe.trim().replaceAll("\\s+", " ");
                try {
                    varsQuestion.getVars().put(sq.getAngabe().getName(), serverEingabe);
                }
                catch (Exception wert) {
                    // empty catch block
                }
                boolean hasLoesung = false;
                for (InputAnswer a7 : sq.getAnswers()) {
                    points = grade * a7.getErg().getFraction() / 100.0;
                    sc = a7.getErg().getFraction() > 98.0 ? Score.OK : (a7.getErg().getFraction() > 2.0 ? Score.TEILWEISE_OK : Score.FALSCH);
                    String loesung = a7.getErg().getText().trim().replaceAll("\\s+", " ");
                    if ((loesung = HTMLtool.XMLToString((String)loesung)).length() <= 0) continue;
                    hasLoesung = true;
                    if (!serverEingabe.equals(loesung)) continue;
                    return new ScoreInfoDto((CalcErgebnis)new CalcString(serverEingabe), new ZielEinheit(), points, grade, sc);
                }
                for (InputAnswer a7 : sq.getAnswers()) {
                    ZielEinheit ze;
                    points = grade * a7.getErg().getFraction() / 100.0;
                    sc = a7.getErg().getFraction() > 98.0 ? Score.OK : (a7.getErg().getFraction() > 2.0 ? Score.TEILWEISE_OK : Score.FALSCH);
                    try {
                        ze = new ZielEinheit(a7.getErg().getEinheit());
                    }
                    catch (Exception e) {
                        ze = new ZielEinheit();
                    }
                    String loesung = a7.getErg().getText().trim().replaceAll("\\s+", " ");
                    if (sq.getParent().getAngabe().getQuestionType() == QuestionType.MoodleCloze && sq.getParent().getAngabe().getSingle() == LueckentextMode.DragAndDrop) {
                        ze.setForce(ZielEinheit.FORCEMODE.FORCE);
                    }
                    if (loesung.length() <= 0) continue;
                    if ((ze.getForce() != ZielEinheit.FORCEMODE.FORCE || ze.getMode() != ZielEinheit.MODE.NORMAL) && serverEingabe.equalsIgnoreCase(loesung) || serverEingabe.equals(loesung)) {
                        return new ScoreInfoDto((CalcErgebnis)new CalcString(serverEingabe), new ZielEinheit(), points, grade, sc);
                    }
                    if (ze.getForce() != ZielEinheit.FORCEMODE.FORCE || ze.getMode() != ZielEinheit.MODE.NORMAL || !serverEingabe.equals(loesung)) continue;
                    return new ScoreInfoDto((CalcErgebnis)new CalcString(serverEingabe), new ZielEinheit(), points, grade, sc);
                }
                if (hasLoesung) {
                    return new ScoreInfoDto((CalcErgebnis)new CalcString(inp), new ZielEinheit(), 0.0, grade, Score.FALSCH);
                }
                return new ScoreInfoDto((CalcErgebnis)new CalcString(inp), new ZielEinheit(), 0.0, grade, Score.NotScored);
            }
            case 9: {
                for (InputAnswer a8 : sq.getAnswers()) {
                    try {
                        CalcToleranz toleranz = a8.getErg().getToleranz();
                        String ausdruck = a8.getErg().getText();
                        ZielEinheit ze = new ZielEinheit();
                        CalcToleranz tol = a8.getErg().getToleranz();
                        CalcErgebnis wert = this.getLoesung(varsQuestion.getVars(), ausdruck, ze, tol, sq.getParent(), school);
                        if (!wert.isNumeric()) {
                            CalcParamsQuestionInfoImpl qp = new CalcParamsQuestionInfoImpl(sq.getParent(), this.getQuestionCache(), school, this.renderService.getLettoConfigDto());
                            wert = wert.optimize(varsQuestion.getVars(), new CalcParams(ZielEinheit.OPTMODE.FULL, CALCMODE.EQUALS, toleranz, (CalcParamsQuestionInfo)qp));
                        }
                        ScoreInfoDto info = new ScoreInfoDto(wert, new ZielEinheit("symbolic"), 0.0, grade, Score.FALSCH);
                        String scinfo = a8.getHtml().getHtmlAnswer();
                        if (scinfo.trim().length() == 0) {
                            scinfo = ((InputAnswer)sq.getAnswers().get(0)).getHtml().getHtmlAnswer();
                        }
                        info.setHtmlScoreInfo(scinfo);
                        if (!(wert instanceof CalcBoolean) || !((CalcBoolean)wert).toBoolean()) continue;
                        info.punkte = grade * a8.getErg().getFraction() / 100.0;
                        info.status = a8.getErg().getFraction() < 95.0 ? Score.TEILWEISE_OK : Score.OK;
                        ret = info;
                        break;
                    }
                    catch (Exception toleranz) {
                    }
                }
                if (ret == null) {
                    ret = new ScoreInfoDto(null, Double.valueOf(0.0), Score.FALSCH);
                }
                if (ret.getHtmlScoreInfo().isEmpty()) {
                    ret.setHtmlScoreInfo(((AnswerHtmlDTO)sq.getAngabe().getAnswers().get(0)).getHtmlAnswer());
                }
                return ret;
            }
            case 10: 
            case 11: {
                return new ScoreInfoDto(null, Double.valueOf(0.0), Score.NotScored);
            }
            case 12: {
                return new ScoreInfoDto(null, Double.valueOf(sq.getErgebnis().getGrade()), Score.OK);
            }
            case 13: {
                double proz;
                boolean k = false;
                int anzL = sq.getMatchingInfos().getLeft().size();
                long anz = sq.getAnswers().stream().filter(a -> !Cmd.isEmpty((String)a.getHtml().getHtmlAnswer()) && !Cmd.isEmpty((String)a.getHtml().getHtmlText())).count();
                double pts = 1.0 / (double)anz;
                double erg = 0.0;
                for (InputAnswer a9 : sq.getMatchingInfos().getAnswered()) {
                    String input = a9.getInput().getInput();
                    if (sq.getAngabe().getAnswers().stream().anyMatch(a1 -> a1.getShortAnswer().equals(input) && a1.getHtmlText().equals(a9.getHtmlText()))) {
                        erg += pts;
                        continue;
                    }
                    Schwierigkeit schw = a9.getParent().getErgebnis().getSchwierigkeit();
                    if (schw == null) {
                        schw = Schwierigkeit.Normal;
                    }
                    switch (1.$SwitchMap$at$letto$tools$enums$Schwierigkeit[schw.ordinal()]) {
                        case 1: {
                            erg -= (double)k * pts;
                            break;
                        }
                        case 2: {
                            erg -= 10000.0;
                            break;
                        }
                        case 3: {
                            erg -= pts;
                        }
                    }
                }
                double d = proz = erg > 0.0 ? 100.0 * erg : 0.0;
                if (sq.getErgebnis().getSchwierigkeit() == Schwierigkeit.Streng && proz < 99.0) {
                    proz = 0.0;
                }
                return new ScoreInfoDto(null, proz, grade);
            }
        }
        return new ScoreInfoDto(null, Double.valueOf(0.0), Score.NotScored);
    }

    public CalcErgebnis getLoesung(VarHash ds, String loesung, ZielEinheit zielEinheit, CalcToleranz toleranz, InputQuestion q, String school) {
        VarHash vars;
        CalcError erg = null;
        CalcParamsQuestionInfoImpl qp = new CalcParamsQuestionInfoImpl(q, this.getQuestionCache(), school, this.renderService.getLettoConfigDto());
        CalcParams cp = new CalcParams(zielEinheit.calcOptmodeLoesung(), CALCMODE.LOESUNG, toleranz, (CalcParamsQuestionInfo)qp, true, q.getErgebnis().isUseSymbolicMode());
        try {
            vars = zielEinheit.getVars(ds);
            for (String key : ds.keySet()) {
                if (!key.matches("^Q\\d+$") || vars.containsKey(key)) continue;
                vars.putGet(ds, key);
            }
            vars.addHashtableCalcErgebnis(q.getErgebnis().getMaximaConst());
            cp = cp.setVars(vars);
            cp = cp.setSymbolicMode(zielEinheit.isSuchMuster() || q.getErgebnis().isUseSymbolicMode());
            erg = ParserCache.getCache().calculate(loesung, vars, cp);
        }
        catch (Exception e) {
            erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, e.getMessage());
        }
        LettoTimer.checkInterrupt();
        switch (1.$SwitchMap$at$letto$math$einheiten$ZielEinheit$MODE[zielEinheit.getMode().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (erg != null && erg instanceof CalcLong) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Im Einheiten Mode " + zielEinheit.getMode() + " muss das Ergebnis eine Ganzzahl sein!");
                break;
            }
            case 5: {
                if (erg != null && erg instanceof CalcLong || erg instanceof CalcRational) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Im Einheiten Mode " + zielEinheit.getMode() + " muss das Ergebnis eine Ganzzahl oder ein Bruch von Ganzzahlen sein!");
                break;
            }
            case 6: {
                if (erg != null && erg instanceof CalcNumerical) {
                    if (erg instanceof CalcComplexEinheit || erg instanceof CalcComplex) {
                        erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "komplexe Zahl ist nicht als Farbcode interpretierbar!");
                    }
                    erg = new CalcDouble(erg.toDouble());
                    break;
                }
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Ergebnis ist nicht als Farbcode interpretierbar!");
                break;
            }
            case 7: {
                if (!(erg instanceof CalcNumerical)) {
                    erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                }
                if (!(erg instanceof CalcPhysical)) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert ohne Einheit sein!");
                break;
            }
            case 8: {
                if (erg != null) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                break;
            }
            case 9: {
                if (erg instanceof CalcNumerical) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                break;
            }
        }
        if (zielEinheit.isSuchMuster() && !zielEinheit.testSchuelereingabeSuchmuster(erg.toString())) {
            try {
                vars = zielEinheit.getVars(ds);
                vars.addHashtableCalcErgebnis(q.getErgebnis().getMaximaConst());
                erg = ParserCache.getCache().calculate(loesung, vars, cp);
                if (!zielEinheit.testSchuelereingabeSuchmuster(erg.toString())) {
                    erg = new CalcError(CalcError.Fehler.MUSTERFEHLER, erg.toString() + "<->" + zielEinheit.calcSuchmuster());
                }
            }
            catch (Exception e) {
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, e.getMessage());
            }
        }
        List letto_ds = q.getErgebnis().getLettoDatasetDefinitions().stream().map(d -> d).collect(Collectors.toList());
        zielEinheit.addDatasets(letto_ds);
        erg = erg.setZielEinheit(zielEinheit);
        return erg;
    }

    public ScoreInfoDto scoreAnswer(InputSubQuestion sq, String serverEingabeString, CalcErgebnis wert, String einheit, double points, CalcToleranz toleranz) {
        ScoreInfoDto info;
        ZielEinheit ze = new ZielEinheit();
        try {
            ze = new ZielEinheit(einheit);
            CalcErgebnis eingabeErgebnis = this.parseAnswer(sq, serverEingabeString, wert, ze, false);
            info = this.scoreAnswer(sq, serverEingabeString, eingabeErgebnis, wert, ze, points, toleranz);
        }
        catch (Exception e) {
            info = new ScoreInfoDto((CalcErgebnis)new CalcString(serverEingabeString), new ZielEinheit(), 0.0, points, Score.EINHEITENFEHLER_Lehrer);
        }
        return info;
    }

    public ScoreInfoDto scoreAnswer(InputSubQuestion sq, String serverEingabeString, CalcErgebnis serverEingabe, CalcErgebnis wert, ZielEinheit ze, double points, CalcToleranz toleranz) {
        ScoreInfoDto dto = ScoreTools.scoreAnswer((String)serverEingabeString, (CalcErgebnis)serverEingabe, (CalcErgebnis)wert, (ZielEinheit)ze, (double)points, (CalcToleranz)toleranz, null, (double)sq.getParent().getErgebnis().getUnitPenalty(), (boolean)sq.getParent().getErgebnis().isUseSymbolicMode());
        return dto;
    }

    public CalcErgebnis parseAnswer(InputSubQuestion sq, String serverEingabe, CalcErgebnis wert, ZielEinheit ze, boolean vorschau) {
        CalcErgebnis a = ScoreTools.parseAnswer((String)serverEingabe, (CalcErgebnis)wert, (ZielEinheit)ze, (boolean)vorschau, null);
        return a;
    }

    public LettoPlugin getPlugin(InputSubQuestion sq) {
        QuestionPluginService plugin = (QuestionPluginService)sq.getAngabe().getPlugin();
        plugin.setPm(this.mc.getPluginManagerService());
        return sq.getAngabe().getPlugin();
    }

    public static String getAnswerTextSubQuest(InputSubQuestion sq) {
        InputQuestion parent = sq.getParent();
        SQMODE mode = sq.getAngabe().getMode();
        if (parent != null && parent.getAngabe().getQuestionType() == QuestionType.MoodleCalculated_Multi) {
            StringBuilder sb = new StringBuilder();
            for (InputAnswer a : sq.getAnswers()) {
                if (sb.length() > 0) {
                    sb.append("<n>");
                }
                sb.append(a.getInput().getInput());
            }
            return sb.toString();
        }
        if (mode == SQMODE.ZUORDNUNG) {
            StringBuilder s = new StringBuilder();
            int i = 0;
            boolean answerd = false;
            for (InputAnswer an : sq.getMatchingInfo().getLeftUnsorted()) {
                String ans;
                if (i > 0) {
                    s.append("<n>");
                }
                if ((ans = an.getInput().getInput()) != null && !ans.isEmpty()) {
                    answerd = true;
                }
                s.append(ans);
                ++i;
            }
            if (!answerd) {
                return "";
            }
            return s.toString() + ":Rf:" + Arrays.toString(sq.getReihenfolgeLinks()) + Arrays.toString(sq.getReihenfolgeRechts());
        }
        if (mode == SQMODE.MULTIPLECALC || mode == SQMODE.MULTIPLETEXT) {
            StringBuilder s = new StringBuilder();
            boolean empty = true;
            for (InputAnswer a : sq.getAnswers()) {
                if (a.getInput().getInput() != null && !a.getInput().getInput().isEmpty()) {
                    empty = false;
                    break;
                }
                if (empty) continue;
                break;
            }
            for (InputAnswer a : sq.getAnswers()) {
                if (s.length() > 0) {
                    s.append("<n>");
                }
                s.append(a.getInput().getInput());
            }
            if (empty) {
                return "";
            }
            return s.toString();
        }
        if (mode == SQMODE.MULTICHOICE) {
            StringBuilder s = new StringBuilder();
            boolean empty = true;
            for (InputAnswer a : sq.getAnswers()) {
                if (a.getInput().isServerCB()) {
                    empty = false;
                    break;
                }
                if (empty) continue;
                break;
            }
            for (InputAnswer a : sq.getAnswers()) {
                if (a.getInput().isServerCB()) {
                    empty = false;
                }
                if (s.length() > 0) {
                    s.append("<n>");
                }
                s.append(a.getInput().isServerCB() ? 1 : 0);
            }
            if (empty) {
                return "";
            }
            return s.toString();
        }
        if (sq.getAngabe().getMatrixInp() != null) {
            ((InputAnswer)sq.getAnswers().get(0)).getInput().setInput(ScoreService.matrixInputToString((InputSubQuestion)sq));
        }
        try {
            return ((InputAnswer)sq.getAnswers().get(0)).getInput().getInput();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getAnswerTextSubQuest(TestAntwortSqDto sq) {
        TestAntwortDto parent = sq.getParent();
        StringBuilder sb = new StringBuilder();
        boolean allEmpty = true;
        int i = 0;
        for (TestAnswerDetailDto a : sq.getAntworten()) {
            if (i++ > 0) {
                sb.append("<n>");
            }
            if (!Cmd.isEmpty((String)a.getInput()) && !a.getInput().equals("0")) {
                allEmpty = false;
            }
            sb.append(a.getInput());
        }
        return allEmpty ? "" : sb.toString();
    }

    public boolean isPluginJSF(InputSubQuestion sq) {
        return false;
    }

    public static String matrixInputToString(InputSubQuestion sq) {
        List matrixInp = sq.getAngabe().getMatrixInp();
        if (matrixInp == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (List line : matrixInp) {
            if (sb.length() > 0) {
                sb.append(",");
            } else {
                sb.append("[");
            }
            StringBuilder l = new StringBuilder();
            for (Value el : line) {
                if (l.length() > 0) {
                    l.append(",");
                } else {
                    l.append("[");
                }
                l.append(el.getVal());
            }
            l.append("]");
            sb.append((CharSequence)l);
        }
        sb.append("]");
        return sb.toString();
    }

    public String getUserInput(InputSubQuestion sq, TestAntwortSqDto tas) {
        if (sq.getInput() == null) {
            return "";
        }
        String answerText = tas.getFirstAnswer().getInput();
        if (answerText == null) {
            return "";
        }
        String[] erg = answerText.split("<c>");
        int pos = sq.getParent().getSubQuestions().indexOf(sq);
        if (pos < erg.length) {
            return erg[pos];
        }
        return "";
    }

    public static String getAnswerText(TestAntwortDto a) {
        boolean empty = true;
        String erg = a.getSqAntworten().stream().filter(sq -> !Cmd.isEmpty((String)sq.getSq())).map(sq -> ScoreService.getAnswerTextSubQuest((TestAntwortSqDto)sq)).collect(Collectors.joining("<c>"));
        if (erg.length() == 0) {
            return "";
        }
        return "inp:" + erg.trim();
    }

    public static List<String> getErgTexte(InputSubQuestion sq) {
        ArrayList<String> ret = new ArrayList<String>();
        SQMODE mode = sq.getAngabe().getMode();
        if (sq.getAnswers() != null) {
            for (InputAnswer a : sq.getAnswers()) {
                Object txt = "";
                try {
                    if (mode == SQMODE.CALCULATED || mode == SQMODE.SCHIEBER || mode == SQMODE.TEXT) {
                        CalcErgebnis erg = a.getErg().getErg();
                        if (erg == null) break;
                        ZielEinheit ze = new ZielEinheit(a.getErg().getEinheit());
                        List letto_ds = sq.getParent().getErgebnis().getLettoDatasetDefinitions().stream().map(d -> d).collect(Collectors.toList());
                        ze.addDatasets(letto_ds);
                        if (erg instanceof CalcComplex) {
                            ze.setComplexMode(ZielEinheit.COMPLEXMODE.kart);
                            txt = "$" + erg.toTex(ze) + "$";
                            ze.setComplexMode(ZielEinheit.COMPLEXMODE.poldeg);
                            txt = (String)txt + "; $" + erg.toTex(ze) + "$";
                        } else {
                            txt = "$" + erg.toTex(ze) + "$";
                        }
                        if (ret.contains(txt)) continue;
                        ret.add((String)txt);
                        continue;
                    }
                    if (mode == SQMODE.SINGLECHOICE) {
                        if (!(a.getErg().getFraction() > 99.99) || ret.contains(txt = a.getErg().getText())) continue;
                        ret.add((String)txt);
                        continue;
                    }
                    if (mode == SQMODE.MULTICHOICE) {
                        ret.add(a.getErg().getFraction() > 0.0 ? "1" : "0");
                        continue;
                    }
                    if (mode == SQMODE.ZUORDNUNG) {
                        ret.add(a.getHtml().getShortAnswer());
                        continue;
                    }
                    double proz = 0.0;
                    for (InputAnswer ans : sq.getAnswers()) {
                        txt = ans.getErg().getFraction() >= proz ? ans.getHtml().getHtmlAnswer() : txt;
                        proz = ans.getErg().getFraction() > proz ? ans.getErg().getFraction() : proz;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        return ret;
    }

    public QuestionRenderService getRenderService() {
        return this.renderService;
    }

    public QuestionCacheService getCacheService() {
        return this.cacheService;
    }

    public MicroServiceConfiguration getMc() {
        return this.mc;
    }

    public void setRenderService(QuestionRenderService renderService) {
        this.renderService = renderService;
    }

    public void setCacheService(QuestionCacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setMc(MicroServiceConfiguration mc) {
        this.mc = mc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreService)) {
            return false;
        }
        ScoreService other = (ScoreService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        QuestionRenderService this$renderService = this.getRenderService();
        QuestionRenderService other$renderService = other.getRenderService();
        if (this$renderService == null ? other$renderService != null : !this$renderService.equals(other$renderService)) {
            return false;
        }
        QuestionCacheService this$cacheService = this.getCacheService();
        QuestionCacheService other$cacheService = other.getCacheService();
        if (this$cacheService == null ? other$cacheService != null : !this$cacheService.equals(other$cacheService)) {
            return false;
        }
        MicroServiceConfiguration this$mc = this.getMc();
        MicroServiceConfiguration other$mc = other.getMc();
        return !(this$mc == null ? other$mc != null : !this$mc.equals(other$mc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScoreService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QuestionRenderService $renderService = this.getRenderService();
        result = result * 59 + ($renderService == null ? 43 : $renderService.hashCode());
        QuestionCacheService $cacheService = this.getCacheService();
        result = result * 59 + ($cacheService == null ? 43 : $cacheService.hashCode());
        MicroServiceConfiguration $mc = this.getMc();
        result = result * 59 + ($mc == null ? 43 : $mc.hashCode());
        return result;
    }

    public String toString() {
        return "ScoreService(renderService=" + this.getRenderService() + ", cacheService=" + this.getCacheService() + ", mc=" + this.getMc() + ")";
    }
}

