function initMathJax() {
    try {
        MathJax.Hub.Config({
            extensions: ["tex2jax.js"],	jax: ["input/TeX", "output/HTML-CSS"],
            tex2jax: { inlineMath: [ ['$$','$$'], ['$','$'], ["\\(","\\)"] ], processEscapes: true 	},

            delayStartupUntil: "onload",
            menuSettings: { context: "XMathJax", inTabOrder: false, zscale: "80%" }
        });
    } catch (e) {}
}

function updateMathjax() {
    try {
        MathJax.Hub.Queue(['Typeset',MathJax.Hub]);
    } catch (e) {
        console.log(e);
    }
}

function post(url, data, token) {
    clearErrorMsg();
    block_screen();
    let http = new XMLHttpRequest();

    http.open('POST', url, false);
    if (token)
        http.setRequestHeader('Authorization','Bearer ' + token);
    http.setRequestHeader("Content-Type", "application/json");
    http.send(JSON.stringify(data));
    let dto = JSON.parse(http.response);
    unblock_screen();
    if (dto.msg.msgType=='OK') {
        return dto.data;
    }
    msg(dto.msg.meldung)
    console.log(dto.msg.meldung);
    console.log(dto.msg.stackTrace);
}

/**
 * Ermittlung des Image-Strings für eine Beurteilung (FALSCH, RICHTIG,....)
 * @param score
 * @returns {string}
 */
function scoreImage(score) {
    switch (score) {
        case 'FALSCH':
            return `<img src="${serverPath(relpath)}/open/img/falsch.png">`;
        case 'OK':
            return `<img src="${serverPath(relpath)}/open/img/ok.png">`;
        case 'TEILWEISE_OK':
            return `<img src="${serverPath(relpath)}/open/img/teilrichtig.png">`;
    }
    return "";
}




// VERSUCHE POST
// FIXME REMOVE

function testAntwortSqNew() {
    return JSON.parse('{"sq":"","soll":null,"ist":null,"origIst":null,"scored":"","scoreText":"","scoreInfo":"","lehrerScored":false,"feedback":"","scoreAnzahl":null,"input":"","antworten":[{"input":"","pos":0}]}');
}



const score = async (data) => {
    let dto = {};

    let link = token ?
        `${serverPath()}/open/question_score`:
        `${serverPath()}/open/question_score_open`;
    const response = await fetch(link, {
        method: 'POST',
        mode: 'cors',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
    });
    dto = await response.json(); //extract JSON from the http response
    console.log(dto);
}

// Example POST method implementation:
async function postData(url = '', data = {}) {
    // Default options are marked with *
    const response = await fetch(url, {
        method: 'POST', // *GET, POST, PUT, DELETE, etc.
        mode: 'cors', // no-cors, *cors, same-origin
        cache: 'no-cache', // *default, no-cache, reload, force-cache, only-if-cached
        credentials: 'same-origin', // include, *same-origin, omit
        headers: {
            'Content-Type': 'application/json'
            // 'Content-Type': 'application/x-www-form-urlencoded',
        },
        redirect: 'follow', // manual, *follow, error
        referrerPolicy: 'no-referrer', // no-referrer, *no-referrer-when-downgrade, origin, origin-when-cross-origin, same-origin, strict-origin, strict-origin-when-cross-origin, unsafe-url
        body: JSON.stringify(data) // body data type must match "Content-Type" header
    });
    return response.json(); // parses JSON response into native JavaScript objects
}







/**
 * Öffnet ein Image, das in eine Frage über [IMGx] eingebunden wurde
 * durch Doppelclick oder einfach-Click. Verwendung in der alten Version der Darstellung von Images
 * @param lnk       http-Link zu Image
 */
function openImg(lnk) {

//    $( "#dialog" ).dialog();

    let el = document.getElementById("imgPrev");
    el.innerHTML=`<button id="close-dialog" class="${button_style}" 
                onclick="document.getElementById('imgPrev').close();">Schliessen</button>
            <br/>
            <img src="${lnk}" width="600px">`;
    document.getElementById("imgPrev").showModal();
}

function lang(txt) {
    if (translations[txt])
        return translations[txt];
    return txt;
}

function msg(header, detail, level) {
    try {
        growl_msg(lang(header), lang(detail), level?level:'warn');
    } catch (e) {
        alert(header+"\n"+detail);
    }

}

