var disableDsButts = false;
class Question {
    constructor(angabe, antwort, erg) {
        this.angabe = JSON.parse(JSON.stringify(angabe));
        this.antwort = antwort;
        this.subquestions = [];
        for (let sq of angabe.subQuestions) {
            switch (sq.mode) {
                case 'ZUORDNUNG':
                    this.subquestions.push(new Zuordnung(sq, antwort, this, erg));
                    break;
                case 'MULTICHOICE':
                    this.subquestions.push(new MultiChoice(sq, antwort, this, erg));
                    break;
                case 'REGEXP':
                case 'TEXT':
                case 'CALCULATED':
                    this.subquestions.push(new Calc(sq, antwort, this, erg));
                    break;
                case 'PLUGIN':
                    this.subquestions.push(new PluginInput(sq, antwort, this, erg));
                    break;
                case 'SCHIEBER':
                    this.subquestions.push(new Schieber(sq, antwort, this, erg));
                    break;
                case 'SINGLECHOICE':
                    this.subquestions.push(new Singlechoice(sq, antwort, this, erg));
                    break;
                case 'FREITEXT':
                    this.subquestions.push(new Freitext(sq, antwort, this, erg));
                    break;
                case 'IMAGE':
                    this.subquestions.push(new ImageInput(sq, antwort, this, erg));
                    break;
                case 'BOOLSCH':
                    this.subquestions.push(new Boolsch(sq, antwort, this, erg));
                    break;
                case 'MULTIPLECALC':
                case 'MULTIPLETEXT':
                    this.subquestions.push(new MultiCalc(sq, antwort, this, erg));
                    break;
                default:
                    this.subquestions.push(new SubQuestion(sq, antwort, this, erg));
            }
        }
    }


    renderHtml(bp_nr) {
        let html = `<form id="question_form" onsubmit="return false;" ><div class="flex-container">
            <div style="flex-grow: 10" class="left">`;

        html+=`<div class="flex-container">`;
        if (bp_nr) html+= `
                <div style="flex-grow: 1; margin:0">
                    <h3>Beispiel ${bp_nr}</h3>
                </div>`;
        else html+=`
                <div style="flex-grow: 1; margin:0">
                    <h3>${this.angabe.name}</h3>
                </div>`;
        if (this.angabe.buttons.includes('ds_buttons') && !disableDsButts) {
            html += `<div style="flex-grow: 0">`;
            html+=addButton("left", translations['last'], "next_dataset(-1);", button_style+ " ui-button-outlined");
            html+=addButton("right", translations['next'], "next_dataset(1);", button_style+ " ui-button-outlined");
            html+=addButton("help", '', "openHelp('https://wiki.letto.at/wiki/index.php/Eingabe_von_Resultaten_in_LeTTo');", button_style+ " ui-button-outlined");
            html += `</div>`;
        }
        //<i class="fa fa-caret-left">
        html+=`<form id="question_form"></div>`

        html+=
            `<dialog id="imgPrev"></dialog>`;

        for (let sq of this.subquestions) {
            html += `<span id="sqInp_${sq.name}">`;
            html+=sq.sqAngabe.htmlText;
            html += sq.renderSq();
            //html+=scoreImage(score);
            html+='</span>';
        }

        html+=`</div>
            <div style="flex-grow: 5" >`;

        if (this.angabe.single=='DragAndDrop') {
            let set = new Set();
            this.angabe.subQuestions.map(sq=>sq.answers).flat(1).map(a=>a.htmlText).forEach(a=>set.add(a));
            let drag = '<div class="header">Antworten</div>';
            let i=0;
            for (let a of set) {
                drag+=`<div id="dragtext_${i++}" class="dragtext">${a}</div>`
            }
            html+=drag;
        }

        html+=`    </div>
        </div>`;


        // Ergebnisübersicht für Plugin- bzw. Boolsche Fragen
        if (this.antwort.bewertung!="NotScored") {
            for (let sq of this.subquestions) {
                if (sq.sqAngabe.mode == "BOOLSCH" || sq.sqAngabe.mode == "PLUGIN") {
                    let score = sq.sqAntwort.scored;
                    html+=`<div class="${score}">`;
                    html+='<b>Ergebnisauswertung:</b><br>';
                    html+=sq.sqAntwort.scoreText;
                    html+=sq.scoreImage(score,1);
                    html+='</div>'
                }
            }
        }

        html+='<div class="div-margin qButtons">';
        // Buttons einfügen
        this.defaultAction="save";

        // Prüfen-Button
        if (this.angabe.buttons.includes('check_next'))
            html+= addButton('check', translations['check_next'], 'scoreQuestionNext();', button_style+ " ", true);
        else if (this.angabe.buttons.includes('check_penalty'))
            html+= addButton('check', translations['check_penalty'], 'scoreQuestionPenalty();', button_style+ " ", true);
        else if (this.angabe.buttons.includes('check'))
            html+= addButton('check', translations['check'], 'scoreQuestion();', button_style+ " ", true);
        if (this.angabe.buttons.includes('results'))
            html+= addButton('check_circle', translations['check_results'], 'scoreQuestionWithResults();', button_style+ " ui-button-outlined");

        let defButt = false;
        if (this.angabe.buttons.includes('check'))
            // Default-Button gesetzt
            defButt = true;

        if (this.angabe.buttons.includes('next_quest'))
            html+= addButton('next_quest', translations['next_quest'], 'nextQuestion();', button_style+ `${defButt?"ui-button-outlined":""}`, !defButt);

        if (this.angabe.buttons.includes('save'))
            html+= addButton('save', translations['save'], 'saveQuestion();', button_style+ `${defButt?"ui-button-outlined":""}`, !defButt);

        if (this.angabe.feedback)
            html+= addButton('feedback', translations['feedback'], `openFeedback()`, button_style+ " ui-button-outlined");


        // Anzeige der Ergebnis-Zusammenfassung, wenn Frage bewertet wurde
        html+='<br>';
        html+='<br>';
        if (this.antwort.bewertung && this.antwort.bewertung!='NotScored')
            html+=this.ergSumme();
        html+='</div></form>'
        try {
            if (this.angabe.copyright) html+=this.angabe.copyright;
        } catch (e) {}

        // html+='<div id="prev" title="Ergebnis-Eingabe" style="overflow:hidden;"> </div>';
        html+='<div id="dial" title="Dialog" style="overflow:hidden;"> </div>';
        // html+='<dialog id="prev" style="min-height: 30px"></dialog>';
        return html;
    }

    render(bp_nr) {
        let html = this.renderHtml(bp_nr);
        // HTML für Frage in Dokument einbauen
        document.getElementById("question").innerHTML = html;

        $(document).ready(function() {
            $('form').on('submit', function(e){
                // validation code here
                e.preventDefault();
                e.stopPropagation();
            });
        });
        /*
                $("#question_form").submit(function(event) {
                    event.preventDefault(); //prevent default action
                    //event.cancel;
                    //if (q.defaultAction=="pruefen") scoreQuestion();
                    return false;
                });
        */
        // Plugins mit Javascript-Unterstützung aktivieren
        for (let pi in this.angabe.plugins) {
            if (this.angabe.plugins[pi]) {
                if (this.angabe.plugins[pi].initScripts) {
                    let script = this.angabe.plugins[pi].initScripts;
                    eval(script);
                }
            }
        }
        for (let sq of this.subquestions)
            sq.initPlugin();
        if (this.angabe.jsPlugins) {
            try {
                let script = this.angabe.jsPlugins;
                eval(script);
            } catch (e) {}
        }


        try {
            this.defineEventHandlers();
        } catch (e) {}
        updateMathjax();

        // Datei hochladen für Images aktivieren
        $(".imageUpload").on("change", function () {
            let id = this.id;
            let name = sqName(id);

            var fileList = this.files; /* Jetzt kann die Dateiliste verarbeitet werden */
            var reader = new FileReader();
            let file = fileList[0];
            reader.readAsDataURL(file);
            reader.onload = function () {
                setPreview(id, name, reader.result);
            };
            reader.onerror = function (error) {
                console.log('Error: ', error);
            };
        });

        //$(document).trigger('loadPlugins');
    }

    initPigPlugins(dtoMap) {
        let map = new Map();
        for (let [key, value] of map) {
            let typ;
            try {
                typ = value.pluginTyp;
            } catch (e) {}
            if (typ) {
                let script = `initPlugin${typ}('${value.pluginDto}', true)`;
                eval(script);
            }
        }
    }



    defineEventHandlers() {

        $( '.letto-input' ).on('keydown', function ( evt ) {
            if( evt.keyCode == 13 )
                updateInputField( this.id,this.value  );
        } );

        $(".clickable").off().on('click',function(ev) {
            let el = ev.target;

            let i=0;
            while (i<10) {
                try {
                    let id = el.id;
                    if (el.isMathJax) {
                        while (el.isMathJax)
                            el=el.parentNode;
                        id=el.id;
                    }
                    if (id) {
                        if (q) q.updateInputField(id);
                        return;
                    }
                    el = $(el).parent()[0];
                    i++;
                } catch (e) {}
            }
        });

        initSliders();
        initDragAndDrop();
        initSelectboxes();

        $(".preview-dialog").dblclick(function(){
            openResultPreview();
            updatePreview(this);
        });

        $(".preview-dialog").keyup(function(){
            updatePreview(this);
        });
    }

    /**
     * Anzeige der Ergebnis-Zusammenfassung
     * @param answer        Antwort-DTO
     * @returns {string}
     */
    ergSumme() {
        let answer = this.antwort;
        return `
        <div class="${answer.bewertung}">
        <table><tbody><tr>
        <td style="width: 50px; padding: 5px;" >
        ${scoreImage(answer.bewertung)}
        </td>
        <td>
        <b>${translations['evaluation']}: </b>
        ${translations['points']}: <b>
        ${answer.points.toFixed(2)}
        </b>
        </td>
        </tr>
        </tbody> </table>
        </div>`;
    }

    loadSubQuestion(sqName) {
        return this.subquestions.filter(sq=>sq.name==sqName)[0];
    }

    loadAnswer(sqName, idAnswer) {
        const sq = this.subquestions.filter(sq=>sq.name==sqName)[0];
        if (sq && sq.sqAngabe.answers[idAnswer]) {
            const ansHtml = sq.sqAngabe.answers[idAnswer];
            if (ansHtml)
                return ansHtml.inp;
        }
        return undefined;
    }

    /**
     * Anzeige des akt. Antwort-DTOs
     */
    showAnswerDto() {
        let out = "";
        for (let sq in this.antwort.sqAntworten) {
            out+=sq.name;
        }
        let ans = this.antwort.sqAntworten.map(sq => sq.antworten).flat(1);
        let a = document.getElementById("answer");
        if (a) a.innerHTML = JSON.stringify(ans, null, 2);
    }

    /**
     * Änderung / Click einer Eingabefeldes (Zuordnung)
     * @param id    ID des Feldes, wird im Hash gesucht, um das entsprechende Antwort-Objekt zui ändern
     * @param val   Neuer (geänderter) Wert
     */
    updateInputField(id, val) {
        val = unescape(val);
        const p = /(Q\w+)_(\d+)/;
        const m = p.exec(id);
        if (!m) return ;
        const sqName = m[1];
        const aNr = m[2];

        let sq = this.loadSubQuestion(sqName);
        if (sq.mode=='ZUORDNUNG')
            sq.click(id);

        else if (sq.mode=='SINGLECHOICE') {
            let a = sq.sqAntwort.antworten[0];
            if (a) a.input = val;
        }
        else {
            let a = q.loadAnswer(sqName, aNr);
            if (a) a.input = val;
        }
        this.showAnswerDto();
        updateMathjax();
        return sq;
    }

    removeZuordnung(butt) {
        const p = /(Q\d+)_(\d+)/;
        const m = p.exec(butt.id);
        const sqName = m[1];
        const aNr = m[2];
        let sq = this.loadSubQuestion(sqName);
        if (sq.removeZuordnung) sq.removeZuordnung(aNr);
    }
}


function setPos(el,x,y) {
    el.setAttribute("pos", JSON.stringify({x:x, y:y}));
    return {x:x, y:y};
}

function getPos(el) {
    return JSON.parse(el.getAttribute("pos"));
}

var dropped = false;
function initDragAndDrop() {
    const dragtext = interact('.dragtext');
    const droptext = interact('.droptext');

    dragtext.draggable({
        listeners: {
            start (event) {
                setPos(event.target, 0,0);
                $(".droptext").each(function( i ) {
                    this.classList.add("showdrop");
                });
                console.clear();
                console.log(event.x, event.x0, event.dx, event.type, event.target)
            },
            end (event) {
                $(".droptext").each(function( i ) {
                    this.classList.remove("showdrop");
                });
                let position = getPos(event.target);
                position.x = 0;
                position.y = 0;
                event.target.style.transform =
                    `translate(${position.x}px, ${position.y}px)`;

                console.log(event.x, event.x0, event.dx, event.type, event.target);
                interact('.dragtext').unset();
                initDragAndDrop();
            },
            move (event) {
                let p = getPos(event.target);
                p = setPos(event.target, p.x + event.dx, p.y + event.dy);
                event.target.style.transform =
                    `translate(${p.x}px, ${p.y}px)`;
                console.log(event.x0, event.x, event.dx);
            },
        }
    });

    droptext.dropzone({
        ondrop: function (event) {
            let sq = q.updateInputField(event.target.id, event.relatedTarget.innerText);
            if (sq) {
                const html = sq.renderSq(true);
                document.getElementById(sq.name+'_0').outerHTML = html;
            }
            dropped = true;
            console.log(event.type, event.target);
        }
    })
        .on('dragenter', function (event) {
            event.target.classList.add("drop_possible");
            var draggableElement = event.relatedTarget,
                dropzoneElement  = event.target,
                dropRect         = interact.getElementRect(dropzoneElement),
                dropCenter       = {
                    x: dropRect.left + dropRect.width  / 2,
                    y: dropRect.top  + dropRect.height / 2
                };

            event.draggable.draggable({
                snap: {
                    targets: [dropCenter]
                }
            });
            /*
                        var dropRect = interact.getElementRect(event.target),
                            dropCenter = {
                                x: dropRect.left + dropRect.width  / 2,
                                y: dropRect.top  + dropRect.height / 2
                            };

                        event.draggable.snap({
                            anchors: [ dropCenter ]
                        });

             */
        })
        .on('dragleave', function (event) {
            event.target.classList.remove("drop_possible");

            //         event.draggable.snap(false);
        });

}


function pressPruefen() {
    if (document.activeElement)
        document.activeElement.blur();
    const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
    (async () => {
        await delay(20);
        document.getElementById("check").click();
    })();

}

/**
 * Frage mit anderem (nächstem/letzen) Datensatz anzeigen
 * @param i Delta zum akt. Datensatz
 */
function next_dataset(i) {
    let id = q.angabe.idQuestion;
    let ds = q.dsNr;
    if (!ds) ds = 0;
    ds = ds+i;
    if (ds > 39) ds=39;
    if (ds<0) ds = 0;
    if (letto_token)
        loadQuestionWithToken(id, ds, letto_token, '');
    else
        loadQuestion(id, ds, '');
}

/**
 * Hinzufügen eines Buttons
 * @param icon  Icon-Class oder key aus icons.js
 * @param text  Angezeigter Text im Button
 * @param func  Callback-Funktion, die durch Button ausgeführt werden soll (als String!)
 * @param style Style-Klassen für den Button
 * @param submitButt    wenn true, dann wird Button zum Submit-Button
 * @returns html für Button
 */
function addButton(icon, text, func, style, submitButt) {
    let iconclass = icon;
    try {
        iconclass=loadIcon(icon);
    } catch (e) {}
    let html =
        text ?
            `
        <button type="${submitButt? 'submit':'button'}"
            class="ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left small ui-button-info ${style}"
            onClick="${func}">
        
            <span class="ui-button-icon-left ui-icon ui-c ${iconclass}"></span>
            <span class="ui-button-text ui-c">${text}</span>
        </button>`  :
            `
        <button type="${submitButt? 'submit':'button'}"
            class="ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only ui-button-help  ${style}"
            onClick="${func}">
        
            <span class="ui-button-icon-left ui-icon ui-c ${iconclass}"></span>
            <span class="ui-button-text ui-c">general help on editing examples</span>
        </button>`;
    return html;
}


/**
 * Öffnet einen Dialog, in dem in einem IFrame eine andere Seite dargestellt werden kann.
 * @param lnk       Link zu anderer Seite
 */
/*
function openIframeDialolg(wiki) {
    let el = document.getElementById("prev");
    el.innerHTML=`
            <iframe src="${wiki}" style="width: 100%; height: 500px"></iframe>
            <div class="previewPanel">` +
        addButton("trash", translations['close'],
            "$('#prev').dialog('close');", button_style+ " ui-button-outlined1") +
        `</div>`;

    let par = {
        width:'800px',
        position: {
            my: "right top",
            at: "right top+50"
        }
    };
    $( "#prev" ).dialog(par);
    //$( "#prev" ).dialog( "open" );
}
*/

/**
 * Öffnet ein Image, das in eine Frage über [IMGx] eingebunden wurde
 * durch Doppelclick oder einfach-Click. Verwendung in der alten Version der Darstellung von Images
 * @param lnk       http-Link zu Image
 */
/*
function openResultPreview(txt) {
    let el = document.getElementById("prev");
    el.innerHTML=`
            <p style="width: 300px" id="preview">${txt}</p>
            <br/><div class="previewPanel">` +
        addButton("trash", translations['close'],
            "$('#prev').dialog('close');", button_style+ " ui-button-outlined1") +
        `</div>`;
//    document.getElementById("prev").show();

    // let par = {
    //     position: {
    //         my: "right top",
    //         at: "right top+50"}
    // };
    $( "#prev" ).dialog(par);
    //$( "#prev" ).dialog( "open" );
}
*/







/**
 * Öffnet ein Image, das in eine Frage über [IMGx] eingebunden wurde
 * durch Doppelclick oder einfach-Click. Verwendung in der alten Version der Darstellung von Images
 * @param lnk       http-Link zu Image
 */
function openHelp(wiki) {
    let html = `<iframe src="${wiki}" style="width: 100%; height: 500px"></iframe>`;
    openDialogQuestion(800, 600, 'center', 'Hilfe zur Eingabe', html);
}
function closeDialog() {
    try {
        let id = "dial";
        $('#dial').dialog('destroy');
        document.getElementById(id).innerHTML='';
    } catch (e) {}
}
/**
 * Öffnet den tag mit id prev als Dialog:
 * @param width :   Breite
 * @param height :  Höhe
 * @param pos : left-top oder center
 * @param title : Titel des Dialogs
 * @param innerHtml : HTML, das innerhalb des Dialogs angezeigt werden soll
 */
function openDialogQuestion(width, height, pos, title, innerHtml) {
    let id = "dial";
    let el = document.getElementById(id);
    el.title=title;
    el.innerHTML=innerHtml + `
        <div class="previewPanel">` +
        addButton("trash", translations['close'],
            "closeDialog('"+id+"');", button_style+ " ui-button-outlined1") +
        `</div>`;

    let w = width ? width : 300;
    let h = height ? height : 150;

    let position;
    if (pos=='right-top')
        position = {my: "right top",at: "right top+50"};
    if (pos=='center')
        position = {my: "center",at: "center"};

    let par = {
        classes: {
            "ui-dialog": "foreground"
        },
        width: w,
        height: h,
        zIndex: 1001,
        position: position
    };
    $( "#"+id ).dialog(par);
    $( "#"+id ).dialog( "moveToTop" );
    $('.foreground').css({"z-index":"2000"});


}

function openFeedback() {
    try {
        openDialogQuestion(800, 600, 'center', 'Feedback', q.angabe.feedback);
        updateMathjax();
    } catch (e) {}
}

/**
 * Öffnet ein Image, das in eine Frage über [IMGx] eingebunden wurde
 * durch Doppelclick oder einfach-Click. Verwendung in der alten Version der Darstellung von Images
 * @param lnk       http-Link zu Image
 */
function openResultPreview() {
    try {
        openDialogQuestion(300, 150, 'right-top', 'Ergebnis-Eingabe', '<p style="width: 300px" id="preview"></p><br/>');
    } catch (e) {}
}




function updatePreview(inp) {
    let name = inp.id;
    let input = inp.value;

    let parseInputDto = {
        secret: 1234,
        valInfo: createValidDto(input, name, q)
    };
    try {
        $('#preview')[0].innerHTML = '';
    } catch (e) {}
    let link =  `${questionPath()}/open/question_parse_eingabe`;
    // let link =  `${serverPath()}/open/question_parse_eingabe?input=${encodeURIComponent(inp)}`;
    execPostRequest(link, null, function (dto) {
        try {
            $('#preview')[0].innerHTML = '$'+dto+'$';
            updateMathjax();

        } catch (e) {}
    }, parseInputDto);
}

/** VALIDATION */
/**
 * Validierung der Frage und ausführung einer Funktion nach Validierung
 * @param method    Methode zum Übertragen der Daten an den Server (Speichern, Prüfen, ...)
 * @returns {boolean}
 */
function validateForm(method) {
    // Alle früheren Fehlermeldungen löschen
    $("[id^=validation_err_]").each(function(i, err_div) {
        err_div.innerHTML = "";
    });

    try {
        let dto = {
            secret: 1234,
            valInfos: []
        };
        $('.validate').each(function(i, obj) {
            let name = obj.id;
            let input = obj.value;
            let valDto = createValidDto(input, name, q);
            if (valDto && input)
                dto.valInfos.push(valDto);
        });

        if (dto.valInfos.length>0) {
            let link =  `${questionPath()}/open/question_validate_eingabe`;
            let ergDto = execPostRequest(link, null, function (ergDto) {
                if (ergDto.length==0) {
                    method();
                    return;
                }
                ergDto.forEach(function (obj){
                    let idMsg = "#validation_err_"+obj.name;
                    $(idMsg).each(function(i, err_div) {
                        err_div.innerHTML = `<span class="validation">${obj.errMsg}</span>`;
                    });
                });
                // Warnung anfordern
                try {
                    growl_msg(translations['err_val_msg'], translations['err_val_msg_detail'], 'warn');
                } catch (e) {}

            }, dto)
        }
        else method();
    } catch (e) {}
}


function sqNameFromId(id) {
    var regex = /^Q\d+/g;
    return id.match(regex).filter(function(m,i,self) {
        return i == self.indexOf(m)
    }).join('')
}


function createValidDto(input, sqName, q) {
    // let input = this.value;
    let sq_Name = sqNameFromId(sqName);
    let sq = q.subquestions.filter(sq=>sq.name && sq.name.includes(sq_Name))[0];
    if (sq && sq.sqAngabe.validierungsInfo) {
        let valDto = {
            input: input,
            eh:sq.sqAngabe.eh,
            validationInfo: sq.sqAngabe.validierungsInfo,
            name:sq_Name,
        }
        return valDto;
    }
    return null;
}