class Schieber extends SubQuestion {
    constructor(sq, antwort, parent, erg) {
        super(sq, antwort, parent, erg);
    }
    renderSq() {
        let ans = this.sqAntwort.antworten[0];
        //answer_map.set(sq.name+'_0', ans )  ;
        let score = this.sqAntwort.scored;
        let schieber = this.sqAngabe.schieberData;
        let reg = /(.*):(.*);(.*):(.*)/.exec(this.sqAngabe.answers[0].htmlText);
        let minTxt = reg[1] ? reg[1] : "min";
        let maxTxt = reg[1] ? reg[3] : "max";
        let min = reg[2] ? reg[2] : "0"
        let max = reg[4] ? reg[4] : "1"
        let html = `<div class="flex-container">
            <div style="flex-grow: 0" class="sliderText">${minTxt}</div>
            <div style="flex-grow: 8" >
                <div class="slider" id="${this.name}_0" val="${ans.input}" min="${min}" max="${max}" ></div> 
            </div>
            <div style="flex-grow: 0" class="sliderText">${maxTxt}</div>
            </div>`;

        html+=this.scoreImage(score);
        return html;
    }
}


const slider = interact('.slider')    // target elements with the "slider" class

function initSliders(){
    $(".slider").each(function( sl ) {
        let val = this.getAttribute("val");
        if (val) {
            let min = parseFloat(this.getAttribute("min"));
            let max = parseFloat(this.getAttribute("max"));
            if (!min) min = 0;
            if (!max) max = 1;
            val = parseFloat(val);
            if (val>max) val=max;
            if (val<min) val=min;
            let proz = (val-min)/(max-min)*100;
            this.style.paddingLeft = proz+"%";
            this.classList.add("val");
        }
    });
}

slider
    .draggable({                        // make the element fire drag events
        origin: 'self',                   // (0, 0) will be the element's top-left
        inertia: true,                    // start inertial movement if thrown
        modifiers: [
            interact.modifiers.restrict({
                restriction: 'self'           // keep the drag coords within the element
            })
        ],
        listeners: {
            move (event) {
                // call this listener on every dragmove
                const sliderWidth = interact.getElementRect(event.target).width
                const value = event.pageX / sliderWidth
                let min = parseFloat(event.target.getAttribute("min"));
                let max = parseFloat(event.target.getAttribute("max"));
                if (!min) min = 0;
                if (!max) max = 1;
                let val = min + (max-min)*parseFloat(value);
                event.target.style.paddingLeft = (value * 100) + '%'
                event.target.setAttribute('val', val.toFixed(2));
                event.target.classList.add("val");

                q.updateInputField(event.target.id, val.toFixed(2));

            }
        }
    })

