class Singlechoice extends SubQuestion {
    constructor(sq, antwort, parent, erg) {
        super(sq, antwort, parent, erg);
    }
    renderSq(noScore) {
        let ans = this.sqAntwort.antworten[0];
        //answer_map.set(sq.name+'_0', ans )  ;
        let score = this.sqAntwort.scored;
        let html = "";

        if (this.erg) {
            let val = this.sqAngabe.answers.filter(a=> a.text==ans.input)[0];
            let inp = val ? val.htmlText : " - - - - ";
            let ergTxt = this.sqAngabe.answers.filter(a=> a.text==this.erg.antworten[0])[0].htmlText;
            ergTxt = ergTxt==inp ? "" : "("+ergTxt +")";
            let scoreClass = this.erg.antworten[0]==this.sqAntwort.antworten[0].input ? "OK":"FALSCH";
            html+=`<span class="${score} ui-inputwrapper-filled" style="display: inline-block ;padding-left: 20px; padding-right: 20px;;margin-left:5px;margin-right:5px;">
                ${inp} ${score ? this.scoreImage(score,1) : ""} ${ergTxt}
            </span>`;

        }
        else {
            html +=` <select id="${this.name}_0_single" class="single_select" onchange="setSelValue(this)" name="state"> `;
            html += `<option value="">-- Bitte Auswählen</option>`;

            let i=0;
            for (let ax of this.sqAngabe.answers) {
                let txt = ax.htmlText;
                let reg = /<img.*?src=('|")(.*?)('|").*?>/;
                let m = reg.exec(txt);
                let imgpath = "";
                if (m) {
                    imgpath =  `data-image="${m[2]}"`;
                }
                const regex = /\$([^$]*)\$/g;
                txt = txt
                    .replace(/<img.*?src=('|")(.*?)('|").*?>/g, "")
                    .replaceAll("$", "\\$");
                let sel = this.sqAntwort.antworten[0].input==ax.text ? "selected" : "";
                html += `<option ${sel} ${imgpath} value='${escape(ax.text)}'>${txt}</option>`;
            }

            html+='</select>';
            if (score)
                html+=this.scoreImage(score);
        }

        return html;
    }
}

function initSelectboxes() {
    try {
        $('.single_select').select2({
            templateResult: formatState,
            templateSelection: formatList
        });
    } catch (e) {}

    $('.single_select').on('select2:open', function (e) {
        delayMathjax(10);
    });
    $('.single_select').on('select2:close', function (e) {
        delayMathjax(10);
    });
}

function delayMathjax(time_in_ms) {
    const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
    (async () => {
        await delay(time_in_ms);
        updateMathjax();
    })();
}

function setSelValue(el) {
    q.updateInputField(el.id, el.value);
}

function formatStateMin (opt) {
    formatState(opt, 50);
}

function formatStateNorm (opt) {
    formatState(opt, undefined);
}


function formatList (opt) {
    opt.text = opt.text.replaceAll("\\$", "$");
    console.log(opt.text);
    if (!opt.id) {
        return opt.text;
    }

    var optimage = $(opt.element).attr('data-image');
    if(!optimage){
        return opt.text;
    } else {
        var $opt = $(
                '<span style="margin-top:-8px;display:inline-block;height:45px;"><img src="' + optimage + ' " height="99%" object-fit: none; " /> ' + opt.text.toUpperCase() + '</span>'
            );
        return $opt;
    }
}

function formatState (opt) {
    opt.text = opt.text.replaceAll("\\$", "$");
    console.log(opt.text);
    if (!opt.id) {
        return opt.text;
    }

    var optimage = $(opt.element).attr('data-image');
    if(!optimage){
        return opt.text;
    } else {

        var $opt =
            $(
                '<span><img src="' + optimage + '" width="80%" /> ' + opt.text.toUpperCase() + '</span>'
            );
        return $opt;
    }
}