var relpath="/question";
var lettopath="/edit";
var scorePath=relpath+"/open";

var icon_mode = 'fontawesome';
var q;
var fullPath;
const corsMode = "cors";
var button_style = "";
//const changeDataset = true;
var letto_token;

function questionPath() {
    return loadFullPath(relpath);
    // return fullPath ? fullPath+relpath : relpath;
}

function serverPath(path) {
    if (path) return loadFullPath(path);
    return loadFullPath(lettopath);
}

function loadFullPath(path) {
    if (path)
        return fullPath ? fullPath+path : path;

    return fullPath ? fullPath+relpath : relpath;
}



function defineServerPath(path, servicepath) {
    fullPath = path;
    relPath = servicepath;
}

function defineQuestionButtonStyle(styleClasses) {
    button_style = styleClasses;
}
/**
 * Funktion zum Laden von Fragen aus einer Kategorie der Datenbank
 * Das Ergebnis wird in div-Element mit der id <b>qlist</b> eingetragen..
 * Im HTML-Dokument muss also <b><div id="qlist"></b> vorhanden sein.
 * @param path  Kategorie-Pfad zB. /tmp/l-mayt/beispiele
 * @param link (optional) Optionaler Link zum REST-Service "questions_in_path" ohne Get-Parameter
 *             Default: /question/open/questions_in_path
 */
function loadQuestionsFromPath(path, link) {
    if (!link)
        link = `${serverPath()}/open/questions_in_path?path=${path}`;
    else
        link = link + `?path=${path}`;

    execGetRequest(link, '', function (dto) {
        // Frageliste laden
        insQuestionListInHtml(dto);
    })
}

/**
 * Funktion zum Laden von Fragen aus einer Kategorie der Datenbank
 * Das Ergebnis wird in div-Element mit der id <b>qlist</b> eingetragen..
 * Im HTML-Dokument muss also <b><div id="qlist"></b> vorhanden sein.
 * @param id   ID der gewünschten Kategorie
 * @param link (optional) Optionaler Link zum REST-Service "questions_in_path" ohne Get-Parameter
 *             Default: /question/open/questions_in_cat
 */
function loadQuestionList(idCat, link) {
    // Link zu REST-Service vorbereiten
    if (!link)   link = `${serverPath()}/open/questions_in_cat?idCat=${idCat}`;
    else         link = link + `?idCat=${idCat}`;
    execGetRequest(link, '', function (dto) {
        // Frageliste laden
        insQuestionListInHtml(dto);
    })
}

/**
 * Darstellung der gefundenen Fragen in einer Liste.
 * PRIVATE!
 * Notweniges DIV-Element: <b><div id="qlist"></b>
 * @param dto   DTO der Rest Anfrage
 */
function insQuestionListInHtml(dto) {
    let i = 0;
    let maxLines = dto.length/2;
    let html =`<h3>Links zu Demofragen</h3>
            <div class="flex-container">
                <div style="flex-grow: 1">`;
    for (let q of dto) {
        html+=`<div onclick="loadQuestion(${q.id},1)" class="link">${q.name}</div>`;
        i++;
        if (i>=maxLines) {
            i=0;
            html+=`</div>
                    <div style="flex-grow: 1">`;
        }
    }
    html+='</div></div>';
    // HTML für Frage in Dokument einbauen
    document.getElementById("qlist").innerHTML = html;
}

/**
 * Laden einer Frage aus der Datenbank mit deren ID. <br>
 * Zugang für Question-Service als Stand-Alone-Service!
 *
 * @param idQuestion    ID der Frage in der Datenbank
 * @param dsNr          Datensatz-Nr von 0-39
 * @param link (optional) Optionaler Link zum REST-Service "questions_in_path" ohne Get-Parameter
 *             Default: /question/open/loadQuestion
 */
function loadQuestion(idQuestion, dsNr, link) {
    if (dsNr==undefined) dsNr=0;
    if (!link)   link = loadFullPath(relpath + "/open/loadQuestion");
    loadQuestionWithToken(idQuestion, dsNr,  '', link);
    scorePath=relpath+"/open";
}


/**
 * Laden einer Frage aus der Datenbank mit deren ID
 * für das Editieren / die Vorschau von Fragen im Edit-Modus
 * @param idQuestion    ID der Frage in der Datenbank
 * @param dsNr          Datensatz-Nr von 0-39
 * @param link (optional) Optionaler Link zum REST-Service
 *             Default: /question/api/teacher/loadQuestion
 */
function loadEditQuestion(idQuestion, dsNr, link) {
    if (dsNr==undefined) dsNr=0;
    if (!link)   link = `${serverPath()}/open/loadQuestion`;
    loadQuestionWithToken(idQuestion, dsNr,  '', link);
    scorePath="/question/api/teacher";
}

/**
 * Laden einer Frage aus einem Testdeteil eines bestehenden Tests.<br>
 * Zugangspunkt über Edit-Service,
 * Interne Weiterleitung (loadQuestion) für das Fragen-Rendern an das Frage-Service
 * über Service-Autentifizierung
 *
 * @param id    ID des Testdetails aus einem bestehenden Test
 * @param link (optional) Optionaler Link zum REST-Service "questions_in_path" ohne Get-Parameter
 *             Default: /question/open/load_by_td
 */
function loadTestDetail(id, token, link) {
    if (!id) return;
    if (id==0) return;
    // Link zu REST-Service vorbereiten
    if (!link)   link = `${lettopath}/api/student/load_by_td?idTd=${id}`;
    else         link = link + `?idTd=${id}`;
    execGetRequest(link, token, function (dto) {
        q = new Question(dto.angabe, dto.antwort, dto.ergebnisseText);
        q.render();
        try {
            PF('statusDialog').hide();
        } catch (e) {}
    });
    scorePath="/edit/api/student";
}
















function loadQuestions(link) {
    let dsNr = Math.floor((Math.random() * 40));
    if (dsNr==undefined || dsNr > 39) dsNr=0;
    if (!link)   link = `${serverPath()}/open/loadQuestion`;


    loadQuestionWithToken(idQuestion, dsNr, '', link);
}


/**
 * FIXME: Verlagern nach loadEditQuestion !!!
 * Laden einer Frage aus der Datenbank mit deren ID und mit UserToken
 * @param idQuestion    ID der Frage in der Datenbank
 * @param dsNr          Datensatz-Nr von 0-39
 * @param token         LeTTo-Token zur Anmeldung
 * @param link (optional) Optionaler Link zum REST-Service "questions_in_path" ohne Get-Parameter
 *             Default: /question/open/load_by_id
 */
function loadQuestionWithToken(idQuestion, dsNr, token, link) {
    if (dsNr==undefined) dsNr=0;
    if (token)
        letto_token = token;
    if (!link)   link = `${serverPath(relpath)}/api/teacher/loadQuestion?dsNr=${dsNr}&idQuestion=${idQuestion}`;
    else         link = link + `?dsNr=${dsNr}&idQuestion=${idQuestion}`;
    execGetRequest(link, token, function (dto) {
        q = new Question(dto.angabe, dto.antwort, dto.ergebnisseText);
        q.dsNr = dsNr;
        q.render();
        q.token = token;
    });
    scorePath="/question/api/teacher";
}

/**
 * Ausführen eines GET-Requests asychron.<br>
 * Die Funktion, die nach dem GET-Request ausgeführt werden soll, wird als Parameter an GET-Request
 * übergeben.
 * @param link  GET-Link mit notwedigen GET-Parametern als String
 * @param token JWT-Token für Autentifikation oder leer für OPEN
 * @param showStatus Anzeige eines Status-Dialogs während des Get-Requests
 * @param f     Funktion, die mit dem zurückgegebenen DTo ausgeführt wird
 */
function execGetRequestInfo(link, token, showStatus, f) {
    clearErrorMsg();
    if (showStatus && !token) block_screen();
    const action = async () => {
        try {

            const response = token ?
                await fetch(link, {
                    headers: { 'Authorization': 'Bearer ' + token },
                    mode: corsMode
                    //mode: 'no-cors'
                }) :
                await fetch(link, {mode: corsMode});
            let dto = await response.json(); //extract JSON from the http response
            dto = handleRestDto(dto);
            if (showStatus) unblock_screen();
            if (!dto) return;
            f(dto);
        } catch (e) {
            let errMsg = document.getElementById("error");
            if (errMsg) {
                let html = `<h4>Fehler: Get-Request fehlgeschlagen</h4>
                   Der Link <a href="${link}">${link}</a> konnte nicht korrekt abgerufen werden.`;
                errMsg.innerHTML = html;
            }
            if (showStatus) unblock_screen();
        }
    }
    action();
}

/**
 * Ausführen eines GET-Requests asychron.<br>
 * Die Funktion, die nach dem GET-Request ausgeführt werden soll, wird als Parameter an GET-Request
 * übergeben.
 * @param link  GET-Link mit notwedigen GET-Parametern als String
 * @param token JWT-Token für Autentifikation oder leer für OPEN
 * @param f     Funktion, die mit dem zurückgegebenen DTo ausgeführt wird
 */
function execGetRequest(link, token, f) {
    execGetRequestInfo(link, token, true, f);
}

/**
 * Ausführen eines POST-Requests asychron.<br>
 * Die Funktion, die nach dem GET-Request ausgeführt werden soll, wird als Parameter an GET-Request
 * übergeben.
 * @param link  GET-Link mit notwedigen GET-Parametern als String
 * @param f     Funktion, die mit dem zurückgegebenen DTo ausgeführt wird
 */
function execPostRequest(link, token, f, data, blockscreen) {
    clearErrorMsg();
    if (blockscreen) block_screen();
    const action = async () => {
        try {
            let daten = data ? JSON.stringify(data) : '';


            param = {
                method: 'POST', // *GET, POST, PUT, DELETE, etc.
                mode: 'cors', // no-cors, *cors, same-origin
                credentials: 'same-origin', // include, *same-origin, omit
                headers: {
                    'Content-Type': 'application/json'
                },
                redirect: 'follow', // manual, *follow, error
                referrerPolicy: 'no-referrer', // no-referrer, *no-referrer-when-downgrade, origin, origin-when-cross-origin, same-origin, strict-origin, strict-origin-when-cross-origin, unsafe-url
                body: daten // body data type must match "Content-Type" header
            }
            if (token) param.headers = { 'Content-Type': 'application/json', 'Authorization': 'Bearer ' + token };
            const response = await fetch(link, param);
            let dto = await response.json(); //extract JSON from the http response
            dto = handleRestDto(dto);
            if (blockscreen) unblock_screen();
            if (!dto) return;
            f(dto);
        } catch (e) {
            let errMsg = document.getElementById("error");
            if (errMsg) {
                let html = `<h4>Fehler: Post-Request fehlgeschlagen</h4>
                   Der Link <a href="${link}">${link}</a> konnte nicht korrekt abgerufen werden.`;
                errMsg.innerHTML = html;
            }
            if (blockscreen) unblock_screen();
        }
    }
    action();
}

function block_screen() {
    $('<div id="loading" class="loading"><div class="waiticon"></div></div>').appendTo('body');
    $('#loading').css( { width: $(document).width(), height: $(document).height() } );
    $('.waiticon').css( { left: ($(document).width()/2-30), top: ($(document).height()/2-30) } );
    $('#loading').animate({}, 200);
}

function unblock_screen() {
    $('.loading').animate({opacity: 0}, 200, function() {
        $('#loading').remove();
    });
}

/**
 * Behandlung der Ergebnisse von REST-Anfragen + FEHLERBEHANDLUNG.<br>
 * Notwendig zur Ausgabe: <b> <div id="error"> </b>
 * @returns {null|daten des dto}
 */
function handleRestDto(dto) {
    if (dto.msg.msgType == 'OK') return dto.data;
    let errMsg = document.getElementById("error");
    if (errMsg) {
        let html = `<h4>Fehler: ${dto.msg.meldung}</h4>
            <pre>${dto.msg.stackTrace}</pre>`;
        errMsg.innerHTML = html;
    }
    else {
        try {
            dtoAndMsgHandling(dto.msg);
        } catch (e) {
            msg(dto.msg.meldung,'');
            console.log(dto.msg.meldung);
            console.log(dto.msg.stackTrace);
        }
    }
    return null;
}

/**
 * Änderung einer Eingabefeldes
 * @param id    ID des Feldes, wird im Hash gesucht, um das entsprechende Antwort-Objekt zui ändern
 * @param val   Neuer (geänderter) Wert
 */
function updateInputField(id, val) {
    q.updateInputField(id, val);
}

function scoreQuestion() {
    validateForm(()=>scoreQuestionAfterValidation());
}

function scoreQuestionAfterValidation() {
    try {
        $( ".hiddenPlugin" ).each(function( pi_inp ) {
            let val = this.value;
            let id = this.id;
            q.updateInputField(id, val);
        });
    } catch (e) {}

    let path = loadFullPath(scorePath);
    link = `${path}/score`;

    execPostRequest(link, letto_token, (antwort)=>afterScorePost(antwort), q.antwort, true);
    // let antwort = post(`${link}`, q.antwort, letto_token);
    // afterScorePost(antwort);
}

function afterScorePost(antwort) {
    // Frage neu mit Antwort rendern
    if (!antwort) return;
    q = new Question(q.angabe, antwort);
    q.render();
    try {
        let id = antwort.idDetail;
        let a = JSON.stringify(antwort);
        informQList(id, a);
    } catch (e) {
        console.log(e);
    }
}

/**
 * Senden der Informationen an die JSF-Application zur Aktualisierung der Daten und der Frageliste
 * @param idTd
 * @param answer
 */
function informQList(idTd, answer) {
    var params = [
        { name : 'idTd',  value : idTd },
        { name : 'answer',  value : answer }
    ];
    try {
        informQuestionList(params);
    } catch (e) { }
}


function scoreQuestionWithResults() {
    validateForm(()=>scoreQuestionWithResultsAfterValidation());
}

function scoreQuestionWithResultsAfterValidation() {
    try {
        $( ".hiddenPlugin" ).each(function( pi_inp ) {
            let val = this.value;
            let id = this.id;
            q.updateInputField(id, val);
        });
    } catch (e) {}

    let path = loadFullPath(scorePath);
    link = `${path}/score_res`;

    let res = post(`${link}`, q.antwort, letto_token);
    let antwort = res.antwortAufFrage;
    let erg = res.ergebnisseText;
    if (!antwort) return;
    let angabe = q.angabe;
    q = new Question(angabe, antwort, erg);
    q.render();
}


function scoreQuestionNext() {
    validateForm(()=> {
        var params = [
            { name : 'answer',  value : JSON.stringify(q.antwort) }];
        try {
            scoreAndNextQuestionJsf(params);
        } catch (e) { }
    });
}




// function scoreQuestionNext() {
//     save_check('/edit/api/student/test_question_score_next', (dto) => {
//         q = new Question(dto.angabe, dto.antwort, dto.ergebnisseText);
//         q.render();
//         try {
//             PF('statusDialog').hide();
//         } catch (e) {}
//
//         try {
//             let antwort = dto.oldAntwort;
//             let id = antwort.idDetail;
//             let a = JSON.stringify(antwort);
//             informQList(id, a);
//         } catch (e) {
//             console.log(e);
//         }
//     }, letto_token, q.antwort, true);
// }

function scoreQuestionPenalty() {
    save_check('/edit/api/student/test_question_score_penalty', (antwort) => {
        // Nächste Frage neu mit Antwort rendern
        if (!antwort) return;
        q = new Question(q.angabe, antwort);
        q.render();
        try {
            let id = antwort.idDetail;
            let a = JSON.stringify(antwort);
            informQList(id, a);
        } catch (e) {
            console.log(e);
        }
    }, letto_token, q.antwort, true);
}

function nextQuestion() {
    validateForm(()=> {
        var params = [
            { name : 'answer',  value : JSON.stringify(q.antwort) }];
        try {
            nextQuestionJsf(params);
        } catch (e) { }
    });
    // save_check('/edit/api/student/test_question_next', (dto) => {
    //     q = new Question(dto.angabe, dto.antwort, dto.ergebnisseText);
    //     q.render();
    //     try {
    //         PF('statusDialog').hide();
    //     } catch (e) {}
    //
    //     try {
    //         let antwort = dto.oldAntwort;
    //         let id = antwort.idDetail;
    //         let a = JSON.stringify(antwort);
    //         informQList(id, a);
    //     } catch (e) {
    //         console.log(e);
    //     }
    // }, letto_token, q.antwort, true);
}

function saveQuestion() {
    validateForm(()=> {
        var params = [
            { name : 'answer',  value : JSON.stringify(q.antwort) }];
        try {
            saveQuestionJsf(params);
        } catch (e) { }
    });
    // save_check('/edit/api/student/save_question_answer', (antwort) => {
    //     try {
    //         let id = antwort.idDetail;
    //         let a = JSON.stringify(antwort);
    //         informQList(id, a);
    //     } catch (e) {
    //         console.log(e);
    //     }
    // }, letto_token, q.antwort, true);
}


function save_check(path, method, token, sendDto, blockscreen) {
    validateForm(()=> {
        updateInput();
        link = loadFullPath(path);
        execPostRequest(link, letto_token, (dto) => method(dto), sendDto, blockscreen);
    });
}


function updateInput() {
    try {
        $( ".hiddenPlugin" ).each(function( pi_inp ) {
            let val = this.value;
            let id = this.id;
            q.updateInputField(id, val);
        });
    } catch (e) {}

}



function clearErrorMsg() {
    let errMsg = document.getElementById("error");
    if (errMsg) {
        errMsg.innerHTML = '';
    }
}

