var width = 500;    // We will scale the photo width to this
var height = 0;     // This will be computed based on the input stream
var streaming = false;
var video = null;
var canvas = null;
var ergfield = null;
var vid = null;

function initClipToAnswer() {
    var idClip = $('.clip')[0].id.replace(/clip/,'') + 'imgbase64clip';
    $(':input.clipImage').on('paste', function(e) {
        var callFkt = function() {
            clipImgAnswer();
        }
        pasteImageParams(e, callFkt, idClip);
    });
}

function sqName(id) {
    return /(Q\w+_\d+_)/.exec(id)[1];
}

function clearFoto(el) {
    let name = sqName(el.id);
    setPreview(el.id, name, "");
    document.getElementById(name + 'clearFoto').classList.add("hidden");
    document.getElementById(name + 'startFoto').classList.remove("hidden");
    document.getElementById(name + 'imageFromClip').classList.remove("hidden");
}

function startupFoto(el) {
    let name = sqName(el.id);
    document.getElementById(el.id).classList.add("hidden");
    document.getElementById(name+'cancelFoto').classList.remove("hidden");
    document.getElementById(name+'contentarea').classList.remove("hidden");

    video = document.getElementById('video');
    canvas = document.getElementById('canvas');
    video.scrollIntoView();

    navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'}})
        .then(function(stream) {
            vid = stream;
            video.srcObject = stream;
            video.play();
        })
        .catch(function(err) {
            console.log("An error occurred: " + err);
        });

    video.addEventListener('canplay', function(ev){
        if (!streaming) {
            height = video.videoHeight / (video.videoWidth/width);
            // Firefox currently has a bug where the height can't be read from
            // the video, so we will make assumptions if this happens.
            if (isNaN(height)) {
                height = width / (4/3);
            }
            video.setAttribute('width', width);
            video.setAttribute('height', height);
            canvas.setAttribute('width', width);
            canvas.setAttribute('height', height);
            streaming = true;
        }
    }, false);
}

function takepicture(obj) {
//    alert(video);
    let name = sqName(obj.id);
    //var name = obj.id.replace(/startbutton/, '') + 'imgbase64';
    //ergfield = document.getElementById(name);
    var context = canvas.getContext('2d');
    context.drawImage(video, 0, 0, width, height);
    let img = canvas.toDataURL('image/png');
    //ergfield.value = img;
    stopStream(obj);

    setPreview(obj.id, name, img);
    //q.updateInputField(obj.id, img);
    //document.getElementById(name+"anzeige").innerHTML= `<img src="${img}"/>`;
}

function stopStream(el) {
    let name = sqName(el.id);
    document.getElementById(name+'startFoto').classList.remove("hidden");
    document.getElementById(name+'cancelFoto').classList.add("hidden");
    document.getElementById(name+'contentarea').classList.add("hidden");

    try {
        streaming = false;
        let stream = video.srcObject;
        let tracks = stream.getTracks();
        tracks.forEach(track => track.stop());
        video.srcObject=null;
    } catch (e) {}

}

function startClip(el) {
    let name = sqName(el.id);
    document.getElementById(name + 'cliparea').classList.remove("hidden");
    document.getElementById(name + 'imageFromClip').classList.add("hidden");

    $(':input.clipImage').on('paste', function(e) {
        /**
         * Import Image aus Zwischenablage, wenn Image vorhanden
         * sonst default-Action
         * @param e	Paste-Event mit Zugriff auf Clipboard
         * @returns
         */
        try  {
            let name = sqName(e.target.id);
            var pasteEvent = e.originalEvent;
            var items = pasteEvent.clipboardData.items;

            if(items == undefined){
                return;
            };

            var img = false;
            for (var i = 0; i < items.length; i++) {
                // Skip content if not image
                if (items[i].type.indexOf("image") == -1) continue;
                // Retrieve image on clipboard as blob
                var blob = items[i].getAsFile();

                img = true;
                var reader = new FileReader();
                reader.readAsDataURL(blob);

                reader.onload = function () {
                    //var t = document.getElementById(inpId);
                    let val = reader.result;
                    setPreview(e.target.id, name, val);
//                    q.updateInputField(e.target.id, val);
//                    document.getElementById(name+"anzeige").innerHTML= `<img src="${val}"/>`;
                };
            }
            if (img) e.preventDefault();
        } catch(e)  {}
    });
}

function setPreview(id, name, val) {
    q.updateInputField(id,val);
    document.getElementById(name+"anzeige").innerHTML= val ? `<img src="${val}"/>` : '';

    if (val) {
        document.getElementById(name + 'bildanzeige').classList.remove("hidden");
        document.getElementById(name + 'cliparea').classList.add("hidden");
        document.getElementById(name + 'clearFoto').classList.remove("hidden");
    } else {
        document.getElementById(name + 'bildanzeige').classList.add("hidden");
    }

}



