// The locale our app first shows
const defaultLocale = "en";
// The active locale
var locale;
// Gets filled with active locale translations
let translations = {};
// When the page content is ready...
document.addEventListener("DOMContentLoaded", () => {
    // Translate the page to the default locale
    if (locale)
        setLocale(locale);
    else
        setLocale(defaultLocale);
});
// Load translations for the given locale and translate
// the page to this locale
async function setLocale(newLocale) {
    if (newLocale === locale) return;
    if (newLocale=='de')
        translations={
            "close": "Schliessen",
            "last": "Letzte",
            "next": "Nächste",
            "check": "Prüfen",
            "check_results": "Prüfen/Ergebnisanzeige",
            "check_next": "Prüfen und zur nächsten Frage",
            "check_penalty": "Prüfen mit Abzügen",
            "next_quest": "Nächste Frage",
            "save": "Eingabe speichern",
            "feedback": "Feedback",
            "evaluation": "Bewertung",
            "points": "Punkte",
            "next_question": "Nächste Frage",
            "add_document": "Datei zur Frage hochladen",
            "help": "Hilfe zur Frage",
            "reset": "Zurücksetzen",

            "err_val_msg": "Fehlerhafte Eingaben!",
            "err_val_msg_detail": "Bitte kontrollieren Sie die markierten Eingabefelder, bevor sie weitermachen.",

            "err_question_val_ganzzahl":"Dies ist keine gültige Ganzzahl: normal: 34, hex: 0x3F, 0x2d , Binär: 0b01000100, Farbcode: re-gr-bl",
            "err_question_val_color":   "Dies ist kein gültiger Farbcode!",
            "err_question_val_einheit": "Dies ist keine gültige Zahl mit Einheit",
            "err_question_val_frequenz":"Dies ist keine gültige Funktion in der Variablen f!",
            "err_question_val_function":"Dies ist keine gültige Funktion in den geforderten Variablen!",
            "err_question_val_ip":      "Dies ist keine gültige IP-Adresse!",
            "err_question_val_laplace": "Dies ist keine gültige Funktion in der Variablen s!",
            "err_question_val_omega":   "Dies ist keine gültige Funktion in der Variablen w!",
            "err_question_val_rational":"Dies ist keine gültiger ganzzahliger Bruch",
            "err_question_val_symbol":  "Der angegebene Ausdruck kann nicht korrekt interpretiert werden!",
            "err_question_val_number":  "Dies ist keine gültige Zahl!",
            "err_question_val_complex": "Dies ist keine gültige komplexe Zahl!",
            "err_question_val_complex_eh":"Dies ist keine gültige komplex Zahl mit Einheit",
            "err_question_val_vector":  "Dies ist kein gültiger Vektor! Eingabeformat: [1,4,5]",
            "err_question_val_matrix":  "Dies ist keine gültige Matrix! Eingabeformat: [[1,4],[2,3]] oder matrix([2,3],[3,5])",
            "err_question_val_boolsch": "Dies ist keine gültiger boolscher Wert! gültige Werte: true,false,0,1,H,L,high,low",
            "err_question_val_incorrect":"Eingabe konnte nicht korrekt interpretiert werden!",
            "err_edit_test_stopped": "Die Aktivität wurde schon geschlossen. Weitere Eingaben sind nicht mehr möglich!"
        };
    else translations={
        "close": "Close",
        "last": "Last",
        "next": "Next",
        "check": "Check",
        "check_results": "Check/display results",
        "check_next": "Check and next question",
        "check_penalty": "Check with penalty",
        "next_quest": "Next question",
        "save": "Save input",
        "feedback": "Feedback",
        "evaluation": "Evaluation",
        "points": "points",
        "next_question": "next question",
        "add_document": "Upload file to question",
        "help": "Help on question",
        "reset": "Reset answer",

        "err_val_msg": "Incorrect inputs!",
        "err_val_msg_detail": "Please check the marked input-fields before continuing.",

        "err_question_val_ganzzahl":"This is not a valid integer: normal: 34, hex: 0x3F, 0x2d , binary: 0b01000100, color code: re-gr-bl",
        "err_question_val_color": "This is not a valid color code!",
        "err_question_val_einheit": "This is not a valid number with unit",
        "err_question_val_frequenz":"This is not a valid function in variable f!",
        "err_question_val_function":"This is not a valid function in the requested variables!",
        "err_question_val_ip": "This is not a valid IP address!",
        "err_question_val_laplace": "This is not a valid function in variable s!",
        "err_question_val_omega": "This is not a valid function in the variable w!",
        "err_question_val_rational":"This is not a valid integer fraction",
        "err_question_val_symbol": "The given expression cannot be interpreted correctly!",
        "err_question_val_number": "This is not a valid number!",
        "err_question_val_complex": "This is not a valid complex number!",
        "err_question_val_complex_eh":"This is not a valid complex number with unit",
        "err_question_val_vector": "This is not a valid vector! Input format: [1,4,5]",
        "err_question_val_matrix": "This is not a valid matrix! Input format: [[1,4],[2,3]] or matrix([2,3],[3,5])",
        "err_question_val_boolsch": "This is not a valid boolean value! valid values: true,false,0,1,H,L,high,low",
        "err_question_val_incorrect":"Input could not be interpreted correctly!",

        "err_edit_test_stopped": "The activity has already closed. Further inputs are no longer possible!"
    };
    locale = newLocale;
    // try {
    //     const newTranslations =
    //         await fetchTranslationsFor(newLocale);
    //     translations = newTranslations;
    //     translatePage();
    // } catch (e) {}
    translatePage();

}
// Retrieve translations JSON object for the given
// locale over the network
async function fetchTranslationsFor(newLocale) {
    let localeFile = loadFullPath()+`/open/js/lang/${newLocale}.json`;
    const response = await fetch(localeFile);
    return await response.json();
}
// Replace the inner text of each element that has a
// data-i18n-key attribute with the translation corresponding
// to its data-i18n-key
function translatePage() {
    document
        .querySelectorAll("[data-i18n-key]")
        .forEach(translateElement);
}
// Replace the inner text of the given HTML element
// with the translation in the active locale,
// corresponding to the element's data-i18n-key
function translateElement(element) {
    const key = element.getAttribute("data-i18n-key");
    const translation = translations[key];
    element.innerText = translation;
}
