
function drawCanvas(plugin) {
    let clsName = "." + plugin.canvas;
    if ($(clsName).length>0)
        $(clsName).remove();

    if ($(clsName).length==0)
        $(plugin.divName).append( `       
            <div class="${plugin.canvas}" >
                <canvas class="${plugin.canvasLine}" id="${plugin.canvasLine}"></canvas>
            </div>`
        );
}

function imagescale(plugin, dto, scaleprozent) {
    if (scaleprozent===null || (!scaleprozent>1)) scaleprozent=100;
    // let cw = document.getElementById(plugin.name+'_div').clientWidth;
    try {
        plugin.iw = $(plugin.divName).innerWidth();
    } catch (e) {
        if (plugin.iw === null || plugin.iw===0) plugin.iw=500;
    }
    try {
        let iw1 = $(window).innerwidth();
        if (iw1!=null && iw1>0 && iw1<plugin.iw) plugin.iw = iw1;
    } catch (e) { }
    try {
        let iw2 = document.getElementById('questionForm').clientWidth;
        if (iw2!=null && iw2>0 && iw2<plugin.iw) plugin.iw = iw2;
    } catch (e) { }
    let iw = plugin.iw;
    if (iw<300) iw=300;
    plugin.scaleprozent = scaleprozent;
    plugin.scale  =  iw/dto.width*scaleprozent*0.01;
    plugin.width  = dto.width  * plugin.scale;
    plugin.height = dto.height * plugin.scale;
    document.getElementById(plugin.canvasLine).setAttribute("width",plugin.width+"px");
    document.getElementById(plugin.canvasLine).setAttribute("height",plugin.height+"px");
}

function drawLine(ctx, x1, y1, x2, y2, width) {
    ctx.beginPath();
    ctx.moveTo(x1 , y1);
    ctx.lineTo(x2, y2);
    ctx.lineWidth = width;
    ctx.stroke();
}

function drawText(ctx, x, y, text) {
    ctx.font = '48px serif';
    ctx.lineWidth = 1;
    ctx.fillText(text, x, y);
}

function drawTextCS(ctx, x, y, text, size, color, hcenter, vcenter) {
    let oldfont = ctx.font;
    let oldfillstyle = ctx.fillStyle;
    ctx.font = size+'px serif';
    let tw = ctx.measureText(text).width;
    let th = size*0.7;
    if (hcenter) x-=tw/2;
    if (vcenter) y+=th/2;
    ctx.fillStyle = color;
    ctx.fillText(text, x,y);
    ctx.font = oldfont;
    ctx.fillStyle = oldfillstyle;
}

function drawZoomIcon(ctx, x, y, size) {
    let a=size/5.0;
    ctx.fillStyle = "lightgray";
    ctx.strokeStyle="black";
    ctx.fillRect(x,y,size,size);
    let w = size/10.0
    ctx.lineWidth = w;
    drawLine(ctx,x+a,y+a,x+a,y+2*a,w);
    drawLine(ctx,x+a,y+a,x+2*a,y+a,w);
    drawLine(ctx,x+4*a,y+a,x+4*a,y+2*a,w);
    drawLine(ctx,x+4*a,y+a,x+3*a,y+a,w);
    drawLine(ctx,x+a,y+4*a,x+a,y+3*a,w);
    drawLine(ctx,x+a,y+4*a,x+2*a,y+4*a,w);
    drawLine(ctx,x+4*a,y+4*a,x+4*a,y+3*a,w);
    drawLine(ctx,x+4*a,y+4*a,x+3*a,y+4*a,w);
}

function drawResetIcon(ctx, x, y, size) {
    let a=size/5.0;
    ctx.fillStyle = "lightgray";
    ctx.strokeStyle="black";
    ctx.fillRect(x,y,size,size);
    let w = size/10.0
    ctx.lineWidth = w;
    drawLine(ctx,x+a,y+a,x+4*a,y+4*a,w);
    drawLine(ctx,x+a,y+4*a,x+4*a,y+a,w);
}

function drawLine(ctx,x1,y1,x2,y2,width,color) {
    ctx.beginPath();
    ctx.moveTo(x1, y1);
    ctx.lineTo(x2, y2);
    ctx.lineWidth = width;
    ctx.strokeStyle = color;
    ctx.stroke();
}

function drawArrow(ctx,x1,y1,x2,y2,width,color) {
    let dy = y2-y1;
    let dx = x2-x1;
    let arg = Math.atan2(dy,dx);
    let abs = Math.sqrt(dx*dx+dy*dy);
    ctx.translate(x1,y1);
    ctx.rotate(arg);
    ctx.beginPath();
    ctx.moveTo(0,0);
    ctx.lineTo(abs, 0);
    ctx.lineWidth = width;
    ctx.strokeStyle = color;
    ctx.stroke();
    let w = width*2
    if (abs>w*3) {
        ctx.fillStyle = color;
        ctx.beginPath();
        ctx.moveTo(abs,0);
        ctx.lineTo(abs - 3 * w, w);
        ctx.lineTo(abs - 3 * w, -w);
        ctx.closePath();
        ctx.fill();
    }
    ctx.rotate(-arg);
    ctx.translate(-x1,-y1);
}

function drawCircle(ctx,mx,my,r,width,color) {
    ctx.beginPath();
    ctx.lineWidth = width;
    ctx.strokeStyle = color;
    ctx.arc(mx,my,r,0,2*Math.PI);
    ctx.stroke();
}

function drawRect(ctx,x,y,w,h,width,color) {
    ctx.beginPath();
    ctx.lineWidth = width;
    ctx.strokeStyle = color;
    ctx.rect(x,y,w,h);
    ctx.stroke();
}

function fillRect(ctx,x,y,w,h,color) {
    ctx.beginPath();
    ctx.fillStyle = color;
    ctx.rect(x,y,w,h);
    ctx.fill();
}

function fillPolygon(ctx,x,y,anzahl,color) {
    ctx.beginPath();
    ctx.fillStyle = color;
    ctx.moveTo(x[0],y[0]);
    for (let i=1;i<anzahl;i++) {
        ctx.lineTo(x[i],y[i]);
    }
    ctx.closePath();
    ctx.fill();
}

function fillCircle(ctx,mx,my,r,color,transparency) {
    ctx.beginPath();
    ctx.fillStyle = color;
    ctx.arc(mx,my,r,0,2*Math.PI);
    let a = ctx.globalAlpha;
    if (transparency>=0)
        ctx.globalAlpha=transparency;
    ctx.fill();
    ctx.globalAlpha=a;
}

function openImageJS(imagepath) {
    var params = [
        { name : 'imgLink',  value : lnk }
    ];
    showImageDetail(params);
}

function vex(x,y) {
    if (x.length===2 && y.length===2) {
        return  x[0]*y[1]-x[1]*y[0];
    } else  if (x.length===3 && y.length===3) {
        return [x[1]*y[2]-x[2]*y[1],x[2]*y[0]-x[0]*y[2],x[0]*y[1]-x[1]*y[0]];
    } else return x*y;
}

function vin(x,y) {
    let e = 0;
    if (x.length=y.length) {
        for (let i=0;i<x.length;i++) {
            e += x[i]*y[i];
        }
        return e;
    }
}

function vabs(x) {
    let e=0;
    for (let i=0;i<x.length;i++) {
        e += x[i]*x[i];
    }
    return Math.sqrt(e);
}

function vneg(x) {
    let e=[];
    for (let i=0;i<x.length;i++) {
        e.push(-x[i]);
    }
    return e;
}

function vadd(x,y) {
    let e=[];
    for (let i=0;i<x.length;i++) {
        e.push(x[i]+y[i]);
    }
    return e;
}

function vsub(x,y) {
    return vadd(x,vneg(y));
}

function numberToString(number) {
    if (Math.abs(number)<1e-30) return "0.0";
    if (Math.abs(number)>1e5) return number.toExponential(4);
    if (Math.abs(number)<1e-2) return number.toExponential(4);
    if (Math.abs(number)>=1000) return number.toFixed(0);
    if (Math.abs(number)>=100) return number.toFixed(1);
    if (Math.abs(number)>=10) return number.toFixed(2);
    if (Math.abs(number)>=1) return number.toFixed(3);
    if (Math.abs(number)>=0.1) return number.toFixed(4);
    if (Math.abs(number)>=0.01) return number.toFixed(5);
    return number.toFixed(4);
}

function drawFadenkreuz(ctx,cx,cy,width,height,scale) {
    try {
        drawLine(ctx,0, cy, width, cy, 1/scale,"magenta");
        drawLine(ctx, cx, 0, cx, height, 1/scale,"magenta");

        ctx.font = '16px serif';
        let s = "(" + Math.trunc(cx) + "/" + Math.trunc(cy) + ")";
        let tw = ctx.measureText(s).width+8;
        let tws = tw/scale;
        let twh = 20/scale;
        let x = cx > width - tws ? cx - tws : cx + 2;
        let y = cy < twh ? cy + twh+4 : cy - 3;
        ctx.translate(x,y);
        ctx.transform(1/scale,0,0,1/scale,0,0);
        ctx.fillStyle = "white";
        ctx.fillRect(4,-20,tw,20);
        drawRect(ctx,4,-20,tw,20,1,"gray");
        ctx.fillStyle = "gray";
        ctx.fillText(s, 8, -5);
        ctx.transform(scale,0,0,scale,0,0);
        ctx.translate(-x,-y);
    } catch (e) {}
}

var nameFreihand = "";

function initPluginFreihand(dtoString, active) {
    let dto = JSON.parse(dtoString);
    let name = dto.tagName;
    nameFreihand = name;

    let saveInp = document.getElementsByClassName(name+'_inp')[0];
    let val = saveInp.value;
    if (active) {
        var img = new Image();
        img.src = 'https://letto.at/download/public/javascript/literallycanvas/img/kariert.png';

        var lc = LC.init(
            document.getElementById(name+"_div"),
            {
                toolbarPosition: 'bottom' ,
                keyboardShortcuts: false,
                defaultStrokeWidth: 1,
                backgroundColor: 'whiteSmoke',
                secondaryColor:  'white',
                tools:   [LC.tools.Pencil,
                    LC.tools.Eraser,
                    LC.tools.Line,
                    LC.tools.Rectangle,
                    LC.tools.Polygon,
                    LC.tools.Pan,
                    LC.tools.Eyedropper],
                imageURLPrefix: 'https://letto.at/download/public/javascript/literallycanvas/img',
                watermarkImage: img,
                watermarkScale: 0.6

            }
        );

        if (val != "") {
            let erg = saveInp.value.split(";");
            lc.loadSnapshot(JSON.parse(erg[0]));
        }

        lc.on('drawingChange', function() {
            saveInp.value = JSON.stringify(lc.getSnapshot()) + ";" +
                lc.getSVGString();
        });
    }
    else {
        if(val != "") {
            let erg = val.split(";");
            let svg = erg[1];
            if (svg.includes("</svg>")){
                document.getElementById(name+"_div").innerHTML = svg;
            }
            else {
                initFreihand(name, true);
            }
        }
    }
}

$=jQuery;

function initPluginPlot(dtoString, active, configdialog) {
    dtoString = dtoString.replaceAll("\\","\\\\");
    let dto = JSON.parse(dtoString);
    let plugin = new Object();
    plugin.isresetable = false;
    switch (dto.inputmode) {
        case "TOLINE": case "TOPOINT": case "TOARROW":
        default:
        case "OFF":
        case "LINE":
        case "VLINE":
        case "HLINE":
        case "ARROW":
        case "MEASURE":
        case "POINT":
        case "MCXY" :
        case "MC" :
            break;
        case "LINES":
        case "POINTS":
        case "POLYLINE":
        case "POLYGON":
        case "FUNCTION":
        case "POLYNOM":
            plugin.isresetable = true;
            break;
    }
    plugin.name = dto.tagName;
    plugin.divName = "#" + plugin.name+"_div";
    plugin.canvas = "canvasContainer"+plugin.name;
    plugin.canvasLine = "canvasLine"+plugin.name;
    plugin.active = active;
    plugin.configdialog = configdialog?true:false;
    plugin.iw = $(plugin.divName).innerWidth();

    drawCanvas(plugin);
    // $(plugin.divName).append( `
    //     <div class="${plugin.canvas}" >
    //         <canvas class="${plugin.canvasLine}" id="${plugin.canvasLine}"></canvas>
    //     </div>`
    // );

    imagescale(plugin,dto,dto.imageWidthProzent);
    initPlot();

    function initPlot() {
        let tol = 40;
        let imagepath = dto.imageUrl;
        let img = new Image();
        let c = document.getElementById(plugin.canvasLine);
        let angleField = "." + plugin.name + "_inp";
        let a = $(angleField)[0];
        let mx = -1;
        let my = -1;
        let wx = 0;
        let wy = 0;
        let cx = -1;
        let cy = -1;
        let wcx = 0;
        let wcy = 0;
        let offset;
        let mode = "NORM";
        let hachse=null;  // aktuelle horizontale Achse, kann spÃ¤ter auch mal gewechselt werden
        let vachse=null;  // aktuelle vertikale Achse
        let point=null;   // aktuell zu verschiebender Punkt
        let delpoint=null;
        let selpoint=null;
        let movebase=null;
        let baseline=null;
        try {
            hachse = dto.hachsen[0];
            vachse = dto.vachsen[0];
        } catch (e){}

        if (c == null || a == null) return;
        let resultDto = {
            points : [],
            mc : [],
            mcitems : []
        };

        if (dto.mc != null) if (dto.mc.items!=null) {
            resultDto.mcitems = dto.mc.items;
        }

        if (a.value!="") {
            try {
                resultDto = JSON.parse(a.value);
                if (dto.inputmode!="TOLINE" && dto.inputmode!="TOPOINT" && dto.inputmode!="TOARROW")
                    dto.mc.items = resultDto.mcitems;
            } catch (e) {}
        }
        let ctx = c.getContext("2d");

        drawCanvas();

        //listener for clicks on svg, and therefore image
        if (plugin.active) {
            $("."+plugin.canvas).mousemove(function (e) {
                // verarbeite die Koordinaten der Maus
                //angle = calcAngleToCenter(e.pageX, e.pageY);
                offset = getImgCoordinates();
                cx = (e.pageX - offset.x)/plugin.scale;
                cy = (e.pageY - offset.y)/plugin.scale;
                try {
                    wcx = toXCoord(hachse, cx);
                    wcy = toYCoord(vachse, cy);
                } catch (e) {}
                if (mode==="MOVE")
                    move();
                if (mode==="RESIZE")
                    resize();
                if (mode==="MOVELINE")
                    move();
                if (mode==="SECOND")
                    move();
                if (cx+20>dto.width && cy+20>dto.width) {
                    cx=-1;
                    cy=-1;
                }
                //if (plugin.iw != $(plugin.divName).innerWidth()) imagescale(plugin,dto,plugin.scaleprozent);
                drawCanvas();
            });
            $("."+plugin.canvas).mousedown(function (e) {
                mouseclick(e,"down")
            });
            $("."+plugin.canvas).mouseup(function (e) {
                // verarbeite die Koordinaten der Maus
                mouseclick(e,"up");
            });
            $("."+plugin.canvas).mouseleave(function (e) {
                if (mode==="MOVE" && point!=null) {
                    resultDto.points = resultDto.points.filter(p => p != point);
                    mode="NORM";
                }
                cx = -1;
                cy = -1;
                drawCanvas();
            });
        }
        $(window).resize(function (e) {
            imagescale(plugin,dto,plugin.scaleprozent);
            drawCanvas();
        });

        function saveResult() {
            switch (dto.inputmode) {
                default:
                    a.value = JSON.stringify(resultDto);
                    break;
                case "LINES":
                case "ARROW":
                    let json   = JSON.stringify(resultDto);
                    let result = JSON.parse(json);
                    try {
                        let ind;
                        for (ind = ((result.points.length-2)/2)*2;ind>=0;ind-=2) {
                            if (result.points[ind].mx==result.points[ind+1].mx &&
                                result.points[ind].my==result.points[ind+1].my) {
                                // lÃ¶sche die zwei Punkte da sie gleich sind!!
                                result.points.splice(ind,2);
                                //console.log("delete Point Nr."+ind+" and "+(ind+1));
                            }
                        }
                        a.value = JSON.stringify(result);
                    } catch (ex) {
                        a.value = JSON.stringify(resultDto);
                    }
                    break;
            }
        }

        function mouseclick(event,click) {
            offset = getImgCoordinates();
            let tmx = (event.pageX - offset.x)/plugin.scale;
            let tmy = (event.pageY - offset.y)/plugin.scale;
            wx = toXCoord(hachse, tmx);
            wy = toYCoord(vachse, tmy);
            if (event.button===0 && click==="down") {
                if (tmx<=20/plugin.scale && tmy<=20/plugin.scale) {
                    // Button fÃ¼r die BildvergrÃ¶ÃŸerung
                    try {
                        if (plugin.scaleprozent===100) {
                            if (dto.imageWidthProzent===100) dto.imageWidthProzent=50;
                            imagescale(plugin,dto,dto.imageWidthProzent);
                        } else {
                            imagescale(plugin,dto,100);
                        }
                        drawCanvas();
                        // openImg(imagepath);
                    } catch (ex) { }
                } else if (tmx<=20/plugin.scale && tmy>=22/plugin.scale && tmy<=42/plugin.scale && plugin.isresetable && resultDto.points.length>0) {
                    // Button fÃ¼r das RÃ¼cksetzen
                    try {
                        resultDto.points = [];
                        drawCanvas();
                        // openImg(imagepath);
                    } catch (ex) { }
                } else{
                    switch (dto.inputmode) {
                        default:
                        case "OFF":
                            break;
                        case "LINES":
                        case "LINE":
                        case "ARROW":
                        case "MEASURE":
                            mx = tmx;
                            my = tmy;
                            if (mode === "NORM") {
                                let foundpoint = findPoint(tmx, tmy);
                                if (foundpoint === null) {
                                    let foundline=findLine(tmx,tmy);
                                    if (foundline !== null) {
                                        point = foundline;
                                        mode = "MOVELINE";
                                        movebase = [tmx,tmy];
                                        baseline = [ [ foundline[0].mx, foundline[0].my ],
                                            [ foundline[1].mx, foundline[1].my ] ];
                                        delpoint = {mx: tmx, my: tmy, x: wx, y: wy};
                                    } else {
                                        let p1 = {mx: mx, my: my, x: wx, y: wy};
                                        let p2 = {mx: mx, my: my, x: wx, y: wy};
                                        if (dto.inputmode === "LINE" || dto.inputmode==="MEASURE") {
                                            resultDto = {points: [p1, p2]};
                                        } else {
                                            resultDto.points.push(p1);
                                            resultDto.points.push(p2);
                                        }
                                        point = p2;
                                        mode = "SECOND";
                                    }
                                } else {
                                    point = foundpoint;
                                    mode = "MOVE";
                                    delpoint = {mx: tmx, my: tmy, x: wx, y: wy};
                                }
                            } else {
                                point.mx = mx; point.my = my; point.x = wx; point.y = wy;
                                point = null;
                                mode = "NORM";
                            }
                            saveResult();
                            //a.value = JSON.stringify(resultDto);
                            break;
                        case "VLINE": case "HLINE": case "TOLINE": case "TOPOINT": case "TOARROW":
                        case "POINT":
                            mx = tmx;
                            my = tmy;
                            resultDto = {points: [{mx: mx, my: my, x: wx, y: wy}]};
                            break;
                        case "POINTS":
                        case "POLYLINE":
                        case "POLYGON":
                        case "FUNCTION": {
                            let foundpoint = findPoint(tmx, tmy);
                            if (foundpoint === null) {
                                point = {mx: tmx, my: tmy, x: wx, y: wy};
                                resultDto.points.push(point);
                                mode = "MOVE";
                            } else {
                                point = foundpoint;
                                mode = "MOVE";
                                delpoint = {mx: tmx, my: tmy, x: wx, y: wy};
                                // resultDto.points = resultDto.points.filter(p => p != foundpoint);
                            }
                            if (dto.inputmode === "FUNCTION") {
                                resultDto.points.sort(function (a, b) {
                                    return a.mx - b.mx
                                });
                            }
                        } break;
                        case "POLYNOM":
                            break;
                        case "MCXY" :
                        case "MC" : {
                            if (plugin.configdialog) {
                                let foundpoint = findPointMC(tmx,tmy,0.6);
                                if (foundpoint===-1) {
                                    foundpoint = findPointMC(tmx,tmy,1.5);
                                    if (foundpoint===-1) {
                                        resultDto.mcitems[resultDto.mcitems.length] = {x: tmx, y: tmy, r: 0, color: ""};
                                    } else {
                                        mode="RESIZE";
                                        selpoint=foundpoint;
                                    }
                                } else {
                                    mode="MOVE";
                                    delpoint = {mx: tmx, my: tmy, x: wx, y: wy};
                                    selpoint=foundpoint;
                                }
                            } else {
                                let foundpoint = findPointMC(tmx,tmy,1);
                                if (foundpoint>-1) {
                                    let found = false;
                                    for (let i = 0; i < resultDto.mc.length; i++) {
                                        if (resultDto.mc[i] === foundpoint) {
                                            found = true;
                                            resultDto.mc.splice(i, 1);
                                        }
                                    }
                                    if (!found) {
                                        resultDto.mc.push(foundpoint)
                                    }
                                }
                            }
                        }   break;
                    }
                    saveResult();
                    //a.value = JSON.stringify(resultDto);
                    drawCanvas();
                }
            } else  if (event.button===0 && click==="up") {
                if (mode==="MOVE") {
                    move();
                    if (delpoint!=null) {
                        if (dto.inputmode==="MC" || dto.inputmode==="MCXY") {
                            resultDto.mcitems.splice(selpoint,1);
                        } else {
                            let dx = delpoint.mx - point.mx;
                            let dy = delpoint.my - point.my;
                            if (dx * dx + dy * dy <= tol) {
                                switch (dto.inputmode) {
                                    default:
                                        break;
                                    case "LINES":
                                    case "ARROW":
                                    case "MEASURE":
                                        let ind = resultDto.points.indexOf(point);
                                        if (ind != null && ind > -1) {
                                            if (ind % 2 === 0) {
                                                resultDto.points = resultDto.points.filter(p => p != resultDto.points[ind + 1]);
                                            } else {
                                                resultDto.points = resultDto.points.filter(p => p != resultDto.points[ind - 1]);
                                            }
                                        }
                                }
                                resultDto.points = resultDto.points.filter(p => p != point);
                            }
                        }
                    }
                    delpoint=null;
                    mode="NORM";
                } else if (mode==="MOVELINE") {
                    move();
                    if (delpoint!=null) {
                        let dx = delpoint.mx - mx;
                        let dy = delpoint.my - my;
                        if (dx * dx + dy * dy <= tol) {
                            resultDto.points = resultDto.points.filter(p => p != point[0]);
                            resultDto.points = resultDto.points.filter(p => p != point[1]);
                        }
                    }
                    delpoint=null;
                    mode="NORM";
                } else if (mode==="RESIZE") {
                    resize();
                    delpoint=null;
                    mode="NORM";
                }
                saveResult();
                //a.value = JSON.stringify(resultDto);
                drawCanvas();
            }
        }

        function resize() {
            if (dto.inputmode==="MC" || dto.inputmode==="MCXY") {
                if (plugin.configdialog) {
                    let dx = resultDto.mcitems[selpoint].x-cx;
                    let dy = resultDto.mcitems[selpoint].y-cy;
                    let r = Math.sqrt(dx*dx+dy*dy);
                    resultDto.mcitems[selpoint].r = r;
                }
            }
        }

        function move() {
            if (delpoint!=null) {
                let dx = delpoint.mx - cx;
                let dy = delpoint.my - cy;
                if (dx * dx + dy * dy > tol) delpoint = null;
            }
            if (mode==="MOVELINE") {
                let v = vsub([cx,cy],movebase);
                let line = [vadd(baseline[0],v),vadd(baseline[1],v)];
                point[0].mx = line[0][0]; point[0].my = line[0][1];
                point[1].mx = line[1][0]; point[1].my = line[1][1];
                point[0].x  = toXCoord(hachse, point[0].mx);
                point[0].y  = toYCoord(vachse, point[0].my);
                point[1].x  = toXCoord(hachse, point[1].mx);
                point[1].y  = toYCoord(vachse, point[1].my);
            } else {
                if (dto.inputmode==="MC" || dto.inputmode==="MCXY") {
                    if (plugin.configdialog) {
                        if (mode==="MOVE") {
                            resultDto.mcitems[selpoint].x = cx;
                            resultDto.mcitems[selpoint].y = cy;
                        }
                    }
                } else {
                    point.mx = cx;
                    point.my = cy;
                    point.x = wcx;
                    point.y = wcy;
                    if (dto.inputmode === "FUNCTION") {
                        resultDto.points.sort(function (a, b) {
                            return a.mx - b.mx
                        });
                    }
                }
            }
            saveResult();
            //a.value = JSON.stringify(resultDto);
        }

        /**
         *  Sucht an der Cursorposition nach einem Punkt
         */
        function findPoint(x,y) {
            for (let i = 0; i < resultDto.points.length; i++) {
                let dx = resultDto.points[i].mx - x;
                let dy = resultDto.points[i].my - y;
                if (dx * dx + dy * dy < tol) {
                    return resultDto.points[i];
                }
            }
            return null;
        }

        /**
         *  Sucht an der Cursorposition nach einem Multiple-Choice-Punkt
         */
        function findPointMC(x,y,size) {
            for (let i = 0; i < resultDto.mcitems.length; i++) {
                let item = resultDto.mcitems[i];
                let r = item.r;
                if (r<1) r = dto.mc.r;
                if (r<1) r = 20;
                let dx = x-item.x;
                let dy = y-item.y;
                let R2 = dx * dx + dy * dy;
                if (R2 < size*r*r)
                    return i;
            }
            return -1;
        }

        /**
         *  Sucht an der Cursorposition nach einer Linie
         */
        function findLine(x,y) {
            for (let i = 0; i < resultDto.points.length-1; i+=2) {
                let p1 = [resultDto.points[i].mx,resultDto.points[i].my];
                let p2 = [resultDto.points[i+1].mx,resultDto.points[i+1].my];
                let p12 = vsub(p2,p1);
                let p1x = vsub([x,y],p1);
                let d   = vex(p12,p1x)/vabs(p12);
                let k   = vin(p12,p1x)/vabs(p12)/vabs(p12);
                if (dto.inputmode==="LINES" || (k>0 && k<1)) {
                    if (d * d < tol) {
                        return [resultDto.points[i], resultDto.points[i + 1]];
                    }
                }
            }
            return null;
        }

        /**
         * Zeichnen
         */
        function drawCanvas() {
            ctx.resetTransform();
            ctx.transform(plugin.scale,0,0,plugin.scale,0,0);
            try {
                ctx.clearRect(0, 0, dto.width, dto.height);
                if (img.loadComplete) {
                    ctx.drawImage(img, 0, 0, dto.width, dto.height);
                    draw();
                } else {
                    img.src = imagepath;
                    img.onload = function () {
                        img.loadComplete = true;
                        ctx.drawImage(img, 0, 0, dto.width, dto.height);
                        draw();
                    }
                }
            } catch(e) {}
        }

        /* --------------------------------------------------------------------------------------------------------
         *              D R A W
         * -------------------------------------------------------------------------------------------------------- */
        function draw() {
            let size = 20/plugin.scale;
            drawZoomIcon(ctx,0,0,size);
            if (plugin.isresetable && resultDto.points.length>0) drawResetIcon(ctx, 0,size*1.1, size);
            ctx.font = '16px serif';
            // Ausgabe des INPUT-Elements
            try {
                switch (dto.inputmode) {
                    default:
                    case "OFF":
                        break;
                    case "LINES":
                    case "LINE": {
                        for (i = 0; i < resultDto.points.length; i++) {
                            fillCircle(ctx, resultDto.points[i].mx, resultDto.points[i].my, 3, "black");
                        }
                        for (i=0;i<resultDto.points.length-1;i+=2) {
                            let m1 = resultDto.points[i];
                            let m2 = resultDto.points[i+1];
                            ctx.strokeStyle = "red";
                            let dx = m1.mx - m2.mx;
                            let dy = m1.my - m2.my;
                            if (Math.abs(dx) > Math.abs(dy)) {
                                let k = dy / dx;
                                let d = m1.my - k * m1.mx;
                                dLine(0, d, dto.width, k * dto.width + d, 2);
                            } else {
                                let k = dx / dy;
                                let d = m1.mx - k * m1.my;
                                dLine(d, 0, k * dto.height + d, dto.height, 2);
                            }
                        }
                    } break;
                    case "ARROW": {
                        for (i=0;i<resultDto.points.length-1;i+=2) {
                            let m1 = resultDto.points[i];
                            let m2 = resultDto.points[i+1];
                            drawArrow(ctx, m1.mx, m1.my, m2.mx, m2.my, 3, "red");
                        }
                    }
                        break;
                    case "MEASURE":
                        let m1 = resultDto.points[0];
                        let m2 = resultDto.points[1];
                        if (mode === "SECOND") {
                            m2 = {mx: cx, my: cy, x: wcx, y: wcy};
                        }
                        if ((mode === "NORM" || cx > -1 || cy > -1) && resultDto.points.length > 0) {
                            if (m1.mx > 0 && m1.my > 0) {
                                ctx.strokeStyle = "red";
                                dLine(m1.mx, m1.my, m2.mx, m2.my, 3);
                                ctx.strokeStyle = "orange";
                                dLine(m1.mx, m1.my, m2.mx, m1.my, 2);
                                dLine(m2.mx, m2.my, m2.mx, m1.my, 2);
                                let dx = m2.x - m1.x;
                                let dy = m2.y - m1.y;
                                let abs = Math.sqrt(dx * dx + dy * dy);
                                let arg = Math.atan2(dy, dx);
                                let arggrad = arg * 180 / Math.PI;
                                sm = sprintNumber(m1.x) + "/" + sprintNumber(m1.y);
                                sc = sprintNumber(m2.x) + "/" + sprintNumber(m2.y);
                                sdx = sprintNumber(dx);
                                sdy = sprintNumber(dy);
                                sabs = sprintNumber(abs);
                                sarg = sprintNumber(arg);
                                sgrad = sprintNumber(arggrad) + "Â°";
                                if (m1.mx < m2.mx) {
                                    ctx.fillStyle = "lightgray";
                                    ctx.fillRect(m1.mx - 105, m1.my - 8, 98, 17);
                                    ctx.fillRect(m2.mx + 10, m2.my, 98, 17);
                                    ctx.fillStyle = "red";
                                    ctx.fillText(sm, m1.mx - 100, m1.my + 7);
                                    ctx.fillText(sc, m2.mx + 15, m2.my + 14);
                                    if (m1.my > m2.my) {
                                        ctx.fillStyle = "lightgray";
                                        ctx.fillRect(m1.mx + 4, m1.my - 18, 55, 17);
                                        ctx.fillStyle = "red";
                                        ctx.fillText(sgrad, m1.mx + 4, m1.my - 2);
                                    } else {
                                        ctx.fillStyle = "lightgray";
                                        ctx.fillRect(m1.mx + 4, m1.my, 55, 17);
                                        ctx.fillStyle = "red";
                                        ctx.fillText(sgrad, m1.mx + 4, m1.my + 15);
                                    }
                                    ctx.fillStyle = "gray";
                                    ctx.fillRect(m2.mx + 3, (m1.my + m2.my) / 2 - 8, 55, 17);
                                    ctx.fillStyle = "orange";
                                    ctx.fillText(sdy, m2.mx + 5, (m1.my + m2.my) / 2 + 7);
                                } else {
                                    ctx.fillStyle = "lightgray";
                                    ctx.fillRect(m2.mx - 105, m2.my - 8, 98, 17);
                                    ctx.fillRect(m1.mx + 10, m1.my, 98, 17);
                                    ctx.fillStyle = "red";
                                    ctx.fillText(sm, m2.mx - 100, m2.my + 7);
                                    ctx.fillText(sc, m1.mx + 15, m1.my + 14);
                                    if (m1.my > m2.my) {
                                        ctx.fillStyle = "lightgray";
                                        ctx.fillRect(m1.mx - 58, m1.my - 18, 55, 17);
                                        ctx.fillStyle = "red";
                                        ctx.fillText(sgrad, m1.mx - 55, m1.my - 2);
                                    } else {
                                        ctx.fillStyle = "lightgray";
                                        ctx.fillRect(m1.mx - 58, m1.my, 55, 17);
                                        ctx.fillStyle = "red";
                                        ctx.fillText(sgrad, m1.mx - 55, m1.my + 15);
                                    }
                                    ctx.fillStyle = "gray";
                                    ctx.fillRect(m2.mx - 60, (m1.my + m2.my) / 2 - 8, 55, 17);
                                    ctx.fillStyle = "orange";
                                    ctx.fillText(sdy, m2.mx - 57, (m1.my + m2.my) / 2 + 7);
                                }
                                if (m1.my > m2.my) {
                                    ctx.fillStyle = "lightgray";
                                    ctx.fillRect((m1.mx + m2.mx) / 2 - 30, (m1.my + m2.my) / 2 - 8, 60, 17);
                                    ctx.fillStyle = "red";
                                    ctx.fillText(sabs, (m1.mx + m2.mx) / 2 - 26, (m1.my + m2.my) / 2 + 7);
                                    ctx.fillStyle = "gray";
                                    ctx.fillRect((m1.mx + m2.mx) / 2 - 30, m1.my, 55, 17);
                                    ctx.fillStyle = "orange";
                                    ctx.fillText(sdx, (m1.mx + m2.mx) / 2 - 27, m1.my + 14);
                                } else {
                                    ctx.fillStyle = "lightgray";
                                    ctx.fillRect((m1.mx + m2.mx) / 2 - 30, (m1.my + m2.my) / 2 - 8, 60, 17);
                                    ctx.fillStyle = "red";
                                    ctx.fillText(sabs, (m1.mx + m2.mx) / 2 - 26, (m1.my + m2.my) / 2 + 7);
                                    ctx.fillStyle = "gray";
                                    ctx.fillRect((m1.mx + m2.mx) / 2 - 30, m1.my - 17, 55, 17);
                                    ctx.fillStyle = "orange";
                                    ctx.fillText(sdx, (m1.mx + m2.mx) / 2 - 27, m1.my);
                                }
                            }
                        }
                        break;
                    case "VLINE":
                        for (i = 0; i < resultDto.points.length; i++) {
                            fillCircle(ctx, resultDto.points[i].mx, resultDto.points[i].my, 3, "red");
                            ctx.strokeStyle = "red";
                            dLine(resultDto.points[i].mx,0,resultDto.points[i].mx,dto.height,2);
                        }
                        break;
                    case "HLINE":
                        for (i = 0; i < resultDto.points.length; i++) {
                            fillCircle(ctx, resultDto.points[i].mx, resultDto.points[i].my, 3, "red");
                            ctx.strokeStyle = "red";
                            dLine(0,resultDto.points[i].my,dto.width,resultDto.points[i].my,2);
                        }
                        break;
                    case "TOLINE": case "TOPOINT": case "TOARROW":
                        let tox = 0;
                        let toy = 0;
                        try {
                            tox = toXScreen(hachse, dto.mc.items[0].x);
                            toy = toYScreen(vachse,dto.mc.items[0].y);
                            fillCircle(ctx, tox, toy, 3, "blue");
                        } catch (e) {}
                        if (dto.cursor != "OFF" && cx > 0 && cy > 0) {
                            ctx.strokeStyle = "magenta";
                            if (dto.inputmode=="TOARROW") drawArrow(ctx,tox,toy,cx,cy,1,"magenta");
                            else if (dto.inputmode=="TOLINE") {
                                ctx.strokeStyle = "magenta";
                                let dx = cx - tox;
                                let dy = cy - toy;
                                if (Math.abs(dx) > Math.abs(dy)) {
                                    let k = dy / dx;
                                    let d = cy - k * cx;
                                    dLine(0, d, dto.width, k * dto.width + d, 1);
                                } else {
                                    let k = dx / dy;
                                    let d = cx - k * cy;
                                    dLine(d, 0, k * dto.height + d, dto.height, 1);
                                }
                            }
                            else dLine(tox,toy,cx,cy,1);
                        }
                        for (i = 0; i < resultDto.points.length; i++) {
                            if (dto.inputmode=="TOPOINT" || dto.inputmode=="TOLINE") fillCircle(ctx, resultDto.points[i].mx, resultDto.points[i].my, 3, "red");
                            ctx.strokeStyle = "red";
                            if (dto.inputmode=="TOARROW") drawArrow(ctx,tox,toy,resultDto.points[i].mx,resultDto.points[i].my,2,"red");
                            else if (dto.inputmode=="TOLINE") {
                                let m1 = resultDto.points[i];
                                ctx.strokeStyle = "red";
                                let dx = m1.mx - tox;
                                let dy = m1.my - toy;
                                if (Math.abs(dx) > Math.abs(dy)) {
                                    let k = dy / dx;
                                    let d = m1.my - k * m1.mx;
                                    dLine(0, d, dto.width, k * dto.width + d, 2);
                                } else {
                                    let k = dx / dy;
                                    let d = m1.mx - k * m1.my;
                                    dLine(d, 0, k * dto.height + d, dto.height, 2);
                                }
                            }
                            else dLine(tox,toy,resultDto.points[i].mx,resultDto.points[i].my,2);
                        }
                        break;
                    case "POINT":
                    case "POINTS":
                        for (i = 0; i < resultDto.points.length; i++) {
                            fillCircle(ctx, resultDto.points[i].mx, resultDto.points[i].my, 3, "red");
                        }
                        break;
                    case "FUNCTION":
                    case "POLYLINE":
                        if (resultDto.points.length == 1) {
                            fillCircle(ctx, resultDto.points[0].mx, resultDto.points[0].my, 3, "red");
                        }
                        for (i = 1; i < resultDto.points.length; i++) {
                            ctx.strokeStyle = "red";
                            let print=true;
                            if (dto.inputmode==="FUNCTION") {
                                if (resultDto.points[i-1].my>dto.height*0.95 && resultDto.points[i].my<dto.height*0.05) print=false;
                                if (resultDto.points[i].my>dto.height*0.95 && resultDto.points[i-1].my<dto.height*0.05) print=false;
                            }
                            if (print) dLine(resultDto.points[i - 1].mx, resultDto.points[i - 1].my,
                                resultDto.points[i].mx, resultDto.points[i].my, 3);
                        }
                        break;
                    case "POLYGON":
                        if (resultDto.points.length > 0) {
                            fillCircle(ctx, resultDto.points[0].mx, resultDto.points[0].my, 3, "red");
                        }
                        for (i = 1; i < resultDto.points.length; i++) {
                            ctx.strokeStyle = "red";
                            dLine(resultDto.points[i - 1].mx, resultDto.points[i - 1].my,
                                resultDto.points[i].mx, resultDto.points[i].my, 3);
                        }
                        if (resultDto.points.length > 1) {
                            ctx.strokeStyle = "red";
                            dLine(resultDto.points[resultDto.points.length - 1].mx, resultDto.points[resultDto.points.length - 1].my,
                                resultDto.points[0].mx, resultDto.points[0].my, 3);
                        }
                        break;
                    case "POLYNOM":
                        break;
                    case "MCXY":
                    case "MC": {
                        let foundpoint = findPointMC(cx,cy,1);
                        for (let i=0;i<dto.mc.items.length;i++) {
                            let item = {...dto.mc.items[i]};
                            if (!(item.color.length>0)) item.color = dto.mc.color;
                            if (!(item.color.length>0)) item.color = "red";
                            if (!(item.r>0)) item.r = dto.mc.r;
                            if (!(item.r>0)) item.r = 20;
                            if (plugin.configdialog) {
                                drawCircle(ctx,item.x,item.y,item.r,4,item.color);
                                drawTextCS(ctx,item.x,item.y,i,item.r, "black",true,true);
                            } else {
                                let found = false;
                                for (let j = 0; j < resultDto.mc.length; j++) {
                                    if (resultDto.mc[j] === i)
                                        found = true;
                                }
                                if (found && foundpoint===i)
                                    fillCircle(ctx,item.x,item.y,item.r,item.color,0.6);
                                else if (found)
                                    fillCircle(ctx,item.x,item.y,item.r,item.color,0.6);
                                else if (foundpoint===i)
                                    fillCircle(ctx,item.x,item.y,item.r,"lightgray",0.5);
                                drawCircle(ctx,item.x,item.y,item.r,4,item.color);
                            }
                        }
                    } break;
                }
            } catch (e){}
            // Ausgabe des Cursors
            try {
                if (dto.inputmode==="MC" || dto.inputmode==="MCXY") {
                    dto.cursor="OFF";
                }
                if (dto.cursor != "OFF" && cx > 0 && cy > 0) {

                    ctx.strokeStyle = "magenta";
                    switch(dto.cursor) {
                        case "POINT": case "PNUM": case "PARG":
                            fillCircle(ctx, cx, cy, 3, "magenta");
                            break;
                        case "HLINE": case "HNUM":
                            dLine(0, cy, dto.width, cy, 1/plugin.scale);
                            break;
                        case "VLINE": case "VNUM":
                            dLine(cx, 0, cx, dto.height, 1/plugin.scale);
                            break;
                        case "CREL":
                            let mtx = toXScreen(hachse,0);
                            let mty = toYScreen(vachse,0);
                            if (dto.inputmode === "TOLINE" || dto.inputmode === "TOPOINT" || dto.inputmode === "TOARROW") {
                                try {
                                    mtx = toXScreen(hachse,dto.mc.items[0].x);
                                    mty = toYScreen(vachse,dto.mc.items[0].y);
                                } catch (e) {
                                    mtx = toXScreen(hachse,0);
                                    mty = toYScreen(vachse,0);
                                }
                            } else {
                                try {
                                    mtx = resultDto.points[resultDto.points.length-1].mx;
                                    mty = resultDto.points[resultDto.points.length-1].my;
                                } catch (e) {
                                    mtx = toXScreen(hachse,0);
                                    mty = toYScreen(vachse,0);
                                }
                            }
                            dLine(mtx,mty,cx,cy,1/plugin.scale);
                        default:
                            dLine(0, cy, dto.width, cy, 1/plugin.scale);
                            dLine(cx, 0, cx, dto.height, 1/plugin.scale);
                            break;
                    }
                    // Pixel-Koordinaten direkt am Cursor
                    if (dto.cursor === "PIXEL" || dto.cursor === "ALL") {
                        ctx.font = '16px serif';
                        let s = "(" + Math.trunc(cx) + "/" + Math.trunc(cy) + ")";
                        let tw = ctx.measureText(s).width+8;
                        let tws = tw/plugin.scale;
                        let twh = 20/plugin.scale;
                        let x = cx > dto.width - tws ? cx - tws : cx + 4;
                        let y = cy < twh ? cy + twh+4 : cy - 3;
                        ctx.translate(x,y);
                        ctx.transform(1/plugin.scale,0,0,1/plugin.scale,0,0);
                        ctx.fillStyle = "white";
                        ctx.fillRect(4,-20,tw,20);
                        drawRect(ctx,4,-20,tw,20,1,"gray");
                        ctx.fillStyle = "gray";
                        ctx.fillText(s, 8, -5);
                        ctx.transform(plugin.scale,0,0,plugin.scale,0,0);
                        ctx.translate(-x,-y);
                    }
                    // Ausgabe der Cursor-Legende in der FuÃŸzeile
                    if (dto.cursor === "NUMBERS" || dto.cursor === "ALL"  || dto.cursor === "CNUM" ||
                        dto.cursor === "CARG" || dto.cursor === "PNUM" || dto.cursor === "PARG" ||
                        dto.cursor === "CREL" || dto.cursor === "HNUM" || dto.cursor === "VNUM" ) {
                        ctx.font = '16px serif';
                        let j = -1;
                        let sx = ""; // Wert/Werte als String fÃ¼r die x-Achse
                        let sy = ""; // Wert/Werte als String fÃ¼r die y-Achse
                        let sabs = ""; // Betrag als String
                        let sarg = ""; // Betrag als Winkel in Grad als String
                        // Werte welche fÃ¼r die CARG,PARG benÃ¶tigt werden

                        let xwert=null;
                        let xeinheit="";
                        let ywert=null;

                        let tox = 0;
                        let toy = 0;
                        if (dto.inputmode === "TOLINE" || dto.inputmode === "TOPOINT" || dto.inputmode === "TOARROW") {
                            try {
                                tox = dto.mc.items[0].x;
                                toy = dto.mc.items[0].y;
                            } catch (e) {
                                tox = 0;
                                toy = 0;
                            }
                        } else {
                            try {
                                tox = resultDto.points[resultDto.points.length-1].x;
                                toy = resultDto.points[resultDto.points.length-1].y;
                            } catch (e) {
                                tox = 0;
                                toy = 0;
                            }
                        }

                        // Berechnung
                        for (i = 0; i < dto.hachsen.length; i++) {
                            j++;
                            achse = dto.hachsen[i];
                            if (sx.length>0) sx += "  ";
                            sx += achse.name + ":";
                            if (achse.einheit==="Â°") {
                                sx += sprintNumber(toXCoord(achse, cx)*180/Math.PI)+"Â°";
                            } else if (achse.skala==="dB") {
                                sx += sprintNumber(20*Math.log10(toXCoord(achse, cx)))+"dB";
                            } else {
                                let wx = toEinheitWert(achse,toXCoord(achse, cx));
                                if (xwert==null) {
                                    if (dto.cursor === "CREL") {
                                        wx = wx-tox;
                                    }
                                    xwert    = wx;
                                    xeinheit = achse.einheit;
                                }
                                sx += sprintNumber(wx)+achse.einheit;
                            }
                        }
                        for (i = 0; i < dto.vachsen.length; i++) {
                            j++;
                            achse = dto.vachsen[i];
                            if (sy.length>0) sy += "  ";
                            sy += achse.name + ":";
                            if (achse.einheit==="Â°") {
                                sy += sprintNumber(toYCoord(achse, cy)*180/Math.PI)+"Â°";
                            } else if (achse.skala==="dB") {
                                sy += sprintNumber(20*Math.log10(toYCoord(achse, cy)))+"dB";
                            } else {
                                let wy=toEinheitWert(achse,toYCoord(achse, cy));
                                if (xwert!=null && ywert==null) {
                                    if (achse.einheit === xeinheit) {
                                        if (dto.cursor === "CREL") {
                                            wy = wy-toy;
                                        }
                                        ywert    = wy;
                                    }
                                }
                                sy += sprintNumber(wy)+achse.einheit;
                            }
                        }
                        // Berechne Abs und Arg
                        if (dto.cursor === "CARG" || dto.cursor === "PARG" || dto.cursor === "CREL") {
                            if (xwert!=null && ywert!=null) {
                                let abs = Math.sqrt(xwert*xwert+ywert*ywert);
                                let arg = Math.atan2(ywert,xwert)*180/Math.PI;
                                sabs = "abs:"+sprintNumber(abs)+xeinheit;
                                sarg = "arg:"+sprintNumber(arg)+"Â°";
                            }
                        }

                        // Ausgabe der FuÃŸzeile
                        ctx.fillStyle = "gray";
                        if (dto.cursor === "HNUM") {
                            ctx.fillText(sy, 5, dto.height - 3);
                        } else if (dto.cursor === "VNUM") {
                            ctx.fillText(sx , 5, dto.height - 3);
                        } else if (sabs.length>0 || sarg.length>0) {
                            ctx.fillText(sx + "  " + sy + " "+sabs+" "+sarg, 5, dto.height - 3);
                        } else {
                            ctx.fillText(sx + "  " + sy, 5, dto.height - 3);
                        }
                        ctx.fillStyle = "white";

                        // Ausgabe der Cursor-Legende direkt am Cursor mit Zahlenwerten
                        if (dto.cursor === "CNUM" || dto.cursor === "CREL" ||
                            dto.cursor === "CARG" || dto.cursor === "PNUM" || dto.cursor === "PARG" ||
                            dto.cursor === "HNUM" || dto.cursor === "VNUM" ) {
                            // Breite berechnen
                            let tw = Math.max(ctx.measureText(sx).width,ctx.measureText(sy).width)+8;
                            if (dto.cursor === "HNUM")                               tw = ctx.measureText(sy).width+8;
                            else if (dto.cursor === "VNUM")                          tw = ctx.measureText(sx).width+8;
                            else if (sabs.length>0 || sarg.length>0) tw = Math.max(ctx.measureText(sx).width,ctx.measureText(sy).width,ctx.measureText(sabs).width,ctx.measureText(sarg).width)+8;
                            let tws = tw/plugin.scale;
                            // HÃ¶he berechnen
                            let twh = 40/plugin.scale;
                            if (dto.cursor === "HNUM" || dto.cursor === "VNUM")      twh=20/plugin.scale;
                            else if (sabs.length>0 || sarg.length>0) twh=80/plugin.scale;

                            let x = cx > dto.width - tws ? cx - tws - 4 : cx + 4;
                            let y = cy < twh ? cy + twh+4 : cy - 4;

                            ctx.translate(x,y);
                            ctx.transform(1/plugin.scale,0,0,1/plugin.scale,0,0);
                            ctx.fillStyle = "white";
                            if (dto.cursor === "HNUM" || dto.cursor === "VNUM") {
                                ctx.fillRect(4, -20, tw, 20);
                                drawRect(ctx, 4, -20, tw, 20, 1, "gray");
                            } else if (sabs.length>0 || sarg.length>0) {
                                ctx.fillRect(4,-80,tw,80);
                                drawRect(ctx, 4, -80, tw, 80, 1, "gray");
                            } else {
                                ctx.fillRect(4,-40,tw,40);
                                drawRect(ctx, 4, -40, tw, 40, 1, "gray");
                            }
                            ctx.fillStyle = "gray";
                            if (dto.cursor === "HNUM") {
                                ctx.fillText(sy, 8, -4);
                            } else if (dto.cursor === "VNUM") {
                                ctx.fillText(sx, 8, -4);
                            } else if (sabs.length>0 || sarg.length>0) {
                                ctx.fillText(sx, 8, -63);
                                ctx.fillText(sy, 8, -43);
                                ctx.fillText(sabs, 8, -23);
                                ctx.fillText(sarg, 8, -4);
                            } else {
                                ctx.fillText(sx, 8, -23);
                                ctx.fillText(sy, 8, -4);
                            }
                            ctx.transform(plugin.scale,0,0,plugin.scale,0,0);
                            ctx.translate(-x,-y);
                        }
                    }
                }
            } catch (e) {}
        }

        function dLine(x1, y1, x2, y2, width) {
            ctx.beginPath();
            ctx.moveTo(x1, y1);
            ctx.lineTo(x2, y2);
            ctx.lineWidth = width;
            ctx.stroke();
        }

        function drawText(x, y, text) {
            ctx.font = '48px serif';
            ctx.fillText(text, x, y);
        }

        /** @returns coordinates of left-upper corner of image */
        function getImgCoordinates() {
            const offs = $("."+plugin.canvas).offset();
            return {
                x: offs.left,
                y: offs.top
            };
        }

        function toEinheitWert(achse, wert) {
            return (wert-achse.einheitoffset)/achse.einheitfaktor;
        }

        /**
         * Wandelt eine x-Bildschirmkoordinate in eine Koordinate im Bildbereich
         * @param pixel Koordinate am Bildschirm
         * @return  Koordinate im Bildbereich
         */
        function toXCoord(achse, pixel) {
            sk = ScreenToSkala(achse, pixel-dto.xtranslate);
            x  = SkalaToWert(achse, sk);
            return x;
        }

        /**
         * Wandelt eine y-Bildschirmkoordinate in eine Koordinate im Bildbereich
         * @param pixel Koordinate am Bildschirm
         * @return  Koordinate im Bildbereich
         */
        function toYCoord(achse, pixel) {
            sk = ScreenToSkala(achse, pixel-dto.ytranslate);
            x  = SkalaToWert(achse, sk);
            return x;
        }

        /**
         * Wandelt einen Wert aus dem Koordinatensystem auf eine Bildschirmkoordinate - Umkehrfunktion zu toXCoord
         * @param achse Koordinatenachse
         * @param wert  Wert auf der Achse
         * @return Bildschirmkoordinate
         */
        function toXScreen(achse,wert) {
            sk    = WertToSkala(achse,wert);
            pixel = SkalaToScreen(achse,sk)+dto.xtranslate;
            return pixel;
        }

        /**
         * Wandelt einen Wert aus dem Koordinatensystem auf eine Bildschirmkoordinate - Umkehrfunktion zu toXCoord
         * @param achse Koordinatenachse
         * @param wert  Wert auf der Achse
         * @return Bildschirmkoordinate
         */
        function toYScreen(achse,wert) {
            sk    = WertToSkala(achse,wert);
            pixel = SkalaToScreen(achse,sk)+dto.ytranslate;
            return pixel;
        }

        /**
         * Wandelt eine Bildschirmkoordinate in einen Skalenwert
         * @param pixel Bildschirmkoordinate
         * @return      Skalenwert
         */
        function ScreenToSkala(achse, pixel) {
            skalenwert = (pixel-achse.origin)/achse.pixelProEinheit;
            return skalenwert;
        }

        /**
         * Wandelt einen Skalenwert in eine Bildschirmkoordinate
         * @param skalenwert Wert
         * @return      Skalenwert
         */
        function SkalaToScreen(achse, skalenwert) {
            pixel = skalenwert*achse.pixelProEinheit + achse.origin;
            return pixel
        }

        /**
         * Wandelt einen Skalenwert in einer originalen Wert im Bildbereich um.<br>
         * @param skalenwert Wert im Skalenbereich
         * @return           Wert im Bildbereich
         */
        function SkalaToWert(achse, skalenwert) {
            switch(achse.skala) {
                default:
                case "LINEAR":
                    return skalenwert;
                case "LOG":
                    return Math.pow(10,skalenwert);
                case "dB":
                    return Math.pow(10,skalenwert/20.0);
            }
        }

        /**
         * Wandelt einen originalen Wert im Bildbereich um in einen Skalenwert.<br>
         * @param wert Wert im Bildbereich
         * @return     Wert im Skalenbereich
         */
        function WertToSkala(achse, wert) {
            switch(achse.skala) {
                default:
                case "LINEAR":
                    return wert;
                case "LOG":
                    return Math.log10(wert);
                case "dB":
                    return 20.0*Math.log10(wert);
            }
        }

        function sprintNumber(number) {
            if (Math.abs(number)<1e-30) return "0.0";
            if (Math.abs(number)>1e5) return number.toExponential(4);
            if (Math.abs(number)<1e-2) return number.toExponential(4);
            if (Math.abs(number)>=1000) return number.toFixed(0);
            if (Math.abs(number)>=100) return number.toFixed(1);
            if (Math.abs(number)>=10) return number.toFixed(2);
            if (Math.abs(number)>=1) return number.toFixed(3);
            if (Math.abs(number)>=0.1) return number.toFixed(4);
            if (Math.abs(number)>=0.01) return number.toFixed(5);
            return number.toFixed(4);
        }
    }
}

$=jQuery;

function initPluginMultiMeter(dtoString, active) {
    dtoString = dtoString.replaceAll("\\","");
    let dto = JSON.parse(dtoString);
    let plugin = new Object();
    plugin.name = dto.tagName;
    plugin.divName = "#" + plugin.name+"_div";
    plugin.canvas = "canvasContainer"+plugin.name;
    plugin.canvasLine = "canvasLine"+plugin.name;
    plugin.active = active;
    plugin.back = false;
    plugin.MG = {Manz:1};

    drawCanvas(plugin);
    // $(plugin.divName).append( `
    //     <div class="${plugin.canvas}" >
    //         <canvas class="${plugin.canvasLine}" id="${plugin.canvasLine}"></canvas>
    //     </div>`
    // );
    imagescale(plugin,dto,dto.imageWidthProzent);
    initMG();
    initMultimeter();

    /*
    function imagescale(plugin, scaleprozent) {
        if (scaleprozent===null || (!scaleprozent>1)) scaleprozent=100;
        let iw = $(plugin.divName).innerWidth();
        if (iw<300) iw=300;
        plugin.scaleprozent = scaleprozent;
        plugin.scale  =  iw/dto.width*scaleprozent*0.01;
        plugin.width  = dto.width  * plugin.scale;
        plugin.height = dto.height * plugin.scale;
        document.getElementById(plugin.canvasLine).setAttribute("width",plugin.width+"px");
        document.getElementById(plugin.canvasLine).setAttribute("height",plugin.height+"px");
    }*/

    function initMultimeter() {
        let tol = 40;
        let imagepath = dto.imageUrl;
        let img = new Image();
        let imgfront = new Image();
        let imgback  = new Image();
        let c = document.getElementById(plugin.canvasLine);
        let angleField = "." + plugin.name + "_inp";
        let a = $(angleField)[0];
        let mx = -1;
        let my = -1;
        let cx = 0;
        let cy = 0;
        let mode = "NORM";
        let offset;

        if (c == null || a == null) return;
        let resultDto = {
            sicherung:0
        };
        if (a.value!="") {
            resultDto = JSON.parse(a.value);
            try {
                if (!(dto.inputmode==="IMAGE")) {
                    dto.mbs = resultDto.mbs;
                    dto.mbs2 = resultDto.mbs2;
                    dto.mode= resultDto.mode;
                    plugin.MG.Z = resultDto.z;
                }
            } catch (e) {}
        }
        let ctx = c.getContext("2d");
        drawCanvas();

        //listener for clicks on svg, and therefore image
        if (plugin.active) {
            $("."+plugin.canvas).mousemove(function (e) {
                // verarbeite die Koordinaten der Maus
                //angle = calcAngleToCenter(e.pageX, e.pageY);
                offset = getImgCoordinates();
                cx = (e.pageX - offset.x)/plugin.scale;
                cy = (e.pageY - offset.y)/plugin.scale;
                if (cx<=20/plugin.scale && cy<=42/plugin.scale) {
                    cx=-1;
                    cy=-1;
                }
                drawCanvas();
            });
            $("."+plugin.canvas).mousedown(function (e) {
                mouseclick(e,"down")
            });
            $("."+plugin.canvas).mouseup(function (e) {
                // verarbeite die Koordinaten der Maus
                mouseclick(e,"up");
            });
            $("."+plugin.canvas).mouseleave(function (e) {
                cx = -1;
                cy = -1;
                drawCanvas();
            });
        }
        $(window).resize(function (e) {
            imagescale(plugin,dto,plugin.scaleprozent);
            drawCanvas();
        });

        function mouseclick(event,click) {
            offset = getImgCoordinates();
            let tmx = (event.pageX - offset.x)/plugin.scale;
            let tmy = (event.pageY - offset.y)/plugin.scale;
            if (event.button===0 && click==="down") {
                if (tmx<=20/plugin.scale && tmy<=20/plugin.scale) {
                    // Button fÃ¼r die BildvergrÃ¶ÃŸerung
                    try {
                        if (plugin.scaleprozent===100) {
                            imagescale(plugin,dto,dto.imageWidthProzent);
                        } else {
                            imagescale(plugin,dto,100);
                        }
                        drawCanvas();
                        // openImg(imagepath);
                    } catch (ex) { }
                } else if (tmx<=20/plugin.scale && tmy<=42/plugin.scale) {
                    // Button fÃ¼r die RÃ¼ckseite
                    try {
                        if (dto.backImage.length>0) {
                            plugin.back=!plugin.back;
                            drawCanvas();
                        }
                    } catch (ex) { }
                } else {
                    clickMG(tmx,tmy);
                    a.value = JSON.stringify(resultDto);
                    drawCanvas();
                }
            } else  if (event.button===0 && click==="up") {
                a.value = JSON.stringify(resultDto);
                drawCanvas();
            }
        }

        /**
         * Zeichnen
         */
        function drawCanvas() {
            ctx.resetTransform();
            ctx.transform(plugin.scale,0,0,plugin.scale,0,0);
            try {
                ctx.clearRect(0, 0, dto.width, dto.height);
                if (plugin.back && imgback.loadComplete) {
                    ctx.drawImage(imgback, 0, 0);
                    draw();
                    return;
                } else if (dto.inputmode==="IMAGE" && img.loadComplete) {
                    ctx.drawImage(img, 0, 0);
                    draw();
                    return;
                } else if (imgfront.loadComplete) {
                    ctx.drawImage(imgfront, 0, 0);
                    draw();
                    return;
                }
                img.src = imagepath;
                img.onload = function () {
                    img.loadComplete = true;
                    if (dto.inputmode==="IMAGE") {
                        ctx.drawImage(img, 0, 0);
                        draw();
                    }
                }
                imgfront.src = dto.frontImage;
                imgfront.onload = function () {
                    imgfront.loadComplete = true;
                    if (!(dto.inputmode==="IMAGE") && !plugin.back) {
                        ctx.drawImage(imgfront, 0, 0);
                        draw();
                    }
                }
                imgback.src = dto.backImage;
                imgback.onload = function () {
                    imgback.loadComplete = true;
                    if (plugin.back) {
                        ctx.drawImage(imgback, 0, 0);
                        draw();
                    }
                }
            } catch(e) {

            }
        }

        /* --------------------------------------------------------------------------------------------------------
         *              D R A W
         * -------------------------------------------------------------------------------------------------------- */
        function draw() {
            let size = 20/plugin.scale;
            drawZoomIcon(ctx,0,0,size);
            if (dto.backImage.length>0) {
                let x = 0;
                let y = size*1.1;
                let a=size/10.0;
                ctx.fillStyle = "lightgray";
                ctx.strokeStyle="black";
                ctx.fillRect(x,y,size,size);
                let w = size/10.0
                ctx.lineWidth = w;
                drawLine(ctx,x+a,y+5*a,x+9*a,y+5*a,w);
                drawLine(ctx,x+a,y+5*a,x+3*a,y+4*a,w);
                drawLine(ctx,x+a,y+5*a,x+3*a,y+6*a,w);
                drawLine(ctx,x+9*a,y+5*a,x+7*a,y+4*a,w);
                drawLine(ctx,x+9*a,y+5*a,x+7*a,y+6*a,w);
            }
            ctx.font = '16px serif';
            // Ausgabe des INPUT-Elements
            try {
                if (!plugin.back) {
                    drawMG();
                }
            } catch (e){}
            if (dto.cursor === "ON" && cx > 0 && cy > 0) {
                drawFadenkreuz(ctx,cx,cy,dto.width, dto.height,plugin.scale);
            }
        }

        function dLine(x1, y1, x2, y2, width) {
            ctx.beginPath();
            ctx.moveTo(x1, y1);
            ctx.lineTo(x2, y2);
            ctx.lineWidth = width;
            ctx.stroke();
        }

        function drawText(x, y, text) {
            ctx.font = '48px serif';
            ctx.fillText(text, x, y);
        }

        /** @returns coordinates of left-upper corner of image */
        function getImgCoordinates() {
            const offs = $("."+plugin.canvas).offset();
            return {
                x: offs.left,
                y: offs.top
            };
        }

        function inRect(x,y,x1,y1,x2,y2) {
            if (x1>x2) { let h=x2;x2=x1;x1=h; }
            if (y1>y2) { let h=y2;y2=y1;y1=h; }
            let result = (x>=x1 && x<=x2 && y>=y1 && y<=y2);
            return result;
        }

        function inKreis(x,y,Mx,My,r) {
            return ((Mx-x)*(Mx-x)+(My-y)*(My-y)<=r*r);
        }

        function clickMG(x,y) {
            if (dto.messgeraet === "UNIGOR") {
                // ModeSchalter
                if (inRect(x, y, 290, 905, 310, 1000)) dto.mode = "PLUS";
                if (inRect(x, y, 322, 905, 342, 1000)) dto.mode = "MINUS";
                if (inRect(x, y, 354, 905, 374, 1000)) dto.mode = "WECHSEL";
            }
            if (dto.messgeraet === "GANZUNIV1") {
                // ModeSchalter
                if (inRect(x, y, 118, 909, 187, 987)) dto.mode = "PLUS";
                if (inRect(x, y, 224, 909, 292, 987)) dto.mode = "WECHSEL";
                if (inRect(x, y, 388, 909, 454, 987)) dto.mode = "PLUS";
                if (inRect(x, y, 495, 909, 563, 987)) dto.mode = "MINUS";
            }
            if (dto.messgeraet === "NORMAMETER") {
                // Messbereichsschalter
                if (inKreis(x,y,plugin.MG.MSx2,plugin.MG.MSy2,plugin.MG.MSr2/4)) {
                    dto.mbs2 = (dto.mbs2+1)%plugin.MG.Manz2Max;
                } else if (inKreis(x,y,plugin.MG.MSx2,plugin.MG.MSy2,plugin.MG.MSr2+50)) {
                    let f = -Math.atan2(y-plugin.MG.MSy2, x-plugin.MG.MSx2)+3*Math.PI/2;
                    f = f-plugin.MG.Moffset2;
                    if (f<0) f += 2*Math.PI;
                    let mbs2 = Math.trunc(f/(2*Math.PI)*plugin.MG.Manz2+0.5) % plugin.MG.Manz2;
                    if (mbs2<plugin.MG.Manz2Max) dto.mbs2 = mbs2;
                }
            }
            if (dto.messgeraet==="CA5011") {
                if (inRect(x,y,118,460,186,562)) {
                    switch (dto.mode) {
                        default : dto.mode="PLUS"; break;
                        case "PLUS": dto.mode="MINUS"; break;
                        case "MINUS": dto.mode="WECHSEL"; break;
                        case "WECHSEL": dto.mode="ACDC"; break;
                        case "ACDC": dto.mode="PLUS"; break;
                    }
                }
            }
            if (dto.messgeraet==="LM1010") {
                if (inRect(x,y,200,735,310,770)) dto.mbs=0;
                if (inRect(x,y,200,770,310,803)) dto.mbs=1;
                if (inRect(x,y,200,803,310,835)) dto.mbs=2;
                if (inRect(x,y,200,835,310,867)) dto.mbs=3;
                if (inRect(x,y,200,867,310,900)) dto.mbs=4;
                if (inRect(x,y,200,900,310,935)) dto.mbs=5;
                if (inRect(x,y,493,735,593,770)) dto.mbs2=0;
                if (inRect(x,y,493,770,593,800)) dto.mbs2=1;
                if (inRect(x,y,493,800,593,830)) dto.mbs2=2;
                if (inRect(x,y,493,830,593,862)) dto.mbs2=3;
                if (inRect(x,y,493,862,593,895)) dto.mbs2=4;
                if (inRect(x,y,493,895,593,935)) dto.mbs2=5;
                // Vorzeichen Ã¤ndern
                if (inRect(x,y,104,436,200,496)) plugin.MG.Z =  Math.abs(plugin.MG.Z);
                if (inRect(x,y,  0,436,103,496)) plugin.MG.Z = -Math.abs(plugin.MG.Z);
                // P-Q-Umschalter
                if (inRect(x,y,330,744,370,784)) resultDto.cm = "P";
                if (inRect(x,y,420,744,460,784)) resultDto.cm = "Q";
            }
            // Messbereichsschalter
            switch (dto.messgeraet) {
                case "UNIGOR": case "NORMAMETER": case "CA5001": case "CA5011":
                case "EPM8705":  case "ESCORT97":  case "GANZUNIV1": case "MX0090":
                case "PX120":  case "STA100":   case "STHz":      case "STV":       case "STV2":   case "STV500":
                case "STcosf": case "WATTMETER":case "WM01": {
                    if (inKreis(x, y, plugin.MG.MSx, plugin.MG.MSy, plugin.MG.MSr / 4)) {
                        dto.mbs = (dto.mbs + 1) % plugin.MG.Manz;
                    } else if (inKreis(x, y, plugin.MG.MSx, plugin.MG.MSy, plugin.MG.MSr + 50)) {
                        let f = -Math.atan2(y - plugin.MG.MSy, x - plugin.MG.MSx) + 3 * Math.PI / 2;
                        f = f - plugin.MG.Moffset;
                        if (f < 0) f += 2 * Math.PI;
                        dto.mbs = Math.trunc(f / (2 * Math.PI) * plugin.MG.Manz + 0.5) % plugin.MG.Manz;
                    }
                } break;
            }
            // Zeigerausschlag
            switch (dto.messgeraet) {
                case "UNIGOR": case "NORMAMETER": case "CA5001": case "CA5011":
                case "EPM8705":  case "ESCORT97":  case "GANZUNIV1": case "LM1010": case "MX0090":
                case "PX120":  case "STA100":   case "STHz":      case "STV":       case "STV2":   case "STV500":
                case "STcosf": case "WATTMETER":case "WM01": {
                    if (dto.inputmode==="INPUT" || dto.inputmode=="ALL") {
                        if (inRect(x,y,14,4,660,350)) {
                            let phi = -Math.atan((plugin.MG.ZMx-x)/(plugin.MG.ZMy-y));
                            plugin.MG.Z = (phi-plugin.MG.Zarg0)/(plugin.MG.ZargMax-plugin.MG.Zarg0);
                        }
                    }
                } break;
            }
        }

        function getMB() {
            switch(dto.messgeraet) {
                case "UNIGOR": {
                    switch (dto.mode) {
                        case "PLUS"   :
                            return plugin.MG.MBplus[dto.mbs];
                        case "MINUS"  :
                            return plugin.MG.MBminus[dto.mbs];
                        case "WECHSEL":
                            return plugin.MG.MBwechsel[dto.mbs];
                    }
                } break;
                case "NORMAMETER":{
                    switch (dto.mbs2) {
                        case 0: return plugin.MG.MBwechsel[dto.mbs];
                        case 1: return plugin.MG.MBplus[dto.mbs];
                        case 2: return plugin.MG.MBminus[dto.mbs];
                        default: return plugin.MG.MBextra[dto.mbs2-3];
                    }
                } break;
                case "CA5001":{
                    return plugin.MG.MBplus[dto.mbs];
                } break;
                case "CA5011":{
                    let mb = Object.assign({}, plugin.MG.MBplus[dto.mbs]) ;
                    if (mb.CM==="I" || mb.CM==="U")
                        switch (dto.mode) {
                            default:
                            case "PLUS": mb.mw="DC"; break;
                            case "MINUS": mb.MB = -mb.MB; mb.mw="DC"; break;
                            case "WECHSEL": mb.mw="AC"; break;
                            case "ACDC": mb.mw="ACDC"; break;
                        }
                    return mb;
                } break;
                case "GANZUNIV1":{
                    switch (dto.mode) {
                        case "PLUS"   :
                            return plugin.MG.MBplus[dto.mbs];
                        case "MINUS"  :
                            return plugin.MG.MBminus[dto.mbs];
                        case "WECHSEL":
                            return plugin.MG.MBwechsel[dto.mbs];
                    }
                }
                case "LM1010":{
                    let U=plugin.MG.WMU[dto.mbs];
                    let I=plugin.MG.WMI[dto.mbs2];
                    let P=U*I;
                    let sP = ""+P;
                    if (sP.startsWith("9")) { P=(P/9)*10; }
                    let mb = {Skala: 'LINEAR', MB: P, Zmax: 1, mw: 'AC', CM: 'P', U:U, I:I }
                    if (resultDto.cm==='P') mb.CM='P';
                    if (resultDto.cm==='Q') mb.CM='Q';
                    return mb;
                } break;
                case "EPM8705":{

                } break;
                case "ESCORT97":{

                } break;

                case "MX0090":{

                } break;
                case "PX120":{

                } break;
                case "STA100":{

                } break;
                case "STHz":{

                } break;
                case "STV":{

                } break;
                case "STV2":{

                } break;
                case "STV500":{

                } break;
                case "STcosf":{

                } break;
                case "WATTMETER":{

                } break;
                case "WM01":{

                } break;
            }
            return null;
        }

        function setAnzeige(mb) {
            plugin.MG.Z=0;
            try {
                let w = 0;
                if (dto.connectionmode === mb.CM) {
                    if (mb.mw === "DC") w = dto.valueDC;
                    if (mb.mw === "AC") w = dto.valueAC;
                    if (mb.mw === "ACDC") w = dto.valueACDC;
                }
                if (dto.connectionmode === 'P' || dto.connectionmode==='Q' || dto.connectionmode==='S') {
                    if (mb.CM === "P") w=dto.valueP;
                    if (mb.CM === "Q") w=dto.valueQ;
                    if (mb.CM === "S") w=dto.valueS;
                }
                switch (mb.Skala) {
                    case "INVERS":
                        w = w/mb.MB;
                        let w1 = Math.pow(w,1/0.78);
                        w = w1<=4?w1:Math.pow(w/0.7,1/1.02);
                        plugin.MG.Z = 1/(1+w)*mb.Zmax;
                        break;
                    case "LINEAR":
                        plugin.MG.Z = w/mb.MB*mb.Zmax;
                        break;
                    case "OHMSCH":
                        plugin.MG.Z = w/(mb.MB+w)*mb.Zmax;
                        break;
                    case "OFF": plugin.Z=0; break;
                }
            } catch (e) { }
        }

        /**
         * Berechnet den Wert welcher gerade angezeigt wird
         */
        function calcValue(mb) {
            resultDto.mbs   = dto.mbs;
            resultDto.mbs2  = dto.mbs2;
            resultDto.z     = plugin.MG.Z;
            let Z   = plugin.MG.Z;
            let ret = 0;
            switch (mb.Skala) {
                case "INVERS":
                    ret = mb.MB*Math.pow((mb.Zmax-Z)/Z,Z<0.2?1.02:0.78)*(Z<0.2?0.7:1);
                    break;
                case "INVERS2":
                    ret = mb.MB*(mb.Zmax-Z)/Z;
                    break;
                case "LINEAR":
                    ret = mb.MB*Z/mb.Zmax;
                    break;
                case "OHMSCH":
                    ret = mb.MB*Z/(mb.Zmax-Z);
                    break;
                case "OFF":
                    break;
            }
            resultDto.value   = ret;
            resultDto.mode    = dto.mode;
            resultDto.skala   = mb.Skala;
            resultDto.mb      = mb.MB;
            resultDto.zmax    = mb.Zmax;
            resultDto.mw      = mb.mw;
            resultDto.cm      = mb.CM;
        }

        function drawMG() {
            let mb          = getMB();
            // Berechnung des Zeigers
            if (dto.inputmode === "VIEW")
                setAnzeige(mb);
            // Berechnung des angezeigten Wertes und des Ergebnisses
            try {
                calcValue(mb);
            } catch (e) {}
            if (dto.inputmode != "IMAGE") {
                // Zeichnen des GerÃ¤tes
                if (dto.messgeraet==="UNIGOR") {
                    // Schalter
                    fillRect(ctx, 231, 947, 435 - 231, 993 - 947, "black");
                    let h = 300;
                    switch (dto.mode) {
                        case "PLUS":
                            h = 300;
                            break;
                        case "MINUS":
                            h = 332;
                            break;
                        case "WECHSEL":
                            h = 364;
                            break;
                    }
                    fillPolygon(ctx, [h - 10, h, h + 10], [993, 947, 993], 3, "white");
                }
                // Einstellungen LM1010 Wattmeter
                if (dto.messgeraet==="LM1010") {
                    switch (dto.mbs) {
                        case 0: drawLine(ctx,147,757,236,755,8,"red"); break;
                        case 1: drawLine(ctx,183,788,236,787,8,"red"); break;
                        case 2: drawLine(ctx,198,820,236,819,8,"red"); break;
                        case 3: drawLine(ctx,206,853,236,852,8,"red"); break;
                        case 4: drawLine(ctx,197,884,236,884,8,"red"); break;
                        case 5: drawLine(ctx,184,918,236,917,8,"red"); break;
                    }
                    switch (dto.mbs2) {
                        case 0: drawLine(ctx,553,750,643,750,8,"red"); break;
                        case 1: drawLine(ctx,553,782,605,782,8,"red"); break;
                        case 2: drawLine(ctx,553,814,592,814,8,"red"); break;
                        case 3: drawLine(ctx,553,846,583,846,8,"red"); break;
                        case 4: drawLine(ctx,553,878,593,878,8,"red"); break;
                        case 5: drawLine(ctx,553,911,608,910,8,"red"); break;
                    }
                    // Vorzeichen
                    if (plugin.MG.Z > 0 ) fillCircle(ctx,122,471,14,"orange");
                    if (plugin.MG.Z < 0 ) fillCircle(ctx, 80,471,14,"lightgreen");
                    // P/Q
                    fillRect(ctx,330,744,40,40,"#25201c");
                    fillRect(ctx,420,744,40,40,"#25201c");
                    ctx.font = '36px serif';
                    if (resultDto.cm==="P") ctx.fillStyle = "red"; else ctx.fillStyle = "white";
                    ctx.fillText('P', 345,775);
                    if (resultDto.cm==="Q") ctx.fillStyle = "red"; else ctx.fillStyle = "white";
                    ctx.fillText('Q', 425,775);
                    ctx.font = '16px serif';
                    if (dto.inputmode==='VIEW') {
                        if (dto.valueU > mb.U * 1.2) fillCircle(ctx, 54, 773, 14, "red");
                        if (dto.valueI > mb.I * 1.2) fillCircle(ctx, 731, 759, 14, "red");
                    }
                }
                // Wahlschalter drehbar
                switch (dto.messgeraet) {
                    case "UNIGOR": case "NORMAMETER":  case "CA5001":
                    case "CA5011": case "EPM8705":  case "ESCORT97":  case "GANZUNIV1": case "LM1010": case "MX0090":
                    case "PX120":  case "STA100":   case "STHz":      case "STV":       case "STV2":   case "STV500":
                    case "STcosf": case "WATTMETER":case "WM01":  {
                        fillCircle(ctx, plugin.MG.MSx, plugin.MG.MSy, plugin.MG.MSr, plugin.MG.color1);
                        f = (Math.PI * 2) * dto.mbs / plugin.MG.Manz + plugin.MG.Moffset;
                        ctx.translate(plugin.MG.MSx, plugin.MG.MSy);
                        ctx.rotate(-f);
                        fillRect(ctx, -8, -plugin.MG.MSr, 16, 2 * plugin.MG.MSr, plugin.MG.color2);
                        fillRect(ctx, -1, -plugin.MG.MSr, 2, 40, plugin.MG.color3);
                        ctx.rotate(f);
                        ctx.translate(-plugin.MG.MSx, -plugin.MG.MSy);
                        // Zweiter Wahlschalter
                        if (plugin.MG.Manz2Max > 0) {
                            fillCircle(ctx, plugin.MG.MSx2, plugin.MG.MSy2, plugin.MG.MSr2, "#648296");
                            f = (Math.PI * 2) * dto.mbs2 / plugin.MG.Manz2 + plugin.MG.Moffset2;
                            ctx.translate(plugin.MG.MSx2, plugin.MG.MSy2);
                            ctx.rotate(-f);
                            fillRect(ctx, -8, -plugin.MG.MSr2, 16, 2 * plugin.MG.MSr2, "black");
                            fillRect(ctx, -1, -plugin.MG.MSr2, 2, 40, "white");
                            ctx.rotate(f);
                            ctx.translate(-plugin.MG.MSx2, -plugin.MG.MSy2);
                        }
                    } break;
                }
                // Einstellungen
                if (dto.messgeraet==="CA5011") {
                    fillRect(ctx,186,202,440-186,294-202,"#609060");
                    let ms = "";
                    ctx.font = '40px serif';
                    switch (dto.mode) {
                        default:
                        case "PLUS":    ms=" ="; break;
                        case "MINUS":   ms=" -"; break;
                        case "WECHSEL": ms=" ~"; break;
                        case "ACDC":    ctx.font = '20px serif'; ms="RMS"; break;
                    }
                    ctx.fillStyle = "black";
                    ctx.fillText(ms, 380,230);
                }
                if (dto.messgeraet === "GANZUNIV1") {
                    switch (dto.mode) {
                        default:
                        case "PLUS":    fillCircle(ctx, 152, 971, 10, "red");
                            fillCircle(ctx, 420, 971, 10, "red"); break;
                        case "MINUS":   fillCircle(ctx, 152, 971, 10, "red");
                            fillCircle(ctx, 529, 971, 10, "red"); break;
                        case "WECHSEL": fillCircle(ctx, 259, 971, 10, "red"); break;
                    }
                }
                // Zeiger
                switch (dto.messgeraet) {
                    case "UNIGOR": case "NORMAMETER":  case "CA5001":
                    case "CA5011": case "EPM8705":  case "ESCORT97":  case "GANZUNIV1": case "LM1010": case "MX0090":
                    case "PX120":  case "STA100":   case "STHz":      case "STV":       case "STV2":   case "STV500":
                    case "STcosf": case "WATTMETER":case "WM01":     {
                        let z = plugin.MG.Z;
                        if (dto.messgeraet==="LM1010") z=Math.abs(z);
                        if (z > 1.1) z = 1.1;
                        if (z < -0.1) z = -0.1;
                        if (plugin.MG.skala) {
                            ctx.translate(plugin.MG.ZMx, plugin.MG.ZMy);
                            f = Math.PI + plugin.MG.Zarg0 + (plugin.MG.ZargMax - plugin.MG.Zarg0) * z;
                            ctx.rotate(f);
                            fillPolygon(ctx, [-3, -1, 1, 3], [plugin.MG.Zlmin, plugin.MG.Zl, plugin.MG.Zl, plugin.MG.Zlmin], 4, "red");
                            ctx.rotate(-f);
                            ctx.translate(-plugin.MG.ZMx, -plugin.MG.ZMy);
                        }
                    }  break;
                }
            }
            // Print Debug - Info
            if (dto.debug) {
                drawText(600,40,"Wert: "+numberToString(resultDto.value)+" "+resultDto.cm);
            }
        }
    }

    /**
     *   CM ConnenctionMode:  N..Nichtverbunden U .. Voltmeter , I .. Amperemeter , R .. Ohmmeter am Bauteil , T .. Temperatur , D .. Diodenspannung , F .. Frequenz
     *   Skala : OFF, LINEAR, INVERS, OHMSCH
     */
    function initMG() {
        let MG = {
            'UNIGOR': {
                MSx:332, MSy: 710, MSr:130, Moffset:0,
                Manz:36, ZMx:340, ZMy:467,
                Zl:430,  Zlmin:100, Z0x:78, Z0y: 131, ZMaxx:590, ZMaxy:126, Manz2Max:0, skala:true,
                color1:'#648296', color2:'black', color3:'white',
                MBplus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.0316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.01, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.00316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.001, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-6, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-6, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-5, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-5, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBminus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:-1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.0316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.01, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.00316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.001, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:1e5, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:1e4, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:1e3, Zmax:0.99, mw:'DC', CM:'R'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OHMSCH', MB:100, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:10, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:1, Zmax:0.99, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:-1e-6, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-6, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-5, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-5, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBwechsel : [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.0316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.01, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.00316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.001, Zmax:1, mw:'AC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'INVERS', MB:1e-9, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-8, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-7, Zmax:0.99, mw:'DC', CM:'C'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'INVERS', MB:1e-6, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-5, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-4, Zmax:0.99, mw:'DC', CM:'C'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-6, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-6, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-5, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-5, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'I'}
                ]},
            'NORMAMETER': {
                MSx:822, MSy: 117, MSr:73, Manz:20, Moffset:3.2986722,
                ZMx:419, ZMy:333, Zl:290,  Zlmin:100, Z0x:228, Z0y: 112, ZMaxx:602, ZMaxy:110,
                MSx2:894, MSy2: 299, MSr2:36, Manz2:20, Moffset2:0.78539816,Manz2Max:9,
                skala:true, color1:'#648296', color2:'black', color3:'white',
                MBplus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'DC', CM:'U'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBminus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:-1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.1, Zmax:1, mw:'DC', CM:'U'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:-1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBwechsel : [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'AC', CM:'U'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'I'}
                ], MBextra : [
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:22, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:0.81e3, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:0.81e4, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:0.81e6, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:0.38e-8, Zmax:1, mw:'DC', CM:'C'},
                    {Skala:'OHMSCH', MB:0.38e-6, Zmax:1, mw:'DC', CM:'C'}
                ]
            },
            'CA5001':{
                MSx:304, MSy: 726, MSr:148, Manz:24, Moffset:0.1308996938,
                ZMx:305, ZMy:457, Zl:390,  Zlmin:120, Z0x:39, Z0y: 180, ZMaxx:570, ZMaxy:181, Manz2Max:0, skala:true,
                color1:'#333333', color2:'#CCCCCC', color3:'black',
                MBplus: [
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.1, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:5e-3, Zmax:0.992, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:5e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:5e-1, Zmax:1, mw:'DC', CM:'I'},
                    //StrÃ¶me AC
                    {Skala:'LINEAR', MB:5e-1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:5e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:5e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //WiderstÃ¤nde
                    {Skala:'INVERS2', MB:14000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:140, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen AC
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'}
                ]
            },
            'CA5011':{
                MSx:307, MSy: 734, MSr:159, Manz:24, Moffset:0.12083048667,
                ZMx:312, ZMy:462, Zl:390,  Zlmin:120, Z0x:48, Z0y: 182, ZMaxx:572, ZMaxy:186, Manz2Max:0,
                skala:true, color1:'#333333', color2:'#CCCCCC', color3:'black',
                MBplus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'F'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'D'},
                    //WiderstÃ¤nde
                    {Skala:'LINEAR', MB:5e1, Zmax:1, mw:'DC', CM:'R'},{Skala:'LINEAR', MB:5e2, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'LINEAR', MB:5e3, Zmax:1, mw:'DC', CM:'R'},{Skala:'LINEAR', MB:5e4, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'LINEAR', MB:5e5, Zmax:1, mw:'DC', CM:'R'},{Skala:'LINEAR', MB:5e6, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'LINEAR', MB:5e7, Zmax:1, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:0.5, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:0.05, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:5e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:5e-4, Zmax:1, mw:'DC', CM:'I'},
                    // Spannungen
                    {Skala:'LINEAR', MB:0.5, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:5, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:50, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:500, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'}
                ]
            },
            'GANZUNIV1':{
                MSx:339, MSy: 716, MSr:124, Manz:24, Moffset:0.12083048667,
                ZMx:343, ZMy:472, Zl:390,  Zlmin:150, Z0x:84, Z0y: 190, ZMaxx:599, ZMaxy:186,
                Manz2Max:0,
                skala:true, color1:'#b7b4ad', color2:'black', color3:'white',
                MBplus: [
                    // Spannungen
                    {Skala:'LINEAR', MB:1200, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:600, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:300, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:120, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:30, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:12, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:3, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.03, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.012, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:100000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:1000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:100, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10, Zmax:1, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:3e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:1.2e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:3e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:1.2e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:0.3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1.2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:6, Zmax:1, mw:'DC', CM:'I'}
                ], MBminus: [
                    // Spannungen
                    {Skala:'LINEAR', MB:-1200, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-600, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-300, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-120, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-30, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-12, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-3, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.06, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.03, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.012, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:100000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:1000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:100, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10, Zmax:1, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:-3e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-1.2e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-3e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-1.2e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-0.06, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-0.3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1.2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-6, Zmax:1, mw:'DC', CM:'I'}
                ], MBwechsel : [
                    // Spannungen
                    {Skala:'LINEAR', MB:1200, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:600, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:300, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:120, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:30, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:12, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:3, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.03, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.012, Zmax:1, mw:'AC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:3e-4, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:1.2e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:3e-3, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:1.2e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:0.3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1.2, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:6, Zmax:1, mw:'AC', CM:'I'}
                ]
            },
            'LM1010':{
                MSx:1, MSy: 1, MSr:1, Manz:0, Moffset:0.0,
                ZMx:387, ZMy: 488, Zl:410,  Zlmin:130, Z0x:109, Z0y: 202, ZMaxx:663, ZMaxy:196, Manz2Max:0,
                skala:true, color1:'#333333', color2:'#CCCCCC', color3:'black',
                WMU: [3,10,30,100,300,1000],
                WMI: [0.1,0.3,1,3,10,30]
            },
            'EPM8705':{ },
            'ESCORT97':{ },
            'MX0090':{ },
            'PX120':{ },
            'STA100':{ },
            'STHz':{ },
            'STV':{ },
            'STV2':{ },
            'STV500':{ },
            'STcosf':{ },
            'WATTMETER':{ },
            'WM01':{}
        };
        plugin.MG = MG[dto.messgeraet];
        switch (dto.messgeraet) {
            case "UNIGOR": { plugin.MG={
                MSx:332, MSy: 710, MSr:130, Moffset:0,
                Manz:36, ZMx:340, ZMy:467,
                Zl:430,  Zlmin:100, Z0x:78, Z0y: 131, ZMaxx:590, ZMaxy:126, Manz2Max:0, skala:true,
                color1:'#648296', color2:'black', color3:'white',
                MBplus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.0316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.01, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.00316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.001, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-6, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-6, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-5, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-5, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBminus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:-1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.0316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.01, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.00316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.001, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:1e5, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:1e4, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:1e3, Zmax:0.99, mw:'DC', CM:'R'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OHMSCH', MB:100, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:10, Zmax:0.99, mw:'DC', CM:'R'},{Skala:'OHMSCH', MB:1, Zmax:0.99, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:-1e-6, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-6, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-5, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-5, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBwechsel : [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.0316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.01, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.00316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.001, Zmax:1, mw:'AC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'INVERS', MB:1e-9, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-8, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-7, Zmax:0.99, mw:'DC', CM:'C'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'INVERS', MB:1e-6, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-5, Zmax:0.99, mw:'DC', CM:'C'},{Skala:'INVERS', MB:1e-4, Zmax:0.99, mw:'DC', CM:'C'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-6, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-6, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-5, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-5, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'I'}
                ]};
            } break;
            case "NORMAMETER": { plugin.MG={
                MSx:822, MSy: 117, MSr:73, Manz:20, Moffset:3.2986722,
                ZMx:419, ZMy:333, Zl:290,  Zlmin:100, Z0x:228, Z0y: 112, ZMaxx:602, ZMaxy:110,
                MSx2:894, MSy2: 299, MSr2:36, Manz2:20, Moffset2:0.78539816,Manz2Max:9,
                skala:true, color1:'#648296', color2:'black', color3:'white',
                MBplus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'DC', CM:'U'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBminus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:-1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.1, Zmax:1, mw:'DC', CM:'U'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:-1e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-4, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1e-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16e-1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-3.16, Zmax:1, mw:'DC', CM:'I'}
                ], MBwechsel : [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.1, Zmax:1, mw:'AC', CM:'U'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:1e-4, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-4, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-3, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-2, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1e-1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16e-1, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'AC', CM:'I'}
                ], MBextra : [
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:22, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:0.81e3, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:0.81e4, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:0.81e6, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:0.38e-8, Zmax:1, mw:'DC', CM:'C'},
                    {Skala:'OHMSCH', MB:0.38e-6, Zmax:1, mw:'DC', CM:'C'}
                ]};
            } break;
            case "CA5001":{ plugin.MG={
                MSx:304, MSy: 726, MSr:148, Manz:24, Moffset:0.1308996938,
                ZMx:305, ZMy:457, Zl:390,  Zlmin:120, Z0x:39, Z0y: 180, ZMaxx:570, ZMaxy:181, Manz2Max:0, skala:true,
                color1:'#333333', color2:'#CCCCCC', color3:'black',
                MBplus: [
                    // Spannungen
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:3.16, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.1, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:5e-3, Zmax:0.992, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:5e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:5e-1, Zmax:1, mw:'DC', CM:'I'},
                    //StrÃ¶me AC
                    {Skala:'LINEAR', MB:5e-1, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:5e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:5e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //WiderstÃ¤nde
                    {Skala:'INVERS2', MB:140, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'INVERS2', MB:14000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    // Spannungen AC
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:31.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:100, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:316, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'}
                ]};
            } break;
            case "CA5011":{ plugin.MG={
                MSx:307, MSy: 734, MSr:159, Manz:24, Moffset:0.12083048667,
                ZMx:312, ZMy:462, Zl:390,  Zlmin:120, Z0x:48, Z0y: 182, ZMaxx:572, ZMaxy:186, Manz2Max:0,
                skala:true, color1:'#333333', color2:'#CCCCCC', color3:'black',
                MBplus: [
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},{Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'F'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'D'},
                    //WiderstÃ¤nde
                    {Skala:'LINEAR', MB:5e1, Zmax:1, mw:'DC', CM:'R'},{Skala:'LINEAR', MB:5e2, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'LINEAR', MB:5e3, Zmax:1, mw:'DC', CM:'R'},{Skala:'LINEAR', MB:5e4, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'LINEAR', MB:5e5, Zmax:1, mw:'DC', CM:'R'},{Skala:'LINEAR', MB:5e6, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'LINEAR', MB:5e7, Zmax:1, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:10, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:1, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:0.5, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:0.05, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:5e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:5e-4, Zmax:1, mw:'DC', CM:'I'},
                    // Spannungen
                    {Skala:'LINEAR', MB:0.5, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:5, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:50, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:500, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:1000, Zmax:1, mw:'DC', CM:'U'}
                ]};
            } break;
            case "GANZUNIV1":{ plugin.MG={
                MSx:339, MSy: 716, MSr:124, Manz:24, Moffset:0.12083048667,
                ZMx:343, ZMy:472, Zl:390,  Zlmin:150, Z0x:84, Z0y: 190, ZMaxx:599, ZMaxy:186,
                Manz2Max:0,
                skala:true, color1:'#b7b4ad', color2:'black', color3:'white',
                MBplus: [
                    // Spannungen
                    {Skala:'LINEAR', MB:1200, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:600, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:300, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:120, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:30, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:12, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:3, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:0.03, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:0.012, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:100000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:1000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:100, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10, Zmax:1, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:3e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:1.2e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:3e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:1.2e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:0.3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:1.2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:6, Zmax:1, mw:'DC', CM:'I'}
                ], MBminus: [
                    // Spannungen
                    {Skala:'LINEAR', MB:-1200, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-600, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-300, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-120, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-30, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-12, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-3, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.6, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.06, Zmax:1, mw:'DC', CM:'U'},{Skala:'LINEAR', MB:-0.03, Zmax:1, mw:'DC', CM:'U'},
                    {Skala:'LINEAR', MB:-0.012, Zmax:1, mw:'DC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OHMSCH', MB:100000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:1000, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:100, Zmax:1, mw:'DC', CM:'R'},
                    {Skala:'OHMSCH', MB:10, Zmax:1, mw:'DC', CM:'R'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:-3e-4, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-1.2e-3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-3e-3, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-1.2e-2, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-0.06, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-0.3, Zmax:1, mw:'DC', CM:'I'},
                    {Skala:'LINEAR', MB:-1.2, Zmax:1, mw:'DC', CM:'I'},{Skala:'LINEAR', MB:-6, Zmax:1, mw:'DC', CM:'I'}
                ], MBwechsel : [
                    // Spannungen
                    {Skala:'LINEAR', MB:1200, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:600, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:300, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:120, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:30, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:12, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:3, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.6, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'AC', CM:'U'},{Skala:'LINEAR', MB:0.03, Zmax:1, mw:'AC', CM:'U'},
                    {Skala:'LINEAR', MB:0.012, Zmax:1, mw:'AC', CM:'U'},
                    // WiderstÃ¤nde
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    {Skala:'OFF', MB:1, Zmax:0, mw:'DC', CM:'N'},
                    //StrÃ¶me
                    {Skala:'LINEAR', MB:3e-4, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:1.2e-3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:3e-3, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:1.2e-2, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:0.06, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:0.3, Zmax:1, mw:'AC', CM:'I'},
                    {Skala:'LINEAR', MB:1.2, Zmax:1, mw:'AC', CM:'I'},{Skala:'LINEAR', MB:6, Zmax:1, mw:'AC', CM:'I'}
                ]};
            } break;
            case "LM1010":{ plugin.MG={
                MSx:1, MSy: 1, MSr:1, Manz:0, Moffset:0.0,
                ZMx:387, ZMy: 488, Zl:410,  Zlmin:130, Z0x:109, Z0y: 202, ZMaxx:663, ZMaxy:196, Manz2Max:0,
                skala:true, color1:'#333333', color2:'#CCCCCC', color3:'black',
                WMU: [3,10,30,100,300,1000],
                WMI: [0.1,0.3,1,3,10,30]};
            } break;
            case "EPM8705":{

            } break;
            case "ESCORT97":{

            } break;

            case "MX0090":{

            } break;
            case "PX120":{

            } break;
            case "STA100":{

            } break;
            case "STHz":{

            } break;
            case "STV":{

            } break;
            case "STV2":{

            } break;
            case "STV500":{

            } break;
            case "STcosf":{

            } break;
            case "WATTMETER":{

            } break;
            case "WM01":{

            } break;
        }
        plugin.MG.Z=dto.z;
        plugin.MG.Zarg0   = -Math.atan((plugin.MG.ZMx-plugin.MG.Z0x)/(plugin.MG.ZMy-plugin.MG.Z0y));
        plugin.MG.ZargMax = Math.atan((plugin.MG.ZMaxx-plugin.MG.ZMx)/(plugin.MG.ZMy-plugin.MG.ZMaxy));
    }

}

$=jQuery;

// function initPluginUhr(name, active, jimagepath, width, height) {
function initPluginUhr(dtoString, active) {
}
function initPluginUhrold(name, active, dto) {

}
function initPluginUhr(dtoString, active) {
    let dto = JSON.parse(dtoString);
    let plugin = new Object();
    plugin.name = dto.tagName;
    plugin.jimagepath = dto.imageUrl;
    plugin.width = dto.width;
    plugin.height = dto.height;
    plugin.divName = "#" + plugin.name+"_div";
    plugin.canvas = "canvasContainer"+plugin.name;
    plugin.canvasLine = "canvasLine"+plugin.name;
    plugin.active = active;

    drawCanvas(plugin);

    document.getElementById(plugin.canvasLine).setAttribute("width",plugin.width+"px");
    document.getElementById(plugin.canvasLine).setAttribute("height",plugin.height+"px");
    initUhr();

    function initUhr() {
        let imagepath = dto.imageUrl;
        let width  = plugin.width;
        let height = plugin.height;
        let xMiddle   = width/2;
        let yMiddle   = height/2;
        let radius    = Math.min(width,height)*0.48;
        let time_string = "";
        let cx = -1;
        let cy = -1;

        let img = new Image();
        let c = document.getElementById(plugin.canvasLine);
        let timeField = "." + plugin.name + "_inp";
        let a = $(timeField)[0];

        if (c==null || a==null) return;
        let angle = parseTime(a.value);
        let anglecursor = angle;
        if (isNaN(angle))
            angle=0;
        let ctx = c.getContext("2d");
        drawClockwithLineFromAngle(angle);

        //listener for clicks on svg, and therefore image
        if (plugin.active) {
            $("."+plugin.canvas).mousemove(function (e) {
                cx = e.pageX-getImgCoordinates().x;
                cy = e.pageY-getImgCoordinates().y;
                if (calcDistanceToCenter(e.pageX, e.pageY) <= radius) {
                    anglecursor = calcAngleToCenter(e.pageX, e.pageY);
                    drawClockwithLineFromAngle(angle, anglecursor);
                }
            });
            $("."+plugin.canvas).mousedown(function (e) {
                cx = e.pageX-getImgCoordinates().x;
                cy = e.pageY-getImgCoordinates().y;
                if (cx+20>width && cy+20>height) {
                    try {
                        openImg(imagepath);
                    } catch (ex) {}
                } else if (calcDistanceToCenter(e.pageX, e.pageY) <= radius) {
                    angle = calcAngleToCenter(e.pageX, e.pageY);
                    anglecursor=angle;
                    drawClockwithLineFromAngle(angle, anglecursor);
                    a.value = time_string;
                }
            });
            $("."+plugin.canvas).mouseleave(function (e) {
                cx = e.pageX-getImgCoordinates().x;
                cy = e.pageY-getImgCoordinates().y;
                anglecursor=null;
                drawClockwithLineFromAngle(angle, anglecursor);
            });
        }

        /**
         * Zeichnen der ganzen Uhr mit Zeiger, das Bild wird geladen,
         * wenn es noch nicht im Speicher ist
         * @param angle     Winkel des Zeigers der Uhr
         */
        function drawClockwithLineFromAngle(angle, anglecursor) {
            ctx.clearRect(0,0, width, height);
            if (img.loadComplete) {
                ctx.drawImage(img, 0, 0, width, height);
                draw(angle,anglecursor);
                return;
            }
            /*img.src = localMode ?
                "https://i.pinimg.com/originals/5b/68/be/5b68bede64bad2affa5c4b98f330f0ef.jpg" :
                "https://" + window.location.host + "/letto/javax.faces.resource/uhr.gif.jsf?ln=bitmaps";*/
            img.src = imagepath;
            img.onload = function(){
                img.loadComplete=true;
                ctx.drawImage(img, 0, 0, width, height);
                draw(angle,anglecursor);
            }
        }
        /**
         * Zeichnen des Zeigers der Uhr in einem bestimmten Winkel
         * @param angle     Winkel in Radiant
         */
        function draw(angle,anglecursor) {
            ctx.fillStyle = "lightgray";
            ctx.strokeStyle="black";
            ctx.fillRect(plugin.width-20,plugin.height-20,20,20);
            ctx.lineWidth = 2;
            drawLine(width-16,width-16,width-16,width-12,2);
            drawLine(width-16,width-16,width-12,width-16,2);
            drawLine(width-4,width-16,width-4,width-12,2);
            drawLine(width-4,width-16,width-8,width-16,2);
            drawLine(width-16,width-4,width-16,width-8,2);
            drawLine(width-16,width-4,width-12,width-4,2);
            drawLine(width-4,width-4,width-4,width-8,2);
            drawLine(width-4,width-4,width-8,width-4,2);

            ctx.strokeStyle="black";
            let s = drawTime(angle);
            ctx.fillStyle = "black";
            drawText(xMiddle+3 , yMiddle-3, s);
            time_string = s;

            ctx.strokeStyle="blue";
            ctx.text
            if (angle!=anglecursor && anglecursor!=null) {
                s = drawTime(anglecursor);
                ctx.fillStyle = "blue";
                drawText(xMiddle+3 , yMiddle+50, s);
            }
            /*
            ctx.strokeStyle="black";
            drawLine(0,cy,width,cy,1);
            drawLine(cx,0,cx,height,1);
            ctx.font = '16px serif';
            ctx.fillText("("+Math.trunc(cx)+"|"+Math.trunc(cy)+")", cx, cy); */
        }

        function drawTime(angle) {
            if (angle < 0) angle += 2*Math.PI;
            let sek  = (1.0-2.0*angle/Math.PI)*3.0*3600.0;
            if (sek<0) sek += 12*3600;
            sek = Math.round(sek);
            let hour = Math.trunc(sek/3600.0);
            if (hour<1) hour+=12;
            let m    = Math.trunc((sek%3600)/60);

            let pointH = calcPointFromAngle(angle,radius*0.5);
            let pointM = calcPointFromAngle(Math.PI/2-m*2*Math.PI/60,radius*0.8);
            let imgCoordinates = getImgCoordinates();
            drawLine(xMiddle , yMiddle, pointH.x - imgCoordinates.x, pointH.y - imgCoordinates.y,7);
            drawLine(xMiddle , yMiddle, pointM.x - imgCoordinates.x, pointM.y - imgCoordinates.y,3);
            let s    = ''+(hour<10?' ':'')+hour+":"+(m<10?'0':'')+m;
            return s;
        }

        /**
         * Wandelt eine Zeit 10:32 in einen Winkel in Radianten um
         * @param time Zeit als String
         */
        function parseTime(time) {
            time_array = time.split(":");
            if (time_array.length<2) return Math.PI/2.0;
            h = time_array[0];
            m = time_array[1];
            if (time_array.length>2) s = time_array[2];
            else s = '0';
            h = parseFloat(h);
            m = parseFloat(m);
            s = parseFloat(s);
            time_sek = s+m*60+h*3600;
            arg = Math.PI/2-time_sek/12.0/3600.0*2.0*Math.PI;
            if (arg<0) arg+=2*Math.PI;
            return arg;
        }

        /**
         * Berechnet aus dem angegebenen Winkel die Uhrzeit
         * @param angle        Winkel
         * @returns {string}   Uhrzeit
         */
        function timestring(angle) {
            let hour = 14-angle*12/2/Math.PI;
            let h    = ((Math.trunc(hour)))%12+1;
            let m    = Math.trunc((hour-Math.trunc(hour))*60);
            let s    = ''+(h<10?' ':'')+h+":"+(m<10?'0':'')+m;
            return s;
        }

        /**
         * Zeichnen einer Linie
         * @param x1    x-Punkt1
         * @param y1    y-Punkt1
         * @param x2    x-Punkt2
         * @param y2    y-Punkt2
         */
        function drawLine(x1, y1, x2, y2, width) {
            ctx.beginPath();
            ctx.moveTo(x1 , y1);
            ctx.lineTo(x2, y2);
            ctx.lineWidth = width;
            ctx.stroke();
        }

        function drawText(x,y,text) {
            ctx.font = '48px serif';
            ctx.lineWidth = 1;
            ctx.fillText(text, x, y);
        }

        /**
         *
         * @returns coordinates of left-upper corner of image
         */
        function getImgCoordinates() {
            const offs = $("." + plugin.canvas).offset();
            return {
                x: offs.left,
                y: offs.top
            };
        }

        /**
         *
         * @returns returns the coordinagtes of the center of the image
         */
        function getImgCenterCoordinates() {
            let imgCoordinates = getImgCoordinates();
            return {
                x: imgCoordinates.x + xMiddle,
                y: imgCoordinates.y + yMiddle
            }
        }

        /**
         * calculates the distance of a point to the center of an image
         * @param xAbsolute   the x-coordinate of the point
         * @param yAbsolute   the y-coordinate of the point
         * @returns {number}  the distance
         */
        function calcDistanceToCenter(xAbsolute, yAbsolute) {
            let imgCenterCoordinates = getImgCenterCoordinates();
            return Math.sqrt(Math.pow(imgCenterCoordinates.x - xAbsolute, 2) + Math.pow(imgCenterCoordinates.y - yAbsolute, 2));
        }


        function calcAngleToCenter(x, y) {
            let center = getImgCenterCoordinates();
            let angle  = calcAngleOfVectors(1,0,x-center.x, y-center.y);
            if (angle < 0) {
                return -angle;
            } else {
                return Math.PI + (Math.PI-angle);
            }
        }

        function calcAngleOfVectors(x1, y1, x2, y2) {
            return Math.atan2(y2-y1, x2-x1);
        }

        function calcPointFromAngle(angle,radius) {
            let center = getImgCenterCoordinates();
            let xPoint = center.x+Math.cos(angle) * radius;
            let yPoint = center.y-Math.sin(angle) * radius;
            return {
                x: xPoint,
                y: yPoint
            }
        }
    }

}


var initPluginCodeCheck = function (dtoString, active) {
    let dto = JSON.parse(dtoString);
    let name = dto.tagName;
    let language = dto.language;
    let divPlugin = name+"_div";
    let classBez = name+"_inp";
    let val = $("."+classBez)[0].value;
    if (active) {
        document.getElementById(divPlugin).style.height = "300px";
        document.getElementById(divPlugin).style.width = "98%";
        let editor = ace.edit(divPlugin);
        editor.session.setMode('ace/mode/' + language);
        editor.setTheme('ace/theme/monokai');
        editor.setShowPrintMargin(false);

        try {
            editor.setValue(val);
        } catch (e) {
            editor.setValue('');
        }
        editor.getSession().on('change', function() {
            let val = "";
            try {
                $("."+classBez)[0].value = editor.getValue();
            } catch (e) { }
        });
    }
    else {
        val = val.replaceAll("\<","&lt;").replaceAll("\>","&gt;");
        document.getElementById(divPlugin).innerHTML = `
        <div style="height:300px;width:98%;border:1px solid #ccc;overflow:auto;">
            <pre class="prettyprint linenums">${val}</pre>
        </div>`

        // document.getElementById(divPlugin).innerHTML =
        //     `<textarea class="ui-inputfield ui-inputtextarea ui-widget ui-state-default ui-corner-all ui-inputtextarea-resizable"
        //             rows="12"
        //             style="overflow-y: scroll;"
        //             readonly="true">${val}</textarea>`
    }
}

