/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setup.restclient.RestLocalSetupService;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.LettoEnvFile;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.model.UpdateServiceDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.SetupUpdateService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetupUpdateService {
    @Autowired
    private CmdService cmdService;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    public DockerService dockerService;
    private Boolean isHostLinux = null;

    private boolean isHostLinux() {
        if (this.isHostLinux == null) {
            this.isHostLinux = this.dockerService.isHostLinux();
        }
        return this.isHostLinux;
    }

    public void waitSeconds(int i) {
        try {
            Thread.sleep(i * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getSetupComposeDir() {
        return this.dockerService.getSetupComposeDir();
    }

    public String getLettoComposeDir() {
        return this.dockerService.getLettoComposeDir();
    }

    public String getMysqlComposeDir() {
        return this.dockerService.getMysqlComposeDir();
    }

    private String cmdSetupUpdateDocker() {
        Object cmd = "docker run -v /var/run/docker.sock:/var/run/docker.sock";
        cmd = (String)cmd + " -v " + this.dockerService.getLocalLettoPathDocker() + ":/opt/letto";
        cmd = (String)cmd + " lettohub/dockeragent:stable /scripts/setup-update.sh";
        return cmd;
    }

    private String cmdSetupRestartDocker() {
        Object cmd = "docker run -v /var/run/docker.sock:/var/run/docker.sock";
        cmd = (String)cmd + " -v " + this.dockerService.getLocalLettoPathDocker() + ":/opt/letto";
        cmd = (String)cmd + " lettohub/dockeragent:stable /scripts/setup-restart.sh";
        return cmd;
    }

    public boolean isSchoolDebug(List<UpdateServiceDto> updateServiceDtoList, String school) {
        if (updateServiceDtoList != null) {
            for (UpdateServiceDto dto : updateServiceDtoList) {
                if (!dto.getYmlFilename().equals("docker-compose-" + school + ".yml") || !dto.getPlan().equals("debug")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLettoDebug(List<UpdateServiceDto> updateServiceDtoList) {
        if (updateServiceDtoList != null) {
            for (UpdateServiceDto dto : updateServiceDtoList) {
                if (!dto.getYmlFilename().equals("docker-compose.yml") || !dto.getComposePath().endsWith("/letto") || !dto.getPlan().equals("debug")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSetupDebug(List<UpdateServiceDto> updateServiceDtoList) {
        if (updateServiceDtoList != null) {
            for (UpdateServiceDto dto : updateServiceDtoList) {
                if (!dto.getYmlFilename().equals("docker-compose.yml") || !dto.getComposePath().endsWith("/setup") || !dto.getPlan().equals("debug")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isYmlDebug(List<UpdateServiceDto> updateServiceDtoList, String ymlfile) {
        if (updateServiceDtoList != null) {
            for (UpdateServiceDto dto : updateServiceDtoList) {
                if (!dto.getYmlFilename().equals(ymlfile) || !dto.getComposePath().endsWith("/letto") || !dto.getPlan().equals("debug")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean copyEnvFileWindows(CmdThread thread, String source, String dest) {
        try {
            File f = new File(dest);
            if (!f.exists()) {
                f.mkdirs();
            }
            thread.runCmd(new String[]{"cp " + source + "/*.yml " + dest + "/"});
            List<String> data = Files.readAllLines(new File(source + "/.env").toPath());
            for (int i = 0; i < data.size(); ++i) {
                Object line = data.get(i);
                Pattern p = Pattern.compile("^([^=]+)=([A-Za-z]):(\\\\.*)$");
                Matcher m = p.matcher((CharSequence)line);
                if (!m.find()) continue;
                String key = m.group(1);
                String lw = m.group(2);
                String path = m.group(3).replaceAll("\\\\", "/");
                line = key + "=//" + lw + path;
                data.set(i, (String)line);
            }
            f = new File(dest + "/.env");
            Files.write(f.toPath(), data, new OpenOption[0]);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void updateThread(CmdThread thread, SETUP_CMD cmd, String school) {
        List updateServiceDtoList = null;
        try {
            updateServiceDtoList = this.dockerService.updateService.getUpdateDto().getServices();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dockerService.isDockerRunning()) {
            String composePath = "/opt/letto/docker/compose";
            switch (cmd.ordinal()) {
                case 4: 
                case 6: {
                    thread.htmlOut("update all services");
                    if (this.dockerService.updateService.availableUpdate("letto-setup")) {
                        thread.htmlErr("update available for letto-setup service!");
                        thread.htmlErr("starting update of letto-setup service");
                        thread.htmlErr("pleas wait 20 seconds for update and then reload page");
                        thread.htmlErr("after reload login again and start the update of all other services");
                        thread.runCmd(new String[]{this.cmdSetupUpdateDocker()});
                        thread.htmlErr("nothing to restart - update of all service continued");
                    }
                    Vector<Object> c = new Vector<Object>();
                    c.add("cd " + composePath + "/letto");
                    Vector schulen = this.dockerService.getSchulenEnv();
                    for (SchuleEnv schule : schulen) {
                        if (!this.dockerService.isSchoolRunning(schule.school) && schulen.size() != 1) continue;
                        if (!this.isSchoolDebug(updateServiceDtoList, schule.school)) {
                            c.add("docker compose -f docker-compose-" + schule.school + ".yml pull");
                        }
                        if (cmd == SETUP_CMD.UPDATE_RESTART_ALL) {
                            c.add("docker compose -f docker-compose-" + schule.school + ".yml down");
                        }
                        c.add("docker compose -f docker-compose-" + schule.school + ".yml up -d");
                        c.add("sleep 10");
                    }
                    for (String ymlFileName : this.dockerService.getServiceYmlFileNames()) {
                        if (!this.isYmlDebug(updateServiceDtoList, ymlFileName)) {
                            c.add("docker compose -f " + ymlFileName + " pull");
                        }
                        if (cmd == SETUP_CMD.UPDATE_RESTART_ALL) {
                            c.add("docker compose -f " + ymlFileName + " down");
                        }
                        c.add("docker compose -f " + ymlFileName + " up -d");
                        c.add("sleep 10");
                    }
                    File f = new File(this.dockerService.getProxyPath() + "/export.conf");
                    ArrayList<String> data = new ArrayList<String>();
                    data.add("");
                    try {
                        Files.write(f.toPath(), data, new OpenOption[0]);
                        thread.htmlOut("written empty file " + f.getAbsolutePath());
                    }
                    catch (IOException e) {
                        thread.htmlErr("cannot write file " + f.getAbsolutePath());
                    }
                    c.add("cd " + composePath + "/letto");
                    if (!this.isLettoDebug(updateServiceDtoList)) {
                        c.add("docker compose pull");
                    }
                    c.add("docker compose down");
                    c.add("docker compose up -d");
                    c.add(this.cmdSetupUpdateDocker());
                    String[] cc = new String[c.size()];
                    for (int i = 0; i < cc.length; ++i) {
                        cc[i] = (String)c.get(i);
                    }
                    thread.runCmd(cc);
                    cmd = SETUP_CMD.START;
                    break;
                }
                case 5: {
                    thread.htmlOut("restart all services");
                    Vector<Object> c = new Vector<Object>();
                    c.add("cd " + composePath + "/letto");
                    Vector schulen = this.dockerService.getSchulenEnv();
                    for (SchuleEnv schule : schulen) {
                        if (!this.dockerService.isSchoolRunning(schule.school) && schulen.size() != 1) continue;
                        c.add("docker compose -f docker-compose-" + schule.school + ".yml down");
                        c.add("docker compose -f docker-compose-" + schule.school + ".yml up -d");
                        c.add("sleep 10");
                    }
                    for (String ymlFileName : this.dockerService.getServiceYmlFileNames()) {
                        c.add("docker compose -f " + ymlFileName + " down");
                        c.add("docker compose -f " + ymlFileName + " up -d");
                        c.add("sleep 10");
                    }
                    c.add("sleep 5");
                    c.add("cd " + composePath + "/letto");
                    c.add("docker compose down");
                    c.add("docker compose up -d");
                    c.add(this.cmdSetupRestartDocker());
                    String[] cc = new String[c.size()];
                    for (int i = 0; i < cc.length; ++i) {
                        cc[i] = (String)c.get(i);
                    }
                    thread.runCmd(cc);
                    cmd = SETUP_CMD.RESTART;
                    break;
                }
                case 3: {
                    thread.htmlOut("stop setup service is not realized! - cancel prozess");
                    return;
                }
                case 7: {
                    thread.htmlOut("start Letto services");
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose up -d"});
                    return;
                }
                case 8: {
                    thread.htmlOut("stop Letto services");
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose down"});
                    return;
                }
                case 10: {
                    thread.htmlOut("restart Letto services");
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose down", "docker compose up -d"});
                    return;
                }
                case 9: {
                    thread.htmlOut("update Letto services");
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose pull", "docker compose up -d"});
                    return;
                }
                case 13: {
                    thread.htmlOut("start MySQL services");
                    thread.runCmd(new String[]{"cd " + composePath + "/mysql", "docker compose up -d"});
                    return;
                }
                case 14: {
                    thread.htmlOut("stop MySQL services");
                    thread.runCmd(new String[]{"cd " + composePath + "/mysql", "docker compose down"});
                    return;
                }
                case 16: {
                    thread.htmlOut("restart MySQL services");
                    thread.runCmd(new String[]{"cd " + composePath + "/mysql", "docker compose down", "docker compose up -d"});
                    return;
                }
                case 15: {
                    thread.htmlOut("update MySQL services");
                    thread.runCmd(new String[]{"cd " + composePath + "/mysql", "docker compose pull", "docker compose up -d"});
                    return;
                }
                case 21: {
                    thread.htmlOut("start service " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f " + school + " up -d"});
                    return;
                }
                case 22: {
                    thread.htmlOut("stop service " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f " + school + " down"});
                    return;
                }
                case 25: {
                    thread.htmlOut("stop service " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f " + school + " down"});
                    try {
                        new File("/opt/letto/docker/compose/letto/" + school).delete();
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                    return;
                }
                case 24: {
                    thread.htmlOut("restart service " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f " + school + " down", "docker compose -f " + school + " up -d"});
                    return;
                }
                case 23: {
                    thread.htmlOut("update Letto services");
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f " + school + " pull", "docker compose -f " + school + " up -d"});
                    return;
                }
                case 17: {
                    thread.htmlOut("start school " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f docker-compose-" + school + ".yml up -d"});
                    return;
                }
                case 18: {
                    thread.htmlOut("stop school " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f docker-compose-" + school + ".yml down"});
                    return;
                }
                case 20: {
                    thread.htmlOut("restart school " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f docker-compose-" + school + ".yml down", "docker compose -f docker-compose-" + school + ".yml up -d"});
                    return;
                }
                case 19: {
                    thread.htmlOut("update school " + school);
                    thread.runCmd(new String[]{"cd " + composePath + "/letto", "docker compose -f docker-compose-" + school + ".yml pull", "docker compose -f docker-compose-" + school + ".yml up -d"});
                    return;
                }
                case 11: {
                    this.createNewCert(thread);
                    return;
                }
                case 12: {
                    thread.htmlOut("create new letsencrypt certificate");
                    thread.runCmd(new String[]{"docker run -i --rm -v certs:/etc/letsencrypt -v certs-data:/data/letsencrypt certbot/certbot renew --webroot --webroot-path=/data/letsencrypt"});
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException i) {
                        // empty catch block
                    }
                    thread.runCmd(new String[]{"docker restart letto-proxy"});
                    return;
                }
                case 0: {
                    thread.htmlOut("update setup service");
                    String cmd1 = this.cmdSetupUpdateDocker();
                    thread.htmlErr("waiting for update and reboot - please reload page after reboot of setup service");
                    thread.runCmd(new String[]{cmd1});
                    break;
                }
                case 1: 
                case 2: {
                    thread.htmlOut("restart setup service");
                    String cmd1 = this.cmdSetupRestartDocker();
                    thread.htmlErr("waiting for reboot - please reload page after reboot of setup service");
                    thread.runCmd(new String[]{cmd1});
                    break;
                }
            }
        } else {
            String dir = "";
            switch (cmd.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    dir = this.getSetupComposeDir();
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    dir = this.getLettoComposeDir();
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    dir = this.getLettoComposeDir();
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    dir = this.getMysqlComposeDir();
                }
            }
            if (dir == null) {
                thread.htmlOut("cannot find compose directory " + this.microServiceConfiguration.getLettoSetupHostDocker() + " prozess cancelled!");
                return;
            }
            thread.htmlOut("base directory: " + dir);
            switch (cmd.ordinal()) {
                case 4: 
                case 6: {
                    thread.htmlOut("update all services");
                    Vector<Object> c = new Vector<Object>();
                    c.add("cd " + this.getSetupComposeDir());
                    if (!this.isSetupDebug(updateServiceDtoList)) {
                        c.add("docker compose pull");
                    }
                    if (cmd == SETUP_CMD.UPDATE_RESTART_ALL) {
                        c.add("docker compose down");
                    }
                    c.add("docker compose up -d");
                    c.add("cd " + this.getLettoComposeDir());
                    for (SchuleEnv schule : this.dockerService.getSchulenEnv()) {
                        if (!this.isSchoolDebug(updateServiceDtoList, schule.school)) {
                            c.add("docker compose -f docker-compose-" + schule.school + ".yml pull");
                        }
                        if (cmd == SETUP_CMD.UPDATE_RESTART_ALL) {
                            c.add("docker compose -f docker-compose-" + schule.school + ".yml down");
                        }
                        c.add("docker compose -f docker-compose-" + schule.school + ".yml up -d");
                    }
                    for (String ymlFileName : this.dockerService.getServiceYmlFileNames()) {
                        if (!this.isYmlDebug(updateServiceDtoList, ymlFileName)) {
                            c.add("docker compose -f " + ymlFileName + " pull");
                        }
                        if (cmd == SETUP_CMD.UPDATE_RESTART_ALL) {
                            c.add("docker compose -f " + ymlFileName + " down");
                        }
                        c.add("docker compose -f " + ymlFileName + " up -d");
                    }
                    c.add("sleep 5");
                    File f = new File(this.dockerService.getProxyPath() + "/export.conf");
                    ArrayList<String> data = new ArrayList<String>();
                    data.add("");
                    try {
                        Files.write(f.toPath(), data, new OpenOption[0]);
                        thread.htmlOut("written empty file " + f.getAbsolutePath());
                    }
                    catch (IOException e) {
                        thread.htmlErr("cannot write file " + f.getAbsolutePath());
                    }
                    c.add("cd " + this.getLettoComposeDir());
                    if (!this.isLettoDebug(updateServiceDtoList)) {
                        c.add("docker compose pull");
                    }
                    c.add("docker compose down");
                    c.add("docker compose up -d");
                    String[] cc = new String[c.size()];
                    for (int i = 0; i < cc.length; ++i) {
                        cc[i] = (String)c.get(i);
                    }
                    thread.runCmd(cc);
                    break;
                }
                case 5: {
                    thread.htmlOut("update all services");
                    Vector<Object> c = new Vector<Object>();
                    c.add("cd " + this.getSetupComposeDir());
                    c.add("docker compose down");
                    c.add("docker compose up -d");
                    c.add("cd " + this.getLettoComposeDir());
                    for (SchuleEnv schule : this.dockerService.getSchulenEnv()) {
                        c.add("docker compose -f docker-compose-" + schule.school + ".yml down");
                        c.add("docker compose -f docker-compose-" + schule.school + ".yml up -d");
                    }
                    for (String ymlFileName : this.dockerService.getServiceYmlFileNames()) {
                        c.add("docker compose -f " + ymlFileName + " down");
                        c.add("docker compose -f " + ymlFileName + " up -d");
                    }
                    c.add("sleep 5");
                    c.add("cd " + this.getLettoComposeDir());
                    c.add("docker compose down");
                    c.add("docker compose up -d");
                    String[] cc = new String[c.size()];
                    for (int i = 0; i < cc.length; ++i) {
                        cc[i] = (String)c.get(i);
                    }
                    thread.runCmd(cc);
                    break;
                }
                case 2: {
                    thread.htmlOut("start setup service");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose up -d"});
                    break;
                }
                case 3: {
                    thread.htmlOut("stop setup service");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose down"});
                    break;
                }
                case 0: {
                    thread.htmlOut("update setup service");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose pull", "docker compose up -d"});
                    break;
                }
                case 1: {
                    thread.htmlOut("restart setup service");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose down", "docker compose up -d"});
                    break;
                }
                case 13: {
                    thread.htmlOut("start MySql services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose up -d"});
                    return;
                }
                case 14: {
                    thread.htmlOut("stop MySql services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose down"});
                    return;
                }
                case 16: {
                    thread.htmlOut("restart MySql services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose down", "docker compose up -d"});
                    return;
                }
                case 15: {
                    thread.htmlOut("update MySql services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose pull", "docker compose up -d"});
                    return;
                }
                case 7: {
                    thread.htmlOut("start Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose up -d"});
                    return;
                }
                case 8: {
                    thread.htmlOut("stop Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose down"});
                    return;
                }
                case 10: {
                    thread.htmlOut("restart Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose down", "docker compose up -d"});
                    return;
                }
                case 21: {
                    thread.htmlOut("start service " + school);
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f " + school + " up -d"});
                    return;
                }
                case 22: {
                    thread.htmlOut("stop service " + school);
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f " + school + " down"});
                    return;
                }
                case 25: {
                    thread.htmlOut("stop service " + school);
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f " + school + " down"});
                    try {
                        new File(dir + "/" + school).delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                case 24: {
                    thread.htmlOut("restart service " + school);
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f " + school + " down", "docker compose -f " + school + " up -d"});
                    return;
                }
                case 23: {
                    thread.htmlOut("update Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f " + school + " pull", "docker compose -f " + school + " up -d"});
                    return;
                }
                case 19: {
                    thread.htmlOut("update Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f docker-compose-" + school + ".yml pull", "docker compose -f docker-compose-" + school + ".yml up -d"});
                    return;
                }
                case 17: {
                    thread.htmlOut("start Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f docker-compose-" + school + ".yml up -d"});
                    return;
                }
                case 18: {
                    thread.htmlOut("stop Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f docker-compose-" + school + ".yml down"});
                    return;
                }
                case 20: {
                    thread.htmlOut("restart Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose -f docker-compose-" + school + ".yml down", "docker compose -f docker-compose-" + school + ".yml up -d"});
                    return;
                }
                case 9: {
                    thread.htmlOut("update Letto services");
                    thread.runCmd(new String[]{"cd " + dir, "docker compose pull", "docker compose up -d"});
                    return;
                }
                case 11: {
                    this.createNewCert(thread);
                    return;
                }
                case 12: {
                    this.renewCert(thread);
                    return;
                }
            }
            return;
        }
    }

    private void dockerCompose(CmdThread cmdThread, String dir, String yml, String service, String info, int timeout, boolean restart, boolean update) {
        Object dockercmd = "docker compose ";
        if (yml != null && yml.length() > 0) {
            dockercmd = "docker compose -f " + yml + " ";
        }
        if (update && restart) {
            cmdThread.htmlOut("update and restart " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, (String)dockercmd + " down", (String)dockercmd + " pull", (String)dockercmd + " up -d"});
        } else if (update) {
            cmdThread.htmlOut("update " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, (String)dockercmd + " pull", (String)dockercmd + " up -d"});
        } else if (restart) {
            cmdThread.htmlOut("restart " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, (String)dockercmd + " down", (String)dockercmd + " up -d"});
        } else {
            cmdThread.htmlOut("start " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, (String)dockercmd + " up -d"});
        }
        if (service != null && service.length() > 0) {
            cmdThread.htmlOut("Wait for service " + service);
            int t = 4;
            this.waitSeconds(t);
            while (!this.dockerService.isDockerContainerRunningHealthyLive(service)) {
                this.waitSeconds(1);
                if (++t <= timeout) continue;
                cmdThread.htmlErr(info + "-services cannot start within " + timeout + " seconds!");
                return;
            }
            cmdThread.htmlOut(info + "-services started in " + t + " seconds");
        } else {
            cmdThread.htmlOut(info + "-services started");
        }
    }

    public void lettoDockerStartAndWait(CmdThread cmdThread, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getLettoComposeDir(), null, "letto-login", "LeTTo", 300, restart, update);
    }

    public void setupDockerStartAndWait(CmdThread cmdThread, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getSetupComposeDir(), null, "letto-setup", "Setup", 60, restart, update);
    }

    public void mysqlDockerStartAndWait(CmdThread cmdThread, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getMysqlComposeDir(), null, "letto-mysql", "Mysql", 600, restart, update);
    }

    public void schuleDockerStartAndWait(CmdThread cmdThread, String school, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getLettoComposeDir(), "docker-compose-" + school + ".yml ", "letto-server-" + school, "LeTTo-" + school, 120, restart, update);
    }

    public void renewCert(CmdThread cmdThread) {
        cmdThread.htmlOut("create new letsencrypt certificate");
        cmdThread.runCmd(new String[]{"docker run -i --rm -v certs:/etc/letsencrypt -v certs-data:/data/letsencrypt certbot/certbot renew --webroot --webroot-path=/data/letsencrypt"});
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cmdThread.runCmd(new String[]{"docker restart letto-proxy"});
    }

    public void createNewCert(CmdThread cmdThread) {
        cmdThread.htmlOut("create new letsencrypt certificate");
        String domains = " -d " + this.dockerService.getServerName();
        try {
            String[] alternatives;
            for (String a : alternatives = this.dockerService.dockerConfiguration.getLettoEnvFile().getDomainAlternativ().split("\\s+")) {
                if (a.length() <= 0) continue;
                domains = domains + " -d " + a;
            }
        }
        catch (Exception alternatives) {
            // empty catch block
        }
        cmdThread.runCmd(new String[]{"docker exec -i letto-proxy /removecert.sh", "docker run -i --rm -v certs:/etc/letsencrypt -v certs-data:/data/letsencrypt certbot/certbot certonly --webroot --webroot-path=/data/letsencrypt  --non-interactive --agree-tos -m " + this.dockerService.getAdminEmail() + domains});
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException alternatives) {
            // empty catch block
        }
        LettoEnvFile envFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
        envFile.setCertCreated(true);
        envFile.writeFile();
        this.dockerService.analyze(false);
        cmdThread.runCmd(new String[]{"docker restart letto-proxy"});
    }

    public CmdThread startProcess(String backlink, SETUP_CMD cmd, String school, String info) {
        ThreadProcess cmdThread = new ThreadProcess(this, backlink, cmd, school, info);
        cmdThread.start();
        this.cmdService.addThread((CmdThread)cmdThread);
        return cmdThread;
    }

    public CmdThread dockerUpdateAll(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.UPDATE_ALL, null, "docker update all");
    }

    public CmdThread dockerRestartAll(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.RESTART_ALL, null, "docker restart all");
    }

    public CmdThread setupStart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.START, null, "Start Setup");
    }

    public CmdThread setupStop(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.STOP, null, "Stop Setup");
    }

    public CmdThread setupRestart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.RESTART, null, "Restart Setup");
    }

    public CmdThread setupUpdate(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.UPDATE, null, "Update Setup");
    }

    public CmdThread dockerLettoRestart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_RESTART, null, "Restart LeTTo");
    }

    public CmdThread dockerLettoStart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_START, null, "Start LeTTo");
    }

    public CmdThread dockerLettoStop(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_STOP, null, "Stop LeTTo");
    }

    public CmdThread dockerLettoUpdate(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_UPDATE, null, "Update LeTTo");
    }

    public CmdThread dockerServiceRestart(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_RESTART, ymlFileName, "Restart Service " + ymlFileName);
    }

    public CmdThread dockerServiceStart(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_START, ymlFileName, "Start Service " + ymlFileName);
    }

    public CmdThread dockerServiceStop(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_STOP, ymlFileName, "Stop Service " + ymlFileName);
    }

    public CmdThread dockerServiceDelete(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_DELETE, ymlFileName, "Delete Service " + ymlFileName);
    }

    public CmdThread dockerServiceUpdate(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_UPDATE, ymlFileName, "Update Service " + ymlFileName);
    }

    public CmdThread dockerSchoolRestart(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_RESTART, school, "Restart school " + school);
    }

    public CmdThread dockerSchoolStart(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_START, school, "Start school " + school);
    }

    public CmdThread dockerSchoolStop(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_STOP, school, "Stop school " + school);
    }

    public CmdThread dockerSchoolUpdate(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_UPDATE, school, "Update school " + school);
    }

    public CmdThread dockerMysqlRestart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_RESTART, null, "Restart MySQL-Server");
    }

    public CmdThread dockerMysqlStart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_START, null, "Start MySQL-Server");
    }

    public CmdThread dockerMysqlStop(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_STOP, null, "Stop MySQL-Server");
    }

    public CmdThread dockerMysqlUpdate(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_UPDATE, null, "Update MySQL-Server");
    }

    public CmdThread createCert(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.CREATE_CERT, null, "Create Certifikate with Let's Encrypt");
    }

    public CmdThread renewCert(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.RENEW_CERT, null, "Renew Certifikate with Certbot");
    }

    public RestLocalSetupService getRestLocalSetupService() {
        RestLocalSetupService restLocalSetupService;
        if (this.isHostLinux() && (restLocalSetupService = new RestLocalSetupService("http://172.17.0.1:8096", "user", this.microServiceConfiguration.getUserUserPassword())).ping()) {
            return restLocalSetupService;
        }
        restLocalSetupService = new RestLocalSetupService("http://host.docker.internal:8096", "user", this.microServiceConfiguration.getUserUserPassword());
        if (restLocalSetupService.ping()) {
            return restLocalSetupService;
        }
        if (!this.isHostLinux.booleanValue() && (restLocalSetupService = new RestLocalSetupService("http://172.17.0.1:8096", "user", this.microServiceConfiguration.getUserUserPassword())).ping()) {
            return restLocalSetupService;
        }
        return null;
    }

    public String setupRestart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerRestart();
            return "restart Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please restart Service in the hosts commandline";
    }

    public String setupStart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerStart();
            return "start Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please start Service in the hosts commandline";
    }

    public String setupStop() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerStop();
            return "stop Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please stop Service in the hosts commandline";
    }

    public String setupUpdate() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerUpdate();
            return "update Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please update Service in the hosts commandline";
    }

    public String lettoRestart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerRestart();
            return "restart LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please restart Service in the hosts commandline";
    }

    public String lettoStart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerStart();
            return "start LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please start Service in the hosts commandline";
    }

    public String lettoStop() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerStop();
            return "stop LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please stop Service in the hosts commandline";
    }

    public String lettoUpdate() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerUpdate();
            return "update LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please update Service in the hosts commandline";
    }
}

