/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.SetupEnvFile;
import at.letto.setupservice.dto.BackupDirectoryInfoDto;
import at.letto.setupservice.model.BackupModel;
import at.letto.setupservice.model.FileInfoDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.BackupService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.EmailService;
import at.letto.setupservice.service.LizenzService;
import at.letto.setupservice.service.SetupUpdateService;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackupService {
    static final Logger LOGGER = LoggerFactory.getLogger(BackupService.class);
    @Autowired
    private DockerService dockerService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private DatabaseService databaseService;
    @Autowired
    private SetupUpdateService setupUpdateService;
    @Autowired
    private LizenzService lizenzService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    private boolean backupRunning = false;

    public List<FileInfoDto> loadDatabaseDumpFiles() {
        File[] listOfFiles;
        String databaseDumpDirectoryName = this.dockerService.getDatabaseDumpDirectoryPath();
        File databaseDumpDirectory = new File(databaseDumpDirectoryName);
        ArrayList<FileInfoDto> files = new ArrayList<FileInfoDto>();
        File folder = new File(databaseDumpDirectoryName);
        if (folder.exists() && (listOfFiles = folder.listFiles()) != null) {
            for (File file : listOfFiles) {
                if (!file.isFile()) continue;
                files.add(new FileInfoDto(file));
            }
        }
        return files;
    }

    public BackupModel loadBackupModel() {
        File[] listOfFiles;
        BackupModel backupModel = new BackupModel();
        SetupEnvFile setupEnvFile = this.dockerService.dockerConfiguration.getSetupEnvFile();
        if (setupEnvFile.getLocalBackup() != null) {
            backupModel.setLocalBackup(setupEnvFile.getLocalBackup().booleanValue());
        }
        if (setupEnvFile.getRefreshLetsEncryptAuto() != null) {
            backupModel.setRefreshLetsEncryptAuto(setupEnvFile.getRefreshLetsEncryptAuto().booleanValue());
        }
        if (setupEnvFile.getCheckLicenseAuto() != null) {
            backupModel.setCheckLicenseAuto(setupEnvFile.getCheckLicenseAuto().booleanValue());
        }
        if (setupEnvFile.getTimeDailyBackup() != null) {
            backupModel.setTimeDailyBackup(setupEnvFile.getTimeDailyBackup());
        }
        if (setupEnvFile.getBackupStopLetto() != null) {
            backupModel.setStopLetto(setupEnvFile.getBackupStopLetto().booleanValue());
        }
        if (setupEnvFile.getBackupMinFreeDiskspaceMB() != null) {
            backupModel.setMinFreeDiskspaceMB(setupEnvFile.getBackupMinFreeDiskspaceMB().intValue());
        }
        if (setupEnvFile.getDatabaseBackup() != null) {
            backupModel.setDatabaseBackup(setupEnvFile.getDatabaseBackup().booleanValue());
        }
        if (setupEnvFile.getDatabaseDayofWeekBackup() != null) {
            backupModel.setDatabaseDayofWeekBackup(setupEnvFile.getDatabaseDayofWeekBackup().booleanValue());
        }
        if (setupEnvFile.getDatabaseMonthlyImage() != null) {
            backupModel.setDatabaseMonthlyImage(setupEnvFile.getDatabaseMonthlyImage().booleanValue());
        }
        if (setupEnvFile.getImageBackup() != null) {
            backupModel.setImagesBackup(setupEnvFile.getImageBackup().booleanValue());
        }
        if (setupEnvFile.getImageDayofWeekBackup() != null) {
            backupModel.setImagesDayofWeekBackup(setupEnvFile.getImageDayofWeekBackup().booleanValue());
        }
        if (setupEnvFile.getImageMonthlyImage() != null) {
            backupModel.setImagesMonthlyImage(setupEnvFile.getImageMonthlyImage().booleanValue());
        }
        if (setupEnvFile.getProjekteBackup() != null) {
            backupModel.setProjekteBackup(setupEnvFile.getProjekteBackup().booleanValue());
        }
        if (setupEnvFile.getProjekteDayofWeekBackup() != null) {
            backupModel.setProjekteDayofWeekBackup(setupEnvFile.getProjekteDayofWeekBackup().booleanValue());
        }
        if (setupEnvFile.getProjekteMonthlyImage() != null) {
            backupModel.setProjekteMonthlyImage(setupEnvFile.getProjekteMonthlyImage().booleanValue());
        }
        List files = this.loadDatabaseDumpFiles();
        backupModel.setDatabaseDumpFileList(files);
        backupModel.setBackupDirectoryInfoDtoList(new ArrayList());
        List backupDirectoryInfoDtoList = backupModel.getBackupDirectoryInfoDtoList();
        String backupDirectoryName = this.dockerService.getBackupDirectoryPath();
        File backupDirectory = new File(backupDirectoryName);
        if (backupDirectory.exists() && (listOfFiles = backupDirectory.listFiles()) != null) {
            for (File file : listOfFiles) {
                if (file.isDirectory()) {
                    BackupDirectoryInfoDto dto = new BackupDirectoryInfoDto();
                    String name = file.getName();
                    String parent = file.getParentFile().getAbsolutePath();
                    dto.setDirectoryName(name);
                    dto.setParentDirectory(parent);
                    dto.setDirectory(file);
                    long size = 0L;
                    Date date = null;
                    File[] dateien = file.listFiles();
                    if (dateien != null) {
                        for (File datei : dateien) {
                            if (datei.isDirectory()) {
                                dto.getDirectoryList().add(new FileInfoDto(datei));
                                continue;
                            }
                            if (!datei.isFile()) continue;
                            FileInfoDto info = new FileInfoDto(datei);
                            dto.getFileList().add(info);
                            size += info.getSize();
                            if (date == null) {
                                date = info.getDate();
                                continue;
                            }
                            if (date.getTime() >= info.getDate().getTime()) continue;
                            date = info.getDate();
                        }
                    }
                    dto.setDate(date);
                    dto.setSize(size);
                    backupDirectoryInfoDtoList.add(dto);
                    continue;
                }
                if (!file.isFile()) continue;
            }
        }
        return backupModel;
    }

    public void saveBackupModel(BackupModel backupModel) {
        SetupEnvFile setupEnvFile = this.dockerService.dockerConfiguration.getSetupEnvFile();
        setupEnvFile.setLocalBackup(Boolean.valueOf(backupModel.isLocalBackup()));
        setupEnvFile.setRefreshLetsEncryptAuto(Boolean.valueOf(backupModel.isRefreshLetsEncryptAuto()));
        setupEnvFile.setCheckLicenseAuto(Boolean.valueOf(backupModel.isCheckLicenseAuto()));
        setupEnvFile.setTimeDailyBackup(backupModel.getTimeDailyBackup());
        setupEnvFile.setBackupStopLetto(Boolean.valueOf(backupModel.isStopLetto()));
        setupEnvFile.setBackupMinFreeDiskspaceMB(Integer.valueOf(backupModel.getMinFreeDiskspaceMB()));
        setupEnvFile.setDatabaseBackup(Boolean.valueOf(backupModel.isDatabaseBackup()));
        setupEnvFile.setDatabaseDayofWeekBackup(Boolean.valueOf(backupModel.isDatabaseDayofWeekBackup()));
        setupEnvFile.setDatabaseMonthlyImage(Boolean.valueOf(backupModel.isDatabaseMonthlyImage()));
        setupEnvFile.setImageBackup(Boolean.valueOf(backupModel.isImagesBackup()));
        setupEnvFile.setImageDayofWeekBackup(Boolean.valueOf(backupModel.isImagesDayofWeekBackup()));
        setupEnvFile.setImageMonthlyImage(Boolean.valueOf(backupModel.isImagesMonthlyImage()));
        setupEnvFile.setProjekteBackup(Boolean.valueOf(backupModel.isProjekteBackup()));
        setupEnvFile.setProjekteDayofWeekBackup(Boolean.valueOf(backupModel.isProjekteDayofWeekBackup()));
        setupEnvFile.setProjekteMonthlyImage(Boolean.valueOf(backupModel.isProjekteMonthlyImage()));
        setupEnvFile.writeFile();
    }

    public CmdThread backup(BackupModel backupModel) {
        Backup cmdThread = new Backup(this, backupModel);
        cmdThread.start();
        this.cmdService.addThread((CmdThread)cmdThread);
        return cmdThread;
    }

    public void cronEveryMinute() {
        try {
            Date actualDate = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(actualDate);
            int timeMinute = cal.get(12) + cal.get(11) * 60;
            BackupModel backupModel = this.loadBackupModel();
            String[] backuptimesString = backupModel.getTimeDailyBackup().split("[\\s\\,; ]+");
            boolean makeBackup = false;
            for (String t : backuptimesString) {
                int minute = -1;
                Matcher m = Pattern.compile("^(\\d+):(\\d+)$").matcher(t);
                if (m.find()) {
                    minute = Integer.parseInt(m.group(1)) * 60 + Integer.parseInt(m.group(2));
                } else {
                    m = Pattern.compile("^(\\d+):(\\d+):(\\d+)$").matcher(t);
                    if (m.find()) {
                        minute = Integer.parseInt(m.group(1)) * 60 + Integer.parseInt(m.group(2));
                    }
                }
                if (minute != timeMinute) continue;
                makeBackup = true;
            }
            if (makeBackup) {
                CmdThread cmdThread = null;
                if (backupModel.isLocalBackup() && !this.dockerService.isDockerRunning()) {
                    LOGGER.info("Backup wird vom lokalen Setup /setup gestartet!");
                    cmdThread = this.backup(backupModel);
                } else if (!backupModel.isLocalBackup() && this.dockerService.isDockerRunning()) {
                    LOGGER.info("Backup wird vom Docker-Container-Setup /config gestartet!");
                    cmdThread = this.backup(backupModel);
                } else if (this.dockerService.isDockerRunning()) {
                    LOGGER.info("Backup wird nicht gestartet, da es vom lokalen Setup /setup gestartet werden sollte!");
                } else {
                    LOGGER.info("Backup wird nicht gestartet, da es vom Docker-Setup /config gestartet werden sollte!");
                }
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void backupEnvFiles() {
        this.backupFileEnvFile(this.microServiceConfiguration.getSetupEnvFile());
        this.backupFileEnvFile(this.microServiceConfiguration.getLettoEnvFile());
        this.backupFileEnvFile(this.microServiceConfiguration.getMysqlEnvFile());
    }

    private void backupFileEnvFile(File f) {
        try {
            if (!f.exists()) {
                throw new RuntimeException("File not found!");
            }
            Object pathname = f.getAbsolutePath();
            pathname = ((String)pathname).endsWith("/.env") ? ((String)pathname).substring(0, ((String)pathname).length() - 5) + "/env-backup/" : (String)pathname + "-backup/";
            File bf = new File((String)pathname + "backup.txt");
            boolean dobackup = false;
            List<String> origindata = Files.readAllLines(f.toPath());
            if (bf.exists()) {
                List<String> backupdata = Files.readAllLines(bf.toPath());
                if (origindata.size() != backupdata.size()) {
                    dobackup = true;
                } else {
                    for (int i = 0; i < origindata.size(); ++i) {
                        if (origindata.get(i).trim().equals(backupdata.get(i).trim())) continue;
                        dobackup = true;
                        break;
                    }
                }
                if (dobackup) {
                    File bf2 = null;
                    int i = 0;
                    while ((bf2 = new File((String)pathname + "backup-" + ++i + ".txt")).exists()) {
                    }
                    Files.write(bf2.toPath(), backupdata, new OpenOption[0]);
                }
            } else {
                dobackup = true;
            }
            if (dobackup) {
                LOGGER.info("Backup file " + f.getAbsolutePath());
                Files.write(bf.toPath(), origindata, new OpenOption[0]);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Cannot backup file " + f.getAbsolutePath() + " - " + ex.getMessage());
        }
    }

    @Generated
    public boolean isBackupRunning() {
        return this.backupRunning;
    }
}

