/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.beans.SchoolEditBean;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.controller.CommandController;
import at.letto.setupservice.model.DockerEditSchoolDto;
import at.letto.setupservice.model.FileInfoDto;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerInstallService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LizenzService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class HttpEditSchoolController {
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private DockerInstallService dockerInstallService;
    @Autowired
    private CommandController commandController;
    @Autowired
    private LizenzService lizenzService;
    @Autowired
    private DatabaseService databaseService;
    @Resource(name="schoolEditBean")
    SchoolEditBean schoolEditBean;

    public String getDockerEditSchoolEP() {
        return this.dockerService.isDockerRunning() ? "/config/session/admin/dockereditschool" : "/setup/session/admin/dockereditschool";
    }

    @RequestMapping(value={"/config/session/admin/dockereditschool"})
    public String dockerEditSchoolDocker(@ModelAttribute DockerEditSchoolDto dockerEditSchoolDto, HttpServletRequest request, Model model) {
        return this.dockerEditSchool(dockerEditSchoolDto, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/dockereditschool"})
    public String dockerEditSchoolLocal(@ModelAttribute DockerEditSchoolDto dockerEditSchoolDto, HttpServletRequest request, Model model) {
        return this.dockerEditSchool(dockerEditSchoolDto, request, model);
    }

    private String dockerEditSchool(@ModelAttribute DockerEditSchoolDto dockerEditSchoolDto, HttpServletRequest request, Model model) {
        model.addAttribute("action", (Object)this.getDockerEditSchoolEP());
        model.addAttribute("lizenz", (Object)this.lizenzService.toLicenseKey(dockerEditSchoolDto.getLizenz()));
        String button = dockerEditSchoolDto.getUserAction();
        String commitedAction = dockerEditSchoolDto.getCommitedAction();
        if (commitedAction != null && commitedAction.trim().length() > 0) {
            button = commitedAction;
        }
        dockerEditSchoolDto.setCommitedAction(null);
        model.addAttribute("msg", (Object)"");
        model.addAttribute("dockerService", (Object)this.dockerService);
        this.dockerService.analyzeFiles();
        Object msg = "";
        String kzl = dockerEditSchoolDto.getSchulkuerzel();
        if (kzl != null) {
            kzl = kzl.trim();
        }
        if (button != null) {
            switch (button) {
                case "importlastbackup": {
                    FileInfoDto importfile = this.dockerService.getDumpFile("letto_" + kzl);
                    if (importfile == null || !importfile.getFile().exists()) {
                        msg = "Database-Dump Datei letto_" + kzl + " nicht gefunden!";
                        break;
                    }
                    CmdThread cmdThread = this.databaseService.loadDatabaseDump(dockerEditSchoolDto.getEnvId(), importfile.getFilename());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "Datenbank kann nicht zur\u00fcckgesichert werden - Thread nicht startbar!";
                    break;
                }
                case "importdb": {
                    FileInfoDto importfile = this.dockerService.getDumpFile(dockerEditSchoolDto.getImportfile());
                    if (importfile == null || !importfile.getFile().exists()) {
                        msg = "Database-Dump Datei " + dockerEditSchoolDto.getImportfile() + " nicht gefunden!";
                        break;
                    }
                    CmdThread cmdThread = this.databaseService.loadDatabaseDump(dockerEditSchoolDto.getEnvId(), importfile.getFilename());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "Datenbank kann nicht zur\u00fcckgesichert werden - Thread nicht startbar!";
                    break;
                }
                case "neu_dbimport": {
                    CmdThread cmdThread;
                    FileInfoDto importfile = this.dockerService.getDumpFile(dockerEditSchoolDto.getImportfile());
                    if (importfile == null) {
                        msg = "Database-Dump Datei " + dockerEditSchoolDto.getImportfile() + " nicht gefunden!";
                        break;
                    }
                    for (SchuleEnv schuleEnv : this.dockerConfiguration.getLettoEnvFile().getSchulen()) {
                        if (!schuleEnv.school.trim().equalsIgnoreCase(kzl)) continue;
                        msg = "Schule mit K\u00fcrzel " + kzl + " ist schon vorhanden und wird deshalb nicht angelegt!";
                        break;
                    }
                    if ((cmdThread = this.dockerInstallService.saveAndAddSchool(dockerEditSchoolDto, true, importfile)) != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "Schule kann nicht angelegt werden!";
                    break;
                }
                case "save": {
                    CmdThread cmdThread = this.dockerInstallService.saveAndAddSchool(dockerEditSchoolDto, false, null);
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "Schule kann nicht neu gespeichert werden!";
                    break;
                }
                case "neu_dbdelete": {
                    msg = "bestehende Datenbank l\u00f6schen und Schule neu anlegen noch nicht realisiert";
                    break;
                }
                case "neu_dbuse": 
                case "add": {
                    CmdThread cmdThread;
                    if (button.equals("add")) {
                        for (SchuleEnv schuleEnv : this.dockerConfiguration.getLettoEnvFile().getSchulen()) {
                            if (!schuleEnv.school.trim().equalsIgnoreCase(kzl)) continue;
                            msg = "Schule mit K\u00fcrzel " + kzl + " ist schon vorhanden und wird deshalb nicht angelegt!";
                            break;
                        }
                        if (dockerEditSchoolDto.getAdminglobalpassword().length() == 0 && (this.dockerService.dockerConfiguration.getSetupEnvFile().getAdminPassword() == null || this.dockerService.dockerConfiguration.getSetupEnvFile().getAdminPassword().length() == 0)) {
                            msg = "Passwort des globalen Administrators fehlt!";
                            break;
                        }
                        if (dockerEditSchoolDto.getAdminglobalpassword().length() > 0 && dockerEditSchoolDto.getAdminglobalpassword().length() < 10) {
                            msg = "Passwort des globalen Administrators ist k\u00fcrzer als 10 Zeichen!";
                            break;
                        }
                        if (dockerEditSchoolDto.getAdminschulepassword().length() > 0 && dockerEditSchoolDto.getAdminschulepassword().length() < 10) {
                            msg = "Passwort des Schuladministrators ist k\u00fcrzer als 10 Zeichen!";
                            break;
                        }
                    }
                    if ((cmdThread = this.dockerInstallService.saveAndAddSchool(dockerEditSchoolDto, true, null)) != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "Schule kann nicht angelegt werden!";
                    break;
                }
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "recreate-database": {
                    int id = dockerEditSchoolDto.getEnvId();
                    CmdThread cmdThread = this.dockerInstallService.createDatabaseSchool(id, dockerEditSchoolDto);
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "Datenbank konnte nicht zur\u00fcckgesetzt werden!";
                    break;
                }
                case "delete-school": {
                    int id = dockerEditSchoolDto.getEnvId();
                    CmdThread cmdThread = this.dockerInstallService.deleteSchool(id);
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "Schule kann nicht gel\u00f6scht werden!";
                    break;
                }
                default: {
                    Pattern p = Pattern.compile("^load-dump-(.*)$");
                    Matcher m = p.matcher(button);
                    if (!m.find()) break;
                    String filename = m.group(1);
                    dockerEditSchoolDto.setImportfile(filename);
                    if (dockerEditSchoolDto.getMode().equals("edit")) {
                        dockerEditSchoolDto.setSchulinfo("");
                        dockerEditSchoolDto.setAdminglobal("");
                        dockerEditSchoolDto.setAdminglobalpassword("");
                        dockerEditSchoolDto.setAdminschule("");
                        dockerEditSchoolDto.setAdminschulepassword("");
                        dockerEditSchoolDto.setLizenz("");
                        dockerEditSchoolDto.setSchuladresse("");
                        dockerEditSchoolDto.setSchulansprechpartner("");
                        dockerEditSchoolDto.setSchulemail("");
                        dockerEditSchoolDto.setSchultel("");
                        dockerEditSchoolDto.setSchuldirektor("");
                        dockerEditSchoolDto.setSchulskz("");
                        dockerEditSchoolDto.setSchulweb("");
                        dockerEditSchoolDto.setAbteilungkuerzel("");
                        dockerEditSchoolDto.setAbteilungname("");
                        dockerEditSchoolDto.setAbteilunginfo("");
                        dockerEditSchoolDto.setAbteilungvorstand("");
                        dockerEditSchoolDto.setAbteilungemail("");
                        dockerEditSchoolDto.setAbteilungtel("");
                        dockerEditSchoolDto.setAbteilungweb("");
                        break;
                    }
                    String n = filename.split("\\.")[0];
                    if (n.startsWith("letto_")) {
                        dockerEditSchoolDto.setSchulkuerzel(n.substring(6).replaceAll("_", "-"));
                        break;
                    }
                    if (!n.startsWith("letto")) break;
                    dockerEditSchoolDto.setSchulkuerzel(n.substring(5).replaceAll("_", "-"));
                }
            }
        }
        model.addAttribute("msg", msg);
        model.addAttribute("dockerEditSchoolDto", (Object)dockerEditSchoolDto);
        return "dockereditschool";
    }
}

